/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.ObjectSerializer;

public class MergeJoinIndexer
extends LoadFunc {
    private boolean firstRec = true;
    private transient TupleFactory mTupleFactory;
    private POLocalRearrange lr;
    private PhysicalPlan precedingPhyPlan;
    private int keysCnt;
    private PhysicalOperator rightPipelineLeaf;
    private PhysicalOperator rightPipelineRoot;
    private Tuple dummyTuple = null;
    private LoadFunc loader;
    private PigSplit pigSplit = null;
    private boolean ignoreNullKeys;

    public MergeJoinIndexer(String funcSpec, String innerPlan, String serializedPhyPlan, String udfCntxtSignature, String scope, String ignoreNulls) throws ExecException {
        this.loader = (LoadFunc)PigContext.instantiateFuncFromSpec(funcSpec);
        this.loader.setUDFContextSignature(udfCntxtSignature);
        this.ignoreNullKeys = Boolean.parseBoolean(ignoreNulls);
        try {
            List innerPlans = (List)ObjectSerializer.deserialize(innerPlan);
            this.lr = new POLocalRearrange(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
            this.lr.setPlans(innerPlans);
            this.keysCnt = innerPlans.size();
            this.precedingPhyPlan = (PhysicalPlan)ObjectSerializer.deserialize(serializedPhyPlan);
            if (this.precedingPhyPlan != null) {
                if (this.precedingPhyPlan.getLeaves().size() != 1 || this.precedingPhyPlan.getRoots().size() != 1) {
                    int errCode = 2168;
                    String errMsg = "Expected physical plan with exactly one root and one leaf.";
                    throw new ExecException(errMsg, errCode, 4);
                }
                this.rightPipelineLeaf = (PhysicalOperator)this.precedingPhyPlan.getLeaves().get(0);
                this.rightPipelineRoot = (PhysicalOperator)this.precedingPhyPlan.getRoots().get(0);
                this.rightPipelineRoot.setInputs(null);
            }
        }
        catch (IOException e) {
            int errCode = 2094;
            String msg = "Unable to deserialize plans in Indexer.";
            throw new ExecException(msg, errCode, e);
        }
        this.mTupleFactory = TupleFactory.getInstance();
    }

    public Tuple getNext() throws IOException {
        int i;
        if (!this.firstRec) {
            return null;
        }
        WritableComparable<?> position = ((OrderedLoadFunc)((Object)this.loader)).getSplitComparable(this.pigSplit.getWrappedSplit());
        Object key = null;
        Tuple wrapperTuple = this.mTupleFactory.newTuple(this.keysCnt + 2);
        while (true) {
            boolean fetchNewTup;
            Tuple readTuple;
            if (null == (readTuple = this.loader.getNext())) {
                for (i = 0; i < this.keysCnt; ++i) {
                    wrapperTuple.set(i, null);
                }
                wrapperTuple.set(this.keysCnt, position);
                this.firstRec = false;
                return wrapperTuple;
            }
            if (null == this.precedingPhyPlan) {
                this.lr.attachInput(readTuple);
                key = ((Tuple)this.lr.getNext((Tuple)this.dummyTuple).result).get(1);
                this.lr.detachInput();
                if (null == key && this.ignoreNullKeys) {
                    continue;
                }
                break;
            }
            this.rightPipelineRoot.attachInput(readTuple);
            block6: while (true) {
                Result res = this.rightPipelineLeaf.getNext(this.dummyTuple);
                switch (res.returnStatus) {
                    case 0: {
                        this.lr.attachInput((Tuple)res.result);
                        key = ((Tuple)this.lr.getNext((Tuple)this.dummyTuple).result).get(1);
                        this.lr.detachInput();
                        if (null == key && this.ignoreNullKeys) continue block6;
                        fetchNewTup = false;
                        break block6;
                    }
                    case 3: {
                        fetchNewTup = true;
                        break block6;
                    }
                    default: {
                        int errCode = 2164;
                        String errMsg = "Expected EOP/OK as return status. Found: " + res.returnStatus;
                        throw new ExecException(errMsg, errCode);
                    }
                }
                break;
            }
            if (!fetchNewTup) break;
        }
        if (key instanceof Tuple) {
            Tuple tupKey = (Tuple)key;
            for (i = 0; i < tupKey.size(); ++i) {
                wrapperTuple.set(i, tupKey.get(i));
            }
        } else {
            wrapperTuple.set(0, key);
        }
        wrapperTuple.set(this.keysCnt, position);
        wrapperTuple.set(this.keysCnt + 1, this.pigSplit.getSplitIndex());
        this.firstRec = false;
        return wrapperTuple;
    }

    public InputFormat getInputFormat() throws IOException {
        return this.loader.getInputFormat();
    }

    public LoadCaster getLoadCaster() throws IOException {
        return this.loader.getLoadCaster();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.loader.prepareToRead(reader, split);
        this.pigSplit = split;
    }

    public void setLocation(String location, Job job) throws IOException {
        this.loader.setLocation(location, job);
    }
}

