/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCombinerPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.builtin.Distinct;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinerOptimizer
extends MROpPlanVisitor {
    private static final String DISTINCT_UDF_CLASSNAME = Distinct.class.getName();
    private Log log = LogFactory.getLog(this.getClass());
    private CompilationMessageCollector messageCollector = null;
    private boolean doMapAgg;

    public CombinerOptimizer(MROperPlan plan, boolean doMapAgg) {
        this(plan, doMapAgg, new CompilationMessageCollector());
    }

    public CombinerOptimizer(MROperPlan plan, boolean doMapAgg, CompilationMessageCollector messageCollector) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
        this.messageCollector = messageCollector;
        this.doMapAgg = doMapAgg;
    }

    public CompilationMessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        List<PhysicalOperator> limitSucs;
        this.log.trace((Object)"Entering CombinerOptimizer.visitMROp");
        if (mr.reducePlan.isEmpty()) {
            return;
        }
        List mapLeaves = mr.mapPlan.getLeaves();
        if (mapLeaves == null || mapLeaves.size() != 1) {
            this.messageCollector.collect("Expected map to have single leaf!", CompilationMessageCollector.MessageType.Warning, PigWarning.MULTI_LEAF_MAP);
            return;
        }
        PhysicalOperator mapLeaf = (PhysicalOperator)mapLeaves.get(0);
        if (!(mapLeaf instanceof POLocalRearrange)) {
            return;
        }
        POLocalRearrange rearrange = (POLocalRearrange)mapLeaf;
        List reduceRoots = mr.reducePlan.getRoots();
        if (reduceRoots.size() != 1) {
            this.messageCollector.collect("Expected reduce to have single leaf", CompilationMessageCollector.MessageType.Warning, PigWarning.MULTI_LEAF_REDUCE);
            return;
        }
        PhysicalOperator root = (PhysicalOperator)reduceRoots.get(0);
        if (!(root instanceof POPackage)) {
            this.messageCollector.collect("Expected reduce root to be a POPackage", CompilationMessageCollector.MessageType.Warning, PigWarning.NON_PACKAGE_REDUCE_PLAN_ROOT);
            return;
        }
        POPackage pack = (POPackage)root;
        List<PhysicalOperator> packSuccessors = mr.reducePlan.getSuccessors(root);
        if (packSuccessors == null || packSuccessors.size() != 1) {
            return;
        }
        PhysicalOperator successor = packSuccessors.get(0);
        if (successor instanceof POLimit && (limitSucs = mr.reducePlan.getSuccessors(successor)) != null && limitSucs.size() == 1 && limitSucs.get(0) instanceof POForEach) {
            successor = limitSucs.get(0);
        }
        if (successor instanceof POForEach) {
            POForEach foreach = (POForEach)successor;
            List<PhysicalPlan> feInners = foreach.getInputPlans();
            List<Pair<PhysicalOperator, PhysicalPlan>> algebraicOps = this.findAlgebraicOps(feInners);
            if (algebraicOps == null || algebraicOps.size() == 0) {
                return;
            }
            if (mr.combinePlan.getRoots().size() != 0) {
                this.messageCollector.collect("Wasn't expecting to find anything already in the combiner!", CompilationMessageCollector.MessageType.Warning, PigWarning.NON_EMPTY_COMBINE_PLAN);
                return;
            }
            this.log.info((Object)"Choosing to move algebraic foreach to combiner");
            try {
                for (Pair<PhysicalOperator, PhysicalPlan> op2plan : algebraicOps) {
                    if (!(op2plan.first instanceof PODistinct)) continue;
                    DistinctPatcher distinctPatcher = new DistinctPatcher((PhysicalPlan)op2plan.second);
                    distinctPatcher.visit();
                    if (distinctPatcher.getDistinct() == null) {
                        int errCode = 2073;
                        String msg = "Problem with replacing distinct operator with distinct built-in function.";
                        throw new PlanException(msg, errCode, 4);
                    }
                    op2plan.first = distinctPatcher.getDistinct();
                }
                POForEach mfe = this.createForEachWithGrpProj(foreach, rearrange.getKeyType());
                HashMap<PhysicalOperator, Integer> op2newpos = new HashMap<PhysicalOperator, Integer>();
                Integer pos = 1;
                for (Pair<PhysicalOperator, PhysicalPlan> op2plan : algebraicOps) {
                    PhysicalPlan udfPlan = this.createPlanWithPredecessors((PhysicalOperator)op2plan.first, (PhysicalPlan)op2plan.second);
                    mfe.addInputPlan(udfPlan, false);
                    Integer n = pos;
                    Integer n2 = pos = Integer.valueOf(pos + 1);
                    op2newpos.put((PhysicalOperator)op2plan.first, n);
                }
                this.changeFunc(mfe, (byte)0);
                for (PhysicalPlan mpl : mfe.getInputPlans()) {
                    try {
                        new fixMapProjects(mpl).visit();
                    }
                    catch (VisitorException e) {
                        int errCode = 2089;
                        String msg = "Unable to flag project operator to use single tuple bag.";
                        throw new PlanException(msg, errCode, 4, (Throwable)e);
                    }
                }
                POForEach cfe = this.createForEachWithGrpProj(foreach, rearrange.getKeyType());
                this.addAlgebraicFuncToCombineFE(cfe, op2newpos);
                this.changeFunc(cfe, (byte)1);
                for (Pair<PhysicalOperator, PhysicalPlan> op2plan : algebraicOps) {
                    this.setProjectInput((PhysicalOperator)op2plan.first, (PhysicalPlan)op2plan.second, (Integer)op2newpos.get(op2plan.first));
                    ((POUserFunc)op2plan.first).setAlgebraicFunction((byte)2);
                }
                mfe.setInputPlans(mfe.getInputPlans());
                cfe.setInputPlans(cfe.getInputPlans());
                foreach.setInputPlans(foreach.getInputPlans());
                int numFields = algebraicOps.size() + 1;
                boolean[] bags = new boolean[numFields];
                bags[0] = false;
                for (int i = 1; i < numFields; ++i) {
                    bags[i] = true;
                }
                mr.combinePlan = new PhysicalPlan();
                POCombinerPackage combinePack = new POCombinerPackage(pack, bags);
                mr.combinePlan.add(combinePack);
                mr.combinePlan.add(cfe);
                mr.combinePlan.connect(combinePack, cfe);
                POLocalRearrange mlr = this.getNewRearrange(rearrange);
                POPartialAgg mapAgg = null;
                if (this.doMapAgg) {
                    mapAgg = this.createPartialAgg(cfe);
                }
                this.patchUpMap(mr.mapPlan, this.getPreCombinerLR(rearrange), mfe, mapAgg, mlr);
                POLocalRearrange clr = this.getNewRearrange(rearrange);
                mr.combinePlan.add(clr);
                mr.combinePlan.connect(cfe, clr);
                POCombinerPackage newReducePack = new POCombinerPackage(pack, bags);
                mr.reducePlan.replace(pack, newReducePack);
                ArrayList<PhysicalOperator> packList = new ArrayList<PhysicalOperator>();
                packList.add(newReducePack);
                List<POCombinerPackage> sucs = mr.reducePlan.getSuccessors(newReducePack);
                ((PhysicalOperator)sucs.get(0)).setInputs(packList);
            }
            catch (Exception e) {
                int errCode = 2018;
                String msg = "Internal error. Unable to introduce the combiner for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    private POPartialAgg createPartialAgg(POForEach combineFE) throws CloneNotSupportedException {
        String scope = combineFE.getOperatorKey().scope;
        POPartialAgg poAgg = new POPartialAgg(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)));
        poAgg.addOriginalLocation(combineFE.getAlias(), combineFE.getOriginalLocations());
        poAgg.setResultType(combineFE.getResultType());
        poAgg.setKeyPlan(combineFE.getInputPlans().get(0).clone());
        ArrayList<PhysicalPlan> valuePlans = new ArrayList<PhysicalPlan>();
        for (int i = 1; i < combineFE.getInputPlans().size(); ++i) {
            valuePlans.add(combineFE.getInputPlans().get(i).clone());
        }
        poAgg.setValuePlans(valuePlans);
        return poAgg;
    }

    private List<Pair<PhysicalOperator, PhysicalPlan>> findAlgebraicOps(List<PhysicalPlan> feInners) throws VisitorException {
        ArrayList<Pair<PhysicalOperator, PhysicalPlan>> algebraicOps = new ArrayList<Pair<PhysicalOperator, PhysicalPlan>>();
        for (PhysicalPlan pplan : feInners) {
            AlgebraicPlanChecker algChecker = new AlgebraicPlanChecker(pplan);
            algChecker.visit();
            if (algChecker.sawNonAlgebraic) {
                return null;
            }
            if (algChecker.sawDistinctAgg) {
                algebraicOps.add(new Pair<PODistinct, PhysicalPlan>(algChecker.getDistinct(), pplan));
                continue;
            }
            List roots = pplan.getRoots();
            for (PhysicalOperator root : roots) {
                if (root instanceof ConstantExpression) continue;
                if (!(root instanceof POProject)) {
                    return null;
                }
                POProject proj = (POProject)root;
                POUserFunc combineUdf = this.getAlgebraicSuccessor(proj, pplan);
                if (combineUdf == null) {
                    if (proj.isProjectToEnd()) {
                        return null;
                    }
                    ArrayList<Integer> cols = proj.getColumns();
                    if (cols != null && cols.size() == 1 && (Integer)cols.get(0) == 0) continue;
                    return null;
                }
                boolean exist = false;
                for (Pair<PhysicalOperator, PhysicalPlan> pair : algebraicOps) {
                    if (!((PhysicalOperator)pair.first).equals(combineUdf)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                algebraicOps.add(new Pair<POUserFunc, PhysicalPlan>(combineUdf, pplan));
            }
        }
        return algebraicOps;
    }

    private POUserFunc getAlgebraicSuccessor(POProject proj, PhysicalPlan pplan) {
        List<POProject> succs = pplan.getSuccessors(proj);
        if (succs == null || succs.size() == 0) {
            return null;
        }
        if (succs.size() > 1) {
            return null;
        }
        PhysicalOperator succ = succs.get(0);
        if (succ instanceof POProject) {
            return this.getAlgebraicSuccessor((POProject)succ, pplan);
        }
        if (succ instanceof POUserFunc && ((POUserFunc)succ).combinable()) {
            return (POUserFunc)succ;
        }
        return null;
    }

    private POForEach createForEachWithGrpProj(POForEach foreach, byte keyType) {
        String scope = foreach.getOperatorKey().scope;
        POForEach newFE = new POForEach(this.createOperatorKey(scope), (List)new ArrayList());
        newFE.addOriginalLocation(foreach.getAlias(), foreach.getOriginalLocations());
        newFE.setResultType(foreach.getResultType());
        PhysicalPlan grpProjPlan = new PhysicalPlan();
        POProject proj = new POProject(this.createOperatorKey(scope), 1, 0);
        proj.setResultType(keyType);
        grpProjPlan.add(proj);
        newFE.addInputPlan(grpProjPlan, false);
        return newFE;
    }

    private PhysicalPlan createPlanWithPredecessors(PhysicalOperator algeOp, PhysicalPlan pplan) throws CloneNotSupportedException, PlanException {
        PhysicalPlan newplan = new PhysicalPlan();
        this.addPredecessorsToPlan(algeOp, pplan, newplan);
        return newplan;
    }

    private PhysicalOperator addPredecessorsToPlan(PhysicalOperator op, PhysicalPlan pplan, PhysicalPlan newplan) throws CloneNotSupportedException, PlanException {
        PhysicalOperator newOp = op.clone();
        newplan.add(newOp);
        if (pplan.getPredecessors(op) == null || pplan.getPredecessors(op).size() == 0) {
            return newOp;
        }
        for (PhysicalOperator pred : pplan.getPredecessors(op)) {
            PhysicalOperator newPred = this.addPredecessorsToPlan(pred, pplan, newplan);
            newplan.connect(newPred, newOp);
        }
        return newOp;
    }

    private void addAlgebraicFuncToCombineFE(POForEach cfe, Map<PhysicalOperator, Integer> op2newpos) throws CloneNotSupportedException, PlanException {
        PhysicalOperator[] opsInOrder = new PhysicalOperator[op2newpos.size() + 1];
        for (Map.Entry<PhysicalOperator, Integer> op2pos : op2newpos.entrySet()) {
            opsInOrder[op2pos.getValue().intValue()] = op2pos.getKey();
        }
        for (int i = 1; i < opsInOrder.length; ++i) {
            PhysicalPlan newPlan = new PhysicalPlan();
            PhysicalOperator newOp = opsInOrder[i].clone();
            newPlan.add(newOp);
            POProject proj = new POProject(this.createOperatorKey(cfe.getOperatorKey().getScope()), 1, i);
            proj.setResultType((byte)120);
            newPlan.add(proj);
            newPlan.connect(proj, newOp);
            cfe.addInputPlan(newPlan, false);
        }
    }

    private void patchUpMap(PhysicalPlan mapPlan, POPreCombinerLocalRearrange preCombinerLR, POForEach mfe, POPartialAgg mapAgg, POLocalRearrange mlr) throws PlanException {
        POLocalRearrange oldLR = (POLocalRearrange)mapPlan.getLeaves().get(0);
        mapPlan.replace(oldLR, preCombinerLR);
        mapPlan.add(mfe);
        mapPlan.connect(preCombinerLR, mfe);
        PhysicalOperator opBeforeLR = mfe;
        if (mapAgg != null) {
            mapPlan.add(mapAgg);
            mapPlan.connect(mfe, mapAgg);
            opBeforeLR = mapAgg;
        }
        mapPlan.add(mlr);
        mapPlan.connect(opBeforeLR, mlr);
    }

    private POPreCombinerLocalRearrange getPreCombinerLR(POLocalRearrange rearrange) {
        String scope = rearrange.getOperatorKey().scope;
        POPreCombinerLocalRearrange pclr = new POPreCombinerLocalRearrange(this.createOperatorKey(scope), rearrange.getRequestedParallelism(), rearrange.getInputs());
        pclr.setPlans(rearrange.getPlans());
        return pclr;
    }

    private OperatorKey createOperatorKey(String scope) {
        return new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope));
    }

    private void setProjectInput(PhysicalOperator op, PhysicalPlan plan, int index) throws PlanException {
        String scope = op.getOperatorKey().scope;
        POProject proj = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), op.getRequestedParallelism(), index);
        proj.setResultType((byte)120);
        plan.trimAbove(op);
        plan.add(proj);
        plan.connect(proj, op);
        ArrayList<PhysicalOperator> inputs = new ArrayList<PhysicalOperator>(1);
        inputs.add(proj);
        op.setInputs(inputs);
    }

    private void changeFunc(POForEach fe, byte type) throws PlanException {
        for (PhysicalPlan plan : fe.getInputPlans()) {
            List leaves = plan.getLeaves();
            if (leaves == null || leaves.size() != 1) {
                int errCode = 2019;
                String msg = "Expected to find plan with single leaf. Found " + leaves.size() + " leaves.";
                throw new PlanException(msg, errCode, 4);
            }
            PhysicalOperator leaf = (PhysicalOperator)leaves.get(0);
            if (leaf instanceof POProject) continue;
            if (!(leaf instanceof POUserFunc)) {
                int errCode = 2020;
                String msg = "Expected to find plan with UDF or project leaf. Found " + leaf.getClass().getSimpleName();
                throw new PlanException(msg, errCode, 4);
            }
            POUserFunc func = (POUserFunc)leaf;
            try {
                func.setAlgebraicFunction(type);
            }
            catch (ExecException e) {
                int errCode = 2075;
                String msg = "Could not set algebraic function type.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    private POLocalRearrange getNewRearrange(POLocalRearrange rearrange) throws PlanException, CloneNotSupportedException {
        POLocalRearrange newRearrange = rearrange.clone();
        PhysicalPlan newPlan = new PhysicalPlan();
        String scope = newRearrange.getOperatorKey().scope;
        POProject proj = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, 0);
        proj.setResultType(newRearrange.getKeyType());
        newPlan.add(proj);
        ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>(1);
        plans.add(newPlan);
        newRearrange.setPlansFromCombiner(plans);
        return newRearrange;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class fixMapProjects
    extends PhyPlanVisitor {
        public fixMapProjects(PhysicalPlan plan) {
            this(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public fixMapProjects(PhysicalPlan plan, PlanWalker<PhysicalOperator, PhysicalPlan> walker) {
            super(plan, walker);
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            if (proj.getResultType() == 120) {
                proj.setResultSingleTupleBag(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistinctPatcher
    extends PhyPlanVisitor {
        private POUserFunc distinct = null;

        public DistinctPatcher(PhysicalPlan plan, PlanWalker<PhysicalOperator, PhysicalPlan> walker) {
            super(plan, walker);
        }

        public DistinctPatcher(PhysicalPlan physicalPlan) {
            this(physicalPlan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(physicalPlan));
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            List<POProject> preds = ((PhysicalPlan)this.mPlan).getPredecessors(proj);
            if (preds == null) {
                return;
            }
            PhysicalOperator pred = preds.get(0);
            if (preds.size() == 1 && pred instanceof PODistinct) {
                if (this.distinct != null) {
                    int errCode = 2076;
                    String msg = "Unexpected Project-Distinct pair while trying to set up plans for use with combiner.";
                    throw new OptimizerException(msg, errCode, 4);
                }
                PhysicalOperator distinctPredecessor = ((PhysicalPlan)this.mPlan).getPredecessors(pred).get(0);
                POUserFunc func = null;
                try {
                    String scope = proj.getOperatorKey().scope;
                    ArrayList<PhysicalOperator> funcInput = new ArrayList<PhysicalOperator>();
                    FuncSpec fSpec = new FuncSpec(DISTINCT_UDF_CLASSNAME);
                    funcInput.add(distinctPredecessor);
                    distinctPredecessor.setResultType((byte)110);
                    func = new POUserFunc(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, funcInput, fSpec);
                    func.setResultType((byte)120);
                    ((PhysicalPlan)this.mPlan).replace(proj, func);
                    ((PhysicalPlan)this.mPlan).remove(pred);
                    ((PhysicalPlan)this.mPlan).connect(distinctPredecessor, func);
                }
                catch (PlanException e) {
                    int errCode = 2077;
                    String msg = "Problem with reconfiguring plan to add distinct built-in function.";
                    throw new OptimizerException(msg, errCode, 4, (Throwable)e);
                }
                this.distinct = func;
            }
        }

        POUserFunc getDistinct() {
            return this.distinct;
        }
    }

    private static class AlgebraicPlanChecker
    extends PhyPlanVisitor {
        boolean sawNonAlgebraic = false;
        boolean sawDistinctAgg = false;
        private boolean sawForeach = false;
        private PODistinct distinct = null;

        AlgebraicPlanChecker(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public void visit() throws VisitorException {
            super.visit();
            if (this.sawForeach && !this.sawDistinctAgg) {
                this.sawNonAlgebraic = true;
            }
        }

        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.distinct = distinct;
            if (this.sawDistinctAgg) {
                this.sawNonAlgebraic = true;
                return;
            }
            PhysicalOperator leaf = (PhysicalOperator)((PhysicalPlan)this.mPlan).getLeaves().get(0);
            if (leaf instanceof POUserFunc) {
                List<PhysicalOperator> preds = ((PhysicalPlan)this.mPlan).getPredecessors(leaf);
                if (preds.size() > 1) {
                    this.sawNonAlgebraic = true;
                    return;
                }
                List<PODistinct> immediateSuccs = ((PhysicalPlan)this.mPlan).getSuccessors(distinct);
                if (immediateSuccs.size() == 1 && immediateSuccs.get(0) instanceof POProject) {
                    PhysicalOperator op;
                    if (this.checkSuccessorIsLeaf(leaf, immediateSuccs.get(0))) {
                        this.sawDistinctAgg = true;
                        return;
                    }
                    List<Operator> nextSuccs = ((PhysicalPlan)this.mPlan).getSuccessors((Operator)immediateSuccs.get(0));
                    if (nextSuccs.size() == 1 && (op = (PhysicalOperator)nextSuccs.get(0)) instanceof POProject && this.checkSuccessorIsLeaf(leaf, op)) {
                        this.sawDistinctAgg = true;
                        return;
                    }
                }
            }
            this.sawNonAlgebraic = true;
        }

        public PODistinct getDistinct() {
            if (this.sawNonAlgebraic) {
                return null;
            }
            return this.distinct;
        }

        public void visitLimit(POLimit limit) throws VisitorException {
            this.sawNonAlgebraic = true;
        }

        private boolean checkSuccessorIsLeaf(PhysicalOperator leaf, PhysicalOperator opToCheck) {
            PhysicalOperator op;
            List<PhysicalOperator> succs = ((PhysicalPlan)this.mPlan).getSuccessors(opToCheck);
            return succs.size() == 1 && (op = succs.get(0)) == leaf;
        }

        public void visitFilter(POFilter filter) throws VisitorException {
            this.sawNonAlgebraic = true;
        }

        public void visitPOForEach(POForEach fe) throws VisitorException {
            this.sawForeach = true;
        }

        public void visitSort(POSort sort) throws VisitorException {
            this.sawNonAlgebraic = true;
        }
    }
}

