/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.InterRegionServerIndexRpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.HashJoinCacheNotFoundException;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.table.CoprocessorHTableFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.util.PropertiesUtil;

public class ServerUtil {
    private static final Log LOG = LogFactory.getLog(ServerUtil.class);
    private static final int COPROCESSOR_SCAN_WORKS = VersionUtil.encodeVersion("0.98.6");
    private static final String FORMAT = "ERROR %d (%s): %s";
    private static final Pattern PATTERN = Pattern.compile("ERROR (\\d+) \\((\\w+)\\): (.*)");
    private static final Pattern HASH_JOIN_EXCEPTION_PATTERN = Pattern.compile("joinId: (-?\\d+)");
    private static final Pattern PATTERN_FOR_TS = Pattern.compile(",serverTimestamp=(\\d+),");
    private static final String FORMAT_FOR_TIMESTAMP = ",serverTimestamp=%d,";
    private static final Map<Class<? extends Exception>, SQLExceptionCode> errorcodeMap = new HashMap<Class<? extends Exception>, SQLExceptionCode>();

    public static void throwIOException(String msg, Throwable t) throws IOException {
        throw ServerUtil.createIOException(msg, t);
    }

    public static IOException createIOException(String msg, Throwable t) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof IOException) {
            t = cause;
        }
        if (t instanceof DoNotRetryIOException) {
            return (DoNotRetryIOException)t;
        }
        if (t instanceof IOException) {
            cause = t.getCause();
            if (cause instanceof RetriesExhaustedWithDetailsException) {
                return new DoNotRetryIOException(t.getMessage(), cause);
            }
            if (cause == null || cause instanceof IOException) {
                return (IOException)t;
            }
            return new DoNotRetryIOException(t.getMessage(), cause);
        }
        if (t instanceof SQLException) {
            return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage((SQLException)t, msg), t);
        }
        SQLExceptionCode code = errorcodeMap.get(t.getClass());
        if (code == null) {
            return new DoNotRetryIOException(msg + ": " + t.getMessage(), t);
        }
        return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage(code, t, msg), t);
    }

    private static String constructSQLErrorMessage(SQLExceptionCode code, Throwable e, String message) {
        return ServerUtil.constructSQLErrorMessage(code.getErrorCode(), code.getSQLState(), code.getMessage() + " " + e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(SQLException e, String message) {
        return ServerUtil.constructSQLErrorMessage(e.getErrorCode(), e.getSQLState(), e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(int errorCode, String SQLState, String message) {
        return String.format(FORMAT, errorCode, SQLState, message);
    }

    public static SQLException parseServerException(Throwable t) {
        SQLException e = ServerUtil.parseServerExceptionOrNull(t);
        if (e != null) {
            return e;
        }
        return new PhoenixIOException(t);
    }

    public static SQLException parseLocalOrRemoteServerException(Throwable t) {
        while (t.getCause() != null) {
            if (t instanceof NotServingRegionException) {
                return ServerUtil.parseRemoteException(new StaleRegionBoundaryCacheException());
            }
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            t = t.getCause();
        }
        return ServerUtil.parseRemoteException(t);
    }

    public static SQLException parseServerExceptionOrNull(Throwable t) {
        while (t.getCause() != null) {
            if (t instanceof NotServingRegionException) {
                return ServerUtil.parseRemoteException(new StaleRegionBoundaryCacheException());
            }
            t = t.getCause();
        }
        return ServerUtil.parseRemoteException(t);
    }

    private static SQLException parseRemoteException(Throwable t) {
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN.matcher(t.getLocalizedMessage())).find()) {
            Matcher m;
            int statusCode = Integer.parseInt(matcher.group(1));
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
            if (code.equals((Object)SQLExceptionCode.HASH_JOIN_CACHE_NOT_FOUND) && (m = HASH_JOIN_EXCEPTION_PATTERN.matcher(t.getLocalizedMessage())).find()) {
                return new HashJoinCacheNotFoundException(Long.parseLong(m.group(1)));
            }
            return new SQLExceptionInfo.Builder(code).setMessage(matcher.group()).setRootCause(t).build().buildException();
        }
        return null;
    }

    private static boolean coprocessorScanWorks(RegionCoprocessorEnvironment env) {
        return VersionUtil.encodeVersion(env.getHBaseVersion()) >= COPROCESSOR_SCAN_WORKS;
    }

    private static HTableInterface getTableFromSingletonPool(RegionCoprocessorEnvironment env, byte[] tableName) throws IOException {
        HTablePool pool = new HTablePool(env.getConfiguration(), 1);
        try {
            return pool.getTable(tableName);
        }
        catch (RuntimeException t) {
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            throw t;
        }
    }

    public static HTableInterface getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, HTableInterface writerTable) throws IOException {
        if (ServerUtil.coprocessorScanWorks(env)) {
            return writerTable;
        }
        return ServerUtil.getTableFromSingletonPool(env, writerTable.getTableName());
    }

    public static HTableInterface getHTableForCoprocessorScan(RegionCoprocessorEnvironment env, byte[] tableName) throws IOException {
        if (ServerUtil.coprocessorScanWorks(env)) {
            return env.getTable(TableName.valueOf((byte[])tableName));
        }
        return ServerUtil.getTableFromSingletonPool(env, tableName);
    }

    public static long parseServerTimestamp(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return ServerUtil.parseTimestampFromRemoteException(t);
    }

    public static long parseTimestampFromRemoteException(Throwable t) {
        String tsString;
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN_FOR_TS.matcher(t.getLocalizedMessage())).find() && (tsString = matcher.group(1)) != null) {
            return Long.parseLong(tsString);
        }
        return Long.MAX_VALUE;
    }

    public static DoNotRetryIOException wrapInDoNotRetryIOException(String msg, Throwable t, long timestamp) {
        if (msg == null) {
            msg = "";
        }
        if (t instanceof SQLException) {
            msg = t.getMessage() + " " + msg;
        }
        msg = msg + String.format(FORMAT_FOR_TIMESTAMP, timestamp);
        return new DoNotRetryIOException(msg, t);
    }

    public static boolean readyToCommit(int rowCount, long mutationSize, int maxBatchSize, long maxBatchSizeBytes) {
        return maxBatchSize > 0 && rowCount >= maxBatchSize || maxBatchSizeBytes > 0L && mutationSize >= maxBatchSizeBytes;
    }

    public static boolean isKeyInRegion(byte[] key, Region region) {
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] endKey = region.getRegionInfo().getEndKey();
        return Bytes.compareTo((byte[])startKey, (byte[])key) <= 0 && (Bytes.compareTo((byte[])HConstants.LAST_ROW, (byte[])endKey) == 0 || Bytes.compareTo((byte[])key, (byte[])endKey) < 0);
    }

    public static HTableFactory getDelegateHTableFactory(CoprocessorEnvironment env, ConnectionType connectionType) {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            return new CoprocessorHConnectionTableFactory(env.getConfiguration(), (HRegionServer)services, connectionType);
        }
        return new CoprocessorHTableFactory(env);
    }

    public static Configuration getCompactionConfig(Configuration conf) {
        Configuration compactionConfig = PropertiesUtil.cloneConfig(conf);
        compactionConfig.setInt("hbase.client.retries.number", conf.getInt("phoenix.metadata.rpc.retries.number", 20));
        compactionConfig.setInt("hbase.client.pause", conf.getInt("phoenix.metadata.rpc.pause", 100));
        return compactionConfig;
    }

    public static Configuration getIndexWriterConnection(Configuration conf) {
        Configuration clonedConfig = PropertiesUtil.cloneConfig(conf);
        clonedConfig.setClass("hbase.rpc.controllerfactory.class", InterRegionServerIndexRpcControllerFactory.class, RpcControllerFactory.class);
        clonedConfig.setInt("hbase.client.retries.number", conf.getInt("phoenix.index.writes.rpc.retries.number", 11));
        clonedConfig.setInt("hbase.client.pause", conf.getInt("phoenix.index.writes.rpc.pause", 100));
        return clonedConfig;
    }

    public static Configuration getIndexWriterConfigurationWithCustomThreads(Configuration conf) {
        Configuration clonedConfig = ServerUtil.getIndexWriterConnection(conf);
        ServerUtil.setHTableThreads(clonedConfig);
        return clonedConfig;
    }

    private static void setHTableThreads(Configuration conf) {
        int htableThreads = conf.getInt("index.writer.threads.pertable.max", Integer.MAX_VALUE);
        IndexManagementUtil.setIfNotSet(conf, "hbase.htable.threads.max", htableThreads);
    }

    public static Configuration getNoRetriesIndexWriterConfigurationWithCustomThreads(Configuration conf) {
        Configuration clonedConf = ServerUtil.getIndexWriterConfigurationWithCustomThreads(conf);
        clonedConf.setInt("hbase.client.retries.number", 1);
        return clonedConf;
    }

    static {
        errorcodeMap.put(ArithmeticException.class, SQLExceptionCode.SERVER_ARITHMETIC_ERROR);
    }

    public static class ConnectionFactory {
        private static Map<ConnectionType, ClusterConnection> connections = new ConcurrentHashMap<ConnectionType, ClusterConnection>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void shutdown() {
            Class<CoprocessorHConnectionTableFactory> clazz = CoprocessorHConnectionTableFactory.class;
            synchronized (CoprocessorHConnectionTableFactory.class) {
                for (ClusterConnection connection : connections.values()) {
                    try {
                        connection.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Unable to close coprocessor connection", (Throwable)e);
                    }
                }
                connections.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ClusterConnection getConnection(ConnectionType connectionType, Configuration conf, HRegionServer server) throws IOException {
            ClusterConnection connection = null;
            connection = connections.get((Object)connectionType);
            if (connection != null) return connection;
            Class<CoprocessorHConnectionTableFactory> clazz = CoprocessorHConnectionTableFactory.class;
            synchronized (CoprocessorHConnectionTableFactory.class) {
                connection = connections.get((Object)connectionType);
                if (connection != null) return connection;
                connection = new CoprocessorHConnection(ConnectionFactory.getTypeSpecificConfiguration(connectionType, conf), server);
                connections.put(connectionType, connection);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return connection;
            }
        }

        public static Configuration getTypeSpecificConfiguration(ConnectionType connectionType, Configuration conf) {
            switch (connectionType) {
                case COMPACTION_CONNECTION: {
                    return ServerUtil.getCompactionConfig(conf);
                }
                case DEFAULT_SERVER_CONNECTION: {
                    return conf;
                }
                case INDEX_WRITER_CONNECTION: {
                    return ServerUtil.getIndexWriterConnection(conf);
                }
                case INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS: {
                    return ServerUtil.getIndexWriterConfigurationWithCustomThreads(conf);
                }
                case INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES: {
                    return ServerUtil.getNoRetriesIndexWriterConfigurationWithCustomThreads(conf);
                }
            }
            return conf;
        }
    }

    public static enum ConnectionType {
        COMPACTION_CONNECTION,
        INDEX_WRITER_CONNECTION,
        INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS,
        INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES,
        DEFAULT_SERVER_CONNECTION;

    }

    public static class CoprocessorHConnectionTableFactory
    implements HTableFactory {
        private final Configuration conf;
        private final HRegionServer server;
        private final ConnectionType connectionType;

        CoprocessorHConnectionTableFactory(Configuration conf, HRegionServer server, ConnectionType connectionType) {
            this.conf = conf;
            this.server = server;
            this.connectionType = connectionType;
        }

        private ClusterConnection getConnection() throws IOException {
            return ConnectionFactory.getConnection(this.connectionType, this.conf, this.server);
        }

        @Override
        public HTableInterface getTable(ImmutableBytesPtr tablename) throws IOException {
            return this.getConnection().getTable(tablename.copyBytesIfNecessary());
        }

        @Override
        public void shutdown() {
            ConnectionFactory.shutdown();
        }

        @Override
        public HTableInterface getTable(ImmutableBytesPtr tablename, ExecutorService pool) throws IOException {
            return this.getConnection().getTable(tablename.copyBytesIfNecessary(), pool);
        }
    }
}

