/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.StringUtil;

public class SchemaUtil {
    private static final int VAR_LENGTH_ESTIMATE = 10;
    private static final int VAR_KV_LENGTH_ESTIMATE = 50;
    public static final String ESCAPE_CHARACTER = "\"";
    public static final DataBlockEncoding DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.FAST_DIFF;
    public static final PDatum VAR_BINARY_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PVarbinary.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    public static final RowKeySchema VAR_BINARY_SCHEMA = new RowKeySchema.RowKeySchemaBuilder(1).addField(VAR_BINARY_DATUM, false, SortOrder.getDefault()).build();
    public static final String SCHEMA_FOR_DEFAULT_NAMESPACE = "default";
    public static final String HBASE_NAMESPACE = "hbase";
    public static final List<String> NOT_ALLOWED_SCHEMA_LIST = Arrays.asList("default", "hbase");

    private SchemaUtil() {
    }

    public static boolean isPKColumn(PColumn column) {
        return column.getFamilyName() == null;
    }

    public static long estimateRowSize(PTable table) {
        int keyLength = SchemaUtil.estimateKeyLength(table);
        long rowSize = 0L;
        for (PColumn column : table.getColumns()) {
            if (SchemaUtil.isPKColumn(column)) continue;
            PDataType type = column.getDataType();
            Integer maxLength = column.getMaxLength();
            int valueLength = !type.isFixedWidth() ? 50 : (maxLength == null ? type.getByteSize() : maxLength);
            rowSize += KeyValue.getKeyValueDataStructureSize((int)keyLength, (int)column.getFamilyName().getBytes().length, (int)column.getName().getBytes().length, (int)valueLength);
        }
        byte[] emptyKeyValueKV = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
        return rowSize += KeyValue.getKeyValueDataStructureSize((int)keyLength, (int)SchemaUtil.getEmptyColumnFamily(table).length, (int)emptyKeyValueKV.length, (int)0);
    }

    public static int estimateKeyLength(PTable table) {
        int maxKeyLength = 0;
        int i = 0;
        List<PColumn> columns = table.getPKColumns();
        while (i < columns.size()) {
            PColumn keyColumn = columns.get(i++);
            PDataType type = keyColumn.getDataType();
            Integer maxLength = keyColumn.getMaxLength();
            maxKeyLength += !type.isFixedWidth() ? 10 : (maxLength == null ? type.getByteSize() : maxLength);
        }
        return maxKeyLength;
    }

    public static String normalizeIdentifier(String name) {
        if (name == null) {
            return name;
        }
        if (SchemaUtil.isCaseSensitive(name)) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    public static String normalizeLiteral(LiteralParseNode literal) {
        if (literal == null) {
            return null;
        }
        String literalString = literal.toString();
        if (SchemaUtil.isEnclosedInSingleQuotes(literalString)) {
            return literalString.substring(1, literalString.length() - 1);
        }
        return literalString;
    }

    public static String normalizeFullTableName(String fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
        String normalizedTableName = "";
        if (!schemaName.isEmpty()) {
            normalizedTableName = SchemaUtil.normalizeIdentifier(schemaName) + ".";
        }
        return normalizedTableName + SchemaUtil.normalizeIdentifier(tableName);
    }

    public static boolean isEnclosedInSingleQuotes(String name) {
        return name != null && name.length() > 0 && name.charAt(0) == '\'';
    }

    public static boolean isCaseSensitive(String name) {
        return name != null && name.length() > 0 && name.charAt(0) == '\"';
    }

    private static boolean isExistingTableMappedToPhoenixName(String name) {
        return name != null && name.length() > 0 && name.charAt(0) == '\"' && name.indexOf(ESCAPE_CHARACTER, 1) == name.length() - 1;
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        int size1 = l1.size();
        if (size1 == 0) {
            return l2;
        }
        int size2 = l2.size();
        if (size2 == 0) {
            return l1;
        }
        ArrayList<T> l3 = new ArrayList<T>(size1 + size2);
        l3.addAll(l1);
        l3.addAll(l2);
        return l3;
    }

    public static byte[] getTableKey(byte[] tenantId, byte[] schemaName, byte[] tableName) {
        return ByteUtil.concat(tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName);
    }

    public static byte[] getFunctionKey(byte[] tenantId, byte[] functionName) {
        return ByteUtil.concat(tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, functionName);
    }

    public static byte[] getKeyForSchema(String tenantId, String schemaName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName));
    }

    public static byte[] getTableKey(String tenantId, String schemaName, String tableName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)tableName));
    }

    public static byte[] getColumnKey(String tenantId, String schemaName, String tableName, String columnName, String familyName) {
        Preconditions.checkNotNull((Object)columnName, (Object)"Column name cannot be null");
        if (familyName == null) {
            return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)columnName));
        }
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)columnName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)familyName));
    }

    public static String getTableName(String schemaName, String tableName) {
        return SchemaUtil.getName(schemaName, tableName, false);
    }

    private static String getName(String optionalQualifier, String name, boolean caseSensitive) {
        String cq;
        String string = cq = caseSensitive ? ESCAPE_CHARACTER + name + ESCAPE_CHARACTER : name;
        if (optionalQualifier == null || optionalQualifier.isEmpty()) {
            return cq;
        }
        String cf = caseSensitive ? ESCAPE_CHARACTER + optionalQualifier + ESCAPE_CHARACTER : optionalQualifier;
        return cf + "." + cq;
    }

    private static String getName(String name, boolean caseSensitive) {
        String cq = caseSensitive ? ESCAPE_CHARACTER + name + ESCAPE_CHARACTER : name;
        return cq;
    }

    public static String getTableName(byte[] schemaName, byte[] tableName) {
        return SchemaUtil.getName(schemaName, tableName);
    }

    public static String getColumnDisplayName(byte[] cf, byte[] cq) {
        return SchemaUtil.getName(cf == null || cf.length == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : cf, cq);
    }

    public static String getColumnDisplayName(String cf, String cq) {
        return SchemaUtil.getName(cf == null || cf.isEmpty() ? null : cf, cq, false);
    }

    public static String getColumnDisplayName(PColumn column) {
        PName columnName = column.getFamilyName();
        String cf = columnName == null ? null : columnName.getString();
        return SchemaUtil.getName(cf == null || cf.isEmpty() ? null : cf, column.getName().getString(), false);
    }

    public static String getCaseSensitiveColumnDisplayName(String cf, String cq) {
        return SchemaUtil.getName(cf == null || cf.isEmpty() ? null : cf, cq, true);
    }

    public static String getMetaDataEntityName(String schemaName, String tableName, String familyName, String columnName) {
        if ((schemaName == null || schemaName.isEmpty()) && (tableName == null || tableName.isEmpty())) {
            if (columnName == null || columnName.isEmpty()) {
                return familyName;
            }
            return SchemaUtil.getName(familyName, columnName, false);
        }
        if (!(familyName != null && !familyName.isEmpty() || columnName != null && !columnName.isEmpty() || tableName != null && !tableName.equals(" "))) {
            return SchemaUtil.getName(schemaName, false);
        }
        if ((familyName == null || familyName.isEmpty()) && (columnName == null || columnName.isEmpty())) {
            return SchemaUtil.getName(schemaName, tableName, false);
        }
        return SchemaUtil.getName(SchemaUtil.getName(schemaName, tableName, false), SchemaUtil.getName(familyName, columnName, false), false);
    }

    public static String getColumnName(String familyName, String columnName) {
        return SchemaUtil.getName(familyName, columnName, false);
    }

    public static List<String> getColumnNames(List<PColumn> pCols) {
        return Lists.transform(pCols, (Function)new Function<PColumn, String>(){

            public String apply(PColumn input) {
                return input.getName().getString();
            }
        });
    }

    public static byte[] getTableNameAsBytes(String schemaName, String tableName) {
        if (schemaName == null || schemaName.length() == 0) {
            return StringUtil.toBytes(tableName);
        }
        return SchemaUtil.getTableNameAsBytes(StringUtil.toBytes(schemaName), StringUtil.toBytes(tableName));
    }

    public static byte[] getTableNameAsBytes(byte[] schemaName, byte[] tableName) {
        return SchemaUtil.getNameAsBytes(schemaName, tableName);
    }

    private static byte[] getNameAsBytes(byte[] nameOne, byte[] nameTwo) {
        if (nameOne == null || nameOne.length == 0) {
            return nameTwo;
        }
        if (nameTwo == null || nameTwo.length == 0) {
            return nameOne;
        }
        return ByteUtil.concat(nameOne, QueryConstants.NAME_SEPARATOR_BYTES, nameTwo);
    }

    public static String getName(byte[] nameOne, byte[] nameTwo) {
        return Bytes.toString((byte[])SchemaUtil.getNameAsBytes(nameOne, nameTwo));
    }

    public static int getVarCharLength(byte[] buf, int keyOffset, int maxLength) {
        return SchemaUtil.getVarCharLength(buf, keyOffset, maxLength, 1);
    }

    public static int getVarCharLength(byte[] buf, int keyOffset, int maxLength, int skipCount) {
        int length = 0;
        for (int i = 0; i < skipCount; ++i) {
            while (length < maxLength && buf[keyOffset + length] != 0) {
                ++length;
            }
            if (i == skipCount - 1) continue;
            ++length;
        }
        return length;
    }

    public static int getVarChars(byte[] rowKey, byte[][] rowKeyMetadata) {
        return SchemaUtil.getVarChars(rowKey, 0, rowKey.length, 0, rowKeyMetadata);
    }

    public static int getVarChars(byte[] rowKey, int colMetaDataLength, byte[][] colMetaData) {
        return SchemaUtil.getVarChars(rowKey, 0, rowKey.length, 0, colMetaDataLength, colMetaData);
    }

    public static int getVarChars(byte[] rowKey, int keyOffset, int keyLength, int colMetaDataOffset, byte[][] colMetaData) {
        return SchemaUtil.getVarChars(rowKey, keyOffset, keyLength, colMetaDataOffset, colMetaData.length, colMetaData);
    }

    public static int getVarChars(byte[] rowKey, int keyOffset, int keyLength, int colMetaDataOffset, int colMetaDataLength, byte[][] colMetaData) {
        int i;
        int length;
        int offset = keyOffset;
        for (i = colMetaDataOffset; i < colMetaDataLength && keyLength > 0; keyLength -= length + 1, ++i) {
            length = SchemaUtil.getVarCharLength(rowKey, offset, keyLength);
            byte[] b = new byte[length];
            System.arraycopy(rowKey, offset, b, 0, length);
            offset += length + 1;
            colMetaData[i] = b;
        }
        return i;
    }

    public static String findExistingColumn(PTable table, List<PColumn> columns) {
        for (PColumn column : columns) {
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                try {
                    return table.getPKColumn(column.getName().getString()).getName().getString();
                }
                catch (ColumnNotFoundException e) {
                    continue;
                }
            }
            try {
                return table.getColumnFamily(familyName.getString()).getPColumnForColumnName(column.getName().getString()).getName().getString();
            }
            catch (ColumnFamilyNotFoundException e) {
            }
            catch (ColumnNotFoundException e) {
            }
        }
        return null;
    }

    public static String toString(byte[][] values) {
        if (values == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("[");
        for (byte[] value : values) {
            buf.append(Bytes.toStringBinary((byte[])value));
            buf.append(',');
        }
        buf.setCharAt(buf.length() - 1, ']');
        return buf.toString();
    }

    public static String toString(PDataType type, byte[] value) {
        return SchemaUtil.toString(type, value, 0, value.length);
    }

    public static String toString(PDataType type, ImmutableBytesWritable value) {
        return SchemaUtil.toString(type, value.get(), value.getOffset(), value.getLength());
    }

    public static String toString(PDataType type, byte[] value, int offset, int length) {
        boolean isString = type.isCoercibleTo(PVarchar.INSTANCE);
        return isString ? "'" + type.toObject(value).toString() + "'" : type.toObject(value, offset, length).toString();
    }

    public static byte[] getEmptyColumnFamily(PName defaultColumnFamily, List<PColumnFamily> families) {
        return families.isEmpty() ? (defaultColumnFamily == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : defaultColumnFamily.getBytes()) : families.get(0).getName().getBytes();
    }

    public static byte[] getEmptyColumnFamily(PTable table) {
        List<PColumnFamily> families = table.getColumnFamilies();
        return families.isEmpty() ? (table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes()) : families.get(0).getName().getBytes();
    }

    public static String getEmptyColumnFamilyAsString(PTable table) {
        List<PColumnFamily> families = table.getColumnFamilies();
        return families.isEmpty() ? (table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString()) : families.get(0).getName().getString();
    }

    public static ImmutableBytesPtr getEmptyColumnFamilyPtr(PTable table) {
        List<PColumnFamily> families = table.getColumnFamilies();
        return families.isEmpty() ? (table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES_PTR : table.getDefaultFamilyName().getBytesPtr()) : families.get(0).getName().getBytesPtr();
    }

    public static boolean isMetaTable(byte[] tableName) {
        return Bytes.compareTo((byte[])tableName, (byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES) == 0 || Bytes.compareTo((byte[])tableName, (byte[])SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true).getName()) == 0;
    }

    public static boolean isFunctionTable(byte[] tableName) {
        return Bytes.compareTo((byte[])tableName, (byte[])PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES) == 0 || Bytes.compareTo((byte[])tableName, (byte[])SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES, true).getName()) == 0;
    }

    public static boolean isStatsTable(byte[] tableName) {
        return Bytes.compareTo((byte[])tableName, (byte[])PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES) == 0 || Bytes.compareTo((byte[])tableName, (byte[])SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, true).getName()) == 0;
    }

    public static boolean isSequenceTable(byte[] tableName) {
        return Bytes.compareTo((byte[])tableName, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES) == 0 || Bytes.compareTo((byte[])tableName, (byte[])SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, true).getName()) == 0;
    }

    public static boolean isSequenceTable(PTable table) {
        return PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME.equals(table.getName().getString());
    }

    public static boolean isMetaTable(PTable table) {
        return "SYSTEM".equals(table.getSchemaName().getString()) && "CATALOG".equals(table.getTableName().getString());
    }

    public static boolean isMetaTable(byte[] schemaName, byte[] tableName) {
        return Bytes.compareTo((byte[])schemaName, (byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_SCHEMA_BYTES) == 0 && Bytes.compareTo((byte[])tableName, (byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES) == 0;
    }

    public static boolean isMetaTable(String schemaName, String tableName) {
        return "SYSTEM".equals(schemaName) && "CATALOG".equals(tableName);
    }

    public static boolean isSystemTable(byte[] fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        return "SYSTEM".equals(schemaName);
    }

    public static byte[][] processSplits(byte[][] splits, LinkedHashSet<PColumn> pkColumns, Integer saltBucketNum, boolean defaultRowKeyOrder) throws SQLException {
        if (splits == null) {
            return null;
        }
        if (splits.length > 0 && saltBucketNum != null && defaultRowKeyOrder) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_SPLITS_ON_SALTED_TABLE).build().buildException();
        }
        if (splits.length == 0 && saltBucketNum != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(saltBucketNum);
        }
        byte[][] newSplits = new byte[splits.length][];
        for (int i = 0; i < splits.length; ++i) {
            newSplits[i] = SchemaUtil.processSplit(splits[i], pkColumns);
        }
        return newSplits;
    }

    private static byte[] processSplit(byte[] split, LinkedHashSet<PColumn> pkColumns) {
        int pos = 0;
        int offset = 0;
        int maxOffset = split.length;
        Iterator<PColumn> iterator = pkColumns.iterator();
        while (pos < pkColumns.size()) {
            PColumn column = (PColumn)iterator.next();
            if (column.getDataType().isFixedWidth()) {
                int length = SchemaUtil.getFixedByteSize(column);
                if (maxOffset - offset < length) {
                    int fillInLength = length - (maxOffset - offset);
                    return ByteUtil.fillKey(split, split.length + (fillInLength += SchemaUtil.estimatePartLength(pos + 1, iterator)));
                }
                offset += length;
                ++pos;
                continue;
            }
            if (pos == pkColumns.size() - 1) break;
            while (offset < maxOffset && split[offset] != 0) {
                ++offset;
            }
            if (offset == maxOffset) {
                int fillInLength = 1;
                return ByteUtil.fillKey(split, split.length + (fillInLength += SchemaUtil.estimatePartLength(pos + 1, iterator)));
            }
            ++offset;
            ++pos;
        }
        return split;
    }

    private static int estimatePartLength(int pos, Iterator<PColumn> iterator) {
        int length = 0;
        while (iterator.hasNext()) {
            PColumn column = iterator.next();
            if (column.getDataType().isFixedWidth()) {
                length += SchemaUtil.getFixedByteSize(column);
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String getEscapedTableName(String schemaName, String tableName) {
        if (schemaName == null || schemaName.length() == 0) {
            return ESCAPE_CHARACTER + tableName + ESCAPE_CHARACTER;
        }
        return ESCAPE_CHARACTER + schemaName + "\"." + ESCAPE_CHARACTER + tableName + ESCAPE_CHARACTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PhoenixConnection addMetaDataColumn(PhoenixConnection conn, long scn, String columnDef) throws SQLException {
        Statement stmt = null;
        try (PhoenixConnection metaConnection = null;){
            PhoenixConnection phoenixConnection;
            block8: {
                metaConnection = new PhoenixConnection(conn.getQueryServices(), conn, scn);
                try {
                    stmt = metaConnection.createStatement();
                    stmt.executeUpdate("ALTER TABLE SYSTEM.\"TABLE\" ADD IF NOT EXISTS " + columnDef);
                    phoenixConnection = metaConnection;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return phoenixConnection;
        }
    }

    public static boolean columnExists(PTable table, String columnName) {
        try {
            table.getColumnForColumnName(columnName);
            return true;
        }
        catch (ColumnNotFoundException e) {
            return false;
        }
        catch (AmbiguousColumnException e) {
            return true;
        }
    }

    public static String getSchemaNameFromFullName(String tableName) {
        if (SchemaUtil.isExistingTableMappedToPhoenixName(tableName)) {
            return "";
        }
        if (tableName.contains(":")) {
            return SchemaUtil.getSchemaNameFromFullName(tableName, ":");
        }
        return SchemaUtil.getSchemaNameFromFullName(tableName, ".");
    }

    public static String getSchemaNameFromFullName(String tableName, String separator) {
        int index = tableName.indexOf(separator);
        if (index < 0) {
            return "";
        }
        return tableName.substring(0, index);
    }

    private static int indexOf(byte[] bytes, byte b) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static String getSchemaNameFromFullName(byte[] tableName) {
        if (tableName == null) {
            return null;
        }
        if (SchemaUtil.isExistingTableMappedToPhoenixName(Bytes.toString((byte[])tableName))) {
            return "";
        }
        int index = SchemaUtil.indexOf(tableName, QueryConstants.NAME_SEPARATOR_BYTE);
        if (index < 0 && (index = SchemaUtil.indexOf(tableName, QueryConstants.NAMESPACE_SEPARATOR_BYTE)) < 0) {
            return "";
        }
        return Bytes.toString((byte[])tableName, (int)0, (int)index);
    }

    public static String getTableNameFromFullName(byte[] tableName) {
        if (tableName == null) {
            return null;
        }
        if (SchemaUtil.isExistingTableMappedToPhoenixName(Bytes.toString((byte[])tableName))) {
            return Bytes.toString((byte[])tableName);
        }
        int index = SchemaUtil.indexOf(tableName, QueryConstants.NAME_SEPARATOR_BYTE);
        if (index < 0 && (index = SchemaUtil.indexOf(tableName, QueryConstants.NAMESPACE_SEPARATOR_BYTE)) < 0) {
            return Bytes.toString((byte[])tableName);
        }
        return Bytes.toString((byte[])tableName, (int)(index + 1), (int)(tableName.length - index - 1));
    }

    public static String getTableNameFromFullName(String tableName) {
        if (SchemaUtil.isExistingTableMappedToPhoenixName(tableName)) {
            return tableName;
        }
        if (tableName.contains(":")) {
            return SchemaUtil.getTableNameFromFullName(tableName, ":");
        }
        return SchemaUtil.getTableNameFromFullName(tableName, ".");
    }

    public static String getTableNameFromFullName(String tableName, String separator) {
        int index = tableName.indexOf(separator);
        if (index < 0) {
            return tableName;
        }
        return tableName.substring(index + 1, tableName.length());
    }

    public static byte[] getTableKeyFromFullName(String fullTableName) {
        int index = fullTableName.indexOf(".");
        if (index < 0 && (index = fullTableName.indexOf(":")) < 0) {
            return SchemaUtil.getTableKey(null, null, fullTableName);
        }
        String schemaName = fullTableName.substring(0, index);
        String tableName = fullTableName.substring(index + 1);
        return SchemaUtil.getTableKey(null, schemaName, tableName);
    }

    private static int getTerminatorCount(RowKeySchema schema) {
        int nTerminators = 0;
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            ValueSchema.Field field = schema.getField(i);
            if (field.getDataType().isFixedWidth()) continue;
            ++nTerminators;
        }
        return nTerminators;
    }

    public static int getMaxKeyLength(RowKeySchema schema, List<List<KeyRange>> slots) {
        int maxKeyLength = SchemaUtil.getTerminatorCount(schema) * 2;
        for (List<KeyRange> slot : slots) {
            int maxSlotLength = 0;
            for (KeyRange range : slot) {
                int maxRangeLength = Math.max(range.getLowerRange().length, range.getUpperRange().length);
                if (maxSlotLength >= maxRangeLength) continue;
                maxSlotLength = maxRangeLength;
            }
            maxKeyLength += maxSlotLength;
        }
        return maxKeyLength;
    }

    public static int getFixedByteSize(PDatum e) {
        assert (e.getDataType().isFixedWidth());
        Integer maxLength = e.getMaxLength();
        return maxLength == null ? e.getDataType().getByteSize() : maxLength;
    }

    public static short getMaxKeySeq(PTable table) {
        int offset = 0;
        if (table.getBucketNum() != null) {
            ++offset;
        }
        return (short)(table.getPKColumns().size() - offset);
    }

    public static int getPKPosition(PTable table, PColumn column) {
        return table.getPKColumns().indexOf(column);
    }

    public static String getEscapedFullColumnName(String fullColumnName) {
        if (fullColumnName.startsWith(ESCAPE_CHARACTER)) {
            return fullColumnName;
        }
        int index = fullColumnName.indexOf(".");
        if (index < 0) {
            return SchemaUtil.getEscapedArgument(fullColumnName);
        }
        String columnFamily = fullColumnName.substring(0, index);
        String columnName = fullColumnName.substring(index + 1);
        return SchemaUtil.getEscapedArgument(columnFamily) + "." + SchemaUtil.getEscapedArgument(columnName);
    }

    public static List<String> getEscapedFullColumnNames(List<String> fullColumnNames) {
        return Lists.newArrayList((Iterable)Iterables.transform(fullColumnNames, (Function)new Function<String, String>(){

            public String apply(String col) {
                return SchemaUtil.getEscapedFullColumnName(col);
            }
        }));
    }

    public static String getEscapedFullTableName(String fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
        return SchemaUtil.getEscapedTableName(schemaName, tableName);
    }

    public static String getEscapedArgument(String argument) {
        Preconditions.checkNotNull((Object)argument, (Object)"Argument passed cannot be null");
        return ESCAPE_CHARACTER + argument + ESCAPE_CHARACTER;
    }

    public static String getQuotedFullColumnName(PColumn pCol) {
        Preconditions.checkNotNull((Object)pCol);
        String columnName = pCol.getName().getString();
        String columnFamilyName = pCol.getFamilyName() != null ? pCol.getFamilyName().getString() : null;
        return SchemaUtil.getQuotedFullColumnName(columnFamilyName, columnName);
    }

    public static String getQuotedFullColumnName(@Nullable String columnFamilyName, String columnName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0, (Object)"Column name cannot be null or empty");
        return columnFamilyName == null ? ESCAPE_CHARACTER + columnName + ESCAPE_CHARACTER : ESCAPE_CHARACTER + columnFamilyName + ESCAPE_CHARACTER + "." + ESCAPE_CHARACTER + columnName + ESCAPE_CHARACTER;
    }

    public static boolean hasHTableDescriptorProps(Map<String, Object> tableProps) {
        int pTablePropCount = 0;
        for (String prop : tableProps.keySet()) {
            if (!TableProperty.isPhoenixTableProperty(prop) && !prop.equals("DATA_TABLE_NAME")) continue;
            ++pTablePropCount;
        }
        return tableProps.size() - pTablePropCount > 0;
    }

    public static String getUnEscapedFullColumnName(String fullColumnName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fullColumnName) ? 1 : 0) != 0, (Object)"Column name cannot be null or empty");
        fullColumnName = fullColumnName.replaceAll(ESCAPE_CHARACTER, "");
        return fullColumnName.trim();
    }

    public static byte getSeparatorByte(boolean rowKeyOrderOptimizable, boolean isNullValue, SortOrder sortOrder) {
        return !rowKeyOrderOptimizable || isNullValue || sortOrder == SortOrder.ASC ? (byte)0 : QueryConstants.DESC_SEPARATOR_BYTE;
    }

    public static byte getSeparatorByte(boolean rowKeyOrderOptimizable, boolean isNullValue, ValueSchema.Field f) {
        return SchemaUtil.getSeparatorByte(rowKeyOrderOptimizable, isNullValue, f.getSortOrder());
    }

    public static byte getSeparatorByte(boolean rowKeyOrderOptimizable, boolean isNullValue, Expression e) {
        return SchemaUtil.getSeparatorByte(rowKeyOrderOptimizable, isNullValue, e.getSortOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnInfo> generateColumnInfo(Connection conn, String tableName, List<String> columns, boolean strict) throws SQLException {
        LinkedHashMap columnNameToTypeMap = Maps.newLinkedHashMap();
        HashSet<String> ambiguousColumnNames = new HashSet<String>();
        LinkedHashMap fullColumnNameToTypeMap = Maps.newLinkedHashMap();
        DatabaseMetaData dbmd = conn.getMetaData();
        int unfoundColumnCount = 0;
        String escapedTableName = StringUtil.escapeLike(tableName);
        String[] schemaAndTable = escapedTableName.split("\\.");
        try (ResultSet rs = null;){
            rs = dbmd.getColumns(null, schemaAndTable.length == 1 ? "" : schemaAndTable[0], schemaAndTable.length == 1 ? escapedTableName : schemaAndTable[1], null);
            while (rs.next()) {
                String colName = rs.getString(4);
                String colFam = rs.getString(25);
                String fullColumn = colFam == null ? colName : String.format("%s.%s", colFam, colName);
                String sqlTypeName = rs.getString(6);
                if (columnNameToTypeMap.keySet().contains(colName)) {
                    ambiguousColumnNames.add(colName);
                }
                columnNameToTypeMap.put(colName, PDataType.fromSqlTypeName(sqlTypeName).getSqlType());
                fullColumnNameToTypeMap.put(fullColumn, PDataType.fromSqlTypeName(sqlTypeName).getSqlType());
            }
            if (columnNameToTypeMap.isEmpty()) {
                throw new IllegalArgumentException("Table " + tableName + " not found");
            }
        }
        ArrayList columnInfoList = Lists.newArrayList();
        TreeSet<String> unresolvedColumnNames = new TreeSet<String>();
        if (columns == null) {
            for (Map.Entry entry : fullColumnNameToTypeMap.entrySet()) {
                columnInfoList.add(new ColumnInfo((String)entry.getKey(), (Integer)entry.getValue()));
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = columns.get(i).trim();
                Integer sqlType = null;
                if (fullColumnNameToTypeMap.containsKey(columnName)) {
                    sqlType = (Integer)fullColumnNameToTypeMap.get(columnName);
                } else if (columnNameToTypeMap.containsKey(columnName)) {
                    if (ambiguousColumnNames.contains(columnName)) {
                        unresolvedColumnNames.add(columnName);
                    }
                    sqlType = (Integer)columnNameToTypeMap.get(columnName);
                }
                if (unresolvedColumnNames.size() > 0) {
                    StringBuilder exceptionMessage = new StringBuilder();
                    boolean first = true;
                    exceptionMessage.append("Unable to resolve these column names to a single column family:\n");
                    for (String col : unresolvedColumnNames) {
                        if (first) {
                            first = false;
                        } else {
                            exceptionMessage.append(",");
                        }
                        exceptionMessage.append(col);
                    }
                    exceptionMessage.append("\nAvailable columns with column families:\n");
                    first = true;
                    for (String col : fullColumnNameToTypeMap.keySet()) {
                        if (first) {
                            first = false;
                        } else {
                            exceptionMessage.append(",");
                        }
                        exceptionMessage.append(col);
                    }
                    throw new SQLException(exceptionMessage.toString());
                }
                if (sqlType == null) {
                    if (strict) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_NOT_FOUND).setColumnName(columnName).setTableName(tableName).build().buildException();
                    }
                    ++unfoundColumnCount;
                    continue;
                }
                columnInfoList.add(new ColumnInfo(columnName, sqlType));
            }
            if (unfoundColumnCount == columns.size()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_NOT_FOUND).setColumnName(Arrays.toString(columns.toArray(new String[0]))).setTableName(tableName).build().buildException();
            }
        }
        return columnInfoList;
    }

    public static boolean hasRowTimestampColumn(PTable table) {
        return table.getRowTimestampColPos() > 0;
    }

    public static byte[] getTableKey(PTable dataTable) {
        PName tenantId = dataTable.getTenantId();
        PName schemaName = dataTable.getSchemaName();
        return SchemaUtil.getTableKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName.getBytes(), dataTable.getTableName().getBytes());
    }

    public static byte[] getSchemaKey(String schemaName) {
        return SchemaUtil.getTableKey(null, schemaName, " ");
    }

    public static PName getPhysicalHBaseTableName(PName schemaName, PName tableName, boolean isNamespaceMapped) {
        return SchemaUtil.getPhysicalHBaseTableName(schemaName == null ? null : schemaName.toString(), tableName.toString(), isNamespaceMapped);
    }

    public static PName getPhysicalHBaseTableName(byte[] schemaName, byte[] tableName, boolean isNamespaceMapped) {
        return SchemaUtil.getPhysicalHBaseTableName(Bytes.toString((byte[])schemaName), Bytes.toString((byte[])tableName), isNamespaceMapped);
    }

    public static TableName getPhysicalTableName(String fullTableName, ReadOnlyProps readOnlyProps) {
        return SchemaUtil.getPhysicalName(Bytes.toBytes((String)fullTableName), readOnlyProps);
    }

    public static TableName getPhysicalTableName(byte[] fullTableName, Configuration conf) {
        return SchemaUtil.getPhysicalTableName(fullTableName, SchemaUtil.isNamespaceMappingEnabled(SchemaUtil.isSystemTable(fullTableName) ? PTableType.SYSTEM : null, conf));
    }

    public static TableName getPhysicalName(byte[] fullTableName, ReadOnlyProps readOnlyProps) {
        return SchemaUtil.getPhysicalTableName(fullTableName, SchemaUtil.isNamespaceMappingEnabled(SchemaUtil.isSystemTable(fullTableName) ? PTableType.SYSTEM : null, readOnlyProps));
    }

    public static TableName getPhysicalTableName(byte[] fullTableName, boolean isNamespaceMappingEnabled) {
        if (SchemaUtil.indexOf(fullTableName, QueryConstants.NAMESPACE_SEPARATOR_BYTE) > 0 || !isNamespaceMappingEnabled) {
            return TableName.valueOf((byte[])fullTableName);
        }
        String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        return TableName.valueOf((String)schemaName, (String)tableName);
    }

    public static PName getPhysicalHBaseTableName(String schemaName, String tableName, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            return PNameFactory.newName(SchemaUtil.getTableNameAsBytes(schemaName, tableName));
        }
        if (schemaName == null || schemaName.isEmpty()) {
            return PNameFactory.newName(tableName);
        }
        return PNameFactory.newName(schemaName + ":" + tableName);
    }

    public static boolean isSchemaCheckRequired(PTableType tableType, ReadOnlyProps props) {
        return PTableType.TABLE.equals((Object)tableType) && SchemaUtil.isNamespaceMappingEnabled(tableType, props);
    }

    public static boolean isNamespaceMappingEnabled(PTableType type, Configuration conf) {
        return conf.getBoolean("phoenix.schema.isNamespaceMappingEnabled", false) && (type == null || !PTableType.SYSTEM.equals((Object)type) || conf.getBoolean("phoenix.schema.mapSystemTablesToNamespace", true));
    }

    public static boolean isNamespaceMappingEnabled(PTableType type, ReadOnlyProps readOnlyProps) {
        return readOnlyProps.getBoolean("phoenix.schema.isNamespaceMappingEnabled", false) && (type == null || !PTableType.SYSTEM.equals((Object)type) || readOnlyProps.getBoolean("phoenix.schema.mapSystemTablesToNamespace", true));
    }

    public static byte[] getParentTableNameFromIndexTable(byte[] physicalTableName, String indexPrefix) {
        String tableName = Bytes.toString((byte[])physicalTableName);
        return SchemaUtil.getParentTableNameFromIndexTable(tableName, indexPrefix).getBytes();
    }

    public static String getParentTableNameFromIndexTable(String physicalTableName, String indexPrefix) {
        if (physicalTableName.contains(":")) {
            String schemaNameFromFullName = SchemaUtil.getSchemaNameFromFullName(physicalTableName, ":");
            String tableNameFromFullName = SchemaUtil.getTableNameFromFullName(physicalTableName, ":");
            return schemaNameFromFullName + ":" + SchemaUtil.getStrippedName(tableNameFromFullName, indexPrefix);
        }
        return SchemaUtil.getStrippedName(physicalTableName, indexPrefix);
    }

    private static String getStrippedName(String physicalTableName, String indexPrefix) {
        return physicalTableName.indexOf(indexPrefix) == 0 ? physicalTableName.substring(indexPrefix.length()) : physicalTableName;
    }

    public static String getQualifiedTableName(String schemaName, String tableName) {
        if (schemaName != null && !schemaName.isEmpty()) {
            return String.format("%s.%s", SchemaUtil.normalizeIdentifier(schemaName), SchemaUtil.normalizeIdentifier(tableName));
        }
        return SchemaUtil.normalizeIdentifier(tableName);
    }

    public static void padData(String tableName, PColumn column, ImmutableBytesWritable ptr) {
        PDataType type = column.getDataType();
        byte[] byteValue = ptr.get();
        boolean isNull = type.isNull(byteValue);
        Integer maxLength = column.getMaxLength();
        if (!isNull && type.isFixedWidth() && maxLength != null) {
            if (ptr.getLength() < maxLength) {
                type.pad(ptr, maxLength, column.getSortOrder());
            } else if (ptr.getLength() > maxLength) {
                throw new DataExceedsCapacityException(tableName + "." + column.getName().getString() + " may not exceed " + maxLength + " bytes (" + type.toObject(byteValue) + ")");
            }
        }
    }

    public static boolean hasGlobalIndex(PTable table) {
        for (PTable index : table.getIndexes()) {
            if (index.getIndexType() != PTable.IndexType.GLOBAL) continue;
            return true;
        }
        return false;
    }

    public static boolean isNamespaceMapped(Result currentResult) {
        Cell isNamespaceMappedCell = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES);
        return isNamespaceMappedCell != null && (Boolean)PBoolean.INSTANCE.toObject(isNamespaceMappedCell.getValue()) != false;
    }

    public static boolean isLogTable(String schemaName, String tableName) {
        return "SYSTEM".equals(schemaName) && "LOG".equals(tableName);
    }
}

