/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataUtil {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataUtil.class);
    public static final String VIEW_INDEX_TABLE_PREFIX = "_IDX_";
    public static final String LOCAL_INDEX_TABLE_PREFIX = "_LOCAL_IDX_";
    public static final String VIEW_INDEX_SEQUENCE_PREFIX = "_SEQ_";
    public static final String VIEW_INDEX_SEQUENCE_NAME_PREFIX = "_ID_";
    public static final byte[] VIEW_INDEX_SEQUENCE_PREFIX_BYTES = Bytes.toBytes((String)"_SEQ_");
    private static final String VIEW_INDEX_ID_COLUMN_NAME = "_INDEX_ID";
    public static final String PARENT_TABLE_KEY = "PARENT_TABLE";
    public static final byte[] PARENT_TABLE_KEY_BYTES = Bytes.toBytes((String)"PARENT_TABLE");
    public static final String IS_VIEW_INDEX_TABLE_PROP_NAME = "IS_VIEW_INDEX_TABLE";
    public static final byte[] IS_VIEW_INDEX_TABLE_PROP_BYTES = Bytes.toBytes((String)"IS_VIEW_INDEX_TABLE");
    public static final String IS_LOCAL_INDEX_TABLE_PROP_NAME = "IS_LOCAL_INDEX_TABLE";
    public static final byte[] IS_LOCAL_INDEX_TABLE_PROP_BYTES = Bytes.toBytes((String)"IS_LOCAL_INDEX_TABLE");
    public static final String DATA_TABLE_NAME_PROP_NAME = "DATA_TABLE_NAME";
    public static final byte[] DATA_TABLE_NAME_PROP_BYTES = Bytes.toBytes((String)"DATA_TABLE_NAME");

    public static boolean areClientAndServerCompatible(long serverHBaseAndPhoenixVersion) {
        return MetaDataUtil.areClientAndServerCompatible(MetaDataUtil.decodePhoenixVersion(serverHBaseAndPhoenixVersion), 4, 14);
    }

    static boolean areClientAndServerCompatible(int serverVersion, int clientMajorVersion, int clientMinorVersion) {
        return VersionUtil.encodeMinPatchVersion(clientMajorVersion, clientMinorVersion) <= serverVersion && VersionUtil.encodeMaxMinorVersion(clientMajorVersion) >= serverVersion;
    }

    public static int decodePhoenixVersion(long version) {
        return (int)(version << 32 >>> 40);
    }

    public static long encodeHasIndexWALCodec(long version, boolean isValid) {
        if (!isValid) {
            return version | 1L;
        }
        return version;
    }

    public static boolean decodeHasIndexWALCodec(long version) {
        return (version & 0xFL) == 0L;
    }

    public static int decodeHBaseVersion(long version) {
        return (int)(version >>> 40);
    }

    public static String decodeHBaseVersionAsString(int version) {
        int major = version >>> 16 & 0xFF;
        int minor = version >>> 8 & 0xFF;
        int patch = version & 0xFF;
        return major + "." + minor + "." + patch;
    }

    public static boolean decodeTableNamespaceMappingEnabled(long version) {
        return ((int)(version << 24 >>> 56) & 1) != 0;
    }

    public static long encodeVersion(String hbaseVersionStr, Configuration config) {
        long hbaseVersion = VersionUtil.encodeVersion(hbaseVersionStr);
        long isTableNamespaceMappingEnabled = SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, new ReadOnlyProps(config.iterator())) ? 1L : 0L;
        long phoenixVersion = VersionUtil.encodeVersion(4, 14, 0);
        long walCodec = IndexManagementUtil.isWALEditCodecSet(config) ? 0L : 1L;
        long version = hbaseVersion << 40 | isTableNamespaceMappingEnabled << 32 | phoenixVersion << 8 | walCodec;
        return version;
    }

    public static void getTenantIdAndSchemaAndTableName(List<Mutation> tableMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
    }

    public static void getTenantIdAndFunctionName(List<Mutation> functionMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(functionMetadata);
        SchemaUtil.getVarChars(m.getRow(), 2, rowKeyMetaData);
    }

    public static byte[] getParentTableName(List<Mutation> tableMetadata) {
        if (tableMetadata.size() == 1) {
            return null;
        }
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        Mutation m = MetaDataUtil.getParentTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
        if (Bytes.compareTo((byte[])schemaName, (byte[])rowKeyMetaData[1]) == 0 && Bytes.compareTo((byte[])tableName, (byte[])rowKeyMetaData[2]) == 0) {
            return null;
        }
        return rowKeyMetaData[2];
    }

    public static long getSequenceNumber(Mutation tableMutation) {
        List kvs = (List)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, (int)0, (int)PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES.length) != 0) continue;
                return PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
            }
        }
        throw new IllegalStateException();
    }

    public static long getSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData));
    }

    public static PTableType getTableType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, builder, value)) {
            return PTableType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }

    public static boolean isNameSpaceMapped(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES, builder, value)) {
            return (Boolean)PBoolean.INSTANCE.toObject(ByteUtil.copyKeyBytesIfNecessary(value));
        }
        return false;
    }

    public static long getParentSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getParentTableHeaderRow(tableMetaData));
    }

    public static Mutation getTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(0);
    }

    public static boolean getMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (builder.compareQualifier((Cell)kv, key, 0, key.length) != 0) continue;
                builder.getValueAsPtr((Cell)kv, ptr);
                return true;
            }
        }
        return false;
    }

    public static Put getPutOnlyTableHeaderRow(List<Mutation> tableMetaData) {
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            return (Put)m;
        }
        throw new IllegalStateException("No table header row found in table metadata");
    }

    public static Put getPutOnlyAutoPartitionColumn(PTable parentTable, List<Mutation> tableMetaData) {
        int autoPartitionPutIndex = parentTable.isMultiTenant() ? 2 : 1;
        int i = 0;
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put) || i++ != autoPartitionPutIndex) continue;
            return (Put)m;
        }
        throw new IllegalStateException("No auto partition column row found in table metadata");
    }

    public static Mutation getParentTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(tableMetaData.size() - 1);
    }

    public static long getClientTimeStamp(List<Mutation> tableMetadata) {
        Mutation m = tableMetadata.get(0);
        return MetaDataUtil.getClientTimeStamp(m);
    }

    public static long getClientTimeStamp(Mutation m) {
        Collection kvs = m.getFamilyCellMap().values();
        return kvs.isEmpty() ? m.getTimeStamp() : ((Cell)((List)kvs.iterator().next()).get(0)).getTimestamp();
    }

    public static byte[] getParentLinkKey(String tenantId, String schemaName, String tableName, String indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)indexName));
    }

    public static byte[] getParentLinkKey(byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, indexName);
    }

    public static byte[] getChildLinkKey(PName parentTenantId, PName parentSchemaName, PName parentTableName, PName viewTenantId, PName viewName) {
        return ByteUtil.concat(parentTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : parentTenantId.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, parentSchemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : parentSchemaName.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, parentTableName.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, viewTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : viewTenantId.getBytes(), QueryConstants.SEPARATOR_BYTE_ARRAY, viewName.getBytes());
    }

    public static Cell getCell(List<Cell> cells, byte[] cq) {
        for (Cell cell : cells) {
            if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])cq, (int)0, (int)cq.length) != 0) continue;
            return cell;
        }
        return null;
    }

    public static boolean isMultiTenant(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isTransactional(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr));
        }
        return false;
    }

    public static boolean isSalted(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        return MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES, builder, ptr);
    }

    public static byte[] getViewIndexPhysicalName(byte[] physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, VIEW_INDEX_TABLE_PREFIX);
    }

    public static String getViewIndexPhysicalName(String physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, VIEW_INDEX_TABLE_PREFIX);
    }

    private static byte[] getIndexPhysicalName(byte[] physicalTableName, String indexPrefix) {
        return Bytes.toBytes((String)MetaDataUtil.getIndexPhysicalName(Bytes.toString((byte[])physicalTableName), indexPrefix));
    }

    private static String getIndexPhysicalName(String physicalTableName, String indexPrefix) {
        if (physicalTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(physicalTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(physicalTableName, ":");
            return schemaName + ":" + indexPrefix + tableName;
        }
        return indexPrefix + physicalTableName;
    }

    public static byte[] getLocalIndexPhysicalName(byte[] physicalTableName) {
        return MetaDataUtil.getIndexPhysicalName(physicalTableName, LOCAL_INDEX_TABLE_PREFIX);
    }

    public static String getLocalIndexTableName(String tableName) {
        return LOCAL_INDEX_TABLE_PREFIX + tableName;
    }

    public static String getLocalIndexSchemaName(String schemaName) {
        return schemaName;
    }

    public static String getLocalIndexUserTableName(String localIndexTableName) {
        if (localIndexTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(localIndexTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(localIndexTableName, ":");
            String userTableName = tableName.substring(LOCAL_INDEX_TABLE_PREFIX.length());
            return schemaName + ":" + userTableName;
        }
        String schemaName = SchemaUtil.getSchemaNameFromFullName(localIndexTableName);
        if (!schemaName.isEmpty()) {
            schemaName = schemaName.substring(LOCAL_INDEX_TABLE_PREFIX.length());
        }
        String tableName = localIndexTableName.substring((schemaName.isEmpty() ? 0 : schemaName.length() + ".".length()) + LOCAL_INDEX_TABLE_PREFIX.length());
        return SchemaUtil.getTableName(schemaName, tableName);
    }

    public static String getViewIndexUserTableName(String viewIndexTableName) {
        if (viewIndexTableName.contains(":")) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(viewIndexTableName, ":");
            String tableName = SchemaUtil.getTableNameFromFullName(viewIndexTableName, ":");
            String userTableName = tableName.substring(VIEW_INDEX_TABLE_PREFIX.length());
            return schemaName + ":" + userTableName;
        }
        String schemaName = SchemaUtil.getSchemaNameFromFullName(viewIndexTableName);
        if (!schemaName.isEmpty()) {
            schemaName = schemaName.substring(VIEW_INDEX_TABLE_PREFIX.length());
        }
        String tableName = viewIndexTableName.substring((schemaName.isEmpty() ? 0 : schemaName.length() + ".".length()) + VIEW_INDEX_TABLE_PREFIX.length());
        return SchemaUtil.getTableName(schemaName, tableName);
    }

    public static String getViewIndexSequenceSchemaName(PName physicalName, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            return VIEW_INDEX_SEQUENCE_PREFIX + physicalName.getString();
        }
        return SchemaUtil.getSchemaNameFromFullName(physicalName.toString());
    }

    public static String getViewIndexSequenceName(PName physicalName, PName tenantId, boolean isNamespaceMapped) {
        if (!isNamespaceMapped) {
            return VIEW_INDEX_SEQUENCE_NAME_PREFIX + (tenantId == null ? "" : tenantId);
        }
        return SchemaUtil.getTableNameFromFullName(physicalName.toString()) + VIEW_INDEX_SEQUENCE_NAME_PREFIX;
    }

    public static SequenceKey getViewIndexSequenceKey(String tenantId, PName physicalName, int nSaltBuckets, boolean isNamespaceMapped) {
        String schemaName = MetaDataUtil.getViewIndexSequenceSchemaName(physicalName, isNamespaceMapped);
        String tableName = MetaDataUtil.getViewIndexSequenceName(physicalName, PNameFactory.newName(tenantId), isNamespaceMapped);
        return new SequenceKey(isNamespaceMapped ? tenantId : null, schemaName, tableName, nSaltBuckets);
    }

    public static PDataType getViewIndexIdDataType() {
        return PSmallint.INSTANCE;
    }

    public static String getViewIndexIdColumnName() {
        return VIEW_INDEX_ID_COLUMN_NAME;
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, PName physicalName) throws SQLException {
        return MetaDataUtil.hasViewIndexTable(connection, physicalName.getBytes());
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        try {
            HTableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalIndexName);
            return desc != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(IS_VIEW_INDEX_TABLE_PROP_BYTES)));
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, PName physicalName) throws SQLException {
        return MetaDataUtil.hasLocalIndexTable(connection, physicalName.getBytes());
    }

    public static boolean hasLocalIndexTable(PhoenixConnection connection, byte[] physicalTableName) throws SQLException {
        try {
            HTableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalTableName);
            if (desc == null) {
                return false;
            }
            return MetaDataUtil.hasLocalIndexColumnFamily(desc);
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static boolean hasLocalIndexColumnFamily(HTableDescriptor desc) {
        for (HColumnDescriptor cf : desc.getColumnFamilies()) {
            if (!cf.getNameAsString().startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    public static List<byte[]> getNonLocalIndexColumnFamilies(HTableDescriptor desc) {
        ArrayList<byte[]> families = new ArrayList<byte[]>(desc.getColumnFamilies().length);
        for (HColumnDescriptor cf : desc.getColumnFamilies()) {
            if (cf.getNameAsString().startsWith("L#")) continue;
            families.add(cf.getName());
        }
        return families;
    }

    public static List<byte[]> getLocalIndexColumnFamilies(PhoenixConnection conn, byte[] physicalTableName) throws SQLException {
        HTableDescriptor desc = conn.getQueryServices().getTableDescriptor(physicalTableName);
        if (desc == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> families = new ArrayList<byte[]>(desc.getColumnFamilies().length / 2);
        for (HColumnDescriptor cf : desc.getColumnFamilies()) {
            if (!cf.getNameAsString().startsWith("L#")) continue;
            families.add(cf.getName());
        }
        return families;
    }

    public static void deleteViewIndexSequences(PhoenixConnection connection, PName name, boolean isNamespaceMapped) throws SQLException {
        String schemaName = MetaDataUtil.getViewIndexSequenceSchemaName(name, isNamespaceMapped);
        String sequenceName = MetaDataUtil.getViewIndexSequenceName(name, null, isNamespaceMapped);
        connection.createStatement().executeUpdate("DELETE FROM SYSTEM.\"SEQUENCE\" WHERE SEQUENCE_SCHEMA" + (schemaName.length() > 0 ? "='" + schemaName + "'" : " IS NULL") + (isNamespaceMapped ? " AND SEQUENCE_NAME = '" + sequenceName + "'" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tableRegionsOnline(Configuration conf, PTable table) {
        HConnection hcon = null;
        try {
            hcon = HConnectionManager.getConnection((Configuration)conf);
            List locations = hcon.locateRegions(TableName.valueOf((byte[])table.getPhysicalName().getBytes()));
            for (HRegionLocation loc : locations) {
                try {
                    ServerName sn = loc.getServerName();
                    if (sn == null) continue;
                    AdminProtos.AdminService.BlockingInterface admin = hcon.getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest((byte[])loc.getRegionInfo().getRegionName());
                    admin.getRegionInfo(null, request);
                }
                catch (ServiceException e) {
                    IOException ie = ProtobufUtil.getRemoteException((ServiceException)e);
                    logger.debug("Region " + loc.getRegionInfo().getEncodedName() + " isn't online due to:" + ie);
                    boolean request = false;
                    if (hcon == null) return request;
                    try {
                        hcon.close();
                        return request;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return request;
                }
                catch (RemoteException e) {
                    logger.debug("Cannot get region " + loc.getRegionInfo().getEncodedName() + " info due to error:" + (Object)((Object)e));
                    boolean bl = false;
                    if (hcon == null) return bl;
                    try {
                        hcon.close();
                        return bl;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return bl;
                    catch (IOException ex) {
                        logger.warn("tableRegionsOnline failed due to:" + ex);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return true;
                    }
                }
            }
        }
        finally {
            if (hcon != null) {
                try {
                    hcon.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static Scan newTableRowsScan(byte[] key, long startTimeStamp, long stopTimeStamp) {
        return MetaDataUtil.newTableRowsScan(key, null, startTimeStamp, stopTimeStamp);
    }

    public static Scan newTableRowsScan(byte[] startKey, byte[] stopKey, long startTimeStamp, long stopTimeStamp) {
        Scan scan = new Scan();
        ScanUtil.setTimeRange(scan, startTimeStamp, stopTimeStamp);
        scan.setStartRow(startKey);
        if (stopKey == null) {
            stopKey = ByteUtil.concat(startKey, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
        }
        scan.setStopRow(stopKey);
        return scan;
    }

    public static PTable.LinkType getLinkType(Mutation tableMutation) {
        List kvs = (List)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length) != 0) continue;
                return PTable.LinkType.fromSerializedValue(PUnsignedTinyint.INSTANCE.getCodec().decodeByte(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault()));
            }
        }
        return null;
    }

    public static boolean isLocalIndex(String physicalName) {
        return physicalName.contains(LOCAL_INDEX_TABLE_PREFIX);
    }

    public static boolean isViewIndex(String physicalName) {
        if (physicalName.contains(":")) {
            return SchemaUtil.getTableNameFromFullName(physicalName).startsWith(VIEW_INDEX_TABLE_PREFIX);
        }
        return physicalName.startsWith(VIEW_INDEX_TABLE_PREFIX);
    }

    public static String getAutoPartitionColumnName(PTable parentTable) {
        List<PColumn> parentTableColumns = parentTable.getPKColumns();
        PColumn column = parentTableColumns.get(MetaDataUtil.getAutoPartitionColIndex(parentTable));
        return column.getName().getString();
    }

    public static int getAutoPartitionColIndex(PTable parentTable) {
        boolean isSalted;
        boolean isMultiTenant = parentTable.isMultiTenant();
        boolean bl = isSalted = parentTable.getBucketNum() != null;
        return isMultiTenant && isSalted ? 2 : (isMultiTenant || isSalted ? 1 : 0);
    }

    public static String getJdbcUrl(RegionCoprocessorEnvironment env) {
        String zkQuorum = env.getConfiguration().get("hbase.zookeeper.quorum");
        String zkClientPort = env.getConfiguration().get("hbase.zookeeper.property.clientPort", Integer.toString(2181));
        String zkParentNode = env.getConfiguration().get("zookeeper.znode.parent", "/hbase");
        return "jdbc:phoenix:" + zkQuorum + ':' + zkClientPort + ':' + zkParentNode;
    }

    public static boolean isHColumnProperty(String propName) {
        return HColumnDescriptor.getDefaultValues().containsKey(propName);
    }

    public static boolean isHTableProperty(String propName) {
        return !MetaDataUtil.isHColumnProperty(propName) && !TableProperty.isPhoenixTableProperty(propName);
    }

    public static boolean isLocalIndexFamily(ImmutableBytesPtr cfPtr) {
        return cfPtr.getLength() >= QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length && Bytes.compareTo((byte[])cfPtr.get(), (int)cfPtr.getOffset(), (int)QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length, (byte[])QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES, (int)0, (int)QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES.length) == 0;
    }

    public static boolean isLocalIndexFamily(byte[] cf) {
        return Bytes.startsWith((byte[])cf, (byte[])QueryConstants.LOCAL_INDEX_COLUMN_FAMILY_PREFIX_BYTES);
    }

    public static final byte[] getPhysicalTableRowForView(PTable view) {
        byte[] physicalTableSchemaName = Bytes.toBytes((String)SchemaUtil.getSchemaNameFromFullName(view.getPhysicalName().getString()));
        byte[] physicalTableName = Bytes.toBytes((String)SchemaUtil.getTableNameFromFullName(view.getPhysicalName().getString()));
        return SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, physicalTableSchemaName, physicalTableName);
    }

    public static PTable.IndexType getIndexType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesWritable value) {
        if (MetaDataUtil.getMutationValue((Mutation)MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.INDEX_TYPE_BYTES, builder, value)) {
            return PTable.IndexType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }
}

