/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.phoenix.coprocessor.TephraTransactionalProcessor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionService;
import org.apache.phoenix.transaction.TephraTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.distributed.PooledClientProvider;
import org.apache.tephra.distributed.ThriftClientProvider;
import org.apache.tephra.distributed.TransactionService;
import org.apache.tephra.distributed.TransactionServiceClient;
import org.apache.tephra.inmemory.InMemoryTxSystemClient;
import org.apache.tephra.metrics.MetricsCollector;
import org.apache.tephra.metrics.TxMetricsCollector;
import org.apache.tephra.persist.HDFSTransactionStateStorage;
import org.apache.tephra.persist.TransactionStateStorage;
import org.apache.tephra.snapshot.SnapshotCodecProvider;
import org.apache.tephra.zookeeper.TephraZKClientService;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.RetryStrategy;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;

public class TephraTransactionProvider
implements PhoenixTransactionProvider {
    private static final TephraTransactionProvider INSTANCE = new TephraTransactionProvider();

    public static final TephraTransactionProvider getInstance() {
        return INSTANCE;
    }

    private TephraTransactionProvider() {
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(byte[] txnBytes) throws IOException {
        return new TephraTransactionContext(txnBytes);
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(PhoenixConnection connection) {
        return new TephraTransactionContext(connection);
    }

    @Override
    public PhoenixTransactionClient getTransactionClient(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) {
        if (connectionInfo.isConnectionless()) {
            TransactionManager txnManager = new TransactionManager(config);
            InMemoryTxSystemClient txClient = new InMemoryTxSystemClient(txnManager);
            return new TephraTransactionClient((TransactionSystemClient)txClient);
        }
        String zkQuorumServersString = config.get("data.tx.zookeeper.quorum");
        if (zkQuorumServersString == null) {
            zkQuorumServersString = connectionInfo.getZookeeperConnectionString();
        }
        int timeOut = config.getInt("zookeeper.session.timeout", 180000);
        ZKClientService zkClientService = ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)new TephraZKClientService(zkQuorumServersString, timeOut, null, (Multimap)ArrayListMultimap.create()), (RetryStrategy)RetryStrategies.exponentialDelay((long)500L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
        ZKDiscoveryService zkDiscoveryService = new ZKDiscoveryService((ZKClient)zkClientService);
        PooledClientProvider pooledClientProvider = new PooledClientProvider(config, (DiscoveryServiceClient)zkDiscoveryService);
        TransactionServiceClient txClient = new TransactionServiceClient(config, (ThriftClientProvider)pooledClientProvider);
        TephraTransactionClient client = new TephraTransactionClient(zkClientService, (TransactionSystemClient)txClient);
        client.start();
        return client;
    }

    @Override
    public PhoenixTransactionService getTransactionService(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connInfo) {
        ZKClientService zkClient = ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)ZKClientService.Builder.of((String)connInfo.getZookeeperConnectionString()).setSessionTimeout(config.getInt("zookeeper.session.timeout", 180000)).build(), (RetryStrategy)RetryStrategies.exponentialDelay((long)500L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
        ZKDiscoveryService discovery = new ZKDiscoveryService((ZKClient)zkClient);
        TransactionManager txManager = new TransactionManager(config, (TransactionStateStorage)new HDFSTransactionStateStorage(config, new SnapshotCodecProvider(config), (MetricsCollector)new TxMetricsCollector()), (MetricsCollector)new TxMetricsCollector());
        TransactionService txService = new TransactionService(config, (ZKClient)zkClient, (DiscoveryService)discovery, Providers.of((Object)txManager));
        TephraTransactionService service = new TephraTransactionService(zkClient, txService);
        service.start();
        return service;
    }

    @Override
    public Class<? extends RegionObserver> getCoprocessor() {
        return TephraTransactionalProcessor.class;
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.TEPHRA;
    }

    @Override
    public boolean isUnsupported(PhoenixTransactionProvider.Feature feature) {
        return false;
    }

    static class TephraTransactionClient
    implements PhoenixTransactionClient {
        private final ZKClientService zkClient;
        private final TransactionSystemClient txClient;

        public TephraTransactionClient(TransactionSystemClient txClient) {
            this(null, txClient);
        }

        public TephraTransactionClient(ZKClientService zkClient, TransactionSystemClient txClient) {
            this.zkClient = zkClient;
            this.txClient = txClient;
        }

        public void start() {
            this.zkClient.startAndWait();
        }

        public TransactionSystemClient getTransactionClient() {
            return this.txClient;
        }

        @Override
        public void close() throws IOException {
            this.zkClient.stopAndWait();
        }
    }

    static class TephraTransactionService
    implements PhoenixTransactionService {
        private final ZKClientService zkClient;
        private final TransactionService txService;

        public TephraTransactionService(ZKClientService zkClient, TransactionService txService) {
            this.zkClient = zkClient;
            this.txService = txService;
        }

        public void start() {
            this.zkClient.startAndWait();
            this.txService.startAndWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.txService != null) {
                    this.txService.stopAndWait();
                }
            }
            finally {
                if (this.zkClient != null) {
                    this.zkClient.stopAndWait();
                }
            }
        }
    }
}

