/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.sun.istack.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.apache.htrace.wrappers.TraceCallable;
import org.apache.phoenix.call.CallWrapper;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.TraceStatement;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.trace.TraceSpanReceiver;
import org.apache.phoenix.trace.TraceWriter;
import org.apache.phoenix.trace.util.ConfigurationAdapter;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.util.StringUtil;

public class Tracing {
    private static final Log LOG = LogFactory.getLog(Tracing.class);
    private static final String SEPARATOR = ".";
    public static final String TRACE_ID_ATTRIBUTE_KEY = "phoenix.trace.traceid";
    public static final String SPAN_ID_ATTRIBUTE_KEY = "phoenix.trace.spanid";
    private static final String TRACE_METRIC_PREFIX = "phoenix.trace.instance";
    private static Function<ConfigurationAdapter, Sampler<?>> CREATE_ALWAYS = new Function<ConfigurationAdapter, Sampler<?>>(){

        public Sampler<?> apply(ConfigurationAdapter arg0) {
            return Sampler.ALWAYS;
        }
    };
    private static Function<ConfigurationAdapter, Sampler<?>> CREATE_NEVER = new Function<ConfigurationAdapter, Sampler<?>>(){

        public Sampler<?> apply(ConfigurationAdapter arg0) {
            return Sampler.NEVER;
        }
    };
    private static Function<ConfigurationAdapter, Sampler<?>> CREATE_PROBABILITY = new Function<ConfigurationAdapter, Sampler<?>>(){

        public Sampler<?> apply(ConfigurationAdapter conf) {
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("sampler.fraction", conf.get("phoenix.trace.probability.threshold", Double.toString(0.05)));
            return new ProbabilitySampler(HTraceConfiguration.fromMap(items));
        }
    };
    private static boolean initialized = false;
    private static TraceSpanReceiver traceSpanReceiver = null;

    public static Sampler<?> getConfiguredSampler(PhoenixConnection connection) {
        String tracelevel = connection.getQueryServices().getProps().get("phoenix.trace.frequency", QueryServicesOptions.DEFAULT_TRACING_FREQ);
        return Tracing.getSampler(tracelevel, new ConfigurationAdapter.ConnectionConfigurationAdapter(connection));
    }

    public static Sampler<?> getConfiguredSampler(Configuration conf) {
        String tracelevel = conf.get("phoenix.trace.frequency", QueryServicesOptions.DEFAULT_TRACING_FREQ);
        return Tracing.getSampler(tracelevel, new ConfigurationAdapter.HadoopConfigConfigurationAdapter(conf));
    }

    public static Sampler<?> getConfiguredSampler(TraceStatement traceStatement) {
        double samplingRate = traceStatement.getSamplingRate();
        if (samplingRate >= 1.0) {
            return Sampler.ALWAYS;
        }
        if (samplingRate < 1.0 && samplingRate > 0.0) {
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("sampler.fraction", Double.toString(samplingRate));
            return new ProbabilitySampler(HTraceConfiguration.fromMap(items));
        }
        return Sampler.NEVER;
    }

    private static Sampler<?> getSampler(String traceLevel, ConfigurationAdapter conf) {
        return (Sampler)Frequency.getSampler((String)traceLevel).builder.apply((Object)conf);
    }

    public static void setSampling(Properties props, Frequency freq) {
        props.setProperty("phoenix.trace.frequency", freq.key);
    }

    public static TraceScope startNewSpan(PhoenixConnection connection, String string) {
        Sampler<?> sampler = connection.getSampler();
        TraceScope scope = Trace.startSpan((String)string, sampler);
        Tracing.addCustomAnnotationsToSpan(scope.getSpan(), connection);
        return scope;
    }

    public static String getSpanName(Span span) {
        return TRACE_METRIC_PREFIX + span.getTraceId() + SEPARATOR + span.getParentId() + SEPARATOR + span.getSpanId();
    }

    public static Span child(Span s, String d) {
        if (s == null) {
            return NullSpan.INSTANCE;
        }
        return s.child(d);
    }

    public static <V> Callable<V> wrap(Callable<V> callable, String description) {
        if (Trace.isTracing()) {
            return new TraceCallable(Trace.currentSpan(), callable, description);
        }
        return callable;
    }

    public static CallWrapper withTracing(PhoenixConnection conn, String desc) {
        return new TracingWrapper(conn, desc);
    }

    private static void addCustomAnnotationsToSpan(@Nullable Span span, @NotNull PhoenixConnection conn) {
        Preconditions.checkNotNull((Object)conn);
        if (span == null) {
            return;
        }
        Map<String, String> annotations = conn.getCustomTracingAnnotations();
        for (Map.Entry<String, String> annotation : annotations.entrySet()) {
            span.addKVAnnotation(StringUtil.toBytes(annotation.getKey()), StringUtil.toBytes(annotation.getValue()));
        }
    }

    public static synchronized void addTraceMetricsSource() {
        try {
            QueryServicesOptions options = QueryServicesOptions.withDefaults();
            if (!initialized && options.isTracingEnabled()) {
                traceSpanReceiver = new TraceSpanReceiver();
                Trace.addReceiver((SpanReceiver)traceSpanReceiver);
                TraceWriter traceWriter = new TraceWriter(options.getTableName(), options.getTracingThreadPoolSize(), options.getTracingBatchSize());
                traceWriter.start();
            }
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"Tracing will outputs will not be written to any metrics sink! No TraceMetricsSink found on the classpath", (Throwable)e);
        }
        catch (IllegalAccessError e) {
            LOG.warn((Object)"Class incompatibility while initializing metrics, metrics will be disabled", (Throwable)e);
        }
        initialized = true;
    }

    public static TraceSpanReceiver getTraceSpanReceiver() {
        return traceSpanReceiver;
    }

    public static boolean isTraceOn(String traceOption) {
        Preconditions.checkArgument((traceOption != null ? 1 : 0) != 0);
        if (traceOption.equalsIgnoreCase("ON")) {
            return true;
        }
        if (traceOption.equalsIgnoreCase("OFF")) {
            return false;
        }
        throw new IllegalArgumentException("Unknown tracing option: " + traceOption);
    }

    static /* synthetic */ Function access$000() {
        return CREATE_NEVER;
    }

    static /* synthetic */ Function access$100() {
        return CREATE_ALWAYS;
    }

    static /* synthetic */ Function access$200() {
        return CREATE_PROBABILITY;
    }

    private static class TracingWrapper
    implements CallWrapper {
        private TraceScope scope;
        private final PhoenixConnection conn;
        private final String desc;

        public TracingWrapper(PhoenixConnection conn, String desc) {
            this.conn = conn;
            this.desc = desc;
        }

        @Override
        public void before() {
            this.scope = Tracing.startNewSpan(this.conn, "Executing " + this.desc);
        }

        @Override
        public void after() {
            this.scope.close();
        }
    }

    public static enum Frequency {
        NEVER("never", Tracing.access$000()),
        ALWAYS("always", Tracing.access$100()),
        PROBABILITY("probability", Tracing.access$200());

        String key;
        Function<ConfigurationAdapter, Sampler<?>> builder;

        private Frequency(String key, Function<ConfigurationAdapter, Sampler<?>> builder) {
            this.key = key;
            this.builder = builder;
        }

        public String getKey() {
            return this.key;
        }

        static Frequency getSampler(String key) {
            for (Frequency type : Frequency.values()) {
                if (!type.key.equals(key)) continue;
                return type;
            }
            return NEVER;
        }
    }
}

