/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedTinyintArray
extends PArrayDataType<byte[]> {
    public static final PUnsignedTinyintArray INSTANCE = new PUnsignedTinyintArray();

    private PUnsignedTinyintArray() {
        super("UNSIGNED_TINYINT ARRAY", 3000 + PUnsignedTinyint.INSTANCE.getSqlType(), PhoenixArray.class, null, 45);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedTinyint.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedTinyint.INSTANCE, sortOrder, maxLength, scale, PUnsignedTinyint.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        byte[] byteArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveBytePhoenixArray pArr = (PhoenixArray.PrimitiveBytePhoenixArray)value;
        byte[] arr$ = byteArr = (byte[])pArr.array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte i = arr$[i$];
            if (super.isCoercibleTo((PDataType)PUnsignedTinyint.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedTinyint.INSTANCE, arrayLength, maxLength);
    }
}

