/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;

public class StatisticsCollectionRunTracker {
    private static volatile StatisticsCollectionRunTracker INSTANCE;
    private final Set<HRegionInfo> updateStatsRegions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<HRegionInfo> compactingRegions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ExecutorService executor;
    public static final long CONCURRENT_UPDATE_STATS_ROW_COUNT = -100L;
    public static final long COMPACTION_UPDATE_STATS_ROW_COUNT = -200L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticsCollectionRunTracker getInstance(Configuration config) {
        StatisticsCollectionRunTracker result = INSTANCE;
        if (result != null) return result;
        Class<StatisticsCollectionRunTracker> clazz = StatisticsCollectionRunTracker.class;
        synchronized (StatisticsCollectionRunTracker.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = new StatisticsCollectionRunTracker(config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private StatisticsCollectionRunTracker(Configuration config) {
        int poolSize = config.getInt("phoenix.stats.pool.size", 4);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("phoenix-update-statistics-%s");
        this.executor = Executors.newFixedThreadPool(poolSize, builder.build());
    }

    public boolean addCompactingRegion(HRegionInfo regionInfo) {
        return this.compactingRegions.add(regionInfo);
    }

    public boolean removeCompactingRegion(HRegionInfo regionInfo) {
        return this.compactingRegions.remove(regionInfo);
    }

    public boolean areStatsBeingCollectedOnCompaction(HRegionInfo regionInfo) {
        return this.compactingRegions.contains(regionInfo);
    }

    public boolean addUpdateStatsCommandRegion(HRegionInfo regionInfo) {
        return this.updateStatsRegions.add(regionInfo);
    }

    public boolean removeUpdateStatsCommandRegion(HRegionInfo regionInfo) {
        return this.updateStatsRegions.remove(regionInfo);
    }

    public <T> Future<T> runTask(Callable<T> c) {
        return this.executor.submit(c);
    }
}

