/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.Objects;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class TableRef {
    public static final TableRef EMPTY_TABLE_REF = new TableRef(new PTableImpl());
    private PTable table;
    private long upperBoundTimeStamp;
    private final String alias;
    private final long lowerBoundTimeStamp;
    private final boolean hasDynamicCols;
    private final long currentTime;

    public TableRef(TableRef tableRef) {
        this(tableRef.alias, tableRef.table, tableRef.upperBoundTimeStamp, tableRef.lowerBoundTimeStamp, tableRef.hasDynamicCols);
    }

    public TableRef(TableRef tableRef, long timeStamp) {
        this(tableRef.alias, tableRef.table, timeStamp, tableRef.lowerBoundTimeStamp, tableRef.hasDynamicCols);
    }

    public TableRef(TableRef tableRef, String alias) {
        this(alias, tableRef.table, tableRef.upperBoundTimeStamp, tableRef.lowerBoundTimeStamp, tableRef.hasDynamicCols);
    }

    public TableRef(PTable table) {
        this(null, table, -1L, false);
    }

    public TableRef(PTable table, long upperBoundTimeStamp, long lowerBoundTimeStamp) {
        this(null, table, upperBoundTimeStamp, lowerBoundTimeStamp, false);
    }

    public TableRef(String alias, PTable table, long upperBoundTimeStamp, boolean hasDynamicCols) {
        this(alias, table, upperBoundTimeStamp, 0L, hasDynamicCols);
    }

    public TableRef(String alias, PTable table, long upperBoundTimeStamp, long lowerBoundTimeStamp, boolean hasDynamicCols) {
        this.alias = alias;
        this.table = table;
        this.currentTime = upperBoundTimeStamp;
        this.upperBoundTimeStamp = table.getUpdateCacheFrequency() != 0L ? -1L : upperBoundTimeStamp;
        this.lowerBoundTimeStamp = lowerBoundTimeStamp;
        this.hasDynamicCols = hasDynamicCols;
    }

    public PTable getTable() {
        return this.table;
    }

    public void setTable(PTable value) {
        this.table = value;
    }

    public void setTimeStamp(long timeStamp) {
        this.upperBoundTimeStamp = timeStamp;
    }

    public String getTableAlias() {
        return this.alias;
    }

    public String getColumnDisplayName(ColumnRef ref, boolean cfCaseSensitive, boolean cqCaseSensitive) {
        String cf = null;
        String cq = null;
        PColumn column = ref.getColumn();
        String name = column.getName().getString();
        boolean isIndex = IndexUtil.isIndexColumn(name);
        if (this.table.getType() == PTableType.PROJECTED && TupleProjectionCompiler.PROJECTED_TABLE_SCHEMA.equals(this.table.getSchemaName()) || this.table.getType() == PTableType.SUBQUERY) {
            cq = name;
        } else if (SchemaUtil.isPKColumn(column)) {
            cq = isIndex ? IndexUtil.getDataColumnName(name) : name;
        } else {
            String defaultFamilyName = this.table.getDefaultFamilyName() == null ? "0" : this.table.getDefaultFamilyName().getString();
            String dataFamilyName = isIndex ? IndexUtil.getDataColumnFamilyName(name) : column.getFamilyName().getString();
            cf = (this.table.getIndexType() == PTable.IndexType.LOCAL ? IndexUtil.getActualColumnFamilyName(defaultFamilyName) : defaultFamilyName).equals(dataFamilyName) ? null : dataFamilyName;
            cq = isIndex ? IndexUtil.getDataColumnName(name) : name;
        }
        cf = cf != null && cfCaseSensitive ? "\"" + cf + "\"" : cf;
        cq = cqCaseSensitive ? "\"" + cq + "\"" : cq;
        return SchemaUtil.getColumnDisplayName(cf, cq);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.alias == null ? 0 : this.alias.hashCode();
        result = 31 * result + (this.table.getName() != null ? this.table.getName().hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRef other = (TableRef)obj;
        if (!Objects.equals(this.alias, other.alias)) {
            return false;
        }
        return Objects.equals(this.table.getName(), other.table.getName());
    }

    public long getTimeStamp() {
        return this.upperBoundTimeStamp;
    }

    public long getLowerBoundTimeStamp() {
        return this.lowerBoundTimeStamp;
    }

    public boolean hasDynamicCols() {
        return this.hasDynamicCols;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }
}

