/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.http.annotation.Immutable;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.function.DefaultValueExpression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.SchemaUtil;

@Immutable
public class ColumnRef {
    private final TableRef tableRef;
    private final int columnPosition;
    private final int pkSlotPosition;

    protected ColumnRef(ColumnRef columnRef, long timeStamp) {
        this.tableRef = new TableRef(columnRef.tableRef, timeStamp);
        this.columnPosition = columnRef.columnPosition;
        this.pkSlotPosition = columnRef.pkSlotPosition;
    }

    public ColumnRef(TableRef tableRef, String familyName, String columnName) throws MetaDataEntityNotFoundException {
        this(tableRef, tableRef.getTable().getColumnFamily(familyName).getPColumnForColumnName(columnName).getPosition());
    }

    public ColumnRef(TableRef tableRef, int columnPosition) {
        if (tableRef == null) {
            throw new NullPointerException();
        }
        if (columnPosition < 0 || columnPosition >= tableRef.getTable().getColumns().size()) {
            throw new IllegalArgumentException("Column position of " + columnPosition + " must be between 0 and " + tableRef.getTable().getColumns().size() + " for table " + tableRef.getTable().getName().getString());
        }
        this.tableRef = tableRef;
        this.columnPosition = columnPosition;
        PColumn column = this.getColumn();
        int i = -1;
        if (SchemaUtil.isPKColumn(column)) {
            for (PColumn pkColumn : tableRef.getTable().getPKColumns()) {
                ++i;
                if (pkColumn != column) continue;
                break;
            }
        }
        this.pkSlotPosition = i;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnPosition;
        result = 31 * result + this.tableRef.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnRef other = (ColumnRef)obj;
        if (this.columnPosition != other.columnPosition) {
            return false;
        }
        return this.tableRef.equals(other.tableRef);
    }

    public Expression newColumnExpression() throws SQLException {
        return this.newColumnExpression(false, false);
    }

    public Expression newColumnExpression(boolean schemaNameCaseSensitive, boolean colNameCaseSensitive) throws SQLException {
        KeyValueColumnExpression expression;
        PTable table = this.tableRef.getTable();
        PColumn column = this.getColumn();
        String displayName = this.tableRef.getColumnDisplayName(this, schemaNameCaseSensitive, colNameCaseSensitive);
        if (SchemaUtil.isPKColumn(column)) {
            return new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(table.getPKColumns(), this.pkSlotPosition), displayName);
        }
        if (table.getType() == PTableType.PROJECTED || table.getType() == PTableType.SUBQUERY) {
            return new ProjectedColumnExpression(column, table, displayName);
        }
        KeyValueColumnExpression keyValueColumnExpression = expression = table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? new SingleCellColumnExpression(column, displayName, table.getEncodingScheme(), table.getImmutableStorageScheme()) : new KeyValueColumnExpression(column, displayName);
        if (column.getExpressionStr() != null) {
            String url = "jdbc:phoenix:none";
            PhoenixConnection conn = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);
            StatementContext context = new StatementContext(new PhoenixStatement(conn));
            ExpressionCompiler compiler = new ExpressionCompiler(context);
            ParseNode defaultParseNode = new SQLParser(column.getExpressionStr()).parseExpression();
            Expression defaultExpression = defaultParseNode.accept(compiler);
            if (!ExpressionUtil.isNull(defaultExpression, new ImmutableBytesWritable())) {
                return new DefaultValueExpression(Arrays.asList(expression, defaultExpression));
            }
        }
        return expression;
    }

    public ColumnRef cloneAtTimestamp(long timestamp) {
        return new ColumnRef(this, timestamp);
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public int getPKSlotPosition() {
        return this.pkSlotPosition;
    }

    public PColumn getColumn() {
        return this.tableRef.getTable().getColumns().get(this.columnPosition);
    }

    public PTable getTable() {
        return this.tableRef.getTable();
    }

    public TableRef getTableRef() {
        return this.tableRef;
    }
}

