/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.replication;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.SchemaUtil;

public class SystemCatalogWALEntryFilter
implements WALEntryFilter {
    private static byte[] CHILD_TABLE_BYTES = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};

    public WAL.Entry filter(WAL.Entry entry) {
        if (!SchemaUtil.isMetaTable(entry.getKey().getTablename().getName())) {
            return entry;
        }
        ArrayList cells = entry.getEdit().getCells();
        ArrayList cellsToRemove = Lists.newArrayList();
        for (Cell cell : cells) {
            if (this.isTenantRowCell(cell)) continue;
            cellsToRemove.add(cell);
        }
        cells.removeAll(cellsToRemove);
        if (cells.size() > 0) {
            return entry;
        }
        return null;
    }

    private boolean isTenantRowCell(Cell cell) {
        ImmutableBytesWritable key = new ImmutableBytesWritable(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
        boolean isTenantRowCell = key.get()[key.getOffset()] != 0;
        boolean isChildLinkToTenantView = false;
        if (!isTenantRowCell) {
            ImmutableBytesWritable columnValue;
            boolean isChildLink;
            ImmutableBytesWritable columnQualifier = new ImmutableBytesWritable(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            boolean bl = isChildLink = columnQualifier.compareTo(PhoenixDatabaseMetaData.LINK_TYPE_BYTES) == 0;
            if (isChildLink && (columnValue = new ImmutableBytesWritable(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength())).compareTo(CHILD_TABLE_BYTES) == 0) {
                byte[][] rowViewKeyMetadata = new byte[5][];
                SchemaUtil.getVarChars(key.get(), key.getOffset(), key.getLength(), 0, rowViewKeyMetadata);
                isChildLinkToTenantView = rowViewKeyMetadata[3].length != 0;
            }
        }
        return isTenantRowCell || isChildLinkToTenantView;
    }
}

