/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePostsCache {
    private static final Logger logger = LoggerFactory.getLogger(GuidePostsCache.class);
    private final ConnectionQueryServices queryServices;
    private final LoadingCache<GuidePostsKey, GuidePostsInfo> cache;

    public GuidePostsCache(ConnectionQueryServices queryServices, Configuration config) {
        this.queryServices = Objects.requireNonNull(queryServices);
        long statsUpdateFrequency = config.getLong("phoenix.stats.updateFrequency", 900000L);
        long maxTableStatsCacheSize = config.getLong("phoenix.stats.cache.maxSize", 0x10000000L);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(statsUpdateFrequency, TimeUnit.MILLISECONDS).maximumWeight(maxTableStatsCacheSize).weigher((Weigher)new Weigher<GuidePostsKey, GuidePostsInfo>(){

            public int weigh(GuidePostsKey key, GuidePostsInfo info) {
                return info.getEstimatedSize();
            }
        }).removalListener((RemovalListener)new PhoenixStatsCacheRemovalListener()).build((CacheLoader)new StatsLoader());
    }

    LoadingCache<GuidePostsKey, GuidePostsInfo> getCache() {
        return this.cache;
    }

    public GuidePostsInfo get(GuidePostsKey key) throws ExecutionException {
        return (GuidePostsInfo)this.getCache().get((Object)key);
    }

    public void put(GuidePostsKey key, GuidePostsInfo info) {
        this.getCache().put((Object)Objects.requireNonNull(key), (Object)Objects.requireNonNull(info));
    }

    public void invalidate(GuidePostsKey key) {
        this.getCache().invalidate((Object)Objects.requireNonNull(key));
    }

    public void invalidateAll() {
        this.getCache().invalidateAll();
    }

    public void invalidateAll(byte[] physicalName) {
        for (GuidePostsKey key : this.getCache().asMap().keySet()) {
            if (Bytes.compareTo((byte[])key.getPhysicalName(), (byte[])physicalName) != 0) continue;
            this.invalidate(key);
        }
    }

    public void invalidateAll(HTableDescriptor htableDesc) {
        byte[] tableName = htableDesc.getTableName().getName();
        for (byte[] fam : htableDesc.getFamiliesKeys()) {
            this.invalidate(new GuidePostsKey(tableName, fam));
        }
    }

    public void invalidateAll(PTable table) {
        byte[] physicalName = table.getPhysicalName().getBytes();
        List<PColumnFamily> families = table.getColumnFamilies();
        if (families.isEmpty()) {
            this.invalidate(new GuidePostsKey(physicalName, SchemaUtil.getEmptyColumnFamily(table)));
        } else {
            for (PColumnFamily family : families) {
                this.invalidate(new GuidePostsKey(physicalName, family.getName().getBytes()));
            }
        }
    }

    static class PhoenixStatsCacheRemovalListener
    implements RemovalListener<GuidePostsKey, GuidePostsInfo> {
        PhoenixStatsCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<GuidePostsKey, GuidePostsInfo> notification) {
            RemovalCause cause;
            if (logger.isTraceEnabled() && this.wasEvicted(cause = notification.getCause())) {
                GuidePostsKey key = (GuidePostsKey)notification.getKey();
                logger.trace("Cached stats for {} with size={}bytes was evicted due to cause={}", new Object[]{key, ((GuidePostsInfo)notification.getValue()).getEstimatedSize(), cause});
            }
        }

        boolean wasEvicted(RemovalCause cause) {
            return RemovalCause.EXPLICIT != cause && RemovalCause.REPLACED != cause;
        }
    }

    protected class StatsLoader
    extends CacheLoader<GuidePostsKey, GuidePostsInfo> {
        protected StatsLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GuidePostsInfo load(GuidePostsKey statsKey) throws Exception {
            HTableInterface statsHTable = GuidePostsCache.this.queryServices.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, GuidePostsCache.this.queryServices.getProps()).getName());
            try {
                GuidePostsInfo guidePostsInfo = StatisticsUtil.readStatistics(statsHTable, statsKey, Long.MAX_VALUE);
                this.traceStatsUpdate(statsKey, guidePostsInfo);
                GuidePostsInfo guidePostsInfo2 = guidePostsInfo;
                return guidePostsInfo2;
            }
            catch (TableNotFoundException e) {
                logger.debug("Unable to locate Phoenix stats table", (Throwable)e);
                GuidePostsInfo guidePostsInfo = GuidePostsInfo.NO_GUIDEPOST;
                return guidePostsInfo;
            }
            catch (IOException e) {
                logger.warn("Unable to read from stats table", (Throwable)e);
                GuidePostsInfo guidePostsInfo = GuidePostsInfo.NO_GUIDEPOST;
                return guidePostsInfo;
            }
            finally {
                try {
                    statsHTable.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close stats table", (Throwable)e);
                }
            }
        }

        void traceStatsUpdate(GuidePostsKey key, GuidePostsInfo info) {
            if (logger.isTraceEnabled()) {
                logger.trace("Updating local TableStats cache (id={}) for {}, size={}bytes", new Object[]{Objects.hashCode(GuidePostsCache.this), key, info.getEstimatedSize()});
            }
        }
    }
}

