/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.optimize;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.GenSubqueryParamValuesRewriter;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.BooleanParseNodeVisitor;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.IndexExpressionParseNodeRewriter;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.IndexUtil;

public class QueryOptimizer {
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final QueryServices services;
    private final boolean useIndexes;
    private final boolean costBased;
    private final long indexPendingDisabledThreshold;

    public QueryOptimizer(QueryServices services) {
        this.services = services;
        this.useIndexes = this.services.getProps().getBoolean("phoenix.query.useIndexes", true);
        this.costBased = this.services.getProps().getBoolean("phoenix.costbased.optimizer.enabled", false);
        this.indexPendingDisabledThreshold = this.services.getProps().getLong("phoenix.index.pending.disable.threshold", 30000L);
    }

    public QueryPlan optimize(PhoenixStatement statement, QueryPlan dataPlan) throws SQLException {
        if (dataPlan.getTableRef() == null) {
            return dataPlan;
        }
        return this.optimize(dataPlan, statement, Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select) throws SQLException {
        return this.optimize(statement, select, FromCompiler.getResolverForQuery(select, statement.getConnection()), Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        QueryCompiler compiler = new QueryCompiler(statement, select, resolver, targetColumns, parallelIteratorFactory, new SequenceManager(statement));
        QueryPlan dataPlan = compiler.compile();
        return this.optimize(dataPlan, statement, targetColumns, parallelIteratorFactory);
    }

    public QueryPlan optimize(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        List<QueryPlan> plans = this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, true);
        return plans.get(0);
    }

    public List<QueryPlan> getBestPlan(QueryPlan dataPlan, PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        return this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, true);
    }

    public List<QueryPlan> getApplicablePlans(QueryPlan dataPlan, PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        return this.getApplicablePlans(dataPlan, statement, targetColumns, parallelIteratorFactory, false);
    }

    private List<QueryPlan> getApplicablePlans(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, boolean stopAtBestPlan) throws SQLException {
        if (!this.useIndexes) {
            return Collections.singletonList(dataPlan);
        }
        SelectStatement select = (SelectStatement)dataPlan.getStatement();
        if (!(select.isUnion() || select.isJoin() || select.getInnerSelectStatement() != null || select.getWhere() != null && select.getWhere().hasSubquery())) {
            return this.getApplicablePlansForSingleFlatQuery(dataPlan, statement, targetColumns, parallelIteratorFactory, stopAtBestPlan);
        }
        ColumnResolver resolver = FromCompiler.getResolverForQuery(select, statement.getConnection());
        HashMap<TableRef, QueryPlan> dataPlans = null;
        if (select.isJoin() || select.getWhere() != null && select.getWhere().hasSubquery()) {
            JoinCompiler.JoinTable join = JoinCompiler.compile(statement, select, resolver);
            HashMap<TableRef, TableRef> replacement = null;
            for (JoinCompiler.Table table : join.getTables()) {
                QueryPlan subDataPlan;
                QueryPlan subPlan;
                TableRef newTableRef;
                if (table.isSubselect()) continue;
                TableRef tableRef = table.getTableRef();
                SelectStatement stmt = table.getAsSubqueryForOptimization(tableRef.equals(dataPlan.getTableRef()));
                if (stmt.getWhere() != null && stmt.getWhere().hasSubquery()) {
                    StatementContext context = new StatementContext(statement, resolver, new Scan(), new SequenceManager(statement));
                    ParseNode dummyWhere = GenSubqueryParamValuesRewriter.replaceWithDummyValues(stmt.getWhere(), context);
                    stmt = FACTORY.select(stmt, dummyWhere);
                }
                if ((newTableRef = (subPlan = this.optimize(statement, subDataPlan = new QueryCompiler(statement, stmt, FromCompiler.getResolverForQuery(stmt, statement.getConnection()), false, false, null).compile())).getTableRef()).equals(tableRef)) continue;
                if (replacement == null) {
                    replacement = new HashMap<TableRef, TableRef>();
                    dataPlans = new HashMap<TableRef, QueryPlan>();
                }
                replacement.put(tableRef, newTableRef);
                dataPlans.put(newTableRef, subDataPlan);
            }
            if (replacement != null) {
                select = QueryOptimizer.rewriteQueryWithIndexReplacement(statement.getConnection(), resolver, select, replacement);
                resolver = FromCompiler.getResolverForQuery(select, statement.getConnection());
            }
        }
        QueryCompiler compiler = new QueryCompiler(statement, select, resolver, targetColumns, parallelIteratorFactory, dataPlan.getContext().getSequenceManager(), true, true, dataPlans);
        return Collections.singletonList(compiler.compile());
    }

    private List<QueryPlan> getApplicablePlansForSingleFlatQuery(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, boolean stopAtBestPlan) throws SQLException {
        SelectStatement select = (SelectStatement)dataPlan.getStatement();
        if (dataPlan.getContext().getScanRanges().isPointLookup() && stopAtBestPlan) {
            return Collections.singletonList(dataPlan);
        }
        ArrayList indexes = Lists.newArrayList(dataPlan.getTableRef().getTable().getIndexes());
        if (indexes.isEmpty() || dataPlan.isDegenerate() || dataPlan.getTableRef().hasDynamicCols() || select.getHint().hasHint(HintNode.Hint.NO_INDEX)) {
            return Collections.singletonList(dataPlan);
        }
        if (targetColumns.isEmpty()) {
            List<? extends ColumnProjector> projectors = dataPlan.getProjector().getColumnProjectors();
            ArrayList targetDatums = Lists.newArrayListWithExpectedSize((int)projectors.size());
            for (ColumnProjector columnProjector : projectors) {
                targetDatums.add(columnProjector.getExpression());
            }
            targetColumns = targetDatums;
        }
        SelectStatement translatedIndexSelect = IndexStatementRewriter.translate(select, FromCompiler.getResolver(dataPlan.getTableRef()));
        ArrayList plans = Lists.newArrayListWithExpectedSize((int)(1 + indexes.size()));
        plans.add(dataPlan);
        QueryPlan hintedPlan = this.getHintedQueryPlan(statement, translatedIndexSelect, indexes, targetColumns, parallelIteratorFactory, plans);
        if (hintedPlan != null) {
            if (stopAtBestPlan) {
                return Collections.singletonList(hintedPlan);
            }
            plans.add(0, hintedPlan);
        }
        for (PTable index : indexes) {
            QueryPlan plan = this.addPlan(statement, translatedIndexSelect, index, targetColumns, parallelIteratorFactory, dataPlan, false);
            if (plan == null) continue;
            if (plan.isDegenerate()) {
                return Collections.singletonList(plan);
            }
            plans.add(plan);
        }
        return hintedPlan == null ? this.orderPlansBestToWorst(select, plans, stopAtBestPlan) : plans;
    }

    private QueryPlan getHintedQueryPlan(PhoenixStatement statement, SelectStatement select, List<PTable> indexes, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, List<QueryPlan> plans) throws SQLException {
        QueryPlan dataPlan = plans.get(0);
        String indexHint = select.getHint().getHint(HintNode.Hint.INDEX);
        if (indexHint == null) {
            return null;
        }
        int startIndex = 0;
        String alias = dataPlan.getTableRef().getTableAlias();
        String prefix = "(" + (alias == null ? dataPlan.getTableRef().getTable().getName().getString() : alias) + ' ';
        while (startIndex < indexHint.length()) {
            if ((startIndex = indexHint.indexOf(prefix, startIndex)) < 0) {
                return null;
            }
            startIndex += prefix.length();
            boolean done = false;
            while (startIndex < indexHint.length() && !done) {
                int endIndex;
                int endIndex1 = indexHint.indexOf(32, startIndex);
                int endIndex2 = indexHint.indexOf(")", startIndex);
                if (endIndex1 < 0 && endIndex2 < 0) {
                    endIndex = indexHint.length();
                } else if (endIndex1 < 0) {
                    done = true;
                    endIndex = endIndex2;
                } else if (endIndex2 < 0) {
                    endIndex = endIndex1;
                } else {
                    endIndex = Math.min(endIndex1, endIndex2);
                    done = endIndex2 == endIndex;
                }
                String indexName = indexHint.substring(startIndex, endIndex);
                int indexPos = QueryOptimizer.getIndexPosition(indexes, indexName);
                if (indexPos >= 0) {
                    PTable index = indexes.get(indexPos);
                    indexes.remove(indexPos);
                    QueryPlan plan = this.addPlan(statement, select, index, targetColumns, parallelIteratorFactory, dataPlan, true);
                    if (plan != null) {
                        return plan;
                    }
                }
                startIndex = endIndex + 1;
            }
        }
        return null;
    }

    private static int getIndexPosition(List<PTable> indexes, String indexName) {
        for (int i = 0; i < indexes.size(); ++i) {
            if (!indexName.equals(indexes.get(i).getTableName().getString())) continue;
            return i;
        }
        return -1;
    }

    private QueryPlan addPlan(PhoenixStatement statement, SelectStatement select, PTable index, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, QueryPlan dataPlan, boolean isHinted) throws SQLException {
        block10: {
            int nColumns = dataPlan.getProjector().getColumnCount();
            String tableAlias = dataPlan.getTableRef().getTableAlias();
            String alias = tableAlias == null ? null : '\"' + tableAlias + '\"';
            String schemaName = index.getParentSchemaName().getString();
            schemaName = schemaName.length() == 0 ? null : '\"' + schemaName + '\"';
            String tableName = '\"' + index.getTableName().getString() + '\"';
            NamedTableNode table = FACTORY.namedTable(alias, FACTORY.table(schemaName, tableName), select.getTableSamplingRate());
            SelectStatement indexSelect = FACTORY.select(select, table);
            ColumnResolver resolver = FromCompiler.getResolverForQuery(indexSelect, statement.getConnection());
            boolean isProjected = dataPlan.getContext().getResolver().getTables().get(0).getTable().getType() == PTableType.PROJECTED;
            TableRef indexTableRef = resolver.getTables().get(0);
            PTable indexTable = indexTableRef.getTable();
            PIndexState indexState = indexTable.getIndexState();
            Map<TableRef, QueryPlan> dataPlans = Collections.singletonMap(indexTableRef, dataPlan);
            if (indexState == PIndexState.ACTIVE || indexState == PIndexState.PENDING_ACTIVE || indexState == PIndexState.PENDING_DISABLE && this.isUnderPendingDisableThreshold(indexTableRef.getCurrentTime(), indexTable.getIndexDisableTimestamp())) {
                try {
                    indexSelect = ParseNodeRewriter.rewrite(indexSelect, (ParseNodeRewriter)new IndexExpressionParseNodeRewriter(index, null, statement.getConnection(), indexSelect.getUdfParseNodes()));
                    QueryCompiler compiler = new QueryCompiler(statement, indexSelect, resolver, targetColumns, parallelIteratorFactory, dataPlan.getContext().getSequenceManager(), isProjected, true, dataPlans);
                    QueryPlan plan = compiler.compile();
                    if (index.getIndexType() == PTable.IndexType.LOCAL && indexSelect.getWhere() == null && !plan.getContext().getDataColumns().isEmpty()) {
                        return null;
                    }
                    indexTableRef = plan.getTableRef();
                    indexTable = indexTableRef.getTable();
                    indexState = indexTable.getIndexState();
                    if (indexState == PIndexState.ACTIVE || indexState == PIndexState.PENDING_ACTIVE || indexState == PIndexState.PENDING_DISABLE && this.isUnderPendingDisableThreshold(indexTableRef.getCurrentTime(), indexTable.getIndexDisableTimestamp())) {
                        if (plan.getProjector().getColumnCount() == nColumns) {
                            return plan;
                        }
                        if (index.getIndexType() == PTable.IndexType.GLOBAL) {
                            String schemaNameStr = index.getSchemaName() == null ? null : index.getSchemaName().getString();
                            String tableNameStr = index.getTableName() == null ? null : index.getTableName().getString();
                            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, "*");
                        }
                    }
                }
                catch (ColumnNotFoundException e) {
                    int posOffset;
                    SelectStatement dataSelect = (SelectStatement)dataPlan.getStatement();
                    ParseNode where = dataSelect.getWhere();
                    if (!isHinted || where == null) break block10;
                    StatementContext context = new StatementContext(statement, resolver);
                    WhereConditionRewriter whereRewriter = new WhereConditionRewriter(FromCompiler.getResolver(dataPlan.getTableRef()), context);
                    if ((where = where.accept(whereRewriter)) == null) break block10;
                    PTable dataTable = dataPlan.getTableRef().getTable();
                    List<PColumn> pkColumns = dataTable.getPKColumns();
                    ArrayList aliasedNodes = Lists.newArrayListWithExpectedSize((int)pkColumns.size());
                    ArrayList nodes = Lists.newArrayListWithExpectedSize((int)pkColumns.size());
                    boolean isSalted = dataTable.getBucketNum() != null;
                    boolean isTenantSpecific = dataTable.isMultiTenant() && statement.getConnection().getTenantId() != null;
                    for (int i = posOffset = (isSalted ? 1 : 0) + (isTenantSpecific ? 1 : 0); i < pkColumns.size(); ++i) {
                        PDataType dataColType;
                        PColumn column = pkColumns.get(i);
                        String indexColName = IndexUtil.getIndexColumnName(column);
                        ParseNode indexColNode = new ColumnParseNode(null, '\"' + indexColName + '\"', indexColName);
                        PDataType indexColType = IndexUtil.getIndexColumnDataType(column);
                        if (indexColType != (dataColType = column.getDataType())) {
                            indexColNode = FACTORY.cast(indexColNode, dataColType, null, null);
                        }
                        aliasedNodes.add(FACTORY.aliasedNode(null, indexColNode));
                        nodes.add(new ColumnParseNode(null, '\"' + column.getName().getString() + '\"'));
                    }
                    SelectStatement innerSelect = FACTORY.select(indexSelect.getFrom(), indexSelect.getHint(), false, aliasedNodes, where, null, null, null, null, null, indexSelect.getBindCount(), false, indexSelect.hasSequence(), Collections.emptyList(), indexSelect.getUdfParseNodes());
                    CompoundParseNode outerWhere = FACTORY.in(nodes.size() == 1 ? (ParseNode)nodes.get(0) : FACTORY.rowValueConstructor(nodes), FACTORY.subquery(innerSelect, false), false, true);
                    ParseNode extractedCondition = whereRewriter.getExtractedCondition();
                    if (extractedCondition != null) {
                        outerWhere = FACTORY.and(Lists.newArrayList((Object[])new ParseNode[]{outerWhere, extractedCondition}));
                    }
                    HintNode hint = HintNode.combine(HintNode.subtract(indexSelect.getHint(), new HintNode.Hint[]{HintNode.Hint.INDEX, HintNode.Hint.NO_CHILD_PARENT_JOIN_OPTIMIZATION}), FACTORY.hint("NO_INDEX"));
                    SelectStatement query = FACTORY.select(dataSelect, hint, (ParseNode)outerWhere);
                    ColumnResolver queryResolver = FromCompiler.getResolverForQuery(query, statement.getConnection());
                    query = SubqueryRewriter.transform(query, queryResolver, statement.getConnection());
                    queryResolver = FromCompiler.getResolverForQuery(query, statement.getConnection());
                    query = StatementNormalizer.normalize(query, queryResolver);
                    QueryPlan plan = new QueryCompiler(statement, query, queryResolver, targetColumns, parallelIteratorFactory, dataPlan.getContext().getSequenceManager(), isProjected, true, dataPlans).compile();
                    return plan;
                }
            }
        }
        return null;
    }

    private boolean isUnderPendingDisableThreshold(long currentTimestamp, long indexDisableTimestamp) {
        return currentTimestamp - indexDisableTimestamp <= this.indexPendingDisabledThreshold;
    }

    private List<QueryPlan> orderPlansBestToWorst(SelectStatement select, List<QueryPlan> plans, boolean stopAtBestPlan) {
        QueryPlan dataPlan = plans.get(0);
        if (plans.size() == 1) {
            return plans;
        }
        if (this.costBased) {
            Collections.sort(plans, new Comparator<QueryPlan>(){

                @Override
                public int compare(QueryPlan plan1, QueryPlan plan2) {
                    return plan1.getCost().compareTo(plan2.getCost());
                }
            });
            if (!plans.get(0).getCost().isUnknown()) {
                return stopAtBestPlan ? plans.subList(0, 1) : plans;
            }
        }
        ArrayList candidates = Lists.newArrayListWithExpectedSize((int)plans.size());
        if (stopAtBestPlan) {
            for (QueryPlan plan : plans) {
                if (!plan.getContext().getScanRanges().isPointLookup()) continue;
                candidates.add(plan);
            }
        } else {
            candidates.addAll(plans);
        }
        ArrayList stillCandidates = plans;
        ArrayList bestCandidates = candidates;
        if (!candidates.isEmpty()) {
            stillCandidates = candidates;
            bestCandidates = Lists.newArrayListWithExpectedSize((int)candidates.size());
        }
        for (QueryPlan plan : stillCandidates) {
            if (!plan.getOrderBy().getOrderByExpressions().isEmpty()) continue;
            bestCandidates.add(plan);
        }
        if (bestCandidates.isEmpty()) {
            bestCandidates.addAll(stillCandidates);
        }
        int nViewConstants = 0;
        PTable dataTable = dataPlan.getTableRef().getTable();
        if (dataTable.getType() == PTableType.VIEW) {
            for (PColumn column : dataTable.getColumns()) {
                if (column.getViewConstant() == null) continue;
                ++nViewConstants;
            }
        }
        final int boundRanges = nViewConstants;
        final boolean useDataOverIndexHint = select.getHint().hasHint(HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
        final int comparisonOfDataVersusIndexTable = useDataOverIndexHint ? -1 : 1;
        Collections.sort(bestCandidates, new Comparator<QueryPlan>(){

            @Override
            public int compare(QueryPlan plan1, QueryPlan plan2) {
                PTable table1 = plan1.getTableRef().getTable();
                PTable table2 = plan2.getTableRef().getTable();
                int boundCount1 = plan1.getContext().getScanRanges().getBoundPkColumnCount();
                int boundCount2 = plan2.getContext().getScanRanges().getBoundPkColumnCount();
                int c = boundCount2 + (table2.getViewIndexId() == null ? 0 : boundRanges - 1) - (boundCount1 + (table1.getViewIndexId() == null ? 0 : boundRanges - 1));
                if (c != 0) {
                    return c;
                }
                if (plan1.getGroupBy() != null && plan2.getGroupBy() != null && plan1.getGroupBy().isOrderPreserving() != plan2.getGroupBy().isOrderPreserving()) {
                    return plan1.getGroupBy().isOrderPreserving() ? -1 : 1;
                }
                if ((!useDataOverIndexHint || table1.getType() == PTableType.INDEX && table2.getType() == PTableType.INDEX) && (c = table1.getColumns().size() - table1.getPKColumns().size() - (table2.getColumns().size() - table2.getPKColumns().size())) != 0) {
                    return c;
                }
                if (table1.getIndexType() == PTable.IndexType.LOCAL && table2.getIndexType() != PTable.IndexType.LOCAL) {
                    return plan1.getContext().getScanRanges().getRanges().isEmpty() ? -1 : 1;
                }
                if (table2.getIndexType() == PTable.IndexType.LOCAL && table1.getIndexType() != PTable.IndexType.LOCAL) {
                    return plan2.getContext().getScanRanges().getRanges().isEmpty() ? 1 : -1;
                }
                if (table1.getType() == PTableType.INDEX && table2.getType() != PTableType.INDEX) {
                    return -comparisonOfDataVersusIndexTable;
                }
                if (table2.getType() == PTableType.INDEX && table1.getType() != PTableType.INDEX) {
                    return comparisonOfDataVersusIndexTable;
                }
                return 0;
            }
        });
        return stopAtBestPlan ? bestCandidates.subList(0, 1) : bestCandidates;
    }

    private static SelectStatement rewriteQueryWithIndexReplacement(PhoenixConnection connection, final ColumnResolver resolver, SelectStatement select, final Map<TableRef, TableRef> replacement) throws SQLException {
        TableNode newFrom;
        TableNode from = select.getFrom();
        if (from == (newFrom = from.accept(new TableNodeVisitor<TableNode>(){

            private TableRef resolveTable(String alias, TableName name) throws SQLException {
                if (alias != null) {
                    return resolver.resolveTable(null, alias);
                }
                return resolver.resolveTable(name.getSchemaName(), name.getTableName());
            }

            private TableName getReplacedTableName(TableRef tableRef) {
                String schemaName = tableRef.getTable().getSchemaName().getString();
                return TableName.create(schemaName.length() == 0 ? null : schemaName, tableRef.getTable().getTableName().getString());
            }

            @Override
            public TableNode visit(BindTableNode boundTableNode) throws SQLException {
                TableRef tableRef = this.resolveTable(boundTableNode.getAlias(), boundTableNode.getName());
                TableRef replaceRef = (TableRef)replacement.get(tableRef);
                if (replaceRef == null) {
                    return boundTableNode;
                }
                String alias = boundTableNode.getAlias();
                return FACTORY.bindTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName(replaceRef));
            }

            @Override
            public TableNode visit(JoinTableNode joinNode) throws SQLException {
                TableNode lhs = joinNode.getLHS();
                TableNode rhs = joinNode.getRHS();
                TableNode lhsReplace = lhs.accept(this);
                TableNode rhsReplace = rhs.accept(this);
                if (lhs == lhsReplace && rhs == rhsReplace) {
                    return joinNode;
                }
                return FACTORY.join(joinNode.getType(), lhsReplace, rhsReplace, joinNode.getOnNode(), joinNode.isSingleValueOnly());
            }

            @Override
            public TableNode visit(NamedTableNode namedTableNode) throws SQLException {
                TableRef tableRef = this.resolveTable(namedTableNode.getAlias(), namedTableNode.getName());
                TableRef replaceRef = (TableRef)replacement.get(tableRef);
                if (replaceRef == null) {
                    return namedTableNode;
                }
                String alias = namedTableNode.getAlias();
                return FACTORY.namedTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName(replaceRef), namedTableNode.getDynamicColumns(), namedTableNode.getTableSamplingRate());
            }

            @Override
            public TableNode visit(DerivedTableNode subselectNode) throws SQLException {
                return subselectNode;
            }
        }))) {
            return select;
        }
        SelectStatement indexSelect = IndexStatementRewriter.translate(FACTORY.select(select, newFrom), resolver, replacement);
        for (TableRef indexTableRef : replacement.values()) {
            indexSelect = ParseNodeRewriter.rewrite(indexSelect, (ParseNodeRewriter)new IndexExpressionParseNodeRewriter(indexTableRef.getTable(), indexTableRef.getTableAlias(), connection, indexSelect.getUdfParseNodes()));
        }
        return indexSelect;
    }

    private static class WhereConditionRewriter
    extends BooleanParseNodeVisitor<ParseNode> {
        private final ColumnResolver dataResolver;
        private final ExpressionCompiler expressionCompiler;
        private List<ParseNode> extractedConditions;

        public WhereConditionRewriter(ColumnResolver dataResolver, StatementContext context) throws SQLException {
            this.dataResolver = dataResolver;
            this.expressionCompiler = new ExpressionCompiler(context);
            this.extractedConditions = Lists.newArrayList();
        }

        public ParseNode getExtractedCondition() {
            if (this.extractedConditions.isEmpty()) {
                return null;
            }
            if (this.extractedConditions.size() == 1) {
                return this.extractedConditions.get(0);
            }
            return FACTORY.and(this.extractedConditions);
        }

        @Override
        public List<ParseNode> newElementList(int size) {
            return Lists.newArrayListWithExpectedSize((int)size);
        }

        @Override
        public void addElement(List<ParseNode> l, ParseNode element) {
            if (element != null) {
                l.add(element);
            }
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public ParseNode visitLeave(AndParseNode node, List<ParseNode> l) throws SQLException {
            if (l.equals(node.getChildren())) {
                return node;
            }
            if (l.isEmpty()) {
                return null;
            }
            if (l.size() == 1) {
                return l.get(0);
            }
            return FACTORY.and(l);
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            ParseNode translatedNode = IndexStatementRewriter.translate(node, this.dataResolver);
            this.expressionCompiler.reset();
            try {
                translatedNode.accept(this.expressionCompiler);
            }
            catch (ColumnNotFoundException e) {
                this.extractedConditions.add(node);
                return null;
            }
            return translatedNode;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveNonBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            return node;
        }
    }
}

