/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.phoenix.mapreduce.index.IndexToolUtil;
import org.apache.phoenix.schema.PIndexState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexImportDirectReducer
extends Reducer<ImmutableBytesWritable, IntWritable, NullWritable, NullWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixIndexImportDirectReducer.class);
    private Configuration configuration;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.configuration = context.getConfiguration();
    }

    protected void reduce(ImmutableBytesWritable arg0, Iterable<IntWritable> arg1, Reducer.Context arg2) throws IOException, InterruptedException {
        try {
            IndexToolUtil.updateIndexState(this.configuration, PIndexState.ACTIVE);
        }
        catch (SQLException e) {
            LOG.error(" Failed to update the status to Active");
            throw new RuntimeException(e.getMessage());
        }
    }
}

