/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexScrutinyMapper
extends Mapper<NullWritable, PhoenixIndexDBWritable, Text, Text> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexScrutinyMapper.class);
    private Connection connection;
    private List<ColumnInfo> targetTblColumnMetadata;
    private long batchSize;
    private List<Pair<Long, List<Object>>> currentBatchValues = new ArrayList<Pair<Long, List<Object>>>();
    private String targetTableQuery;
    private int numTargetPkCols;
    private boolean outputInvalidRows;
    private IndexScrutinyTool.OutputFormat outputFormat = IndexScrutinyTool.OutputFormat.FILE;
    private String qSourceTable;
    private String qTargetTable;
    private long executeTimestamp;
    private int numSourcePkCols;
    private final PhoenixIndexDBWritable indxWritable = new PhoenixIndexDBWritable();
    private List<ColumnInfo> sourceTblColumnMetadata;
    private Connection outputConn;
    private PreparedStatement outputUpsertStmt;
    private long outputMaxRows;
    private MessageDigest md5;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        try {
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            overrideProps.put("CurrentSCN", scn);
            this.connection = ConnectionUtil.getOutputConnection(configuration, overrideProps);
            this.connection.setAutoCommit(false);
            this.batchSize = PhoenixConfigurationUtil.getScrutinyBatchSize(configuration);
            this.outputInvalidRows = PhoenixConfigurationUtil.getScrutinyOutputInvalidRows(configuration);
            this.outputFormat = PhoenixConfigurationUtil.getScrutinyOutputFormat(configuration);
            this.executeTimestamp = PhoenixConfigurationUtil.getScrutinyExecuteTimestamp(configuration);
            String qDataTable = PhoenixConfigurationUtil.getScrutinyDataTableName(configuration);
            PTable pdataTable = PhoenixRuntime.getTable(this.connection, qDataTable);
            String qIndexTable = PhoenixConfigurationUtil.getScrutinyIndexTableName(configuration);
            PTable pindexTable = PhoenixRuntime.getTable(this.connection, qIndexTable);
            IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getScrutinySourceTable(configuration);
            SourceTargetColumnNames columnNames = (SourceTargetColumnNames)((Object)(IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) ? new SourceTargetColumnNames.DataSourceColNames(pdataTable, pindexTable) : new SourceTargetColumnNames.IndexSourceColNames(pdataTable, pindexTable)));
            this.qSourceTable = columnNames.getQualifiedSourceTableName();
            this.qTargetTable = columnNames.getQualifiedTargetTableName();
            List<String> targetColNames = columnNames.getTargetColNames();
            List<String> sourceColNames = columnNames.getSourceColNames();
            List<String> targetPkColNames = columnNames.getTargetPkColNames();
            String targetPksCsv = Joiner.on((String)",").join(SchemaUtil.getEscapedFullColumnNames(targetPkColNames));
            this.numSourcePkCols = columnNames.getSourcePkColNames().size();
            this.numTargetPkCols = targetPkColNames.size();
            if (this.outputInvalidRows && IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
                this.outputConn = ConnectionUtil.getOutputConnection(configuration, new Properties());
                String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
                this.outputUpsertStmt = this.outputConn.prepareStatement(upsertQuery);
            }
            this.outputMaxRows = PhoenixConfigurationUtil.getScrutinyOutputMax(configuration);
            this.targetTableQuery = QueryUtil.constructSelectStatement(this.qTargetTable, columnNames.getCastedTargetColNames(), targetPksCsv, HintNode.Hint.NO_INDEX, false) + " IN ";
            this.targetTblColumnMetadata = PhoenixRuntime.generateColumnInfo(this.connection, this.qTargetTable, targetColNames);
            this.sourceTblColumnMetadata = PhoenixRuntime.generateColumnInfo(this.connection, this.qSourceTable, sourceColNames);
            LOG.info("Target table base query: " + this.targetTableQuery);
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void map(NullWritable key, PhoenixIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<Object> values = record.getValues();
            context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
            this.currentBatchValues.add((Pair<Long, List<Object>>)new Pair((Object)record.getRowTs(), values));
            if (context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue() % this.batchSize != 0L) {
                context.progress();
                return;
            }
            this.processBatch(context);
            context.progress();
        }
        catch (IllegalArgumentException | SQLException e) {
            LOG.error(" Error while read/write of a record ", (Throwable)e);
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new IOException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        if (this.connection != null) {
            try {
                this.processBatch(context);
                this.connection.close();
                if (this.outputConn != null) {
                    this.outputConn.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Error while closing connection in the PhoenixIndexMapper class ", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    private void processBatch(Mapper.Context context) throws SQLException, IOException, InterruptedException {
        if (this.currentBatchValues.size() == 0) {
            return;
        }
        context.getCounter((Enum)PhoenixScrutinyJobCounters.BATCHES_PROCESSED_COUNT).increment(1L);
        String inClause = QueryUtil.constructParameterizedInClause(this.numTargetPkCols, this.currentBatchValues.size());
        String indexQuery = this.targetTableQuery + inClause;
        try (PreparedStatement targetStatement = this.connection.prepareStatement(indexQuery);){
            Map<String, Pair<Long, List<Object>>> targetPkToSourceValues = this.buildTargetStatement(targetStatement);
            this.queryTargetTable(context, targetStatement, targetPkToSourceValues);
            context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).increment((long)targetPkToSourceValues.size());
            if (this.outputInvalidRows) {
                for (Pair<Long, List<Object>> sourceRowWithoutTargetRow : targetPkToSourceValues.values()) {
                    List valuesWithoutTarget = (List)sourceRowWithoutTargetRow.getSecond();
                    if (IndexScrutinyTool.OutputFormat.FILE.equals((Object)this.outputFormat)) {
                        context.write((Object)new Text(Arrays.toString(valuesWithoutTarget.toArray())), (Object)new Text("Target row not found"));
                        continue;
                    }
                    if (!IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) continue;
                    this.writeToOutputTable(context, valuesWithoutTarget, null, (Long)sourceRowWithoutTargetRow.getFirst(), -1L);
                }
            }
            if (this.outputInvalidRows && IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
                this.outputUpsertStmt.executeBatch();
                this.outputConn.commit();
            }
            this.currentBatchValues.clear();
        }
    }

    private Map<String, Pair<Long, List<Object>>> buildTargetStatement(PreparedStatement targetStatement) throws SQLException {
        HashMap<String, Pair<Long, List<Object>>> targetPkToSourceValues = new HashMap<String, Pair<Long, List<Object>>>(this.currentBatchValues.size());
        int rsIndex = 1;
        for (Pair<Long, List<Object>> batchTsRow : this.currentBatchValues) {
            List batchRow = (List)batchTsRow.getSecond();
            String targetPkHash = this.getPkHash(batchRow.subList(0, this.numTargetPkCols));
            targetPkToSourceValues.put(targetPkHash, batchTsRow);
            for (int i = 0; i < this.numTargetPkCols; ++i) {
                ColumnInfo targetPkInfo = this.targetTblColumnMetadata.get(i);
                Object value = batchRow.get(i);
                if (value == null) {
                    targetStatement.setNull(rsIndex++, targetPkInfo.getSqlType());
                    continue;
                }
                targetStatement.setObject(rsIndex++, value, targetPkInfo.getSqlType());
            }
        }
        return targetPkToSourceValues;
    }

    private void queryTargetTable(Mapper.Context context, PreparedStatement targetStatement, Map<String, Pair<Long, List<Object>>> targetPkToSourceValues) throws SQLException, IOException, InterruptedException {
        ResultSet targetResultSet = targetStatement.executeQuery();
        while (targetResultSet.next()) {
            this.indxWritable.readFields(targetResultSet);
            List<Object> targetValues = this.indxWritable.getValues();
            ArrayList<Object> pkObjects = new ArrayList<Object>(this.numTargetPkCols);
            for (int i = 0; i < this.numTargetPkCols; ++i) {
                Object pkPart = targetResultSet.getObject(i + 1);
                pkObjects.add(pkPart);
            }
            Long targetTS = targetResultSet.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp();
            String targetPk = this.getPkHash(pkObjects);
            Pair<Long, List<Object>> sourceTsValues = targetPkToSourceValues.get(targetPk);
            Long sourceTS = (Long)sourceTsValues.getFirst();
            List sourceValues = (List)sourceTsValues.getSecond();
            boolean isIndexedCorrectly = this.compareValues(this.numTargetPkCols, targetValues, sourceValues, context);
            if (isIndexedCorrectly) {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).increment(1L);
            } else {
                context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).increment(1L);
                if (this.outputInvalidRows) {
                    this.outputInvalidRow(context, sourceValues, targetValues, sourceTS, targetTS);
                }
            }
            targetPkToSourceValues.remove(targetPk);
        }
    }

    private void outputInvalidRow(Mapper.Context context, List<Object> sourceValues, List<Object> targetValues, long sourceTS, long targetTS) throws SQLException, IOException, InterruptedException {
        if (IndexScrutinyTool.OutputFormat.FILE.equals((Object)this.outputFormat)) {
            context.write((Object)new Text(Arrays.toString(sourceValues.toArray())), (Object)new Text(Arrays.toString(targetValues.toArray())));
        } else if (IndexScrutinyTool.OutputFormat.TABLE.equals((Object)this.outputFormat)) {
            this.writeToOutputTable(context, sourceValues, targetValues, sourceTS, targetTS);
        }
    }

    private void writeToOutputTable(Mapper.Context context, List<Object> sourceValues, List<Object> targetValues, long sourceTS, long targetTS) throws SQLException {
        if (context.getCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue() > this.outputMaxRows) {
            return;
        }
        int index = 1;
        this.outputUpsertStmt.setString(index++, this.qSourceTable);
        this.outputUpsertStmt.setString(index++, this.qTargetTable);
        this.outputUpsertStmt.setLong(index++, this.executeTimestamp);
        this.outputUpsertStmt.setString(index++, this.getPkHash(sourceValues.subList(0, this.numSourcePkCols)));
        this.outputUpsertStmt.setLong(index++, sourceTS);
        this.outputUpsertStmt.setLong(index++, targetTS);
        this.outputUpsertStmt.setBoolean(index++, targetValues != null);
        index = this.setStatementObjects(sourceValues, index, this.sourceTblColumnMetadata);
        if (targetValues != null) {
            index = this.setStatementObjects(targetValues, index, this.targetTblColumnMetadata);
        } else {
            for (int i = 0; i < sourceValues.size(); ++i) {
                this.outputUpsertStmt.setNull(index++, this.targetTblColumnMetadata.get(i).getSqlType());
            }
        }
        this.outputUpsertStmt.addBatch();
    }

    private int setStatementObjects(List<Object> values, int index, List<ColumnInfo> colMetadata) throws SQLException {
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            ColumnInfo colInfo = colMetadata.get(i);
            if (value != null) {
                this.outputUpsertStmt.setObject(index++, value, colInfo.getSqlType());
                continue;
            }
            this.outputUpsertStmt.setNull(index++, colInfo.getSqlType());
        }
        return index;
    }

    private boolean compareValues(int startIndex, List<Object> targetValues, List<Object> sourceValues, Mapper.Context context) throws SQLException {
        if (targetValues == null || sourceValues == null) {
            return false;
        }
        for (int i = startIndex; i < sourceValues.size(); ++i) {
            Object targetValue = targetValues.get(i);
            Object sourceValue = sourceValues.get(i);
            if (targetValue == null || targetValue.equals(sourceValue)) continue;
            context.getCounter((Enum)PhoenixScrutinyJobCounters.BAD_COVERED_COL_VAL_COUNT).increment(1L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPkHash(List<Object> pkObjects) {
        try {
            for (int i = 0; i < pkObjects.size(); ++i) {
                this.md5.update(this.sourceTblColumnMetadata.get(i).getPDataType().toBytes(pkObjects.get(i)));
            }
            String string = Hex.encodeHexString((byte[])this.md5.digest());
            return string;
        }
        finally {
            this.md5.reset();
        }
    }
}

