/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectHTableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DirectHTableWriter.class);
    private Configuration conf = null;
    private HTable table;

    public DirectHTableWriter(Configuration otherConf) {
        this.setConf(otherConf);
    }

    protected void setConf(Configuration otherConf) {
        this.conf = HBaseConfiguration.create((Configuration)otherConf);
        String tableName = this.conf.get("hbase.mapred.outputtable");
        if (tableName == null || tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        try {
            this.table = new HTable(this.conf, tableName);
            this.table.setAutoFlush(false, true);
            LOG.info("Created table instance for " + tableName);
        }
        catch (IOException e) {
            LOG.error("IOException : ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void write(List<Mutation> mutations) throws IOException, InterruptedException {
        Object[] results = new Object[mutations.size()];
        this.table.batch(mutations, results);
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected HTable getTable() {
        return this.table;
    }

    public void close() throws IOException {
        this.table.close();
    }
}

