/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.iterate.TableSnapshotResultIterator;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.query.ConnectionQueryServices;

public class PhoenixRecordReader<T extends DBWritable>
extends RecordReader<NullWritable, T> {
    private static final Log LOG = LogFactory.getLog(PhoenixRecordReader.class);
    private final Configuration configuration;
    private final QueryPlan queryPlan;
    private NullWritable key = NullWritable.get();
    private T value = null;
    private Class<T> inputClass;
    private ResultIterator resultIterator = null;
    private PhoenixResultSet resultSet;

    public PhoenixRecordReader(Class<T> inputClass, Configuration configuration, QueryPlan queryPlan) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)queryPlan);
        this.inputClass = inputClass;
        this.configuration = configuration;
        this.queryPlan = queryPlan;
    }

    public void close() throws IOException {
        if (this.resultIterator != null) {
            try {
                this.resultIterator.close();
            }
            catch (SQLException e) {
                LOG.error((Object)" Error closing resultset.");
                throw new RuntimeException(e);
            }
        }
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        PhoenixInputSplit pSplit = (PhoenixInputSplit)split;
        List<Scan> scans = pSplit.getScans();
        try {
            ResultIterator iterator;
            ArrayList iterators = Lists.newArrayListWithExpectedSize((int)scans.size());
            StatementContext ctx = this.queryPlan.getContext();
            ReadMetricQueue readMetrics = ctx.getReadMetricsQueue();
            String tableName = this.queryPlan.getTableRef().getTable().getPhysicalName().getString();
            String snapshotName = this.configuration.get("phoenix.mapreduce.snapshot.name");
            byte[] tableNameBytes = this.queryPlan.getTableRef().getTable().getPhysicalName().getBytes();
            ConnectionQueryServices services = this.queryPlan.getContext().getConnection().getQueryServices();
            services.clearTableRegionCache(tableNameBytes);
            long renewScannerLeaseThreshold = this.queryPlan.getContext().getConnection().getQueryServices().getRenewLeaseThresholdMilliSeconds();
            for (Scan scan : scans) {
                PeekingResultIterator peekingResultIterator;
                scan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance(readMetrics, tableName, scan, this.queryPlan.getContext().getConnection().getLogLevel());
                if (snapshotName != null) {
                    TableSnapshotResultIterator tableSnapshotResultIterator = new TableSnapshotResultIterator(this.configuration, scan, scanMetricsHolder);
                    peekingResultIterator = LookAheadResultIterator.wrap(tableSnapshotResultIterator);
                } else {
                    TableResultIterator tableResultIterator = new TableResultIterator(this.queryPlan.getContext().getConnection().getMutationState(), scan, scanMetricsHolder, renewScannerLeaseThreshold, this.queryPlan, MapReduceParallelScanGrouper.getInstance());
                    peekingResultIterator = LookAheadResultIterator.wrap(tableResultIterator);
                }
                iterators.add(peekingResultIterator);
            }
            ResultIterator resultIterator = iterator = this.queryPlan.useRoundRobinIterator() ? RoundRobinResultIterator.newIterator(iterators, this.queryPlan) : ConcatResultIterator.newIterator(iterators);
            if (this.queryPlan.getContext().getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator(iterator, this.queryPlan.getContext().getSequenceManager());
            }
            this.resultIterator = iterator;
            this.resultSet = new PhoenixResultSet(this.resultIterator, this.queryPlan.getProjector().cloneIfNecessary(), this.queryPlan.getContext());
        }
        catch (SQLException e) {
            LOG.error((Object)String.format(" Error [%s] initializing PhoenixRecordReader. ", e.getMessage()));
            Throwables.propagate((Throwable)e);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = NullWritable.get();
        }
        if (this.value == null) {
            this.value = (DBWritable)ReflectionUtils.newInstance(this.inputClass, (Configuration)this.configuration);
        }
        Preconditions.checkNotNull((Object)this.resultSet);
        try {
            if (!this.resultSet.next()) {
                return false;
            }
            this.value.readFields((ResultSet)this.resultSet);
            return true;
        }
        catch (SQLException e) {
            LOG.error((Object)String.format(" Error [%s] occurred while iterating over the resultset. ", e.getMessage()));
            throw new RuntimeException(e);
        }
    }
}

