/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.csv.CsvUpsertExecutor;

public class CsvToKeyValueMapper
extends FormatToBytesWritableMapper<CSVRecord> {
    public static final String FIELD_DELIMITER_CONFKEY = "phoenix.mapreduce.import.fielddelimiter";
    public static final String QUOTE_CHAR_CONFKEY = "phoenix.mapreduce.import.quotechar";
    public static final String ESCAPE_CHAR_CONFKEY = "phoenix.mapreduce.import.escapechar";
    public static final String ARRAY_DELIMITER_CONFKEY = "phoenix.mapreduce.import.arraydelimiter";
    private CsvLineParser lineParser;

    @Override
    protected FormatToBytesWritableMapper.LineParser<CSVRecord> getLineParser() {
        return this.lineParser;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.lineParser = new CsvLineParser(CsvBulkImportUtil.getCharacter(conf, FIELD_DELIMITER_CONFKEY).charValue(), CsvBulkImportUtil.getCharacter(conf, QUOTE_CHAR_CONFKEY).charValue(), CsvBulkImportUtil.getCharacter(conf, ESCAPE_CHAR_CONFKEY).charValue());
    }

    @Override
    @VisibleForTesting
    protected UpsertExecutor<CSVRecord, ?> buildUpsertExecutor(Configuration conf) {
        String tableName = conf.get("phoenix.mapreduce.import.tablename");
        String arraySeparator = conf.get(ARRAY_DELIMITER_CONFKEY, ":");
        Preconditions.checkNotNull((Object)tableName, (Object)"table name is not configured");
        List<ColumnInfo> columnInfoList = CsvToKeyValueMapper.buildColumnInfoList(conf);
        return new CsvUpsertExecutor((Connection)this.conn, tableName, columnInfoList, (UpsertExecutor.UpsertListener<CSVRecord>)this.upsertListener, arraySeparator);
    }

    @VisibleForTesting
    static class CsvLineParser
    implements FormatToBytesWritableMapper.LineParser<CSVRecord> {
        private final CSVFormat csvFormat;

        CsvLineParser(char fieldDelimiter, char quote, char escape) {
            this.csvFormat = CSVFormat.DEFAULT.withIgnoreEmptyLines(true).withDelimiter(fieldDelimiter).withEscape(escape).withQuote(quote);
        }

        @Override
        public CSVRecord parse(String input) throws IOException {
            CSVParser csvParser = new CSVParser((Reader)new StringReader(input), this.csvFormat);
            return (CSVRecord)Iterables.getFirst((Iterable)csvParser, null);
        }
    }
}

