/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PName;

public class QueryLoggerUtil {
    public static void logInitialDetails(QueryLogger queryLogger, PName tenantId, ConnectionQueryServices queryServices, String query, List<Object> bindParameters) {
        try {
            String clientIP;
            try {
                clientIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                clientIP = "UnknownHost";
            }
            if (clientIP != null) {
                queryLogger.log(QueryLogInfo.CLIENT_IP_I, clientIP);
            }
            if (query != null) {
                queryLogger.log(QueryLogInfo.QUERY_I, query);
            }
            if (bindParameters != null) {
                queryLogger.log(QueryLogInfo.BIND_PARAMETERS_I, StringUtils.join(bindParameters, (String)","));
            }
            if (tenantId != null) {
                queryLogger.log(QueryLogInfo.TENANT_ID_I, tenantId.getString());
            }
            queryLogger.log(QueryLogInfo.USER_I, queryServices.getUserName() != null ? queryServices.getUserName() : queryServices.getUser().getShortName());
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

