/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.monitoring.OverAllQueryMetrics;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.ServerUtil;

public class UnionResultIterators
implements ResultIterators {
    private final List<KeyRange> splits;
    private final List<List<Scan>> scans;
    private final List<PeekingResultIterator> iterators;
    private final List<ReadMetricQueue> readMetricsList;
    private final List<OverAllQueryMetrics> overAllQueryMetricsList;
    private boolean closed;
    private final StatementContext parentStmtCtx;

    public UnionResultIterators(List<QueryPlan> plans, StatementContext parentStmtCtx) throws SQLException {
        this.parentStmtCtx = parentStmtCtx;
        int nPlans = plans.size();
        this.iterators = Lists.newArrayListWithExpectedSize((int)nPlans);
        this.splits = Lists.newArrayListWithExpectedSize((int)(nPlans * 30));
        this.scans = Lists.newArrayListWithExpectedSize((int)(nPlans * 10));
        this.readMetricsList = Lists.newArrayListWithCapacity((int)nPlans);
        this.overAllQueryMetricsList = Lists.newArrayListWithCapacity((int)nPlans);
        for (QueryPlan plan : plans) {
            this.readMetricsList.add(plan.getContext().getReadMetricsQueue());
            this.overAllQueryMetricsList.add(plan.getContext().getOverallQueryMetrics());
            this.iterators.add(LookAheadResultIterator.wrap(plan.iterator()));
            this.splits.addAll(plan.getSplits());
            this.scans.addAll(plan.getScans());
        }
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block11: {
            if (!this.closed) {
                this.closed = true;
                SQLException toThrow = null;
                try {
                    if (this.iterators != null) {
                        for (int index = 0; index < this.iterators.size(); ++index) {
                            PeekingResultIterator iterator = this.iterators.get(index);
                            try {
                                iterator.close();
                                continue;
                            }
                            catch (Exception e) {
                                if (toThrow == null) {
                                    toThrow = ServerUtil.parseServerException(e);
                                    continue;
                                }
                                toThrow.setNextException(ServerUtil.parseServerException(e));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    toThrow = ServerUtil.parseServerException(e);
                }
                finally {
                    this.setMetricsInParentContext();
                    if (toThrow == null) break block11;
                    throw toThrow;
                }
            }
        }
    }

    private void setMetricsInParentContext() {
        ReadMetricQueue parentCtxReadMetrics = this.parentStmtCtx.getReadMetricsQueue();
        for (ReadMetricQueue readMetrics : this.readMetricsList) {
            parentCtxReadMetrics.combineReadMetrics(readMetrics);
        }
        OverAllQueryMetrics parentCtxQueryMetrics = this.parentStmtCtx.getOverallQueryMetrics();
        for (OverAllQueryMetrics metric : this.overAllQueryMetricsList) {
            parentCtxQueryMetrics.combine(metric);
        }
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    @Override
    public int size() {
        return this.scans.size();
    }

    @Override
    public void explain(List<String> planSteps) {
        for (int index = 0; index < this.iterators.size(); ++index) {
            this.iterators.get(index).explain(planSteps);
        }
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        return this.iterators;
    }
}

