/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.iterate.RegionScannerFactory;

public class SnapshotScanner
extends AbstractClientScanner {
    private static final Log LOG = LogFactory.getLog(SnapshotScanner.class);
    private RegionScanner scanner = null;
    private HRegion region;
    List<Cell> values;

    public SnapshotScanner(Configuration conf, FileSystem fs, Path rootDir, HTableDescriptor htd, HRegionInfo hri, Scan scan) throws Throwable {
        scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        this.values = new ArrayList<Cell>();
        this.region = HRegion.openHRegion((Configuration)conf, (FileSystem)fs, (Path)rootDir, (HRegionInfo)hri, (HTableDescriptor)htd, null, null, null);
        RegionCoprocessorEnvironment snapshotEnv = this.getSnapshotContextEnvironment(conf);
        if (scan.getAttribute("_NonAggregateQuery") == null) {
            throw new UnsupportedOperationException("Snapshot M/R jobs not available for aggregate queries");
        }
        NonAggregateRegionScannerFactory regionScannerFactory = new NonAggregateRegionScannerFactory(snapshotEnv);
        this.scanner = ((RegionScannerFactory)regionScannerFactory).getRegionScanner(scan, this.region.getScanner(scan));
        this.region.startRegionOperation();
    }

    public Result next() throws IOException {
        this.values.clear();
        this.scanner.nextRaw(this.values);
        if (this.values.isEmpty()) {
            return null;
        }
        return Result.create(this.values);
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.scanner.close();
                this.scanner = null;
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception while closing scanner", (Throwable)e);
            }
        }
        if (this.region != null) {
            try {
                this.region.closeRegionOperation();
                this.region.close(true);
                this.region = null;
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception while closing scanner", (Throwable)e);
            }
        }
    }

    public boolean renewLease() {
        return false;
    }

    private RegionCoprocessorEnvironment getSnapshotContextEnvironment(final Configuration conf) {
        return new RegionCoprocessorEnvironment(){

            public Region getRegion() {
                return SnapshotScanner.this.region;
            }

            public HRegionInfo getRegionInfo() {
                return SnapshotScanner.this.region.getRegionInfo();
            }

            public RegionServerServices getRegionServerServices() {
                throw new UnsupportedOperationException();
            }

            public ConcurrentMap<String, Object> getSharedData() {
                throw new UnsupportedOperationException();
            }

            public int getVersion() {
                throw new UnsupportedOperationException();
            }

            public String getHBaseVersion() {
                throw new UnsupportedOperationException();
            }

            public Coprocessor getInstance() {
                throw new UnsupportedOperationException();
            }

            public int getPriority() {
                throw new UnsupportedOperationException();
            }

            public int getLoadSequence() {
                throw new UnsupportedOperationException();
            }

            public Configuration getConfiguration() {
                return conf;
            }

            public HTableInterface getTable(TableName tableName) throws IOException {
                throw new UnsupportedOperationException();
            }

            public HTableInterface getTable(TableName tableName, ExecutorService executorService) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ClassLoader getClassLoader() {
                throw new UnsupportedOperationException();
            }

            public MetricRegistry getMetricRegistryForRegionServer() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

