/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class ScanningResultIterator
implements ResultIterator {
    private final ResultScanner scanner;
    private final Scan scan;
    private final ScanMetricsHolder scanMetricsHolder;
    boolean scanMetricsUpdated;
    boolean scanMetricsEnabled;
    static final String RPC_CALLS_METRIC_NAME = "RPC_CALLS";
    static final String REMOTE_RPC_CALLS_METRIC_NAME = "REMOTE_RPC_CALLS";
    static final String MILLIS_BETWEEN_NEXTS_METRIC_NAME = "MILLIS_BETWEEN_NEXTS";
    static final String NOT_SERVING_REGION_EXCEPTION_METRIC_NAME = "NOT_SERVING_REGION_EXCEPTION";
    static final String BYTES_IN_RESULTS_METRIC_NAME = "BYTES_IN_RESULTS";
    static final String BYTES_IN_REMOTE_RESULTS_METRIC_NAME = "BYTES_IN_REMOTE_RESULTS";
    static final String REGIONS_SCANNED_METRIC_NAME = "REGIONS_SCANNED";
    static final String RPC_RETRIES_METRIC_NAME = "RPC_RETRIES";
    static final String REMOTE_RPC_RETRIES_METRIC_NAME = "REMOTE_RPC_RETRIES";
    static final String COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME = "ROWS_SCANNED";
    static final String COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME = "ROWS_FILTERED";
    static final String GLOBAL_BYTES_IN_RESULTS_METRIC_NAME = "BYTES_IN_RESULTS";

    public ScanningResultIterator(ResultScanner scanner, Scan scan, ScanMetricsHolder scanMetricsHolder) {
        this.scanner = scanner;
        this.scan = scan;
        this.scanMetricsHolder = scanMetricsHolder;
        this.scanMetricsUpdated = false;
        this.scanMetricsEnabled = scan.isScanMetricsEnabled();
    }

    @Override
    public void close() throws SQLException {
        this.getScanMetrics();
        this.scanner.close();
    }

    private static void changeMetric(CombinableMetric metric, Long value) {
        if (value != null) {
            metric.change(value);
        }
    }

    private void getScanMetrics() {
        if (!this.scanMetricsUpdated && this.scanMetricsEnabled) {
            Map scanMetricsMap = this.scan.getScanMetrics().getMetricsMap();
            if (scanMetricsMap == null) {
                return;
            }
            this.scanMetricsHolder.setScanMetricMap(scanMetricsMap);
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRPCcalls(), (Long)scanMetricsMap.get(RPC_CALLS_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCcalls(), (Long)scanMetricsMap.get(REMOTE_RPC_CALLS_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getSumOfMillisSecBetweenNexts(), (Long)scanMetricsMap.get(MILLIS_BETWEEN_NEXTS_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfNSRE(), (Long)scanMetricsMap.get(NOT_SERVING_REGION_EXCEPTION_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfBytesInResults(), (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfBytesInRemoteResults(), (Long)scanMetricsMap.get(BYTES_IN_REMOTE_RESULTS_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRegions(), (Long)scanMetricsMap.get(REGIONS_SCANNED_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRPCRetries(), (Long)scanMetricsMap.get(RPC_RETRIES_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCRetries(), (Long)scanMetricsMap.get(REMOTE_RPC_RETRIES_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRowsFiltered(), (Long)scanMetricsMap.get(COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME));
            ScanningResultIterator.changeMetric(this.scanMetricsHolder.getCountOfRowsFiltered(), (Long)scanMetricsMap.get(COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_SCAN_BYTES.update((Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_CALLS.update((Long)scanMetricsMap.get(RPC_CALLS_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_CALLS.update((Long)scanMetricsMap.get(REMOTE_RPC_CALLS_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_MILLS_BETWEEN_NEXTS.update((Long)scanMetricsMap.get(MILLIS_BETWEEN_NEXTS_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_NOT_SERVING_REGION_EXCEPTION.update((Long)scanMetricsMap.get(NOT_SERVING_REGION_EXCEPTION_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_REGION_SERVER_RESULTS.update((Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_IN_REMOTE_RESULTS.update((Long)scanMetricsMap.get(BYTES_IN_REMOTE_RESULTS_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_SCANNED_REGIONS.update((Long)scanMetricsMap.get(REGIONS_SCANNED_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_RETRIES.update((Long)scanMetricsMap.get(RPC_RETRIES_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_RETRIES.update((Long)scanMetricsMap.get(REMOTE_RPC_RETRIES_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_SCANNED.update((Long)scanMetricsMap.get(COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME));
            GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_FILTERED.update((Long)scanMetricsMap.get(COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME));
            this.scanMetricsUpdated = true;
        }
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            Result result = this.scanner.next();
            if (result == null) {
                this.close();
                return null;
            }
            return new ResultTuple(result);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    public String toString() {
        return "ScanningResultIterator [scanner=" + this.scanner + "]";
    }

    public ResultScanner getScanner() {
        return this.scanner;
    }
}

