/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.function.ArrayIndexFunction;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.RegionScannerFactory;
import org.apache.phoenix.iterate.RegionScannerResultIterator;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class NonAggregateRegionScannerFactory
extends RegionScannerFactory {
    public NonAggregateRegionScannerFactory(RegionCoprocessorEnvironment env) {
        this.env = env;
    }

    @Override
    public RegionScanner getRegionScanner(Scan scan, RegionScanner s) throws Throwable {
        OrderedResultIterator iterator;
        boolean useQualifierAsIndex;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int offset = 0;
        if (ScanUtil.isLocalIndex(scan)) {
            Region region = this.getRegion();
            offset = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset(scan, offset);
        }
        byte[] scanOffsetBytes = scan.getAttribute("_RowOffset");
        Integer scanOffset = null;
        if (scanOffsetBytes != null) {
            scanOffset = (Integer)PInteger.INSTANCE.toObject(scanOffsetBytes);
        }
        RegionScanner innerScanner = s;
        PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier(scan);
        HashSet arrayKVRefs = Sets.newHashSet();
        KeyValueSchema kvSchema = null;
        ValueBitSet kvSchemaBitSet = null;
        Expression[] arrayFuncRefs = this.deserializeArrayPositionalExpressionInfoFromScan(scan, innerScanner, arrayKVRefs);
        if (arrayFuncRefs != null) {
            KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : arrayFuncRefs) {
                builder.addField(expression);
            }
            kvSchema = builder.build();
            kvSchemaBitSet = ValueBitSet.newInstance(kvSchema);
        }
        TupleProjector tupleProjector = null;
        Region dataRegion = null;
        IndexMaintainer indexMaintainer = null;
        byte[][] viewConstants = null;
        PhoenixTransactionContext tx = null;
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
        if (dataColumns != null) {
            tupleProjector = IndexUtil.getTupleProjector(scan, dataColumns);
            dataRegion = this.env.getRegion();
            boolean useProto = false;
            byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
            boolean bl = useProto = localIndexBytes != null;
            if (localIndexBytes == null) {
                localIndexBytes = scan.getAttribute("_LocalIndexBuild");
            }
            int clientVersion = ScanUtil.getClientVersion(scan);
            List<IndexMaintainer> indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize(localIndexBytes, useProto);
            indexMaintainer = indexMaintainers.get(0);
            viewConstants = IndexUtil.deserializeViewConstantsFromScan(scan);
            byte[] txState = scan.getAttribute("_TxState");
            tx = TransactionFactory.getTransactionContext(txState, clientVersion);
        }
        TupleProjector p = TupleProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        boolean bl = useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan)) && scan.getAttribute("_TopN") != null;
        if (dataRegion == null && this.env.getConfiguration().get("phoenix.mapreduce.snapshot.name") != null) {
            dataRegion = this.env.getRegion();
        }
        innerScanner = this.getWrappedScanner(this.env, innerScanner, arrayKVRefs, arrayFuncRefs, offset, scan, dataColumns, tupleProjector, dataRegion, indexMaintainer, tx, viewConstants, kvSchema, kvSchemaBitSet, j == null ? p : null, ptr, useQualifierAsIndex);
        ImmutableBytesPtr tenantId = ScanUtil.getTenantId(scan);
        if (j != null) {
            innerScanner = new HashJoinRegionScanner(innerScanner, p, j, tenantId, this.env, useQualifierAsIndex, useNewValueColumnQualifier);
        }
        if (scanOffset != null) {
            innerScanner = this.getOffsetScanner(innerScanner, new OffsetResultIterator(new RegionScannerResultIterator(innerScanner, EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan), encodingScheme), scanOffset), scan.getAttribute("LAST_SCAN") != null);
        }
        if ((iterator = NonAggregateRegionScannerFactory.deserializeFromScan(scan, innerScanner)) == null) {
            return innerScanner;
        }
        return this.getTopNScanner(this.env, innerScanner, iterator, tenantId);
    }

    private static OrderedResultIterator deserializeFromScan(Scan scan, RegionScanner s) {
        byte[] topN = scan.getAttribute("_TopN");
        if (topN == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(topN);
        try {
            DataInputStream input = new DataInputStream(stream);
            int thresholdBytes = WritableUtils.readVInt((DataInput)input);
            int limit = WritableUtils.readVInt((DataInput)input);
            int estimatedRowSize = WritableUtils.readVInt((DataInput)input);
            int size = WritableUtils.readVInt((DataInput)input);
            ArrayList orderByExpressions = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                OrderByExpression orderByExpression = new OrderByExpression();
                orderByExpression.readFields(input);
                orderByExpressions.add(orderByExpression);
            }
            PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
            RegionScannerResultIterator inner = new RegionScannerResultIterator(s, EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan), encodingScheme);
            OrderedResultIterator orderedResultIterator = new OrderedResultIterator(inner, orderByExpressions, thresholdBytes, limit >= 0 ? Integer.valueOf(limit) : null, null, estimatedRowSize);
            return orderedResultIterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Expression[] deserializeArrayPositionalExpressionInfoFromScan(Scan scan, RegionScanner s, Set<KeyValueColumnExpression> arrayKVRefs) {
        byte[] specificArrayIdx = scan.getAttribute("_SpecificArrayIndex");
        if (specificArrayIdx == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(specificArrayIdx);
        try {
            DataInputStream input = new DataInputStream(stream);
            int arrayKVRefSize = WritableUtils.readVInt((DataInput)input);
            for (int i = 0; i < arrayKVRefSize; ++i) {
                PTable.ImmutableStorageScheme scheme = EncodedColumnsUtil.getImmutableStorageScheme(scan);
                KeyValueColumnExpression kvExp = scheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN ? new SingleCellColumnExpression(scheme) : new KeyValueColumnExpression();
                kvExp.readFields(input);
                arrayKVRefs.add(kvExp);
            }
            int arrayKVFuncSize = WritableUtils.readVInt((DataInput)input);
            Expression[] arrayFuncRefs = new Expression[arrayKVFuncSize];
            for (int i = 0; i < arrayKVFuncSize; ++i) {
                ArrayIndexFunction arrayIdxFunc = new ArrayIndexFunction();
                arrayIdxFunc.readFields(input);
                arrayFuncRefs[i] = arrayIdxFunc;
            }
            Expression[] expressionArray = arrayFuncRefs;
            return expressionArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner getOffsetScanner(final RegionScanner s, final OffsetResultIterator iterator, boolean isLastScan) throws IOException {
        Tuple firstTuple;
        Region region = this.getRegion();
        region.startRegionOperation();
        try {
            Tuple tuple = iterator.next();
            if (tuple == null && !isLastScan) {
                ArrayList<KeyValue> kvList = new ArrayList<KeyValue>(1);
                KeyValue kv = new KeyValue(QueryConstants.OFFSET_ROW_KEY_BYTES, QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN, PInteger.INSTANCE.toBytes(iterator.getRemainingOffset()));
                kvList.add(kv);
                Result r = new Result(kvList);
                firstTuple = new ResultTuple(r);
            } else {
                firstTuple = tuple;
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.getRegion().getRegionInfo().getRegionNameAsString(), t);
            RegionScanner regionScanner = null;
            return regionScanner;
        }
        finally {
            region.closeRegionOperation();
        }
        return new BaseRegionScanner(s){
            private Tuple tuple;
            {
                super(x0);
                this.tuple = firstTuple;
            }

            @Override
            public boolean isFilterDone() {
                return this.tuple == null;
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                try {
                    if (this.isFilterDone()) {
                        return false;
                    }
                    for (int i = 0; i < this.tuple.size(); ++i) {
                        results.add(this.tuple.getValue(i));
                    }
                    this.tuple = iterator.next();
                    return !this.isFilterDone();
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(NonAggregateRegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    s.close();
                }
                finally {
                    try {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                    catch (SQLException e) {
                        ServerUtil.throwIOException(NonAggregateRegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner getTopNScanner(RegionCoprocessorEnvironment env, final RegionScanner s, final OrderedResultIterator iterator, ImmutableBytesPtr tenantId) throws Throwable {
        Tuple firstTuple;
        TenantCache tenantCache = GlobalCache.getTenantCache(env, tenantId);
        long estSize = iterator.getEstimatedByteSize();
        final MemoryManager.MemoryChunk chunk = tenantCache.getMemoryManager().allocate(estSize);
        final Region region = this.getRegion();
        region.startRegionOperation();
        try {
            firstTuple = iterator.next();
            long actualSize = iterator.getByteSize();
            chunk.resize(actualSize);
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(region.getRegionInfo().getRegionNameAsString(), t);
            RegionScanner regionScanner = null;
            return regionScanner;
        }
        finally {
            region.closeRegionOperation();
        }
        return new BaseRegionScanner(s){
            private Tuple tuple;
            {
                super(x0);
                this.tuple = firstTuple;
            }

            @Override
            public boolean isFilterDone() {
                return this.tuple == null;
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                try {
                    if (this.isFilterDone()) {
                        return false;
                    }
                    for (int i = 0; i < this.tuple.size(); ++i) {
                        results.add(this.tuple.getValue(i));
                    }
                    this.tuple = iterator.next();
                    return !this.isFilterDone();
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(region.getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    s.close();
                }
                finally {
                    try {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                    catch (SQLException e) {
                        ServerUtil.throwIOException(region.getRegionInfo().getRegionNameAsString(), e);
                    }
                    finally {
                        chunk.close();
                    }
                }
            }
        };
    }
}

