/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class MaterializedComparableResultIterator
implements PeekingResultIterator,
Comparable<MaterializedComparableResultIterator> {
    private PeekingResultIterator delegate;
    private Comparator<? super Tuple> comparator;
    private Tuple current;

    public Tuple getCurrent() {
        return this.current;
    }

    public MaterializedComparableResultIterator(PeekingResultIterator delegate, Comparator<? super Tuple> c) throws SQLException {
        this.delegate = delegate;
        this.comparator = c;
        this.current = delegate.peek();
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple next = this.delegate.next();
        this.current = this.delegate.peek();
        return next;
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.delegate.peek();
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public int compareTo(MaterializedComparableResultIterator o) {
        return this.comparator.compare(this.getCurrent(), o.getCurrent());
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
    }
}

