/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;

public abstract class MappedByteBufferQueue<T>
extends AbstractQueue<T> {
    private final int thresholdBytes;
    private List<MappedByteBufferSegmentQueue<T>> queues;
    private int currentIndex;
    private MappedByteBufferSegmentQueue<T> currentQueue;
    private MinMaxPriorityQueue<MappedByteBufferSegmentQueue<T>> mergedQueue;

    public MappedByteBufferQueue(int thresholdBytes) {
        this.thresholdBytes = thresholdBytes;
        this.queues = Lists.newArrayList();
        this.currentIndex = -1;
        this.currentQueue = null;
        this.mergedQueue = null;
    }

    protected abstract MappedByteBufferSegmentQueue<T> createSegmentQueue(int var1, int var2);

    protected abstract Comparator<MappedByteBufferSegmentQueue<T>> getSegmentQueueComparator();

    protected final List<MappedByteBufferSegmentQueue<T>> getSegmentQueues() {
        return this.queues.subList(0, this.currentIndex + 1);
    }

    @Override
    public boolean offer(T e) {
        boolean startNewQueue;
        boolean bl = startNewQueue = this.currentQueue == null || this.currentQueue.isFlushed();
        if (startNewQueue) {
            ++this.currentIndex;
            if (this.currentIndex < this.queues.size()) {
                this.currentQueue = this.queues.get(this.currentIndex);
            } else {
                this.currentQueue = this.createSegmentQueue(this.currentIndex, this.thresholdBytes);
                this.queues.add(this.currentQueue);
            }
        }
        return this.currentQueue.offer(e);
    }

    @Override
    public T poll() {
        this.initMergedQueue();
        if (this.mergedQueue != null && !this.mergedQueue.isEmpty()) {
            MappedByteBufferSegmentQueue queue = (MappedByteBufferSegmentQueue)this.mergedQueue.poll();
            Object re = queue.poll();
            if (queue.peek() != null) {
                this.mergedQueue.add((Object)queue);
            }
            return re;
        }
        return null;
    }

    @Override
    public T peek() {
        this.initMergedQueue();
        if (this.mergedQueue != null && !this.mergedQueue.isEmpty()) {
            return ((MappedByteBufferSegmentQueue)this.mergedQueue.peek()).peek();
        }
        return null;
    }

    @Override
    public void clear() {
        for (MappedByteBufferSegmentQueue<T> queue : this.getSegmentQueues()) {
            queue.clear();
        }
        this.currentIndex = -1;
        this.currentQueue = null;
        this.mergedQueue = null;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (MappedByteBufferSegmentQueue<T> queue : this.getSegmentQueues()) {
            size += queue.size();
        }
        return size;
    }

    public long getByteSize() {
        return this.currentQueue == null ? 0L : this.currentQueue.getInMemByteSize();
    }

    public void close() {
        for (MappedByteBufferSegmentQueue<T> queue : this.queues) {
            queue.close();
        }
        this.queues.clear();
    }

    private void initMergedQueue() {
        if (this.mergedQueue == null && this.currentIndex >= 0) {
            this.mergedQueue = MinMaxPriorityQueue.orderedBy(this.getSegmentQueueComparator()).maximumSize(this.currentIndex + 1).create();
            for (MappedByteBufferSegmentQueue<T> queue : this.getSegmentQueues()) {
                T re = queue.peek();
                if (re == null) continue;
                this.mergedQueue.add(queue);
            }
        }
    }

    public static abstract class MappedByteBufferSegmentQueue<T>
    extends AbstractQueue<T> {
        protected static final int EOF = -1;
        private static final long DEFAULT_MAPPING_SIZE = 131072L;
        private final int index;
        private final int thresholdBytes;
        private final boolean hasMaxQueueSize;
        private long totalResultSize = 0L;
        private int maxResultSize = 0;
        private long mappingSize = 0L;
        private File file;
        private boolean isClosed = false;
        private boolean flushBuffer = false;
        private int flushedCount = 0;
        private T current = null;
        private SegmentQueueFileIterator thisIterator;
        private List<SegmentQueueFileIterator> iterators;

        public MappedByteBufferSegmentQueue(int index, int thresholdBytes, boolean hasMaxQueueSize) {
            this.index = index;
            this.thresholdBytes = thresholdBytes;
            this.hasMaxQueueSize = hasMaxQueueSize;
            this.iterators = Lists.newArrayList();
        }

        protected abstract Queue<T> getInMemoryQueue();

        protected abstract int sizeOf(T var1);

        protected abstract void writeToBuffer(MappedByteBuffer var1, T var2);

        protected abstract T readFromBuffer(MappedByteBuffer var1);

        public int index() {
            return this.index;
        }

        @Override
        public int size() {
            if (this.flushBuffer) {
                return this.flushedCount;
            }
            return this.getInMemoryQueue().size();
        }

        public long getInMemByteSize() {
            if (this.flushBuffer) {
                return 0L;
            }
            return this.totalResultSize;
        }

        public boolean isFlushed() {
            return this.flushBuffer;
        }

        @Override
        public boolean offer(T e) {
            if (this.isClosed || this.flushBuffer) {
                return false;
            }
            boolean added = this.getInMemoryQueue().add(e);
            if (added) {
                try {
                    this.flush(e);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return added;
        }

        @Override
        public T peek() {
            if (this.current == null && !this.isClosed) {
                this.current = this.next();
            }
            return this.current;
        }

        @Override
        public T poll() {
            T ret = this.peek();
            this.current = !this.isClosed ? this.next() : null;
            return ret;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.isClosed) {
                return null;
            }
            if (!this.flushBuffer) {
                return this.getInMemoryQueue().iterator();
            }
            SegmentQueueFileIterator iterator = new SegmentQueueFileIterator(this.thisIterator);
            this.iterators.add(iterator);
            return iterator;
        }

        @Override
        public void clear() {
            this.getInMemoryQueue().clear();
            this.totalResultSize = 0L;
            this.maxResultSize = 0;
            this.mappingSize = 0L;
            this.flushBuffer = false;
            this.flushedCount = 0;
            this.current = null;
            if (this.thisIterator != null) {
                this.thisIterator.close();
                this.thisIterator = null;
            }
            for (SegmentQueueFileIterator iter : this.iterators) {
                iter.close();
            }
            this.iterators.clear();
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
        }

        public void close() {
            if (!this.isClosed) {
                this.clear();
                this.isClosed = true;
            }
        }

        private T next() {
            T ret = null;
            if (!this.flushBuffer) {
                ret = this.getInMemoryQueue().poll();
            } else {
                if (this.thisIterator == null) {
                    this.thisIterator = new SegmentQueueFileIterator();
                }
                ret = this.thisIterator.next();
            }
            if (ret == null) {
                this.close();
            }
            return ret;
        }

        private void flush(T entry) throws IOException {
            Queue<T> inMemQueue = this.getInMemoryQueue();
            int resultSize = this.sizeOf(entry);
            this.maxResultSize = Math.max(this.maxResultSize, resultSize);
            long l = this.totalResultSize = this.hasMaxQueueSize ? (long)(this.maxResultSize * inMemQueue.size()) : this.totalResultSize + (long)resultSize;
            if (this.totalResultSize >= (long)this.thresholdBytes) {
                this.file = File.createTempFile(UUID.randomUUID().toString(), null);
                RandomAccessFile af = new RandomAccessFile(this.file, "rw");
                FileChannel fc = af.getChannel();
                int writeIndex = 0;
                this.mappingSize = Math.min(Math.max((long)this.maxResultSize, 131072L), this.totalResultSize);
                MappedByteBuffer writeBuffer = fc.map(FileChannel.MapMode.READ_WRITE, writeIndex, this.mappingSize);
                int resSize = inMemQueue.size();
                for (int i = 0; i < resSize; ++i) {
                    T e = inMemQueue.poll();
                    this.writeToBuffer(writeBuffer, e);
                    if (this.mappingSize - (long)writeBuffer.position() >= (long)this.maxResultSize) continue;
                    writeBuffer = fc.map(FileChannel.MapMode.READ_WRITE, writeIndex += writeBuffer.position(), this.mappingSize);
                }
                writeBuffer.putInt(-1);
                fc.force(true);
                fc.close();
                af.close();
                this.flushedCount = resSize;
                inMemQueue.clear();
                this.flushBuffer = true;
            }
        }

        private class SegmentQueueFileIterator
        implements Iterator<T>,
        Closeable {
            private boolean isEnd;
            private long readIndex;
            private RandomAccessFile af;
            private FileChannel fc;
            private MappedByteBuffer readBuffer;
            private T next;

            public SegmentQueueFileIterator() {
                this.init(0L);
            }

            public SegmentQueueFileIterator(SegmentQueueFileIterator iterator) {
                if (iterator != null && iterator.isEnd) {
                    this.isEnd = true;
                } else {
                    this.init(iterator == null ? 0L : iterator.readIndex);
                }
            }

            private void init(long readIndex) {
                this.isEnd = false;
                this.readIndex = readIndex;
                this.next = null;
                try {
                    this.af = new RandomAccessFile(MappedByteBufferSegmentQueue.this.file, "r");
                    this.fc = this.af.getChannel();
                    this.readBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, readIndex, MappedByteBufferSegmentQueue.this.mappingSize);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                if (!this.isEnd && this.next == null) {
                    this.next = this.readNext();
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    return null;
                }
                Object ret = this.next;
                this.next = this.readNext();
                return ret;
            }

            private T readNext() {
                if (this.isEnd) {
                    return null;
                }
                Object e = MappedByteBufferSegmentQueue.this.readFromBuffer(this.readBuffer);
                if (e == null) {
                    this.close();
                    return null;
                }
                if (MappedByteBufferSegmentQueue.this.mappingSize - (long)this.readBuffer.position() < (long)MappedByteBufferSegmentQueue.this.maxResultSize) {
                    this.readIndex += (long)this.readBuffer.position();
                    try {
                        this.readBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.readIndex, MappedByteBufferSegmentQueue.this.mappingSize);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                this.isEnd = true;
                if (this.fc != null) {
                    try {
                        this.fc.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (this.af != null) {
                    try {
                        this.af.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.af = null;
                }
            }
        }
    }
}

