/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.CursorUtil;

public class CursorResultIterator
implements ResultIterator {
    private String cursorName;
    private PeekingResultIterator delegate;
    private int fetchSize = 0;
    private int rowsRead = 0;

    public CursorResultIterator(PeekingResultIterator delegate, String cursorName) {
        this.delegate = delegate;
        this.cursorName = cursorName;
    }

    @Override
    public Tuple next() throws SQLException {
        if (!CursorUtil.moreValues(this.cursorName)) {
            return null;
        }
        if (this.fetchSize == this.rowsRead) {
            return null;
        }
        Tuple next = this.delegate.next();
        CursorUtil.updateCursor(this.cursorName, next, this.delegate.peek());
        ++this.rowsRead;
        return next;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT CURSOR " + this.cursorName);
    }

    public String toString() {
        return "CursorResultIterator [cursor=" + this.cursorName + "]";
    }

    @Override
    public void close() throws SQLException {
    }

    public void closeCursor() throws SQLException {
        this.delegate.close();
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        this.rowsRead = 0;
    }
}

