/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.transaction.PhoenixTransactionContext;

public class PhoenixIndexMetaData
implements IndexMetaData {
    private final Map<String, byte[]> attributes;
    private final IndexMetaDataCache indexMetaDataCache;
    private final BaseScannerRegionObserver.ReplayWrite replayWrite;
    private final boolean isImmutable;
    private final boolean hasNonPkColumns;
    private final boolean hasLocalIndexes;

    public static boolean isIndexRebuild(Map<String, byte[]> attributes) {
        return attributes.get("_IGNORE_NEWER_MUTATIONS") != null;
    }

    public static BaseScannerRegionObserver.ReplayWrite getReplayWrite(Map<String, byte[]> attributes) {
        return BaseScannerRegionObserver.ReplayWrite.fromBytes(attributes.get("_IGNORE_NEWER_MUTATIONS"));
    }

    public PhoenixIndexMetaData(IndexMetaDataCache indexMetaDataCache, Map<String, byte[]> attributes) throws IOException {
        this.indexMetaDataCache = indexMetaDataCache;
        boolean isImmutable = true;
        boolean hasNonPkColumns = false;
        boolean hasLocalIndexes = false;
        for (IndexMaintainer maintainer : indexMetaDataCache.getIndexMaintainers()) {
            isImmutable &= maintainer.isImmutableRows();
            hasNonPkColumns |= !maintainer.getIndexedColumns().isEmpty();
            hasLocalIndexes |= maintainer.isLocalIndex();
        }
        this.isImmutable = isImmutable;
        this.hasNonPkColumns = hasNonPkColumns;
        this.attributes = attributes;
        this.replayWrite = PhoenixIndexMetaData.getReplayWrite(attributes);
        this.hasLocalIndexes = hasLocalIndexes;
    }

    public PhoenixTransactionContext getTransactionContext() {
        return this.indexMetaDataCache.getTransactionContext();
    }

    public List<IndexMaintainer> getIndexMaintainers() {
        return this.indexMetaDataCache.getIndexMaintainers();
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getClientVersion() {
        return this.indexMetaDataCache.getClientVersion();
    }

    @Override
    public BaseScannerRegionObserver.ReplayWrite getReplayWrite() {
        return this.replayWrite;
    }

    public boolean isImmutableRows() {
        return this.isImmutable;
    }

    public boolean hasLocalIndexes() {
        return this.hasLocalIndexes;
    }

    @Override
    public boolean requiresPriorRowState(Mutation m) {
        return !this.isImmutable || this.indexMetaDataCache.getIndexMaintainers().get(0).isRowDeleted(m) && this.hasNonPkColumns;
    }
}

