/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.util.ServerUtil;

public class IndexWriterUtils {
    private static final Log LOG = LogFactory.getLog(IndexWriterUtils.class);
    public static final String INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY = "index.writer.threads.pertable.max";
    public static final int DEFAULT_NUM_PER_TABLE_THREADS = Integer.MAX_VALUE;
    public static final String HTABLE_THREAD_KEY = "hbase.htable.threads.max";
    public static final String INDEX_WRITES_THREAD_MAX_PER_REGIONSERVER_KEY = "phoenix.index.writes.threads.max";
    public static final String HTABLE_KEEP_ALIVE_KEY = "hbase.htable.threads.keepalivetime";
    @Deprecated
    public static final String INDEX_WRITER_RPC_RETRIES_NUMBER = "phoenix.index.writes.rpc.retries.number";
    @Deprecated
    public static final int DEFAULT_INDEX_WRITER_RPC_RETRIES_NUMBER = 11;
    @Deprecated
    public static final String INDEX_WRITER_RPC_PAUSE = "phoenix.index.writes.rpc.pause";
    @Deprecated
    public static final int DEFAULT_INDEX_WRITER_RPC_PAUSE = 100;

    private IndexWriterUtils() {
    }

    public static HTableFactory getDefaultDelegateHTableFactory(CoprocessorEnvironment env) {
        return ServerUtil.getDelegateHTableFactory(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS);
    }

    public static HTableFactory getNoRetriesHTableFactory(CoprocessorEnvironment env) {
        return ServerUtil.getDelegateHTableFactory(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES);
    }
}

