/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;

public class IndexWriter
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(IndexWriter.class);
    public static final String INDEX_COMMITTER_CONF_KEY = "index.writer.commiter.class";
    public static final String INDEX_FAILURE_POLICY_CONF_KEY = "index.writer.failurepolicy.class";
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private IndexCommitter writer;
    private IndexFailurePolicy failurePolicy;

    public IndexWriter(RegionCoprocessorEnvironment env, String name) throws IOException {
        this(IndexWriter.getCommitter(env), IndexWriter.getFailurePolicy(env), env, name);
    }

    public IndexWriter(IndexFailurePolicy failurePolicy, RegionCoprocessorEnvironment env, String name) throws IOException {
        this(IndexWriter.getCommitter(env), failurePolicy, env, name);
    }

    public static IndexCommitter getCommitter(RegionCoprocessorEnvironment env) throws IOException {
        return IndexWriter.getCommitter(env, TrackingParallelWriterIndexCommitter.class);
    }

    public static IndexCommitter getCommitter(RegionCoprocessorEnvironment env, Class<? extends IndexCommitter> defaultClass) throws IOException {
        Configuration conf = env.getConfiguration();
        try {
            IndexCommitter committer = (IndexCommitter)conf.getClass(INDEX_COMMITTER_CONF_KEY, defaultClass, IndexCommitter.class).newInstance();
            return committer;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public static IndexFailurePolicy getFailurePolicy(RegionCoprocessorEnvironment env) throws IOException {
        Configuration conf = env.getConfiguration();
        try {
            IndexFailurePolicy committer = (IndexFailurePolicy)conf.getClass(INDEX_FAILURE_POLICY_CONF_KEY, PhoenixIndexFailurePolicy.class, IndexFailurePolicy.class).newInstance();
            return committer;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public IndexWriter(IndexCommitter committer, IndexFailurePolicy policy, RegionCoprocessorEnvironment env, String name) {
        this(committer, policy);
        this.writer.setup(this, env, name);
        this.failurePolicy.setup(this, env);
    }

    IndexWriter(IndexCommitter committer, IndexFailurePolicy policy) {
        this.writer = committer;
        this.failurePolicy = policy;
    }

    public void writeAndKillYourselfOnFailure(Collection<Pair<Mutation, byte[]>> indexUpdates, boolean allowLocalUpdates, int clientVersion) throws IOException {
        Multimap<HTableInterfaceReference, Mutation> toWrite = this.resolveTableReferences(indexUpdates);
        this.writeAndKillYourselfOnFailure(toWrite, allowLocalUpdates, clientVersion);
    }

    public void writeAndKillYourselfOnFailure(Multimap<HTableInterfaceReference, Mutation> toWrite, boolean allowLocalUpdates, int clientVersion) throws IOException {
        try {
            this.write(toWrite, allowLocalUpdates, clientVersion);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Done writing all index updates!\n\t" + toWrite));
            }
        }
        catch (Exception e) {
            this.failurePolicy.handleFailure(toWrite, e);
        }
    }

    public void write(Collection<Pair<Mutation, byte[]>> toWrite, int clientVersion) throws IndexWriteException {
        this.write(this.resolveTableReferences(toWrite), false, clientVersion);
    }

    public void write(Collection<Pair<Mutation, byte[]>> toWrite, boolean allowLocalUpdates, int clientVersion) throws IOException {
        this.write(this.resolveTableReferences(toWrite), allowLocalUpdates, clientVersion);
    }

    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, boolean allowLocalUpdates, int clientVersion) throws IndexWriteException {
        this.writer.write(toWrite, allowLocalUpdates, clientVersion);
    }

    protected Multimap<HTableInterfaceReference, Mutation> resolveTableReferences(Collection<Pair<Mutation, byte[]>> indexUpdates) {
        ArrayListMultimap updates = ArrayListMultimap.create();
        HashMap<ImmutableBytesPtr, HTableInterfaceReference> tables = new HashMap<ImmutableBytesPtr, HTableInterfaceReference>(updates.size());
        for (Pair<Mutation, byte[]> entry : indexUpdates) {
            byte[] tableName = (byte[])entry.getSecond();
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(tableName);
            HTableInterfaceReference table = (HTableInterfaceReference)tables.get((Object)ptr);
            if (table == null) {
                table = new HTableInterfaceReference(ptr);
                tables.put(ptr, table);
            }
            updates.put((Object)table, entry.getFirst());
        }
        return updates;
    }

    public void stop(String why) {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        LOG.debug((Object)("Stopping because " + why));
        this.writer.stop(why);
        this.failurePolicy.stop(why);
    }

    public boolean isStopped() {
        return this.stopped.get();
    }
}

