/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSource;

public class MetricsIndexerSourceImpl
extends BaseSourceImpl
implements MetricsIndexerSource {
    private final MetricHistogram indexPrepareTimeHisto = this.getMetricsRegistry().newHistogram("indexPrepareTime", "Histogram for the time in milliseconds for preparing an index write");
    private final MutableFastCounter slowIndexPrepareCalls = this.getMetricsRegistry().newCounter("slowIndexPrepareCalls", "The number of index preparations slower than the configured threshold", 0L);
    private final MetricHistogram indexWriteTimeHisto = this.getMetricsRegistry().newHistogram("indexWriteTime", "Histogram for the time in milliseconds for writing an index update");
    private final MutableFastCounter slowIndexWriteCalls = this.getMetricsRegistry().newCounter("slowIndexWriteCalls", "The number of index writes slower than the configured threshold", 0L);
    private final MetricHistogram preWALRestoreTimeHisto = this.getMetricsRegistry().newHistogram("preWALRestoreTime", "Histogram for the time in milliseconds for Indexer's preWALRestore");
    private final MutableFastCounter slowPreWALRestoreCalls = this.getMetricsRegistry().newCounter("slowPreWALRestoreCalls", "The number of preWALRestore calls slower than the configured threshold", 0L);
    private final MetricHistogram postPutTimeHisto = this.getMetricsRegistry().newHistogram("postPutTime", "Histogram for the time in milliseconds for Indexer's postPut");
    private final MutableFastCounter slowPostPutCalls = this.getMetricsRegistry().newCounter("slowPostPutCalls", "The number of postPut calls slower than the configured threshold", 0L);
    private final MetricHistogram postDeleteTimeHisto = this.getMetricsRegistry().newHistogram("postDeleteTime", "Histogram for the time in milliseconds for Indexer's postDelete");
    private final MutableFastCounter slowPostDeleteCalls = this.getMetricsRegistry().newCounter("slowPostDeleteCalls", "The number of postDelete calls slower than the configured threshold", 0L);
    private final MetricHistogram postOpenTimeHisto = this.getMetricsRegistry().newHistogram("postOpenTime", "Histogram for the time in milliseconds for Indexer's postOpen");
    private final MutableFastCounter slowPostOpenCalls = this.getMetricsRegistry().newCounter("slowPostOpenCalls", "The number of postOpen calls slower than the configured threshold", 0L);
    private final MetricHistogram duplicateKeyTimeHisto = this.getMetricsRegistry().newHistogram("duplicateKeyCheckTime", "Histogram for the time in milliseconds to handle ON DUPLICATE keywords");
    private final MutableFastCounter slowDuplicateKeyCalls = this.getMetricsRegistry().newCounter("slowDuplicateKeyCheckCalls", "The number of on duplicate key checks slower than the configured threshold", 0L);

    public MetricsIndexerSourceImpl() {
        this("PhoenixIndexer", "Metrics about the Phoenix Indexer", "phoenix", "RegionServer,sub=PhoenixIndexer");
    }

    public MetricsIndexerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void updateIndexPrepareTime(long t) {
        this.indexPrepareTimeHisto.add(t);
    }

    @Override
    public void updateIndexWriteTime(long t) {
        this.indexWriteTimeHisto.add(t);
    }

    @Override
    public void updatePreWALRestoreTime(long t) {
        this.preWALRestoreTimeHisto.add(t);
    }

    @Override
    public void updatePostPutTime(long t) {
        this.postPutTimeHisto.add(t);
    }

    @Override
    public void updatePostDeleteTime(long t) {
        this.postDeleteTimeHisto.add(t);
    }

    @Override
    public void updatePostOpenTime(long t) {
        this.postOpenTimeHisto.add(t);
    }

    @Override
    public void incrementNumSlowIndexPrepareCalls() {
        this.slowIndexPrepareCalls.incr();
    }

    @Override
    public void incrementNumSlowIndexWriteCalls() {
        this.slowIndexWriteCalls.incr();
    }

    @Override
    public void incrementNumSlowPreWALRestoreCalls() {
        this.slowPreWALRestoreCalls.incr();
    }

    @Override
    public void incrementNumSlowPostPutCalls() {
        this.slowPostPutCalls.incr();
    }

    @Override
    public void incrementNumSlowPostDeleteCalls() {
        this.slowPostDeleteCalls.incr();
    }

    @Override
    public void incrementNumSlowPostOpenCalls() {
        this.slowPostOpenCalls.incr();
    }

    @Override
    public void updateDuplicateKeyCheckTime(long t) {
        this.duplicateKeyTimeHisto.add(t);
    }

    @Override
    public void incrementSlowDuplicateKeyCheckCalls() {
        this.slowDuplicateKeyCalls.incr();
    }
}

