/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class IndexUpdateManager {
    public Comparator<Mutation> COMPARATOR = new MutationComparator();
    private static final String PHOENIX_HBASE_TEMP_DELETE_MARKER = "phoenix.hbase.temp.delete.marker";
    private static final byte[] TRUE_MARKER = new byte[]{1};
    protected final Map<ImmutableBytesPtr, Collection<Mutation>> map = new HashMap<ImmutableBytesPtr, Collection<Mutation>>();
    private IndexMetaData indexMetaData;

    public IndexUpdateManager(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public void addIndexUpdate(byte[] tableName, Mutation m) {
        ImmutableBytesPtr key = new ImmutableBytesPtr(tableName);
        Collection<Mutation> updates = this.map.get((Object)key);
        if (updates == null) {
            updates = new TreeSet<Mutation>(this.COMPARATOR);
            this.map.put(key, updates);
        }
        if (this.indexMetaData.getReplayWrite() != null) {
            updates.add(m);
        } else {
            this.fixUpCurrentUpdates(updates, m);
        }
    }

    protected void fixUpCurrentUpdates(Collection<Mutation> updates, Mutation pendingMutation) {
        Mutation toRemove = null;
        Delete pendingDelete = pendingMutation instanceof Delete ? (Delete)pendingMutation : null;
        boolean sawRowMatch = false;
        for (Mutation stored : updates) {
            int compare = pendingMutation.compareTo((Row)stored);
            if (compare < 0) continue;
            if (compare > 0) {
                if (!sawRowMatch) continue;
                break;
            }
            sawRowMatch = true;
            if (stored.getTimeStamp() < pendingMutation.getTimeStamp()) continue;
            if (stored instanceof Delete) {
                if (pendingDelete != null) {
                    return;
                }
                this.markMutationForRemoval(stored);
                return;
            }
            toRemove = stored;
            if (pendingDelete == null) continue;
            this.markMutationForRemoval(pendingMutation);
            break;
        }
        if (toRemove != null) {
            updates.remove(toRemove);
        }
        if (pendingMutation != null) {
            updates.add(pendingMutation);
        }
    }

    private void markMutationForRemoval(Mutation m) {
        m.setAttribute(PHOENIX_HBASE_TEMP_DELETE_MARKER, TRUE_MARKER);
    }

    public List<Pair<Mutation, byte[]>> toMap() {
        ArrayList updateMap = Lists.newArrayList();
        for (Map.Entry<ImmutableBytesPtr, Collection<Mutation>> updates : this.map.entrySet()) {
            byte[] tableName = updates.getKey().get();
            for (Mutation m : updates.getValue()) {
                if (this.shouldBeRemoved(m)) continue;
                updateMap.add(new Pair((Object)m, (Object)tableName));
            }
        }
        return updateMap;
    }

    public void addAll(Collection<Pair<Mutation, String>> updates) {
        for (Pair<Mutation, String> update : updates) {
            this.addIndexUpdate(Bytes.toBytes((String)((String)update.getSecond())), (Mutation)update.getFirst());
        }
    }

    private boolean shouldBeRemoved(Mutation m) {
        return m.getAttribute(PHOENIX_HBASE_TEMP_DELETE_MARKER) != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pending Index Updates:\n");
        for (Map.Entry<ImmutableBytesPtr, Collection<Mutation>> entry : this.map.entrySet()) {
            String tableName = Bytes.toStringBinary((byte[])entry.getKey().get());
            sb.append("   Table: '" + tableName + "'\n");
            for (Mutation m : entry.getValue()) {
                sb.append("\t");
                if (this.shouldBeRemoved(m)) {
                    sb.append("[REMOVED]");
                }
                sb.append(m.getClass().getSimpleName() + ":" + (m instanceof Put ? m.getTimeStamp() + " " : ""));
                sb.append(" row=" + Bytes.toStringBinary((byte[])m.getRow()));
                sb.append("\n");
                if (m.getFamilyCellMap().isEmpty()) {
                    sb.append("\t\t=== EMPTY ===\n");
                }
                for (List kvs : m.getFamilyCellMap().values()) {
                    for (Cell kv : kvs) {
                        sb.append("\t\t" + kv.toString() + "/value=" + Bytes.toStringBinary((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
                        sb.append("\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    class MutationComparator
    implements Comparator<Mutation> {
        MutationComparator() {
        }

        @Override
        public int compare(Mutation o1, Mutation o2) {
            int compare = o1.compareTo((Row)o2);
            if (compare != 0) {
                return compare;
            }
            compare = Longs.compare((long)o2.getTimeStamp(), (long)o1.getTimeStamp());
            if (compare != 0) {
                return compare;
            }
            if (o1 instanceof Delete) {
                if (o2 instanceof Delete) {
                    return 0;
                }
                return -1;
            }
            if (o2 instanceof Delete) {
                return 1;
            }
            if (o2 instanceof Put) {
                return this.comparePuts((Put)o1, (Put)o2);
            }
            throw new RuntimeException("Got unexpected mutation types! Can only be Put or Delete, but got: " + o1 + ", and " + o2);
        }

        private int comparePuts(Put p1, Put p2) {
            int p2Size;
            int p1Size = p1.size();
            int compare = p1Size - (p2Size = p2.size());
            if (compare == 0) {
                return Longs.compare((long)p1.heapSize(), (long)p2.heapSize());
            }
            return compare;
        }
    }
}

