/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.builder;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.hbase.index.builder.IndexBuilder;
import org.apache.phoenix.hbase.index.covered.IndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;

public abstract class BaseIndexBuilder
implements IndexBuilder {
    public static final String CODEC_CLASS_NAME_KEY = "org.apache.hadoop.hbase.index.codec.class";
    private static final Log LOG = LogFactory.getLog(BaseIndexBuilder.class);
    protected boolean stopped;
    protected RegionCoprocessorEnvironment env;
    protected IndexCodec codec;

    @Override
    public void extendBaseIndexBuilderInstead() {
    }

    @Override
    public void setup(RegionCoprocessorEnvironment env) throws IOException {
        this.env = env;
        Configuration conf = env.getConfiguration();
        Class codecClass = conf.getClass(CODEC_CLASS_NAME_KEY, null, IndexCodec.class);
        try {
            Constructor meth = codecClass.getDeclaredConstructor(new Class[0]);
            meth.setAccessible(true);
            this.codec = (IndexCodec)meth.newInstance(new Object[0]);
            this.codec.initialize(conf, env.getRegionInfo().getStartKey(), env.getRegionInfo().getEndKey(), env.getRegion().getRegionInfo().getTable().getName());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexMetaData context) throws IOException {
    }

    @Override
    public IndexMetaData getIndexMetaData(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        return IndexMetaData.NULL_INDEX_META_DATA;
    }

    @Override
    public void batchCompleted(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
    }

    @Override
    public boolean isEnabled(Mutation m) throws IOException {
        return this.codec.isEnabled(m);
    }

    @Override
    public boolean isAtomicOp(Mutation m) throws IOException {
        return false;
    }

    @Override
    public List<Mutation> executeAtomicOp(Increment inc) throws IOException {
        return null;
    }

    public void setIndexCodecForTesting(IndexCodec codec) {
        this.codec = codec;
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<KeyValue> filtered, IndexMetaData context) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void stop(String why) {
        LOG.debug((Object)("Stopping because: " + why));
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public BaseScannerRegionObserver.ReplayWrite getReplayWrite(Mutation m) {
        return null;
    }
}

