/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class LockManager {
    private static final Log LOG = LogFactory.getLog(LockManager.class);
    private final ConcurrentHashMap<ImmutableBytesPtr, RowLockContext> lockedRows = new ConcurrentHashMap();

    public RowLock lockRow(byte[] row, int waitDuration) throws IOException {
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(row);
        Object rowLockContext = null;
        RowLockImpl result = null;
        TraceScope traceScope = null;
        if (Trace.isTracing()) {
            traceScope = Trace.startSpan((String)"LockManager.getRowLock");
            traceScope.getSpan().addTimelineAnnotation("Getting a lock");
        }
        boolean success = false;
        try {
            Object existingContext;
            while (result == null) {
                rowLockContext = new RowLockContext(rowKey);
                existingContext = this.lockedRows.putIfAbsent(rowKey, (RowLockContext)rowLockContext);
                if (existingContext != null) {
                    rowLockContext = existingContext;
                }
                result = ((RowLockContext)rowLockContext).newRowLock();
            }
            if (!result.getLock().tryLock(waitDuration, TimeUnit.MILLISECONDS)) {
                if (traceScope != null) {
                    traceScope.getSpan().addTimelineAnnotation("Failed to get row lock");
                }
                throw new TimeoutIOException("Timed out waiting for lock for row: " + (Object)((Object)rowKey));
            }
            ((RowLockContext)rowLockContext).setThreadName(Thread.currentThread().getName());
            success = true;
            existingContext = result;
            return existingContext;
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Thread interrupted waiting for lock on row: " + (Object)((Object)rowKey)));
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            if (traceScope != null) {
                traceScope.getSpan().addTimelineAnnotation("Interrupted exception getting row lock");
            }
            Thread.currentThread().interrupt();
            throw iie;
        }
        finally {
            if (!success && rowLockContext != null) {
                ((RowLockContext)rowLockContext).cleanUp();
            }
            if (traceScope != null) {
                traceScope.close();
            }
        }
    }

    public void unlockRow(byte[] row) throws IOException {
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(row);
        RowLockContext lockContext = this.lockedRows.get((Object)rowKey);
        if (lockContext != null) {
            lockContext.releaseRowLock();
        }
    }

    public static interface RowLock {
        public void release();
    }

    public static class RowLockImpl
    implements RowLock {
        static final RowLockImpl UNINITIALIZED = new RowLockImpl();
        private final RowLockContext context;
        private final Lock lock;

        private RowLockImpl() {
            this.context = null;
            this.lock = null;
        }

        RowLockImpl(RowLockContext context, Lock lock) {
            this.context = context;
            this.lock = lock;
        }

        Lock getLock() {
            return this.lock;
        }

        @Override
        public void release() {
            this.lock.unlock();
            this.context.cleanUp();
        }

        public String toString() {
            return "RowLockImpl{context=" + this.context + ", lock=" + this.lock + '}';
        }
    }

    class RowLockContext {
        private final ImmutableBytesPtr rowKey;
        private final AtomicInteger count = new AtomicInteger(0);
        private final ReentrantLock reentrantLock = new ReentrantLock(true);
        private volatile RowLockImpl rowLock = RowLockImpl.UNINITIALIZED;
        private String threadName;

        RowLockContext(ImmutableBytesPtr rowKey) {
            this.rowKey = rowKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RowLockImpl newRowLock() {
            this.count.incrementAndGet();
            RowLockContext rowLockContext = this;
            synchronized (rowLockContext) {
                if (this.rowLock != null) {
                    this.rowLock = new RowLockImpl(this, this.reentrantLock);
                    return this.rowLock;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseRowLock() {
            RowLockContext rowLockContext = this;
            synchronized (rowLockContext) {
                if (this.rowLock != null) {
                    this.rowLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUp() {
            long c = this.count.decrementAndGet();
            if (c <= 0L) {
                RowLockContext rowLockContext = this;
                synchronized (rowLockContext) {
                    if (this.count.get() <= 0 && this.rowLock != null) {
                        this.rowLock = null;
                        RowLockContext removed = (RowLockContext)LockManager.this.lockedRows.remove((Object)this.rowKey);
                        assert (removed == this) : "we should never remove a different context";
                    }
                }
            }
        }

        void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public String toString() {
            return "RowLockContext{row=" + (Object)((Object)this.rowKey) + ", readWriteLock=" + this.reentrantLock + ", count=" + this.count + ", threadName=" + this.threadName + '}';
        }
    }
}

