/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.LockManager;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.builder.IndexBuildManager;
import org.apache.phoenix.hbase.index.builder.IndexBuilder;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.RecoveryIndexWriter;
import org.apache.phoenix.hbase.index.write.recovery.PerRegionIndexWriteCache;
import org.apache.phoenix.hbase.index.write.recovery.StoreFailuresInCachePolicy;
import org.apache.phoenix.trace.TracingUtils;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class Indexer
extends BaseRegionObserver {
    private static final Log LOG = LogFactory.getLog(Indexer.class);
    private static final OperationStatus IGNORE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    private static final OperationStatus NOWRITE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    protected IndexWriter writer;
    protected IndexBuildManager builder;
    private LockManager lockManager;
    private ThreadLocal<BatchMutateContext> batchMutateContext = new ThreadLocal();
    public static final String INDEX_BUILDER_CONF_KEY = "index.builder";
    public static final String CHECK_VERSION_CONF_KEY = "com.saleforce.hbase.index.checkversion";
    private static final String INDEX_RECOVERY_FAILURE_POLICY_KEY = "org.apache.hadoop.hbase.index.recovery.failurepolicy";
    private static final String INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.post.batch.mutate.threshold";
    private static final long INDEXER_INDEX_WRITE_SLOW_THRESHOLD_DEFAULT = 3000L;
    private static final String INDEXER_INDEX_PREPARE_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.pre.batch.mutate.threshold";
    private static final long INDEXER_INDEX_PREPARE_SLOW_THREHSOLD_DEFAULT = 3000L;
    private static final String INDEXER_PRE_WAL_RESTORE_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.pre.wal.restore.threshold";
    private static final long INDEXER_PRE_WAL_RESTORE_SLOW_THRESHOLD_DEFAULT = 3000L;
    private static final String INDEXER_POST_OPEN_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.open.threshold";
    private static final long INDEXER_POST_OPEN_SLOW_THRESHOLD_DEFAULT = 3000L;
    private static final String INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.pre.increment";
    private static final long INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_DEFAULT = 3000L;
    private PerRegionIndexWriteCache failedIndexEdits = new PerRegionIndexWriteCache();
    private IndexWriter recoveryWriter;
    private MetricsIndexerSource metricSource;
    private boolean stopped;
    private boolean disabled;
    private long slowIndexWriteThreshold;
    private long slowIndexPrepareThreshold;
    private long slowPreWALRestoreThreshold;
    private long slowPostOpenThreshold;
    private long slowPreIncrementThreshold;
    private int rowLockWaitDuration;
    public static final String RecoveryFailurePolicyKeyForTesting = "org.apache.hadoop.hbase.index.recovery.failurepolicy";
    public static final int INDEXING_SUPPORTED_MAJOR_VERSION = VersionUtil.encodeMaxPatchVersion(0, 94);
    public static final int INDEXING_SUPPORTED__MIN_MAJOR_VERSION = VersionUtil.encodeVersion("0.94.0");
    private static final int INDEX_WAL_COMPRESSION_MINIMUM_SUPPORTED_VERSION = VersionUtil.encodeVersion("0.94.9");
    private static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;

    public void start(CoprocessorEnvironment e) throws IOException {
        try {
            String errormsg;
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            String serverName = env.getRegionServerServices().getServerName().getServerName();
            if (env.getConfiguration().getBoolean(CHECK_VERSION_CONF_KEY, true) && (errormsg = Indexer.validateVersion(env.getHBaseVersion(), env.getConfiguration())) != null) {
                IOException ioe = new IOException(errormsg);
                env.getRegionServerServices().abort(errormsg, (Throwable)ioe);
                throw ioe;
            }
            this.builder = new IndexBuildManager(env);
            DelegateRegionCoprocessorEnvironment indexWriterEnv = new DelegateRegionCoprocessorEnvironment(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION);
            this.writer = new IndexWriter(indexWriterEnv, serverName + "-index-writer");
            this.rowLockWaitDuration = env.getConfiguration().getInt("hbase.rowlock.wait.duration", 30000);
            this.lockManager = new LockManager();
            this.metricSource = MetricsIndexerSourceFactory.getInstance().create();
            this.setSlowThresholds(e.getConfiguration());
            try {
                Class policyClass = env.getConfiguration().getClass("org.apache.hadoop.hbase.index.recovery.failurepolicy", StoreFailuresInCachePolicy.class, IndexFailurePolicy.class);
                IndexFailurePolicy policy = (IndexFailurePolicy)policyClass.getConstructor(PerRegionIndexWriteCache.class).newInstance(this.failedIndexEdits);
                LOG.debug((Object)("Setting up recovery writter with failure policy: " + policy.getClass()));
                this.recoveryWriter = new RecoveryIndexWriter(policy, indexWriterEnv, serverName + "-recovery-writer");
            }
            catch (Exception ex) {
                throw new IOException("Could not instantiate recovery failure policy!", ex);
            }
        }
        catch (NoSuchMethodError ex) {
            this.disabled = true;
            super.start(e);
            LOG.error((Object)"Must be too early a version of HBase. Disabled coprocessor ", (Throwable)ex);
        }
    }

    private void setSlowThresholds(Configuration c) {
        this.slowIndexPrepareThreshold = c.getLong(INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY, 3000L);
        this.slowIndexWriteThreshold = c.getLong(INDEXER_INDEX_PREPARE_SLOW_THRESHOLD_KEY, 3000L);
        this.slowPreWALRestoreThreshold = c.getLong(INDEXER_PRE_WAL_RESTORE_SLOW_THRESHOLD_KEY, 3000L);
        this.slowPostOpenThreshold = c.getLong(INDEXER_POST_OPEN_SLOW_THRESHOLD_KEY, 3000L);
        this.slowPreIncrementThreshold = c.getLong(INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY, 3000L);
    }

    private String getCallTooSlowMessage(String callName, long duration, long threshold) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("(callTooSlow) ").append(callName).append(" duration=").append(duration);
        sb.append("ms, threshold=").append(threshold).append("ms");
        return sb.toString();
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        if (this.stopped) {
            return;
        }
        if (this.disabled) {
            super.stop(e);
            return;
        }
        this.stopped = true;
        String msg = "Indexer is being stopped";
        this.builder.stop(msg);
        this.writer.stop(msg);
        this.recoveryWriter.stop(msg);
    }

    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Increment inc) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            List<Mutation> mutations = this.builder.executeAtomicOp(inc);
            if (mutations == null) {
                Result result = null;
                return result;
            }
            e.bypass();
            e.complete();
            if (!mutations.isEmpty()) {
                Region region = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
                region.batchMutate(mutations.toArray(new Mutation[0]), 0L, 0L);
            }
            Result result = Result.EMPTY_RESULT;
            return result;
        }
        catch (Throwable t) {
            throw ServerUtil.createIOException("Unable to process ON DUPLICATE IGNORE for " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString() + "(" + Bytes.toStringBinary((byte[])inc.getRow()) + ")", t);
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexPrepareThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("preIncrementAfterRowLock", duration, this.slowPreIncrementThreshold));
                }
                this.metricSource.incrementSlowDuplicateKeyCheckCalls();
            }
            this.metricSource.updateDuplicateKeyCheckTime(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.disabled) {
            super.preBatchMutate(c, miniBatchOp);
            return;
        }
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.preBatchMutateWithExceptions(c, miniBatchOp);
            return;
        }
        catch (Throwable t) {
            IndexManagementUtil.rethrowIndexingException(t);
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexPrepareThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("preBatchMutate", duration, this.slowIndexPrepareThreshold));
                }
                this.metricSource.incrementNumSlowIndexPrepareCalls();
            }
            this.metricSource.updateIndexPrepareTime(duration);
        }
        throw new RuntimeException("Somehow didn't return an index update but also didn't propagate the failure to the client!");
    }

    private static void setTimeStamp(KeyValue kv, byte[] tsBytes) {
        int tsOffset = kv.getTimestampOffset();
        System.arraycopy(tsBytes, 0, kv.getBuffer(), tsOffset, 8);
    }

    public void preBatchMutateWithExceptions(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws Throwable {
        Collection<Object> mutations;
        ArrayList originalMutations;
        HashMap<ImmutableBytesPtr, MultiMutation> mutationsMap = new HashMap<ImmutableBytesPtr, MultiMutation>();
        Durability defaultDurability = Durability.SYNC_WAL;
        if (((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion() != null) {
            defaultDurability = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDesc().getDurability();
            defaultDurability = defaultDurability == Durability.USE_DEFAULT ? Durability.SYNC_WAL : defaultDurability;
        }
        BatchMutateContext context = new BatchMutateContext(this.builder.getIndexMetaData(miniBatchOp).getClientVersion());
        this.setBatchMutateContext(c, context);
        Durability durability = Durability.SKIP_WAL;
        boolean copyMutations = false;
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            ImmutableBytesPtr row;
            Durability effectiveDurablity;
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (this.builder.isAtomicOp(m)) {
                miniBatchOp.setOperationStatus(i, IGNORE);
                continue;
            }
            if (!this.builder.isEnabled(m)) continue;
            context.rowLocks.add(this.lockManager.lockRow(m.getRow(), this.rowLockWaitDuration));
            Durability durability2 = effectiveDurablity = m.getDurability() == Durability.USE_DEFAULT ? defaultDurability : m.getDurability();
            if (effectiveDurablity.ordinal() > durability.ordinal()) {
                durability = effectiveDurablity;
            }
            if (mutationsMap.containsKey((Object)(row = new ImmutableBytesPtr(m.getRow())))) {
                copyMutations = true;
                continue;
            }
            mutationsMap.put(row, null);
        }
        if (mutationsMap.isEmpty()) {
            return;
        }
        if (copyMutations) {
            originalMutations = null;
            mutations = mutationsMap.values();
        } else {
            mutations = originalMutations = Lists.newArrayListWithExpectedSize((int)mutationsMap.size());
        }
        Mutation firstMutation = (Mutation)miniBatchOp.getOperation(0);
        BaseScannerRegionObserver.ReplayWrite replayWrite = this.builder.getReplayWrite(firstMutation);
        boolean resetTimeStamp = replayWrite == null;
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes((long)now);
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (miniBatchOp.getOperationStatus(i) == IGNORE || !this.builder.isEnabled(m)) continue;
            if (resetTimeStamp) {
                for (List family : m.getFamilyCellMap().values()) {
                    List familyKVs = KeyValueUtil.ensureKeyValues((List)family);
                    for (KeyValue kv : familyKVs) {
                        Indexer.setTimeStamp(kv, byteNow);
                    }
                }
            }
            if (replayWrite == BaseScannerRegionObserver.ReplayWrite.INDEX_ONLY) {
                miniBatchOp.setOperationStatus(i, NOWRITE);
            }
            if (copyMutations) {
                ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
                MultiMutation stored = (MultiMutation)((Object)mutationsMap.get((Object)row));
                if (stored == null) {
                    stored = new MultiMutation(row);
                    mutationsMap.put(row, stored);
                }
                stored.addAll(m);
                continue;
            }
            originalMutations.add(m);
        }
        WALEdit edit = miniBatchOp.getWalEdit(0);
        if (edit == null) {
            edit = new WALEdit();
            miniBatchOp.setWalEdit(0, edit);
        }
        if (copyMutations || replayWrite != null) {
            mutations = IndexManagementUtil.flattenMutationsByTimestamp(mutations);
        }
        try (TraceScope scope = Trace.startSpan((String)"Starting to build index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            long start = EnvironmentEdgeManager.currentTimeMillis();
            Collection<Pair<Mutation, byte[]>> indexUpdates = this.builder.getIndexUpdate(miniBatchOp, mutations);
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexPrepareThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("indexPrepare", duration, this.slowIndexPrepareThreshold));
                }
                this.metricSource.incrementNumSlowIndexPrepareCalls();
            }
            this.metricSource.updateIndexPrepareTime(duration);
            current.addTimelineAnnotation("Built index updates, doing preStep");
            TracingUtils.addAnnotation(current, "index update count", indexUpdates.size());
            byte[] tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDesc().getTableName().getName();
            Iterator<Pair<Mutation, byte[]>> indexUpdatesItr = indexUpdates.iterator();
            ArrayList<Object> localUpdates = new ArrayList<Object>(indexUpdates.size());
            while (indexUpdatesItr.hasNext()) {
                Pair<Mutation, byte[]> next = indexUpdatesItr.next();
                if (Bytes.compareTo((byte[])((byte[])next.getSecond()), (byte[])tableName) != 0) continue;
                localUpdates.add(next.getFirst());
                indexUpdatesItr.remove();
            }
            if (!localUpdates.isEmpty()) {
                miniBatchOp.addOperationsFromCP(0, localUpdates.toArray(new Mutation[localUpdates.size()]));
            }
            if (!indexUpdates.isEmpty()) {
                context.indexUpdates = indexUpdates;
                if (durability != Durability.SKIP_WAL) {
                    for (Pair<Mutation, byte[]> entry : indexUpdates) {
                        edit.add((Cell)new IndexedKeyValue((byte[])entry.getSecond(), (Mutation)entry.getFirst()));
                    }
                }
            }
        }
    }

    private void setBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) {
        this.batchMutateContext.set(context);
    }

    private BatchMutateContext getBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        return this.batchMutateContext.get();
    }

    private void removeBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.batchMutateContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (this.disabled) {
            super.postBatchMutateIndispensably(c, miniBatchOp, success);
            return;
        }
        long start = EnvironmentEdgeManager.currentTimeMillis();
        BatchMutateContext context = this.getBatchMutateContext(c);
        if (context == null) {
            return;
        }
        try {
            for (LockManager.RowLock rowLock : context.rowLocks) {
                rowLock.release();
            }
            this.builder.batchCompleted(miniBatchOp);
            if (success) {
                this.doPost(c, context);
            }
        }
        finally {
            this.removeBatchMutateContext(c);
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexWriteThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("postBatchMutateIndispensably", duration, this.slowIndexWriteThreshold));
                }
                this.metricSource.incrementNumSlowIndexWriteCalls();
            }
            this.metricSource.updateIndexWriteTime(duration);
        }
    }

    private void doPost(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        try {
            this.doPostWithExceptions(c, context);
            return;
        }
        catch (Throwable e) {
            IndexManagementUtil.rethrowIndexingException(e);
            throw new RuntimeException("Somehow didn't complete the index update, but didn't return succesfully either!");
        }
    }

    private void doPostWithExceptions(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        if (context == null || context.indexUpdates.isEmpty()) {
            return;
        }
        try (TraceScope scope = Trace.startSpan((String)"Completing index writes");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            long start = EnvironmentEdgeManager.currentTimeMillis();
            current.addTimelineAnnotation("Actually doing index update for first time");
            this.writer.writeAndKillYourselfOnFailure(context.indexUpdates, false, context.clientVersion);
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexWriteThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("indexWrite", duration, this.slowIndexWriteThreshold));
                }
                this.metricSource.incrementNumSlowIndexWriteCalls();
            }
            this.metricSource.updateIndexWriteTime(duration);
        }
    }

    private IndexedKeyValue getFirstIndexedKeyValue(WALEdit edit) {
        for (Cell kv : edit.getCells()) {
            if (!(kv instanceof IndexedKeyValue)) continue;
            return (IndexedKeyValue)kv;
        }
        return null;
    }

    private Collection<Pair<Mutation, byte[]>> extractIndexUpdate(WALEdit edit) {
        int initialSize = Math.min(edit.size(), 64);
        ArrayList<Pair<Mutation, byte[]>> indexUpdates = new ArrayList<Pair<Mutation, byte[]>>(initialSize);
        for (Cell kv : edit.getCells()) {
            if (!(kv instanceof IndexedKeyValue)) continue;
            IndexedKeyValue ikv = (IndexedKeyValue)kv;
            indexUpdates.add((Pair<Mutation, byte[]>)new Pair((Object)ikv.getMutation(), (Object)ikv.getIndexTable()));
        }
        return indexUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        Multimap<HTableInterfaceReference, Mutation> updates = this.failedIndexEdits.getEdits(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion());
        if (this.disabled) {
            super.postOpen(c);
            return;
        }
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            if (updates == null || updates.size() == 0) {
                return;
            }
            LOG.info((Object)"Found some outstanding index updates that didn't succeed during WAL replay - attempting to replay now.");
            try {
                this.writer.writeAndKillYourselfOnFailure(updates, true, ScanUtil.UNKNOWN_CLIENT_VERSION);
            }
            catch (IOException e) {
                LOG.error((Object)"During WAL replay of outstanding index updates, Exception is thrown instead of killing server during index writing", (Throwable)e);
            }
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowPostOpenThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("postOpen", duration, this.slowPostOpenThreshold));
                }
                this.metricSource.incrementNumSlowPostOpenCalls();
            }
            this.metricSource.updatePostOpenTime(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (this.disabled) {
            super.preWALRestore(env, info, logKey, logEdit);
            return;
        }
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            Collection<Pair<Mutation, byte[]>> indexUpdates = this.extractIndexUpdate(logEdit);
            this.recoveryWriter.writeAndKillYourselfOnFailure(indexUpdates, true, ScanUtil.UNKNOWN_CLIENT_VERSION);
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowPreWALRestoreThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.getCallTooSlowMessage("preWALRestore", duration, this.slowPreWALRestoreThreshold));
                }
                this.metricSource.incrementNumSlowPreWALRestoreCalls();
            }
            this.metricSource.updatePreWALRestoreTime(duration);
        }
    }

    public InternalScanner preCompactScannerOpen(final ObserverContext<RegionCoprocessorEnvironment> c, final Store store, final List<? extends KeyValueScanner> scanners, final ScanType scanType, final long earliestPutTs, final InternalScanner s) throws IOException {
        return (InternalScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

            @Override
            public InternalScanner run() throws Exception {
                return Indexer.super.preCompactScannerOpen(c, store, scanners, scanType, earliestPutTs, s);
            }
        });
    }

    public IndexBuilder getBuilderForTesting() {
        return this.builder.getBuilderForTesting();
    }

    public static String validateVersion(String hbaseVersion, Configuration conf) {
        int encodedVersion = VersionUtil.encodeVersion(hbaseVersion);
        if (encodedVersion > INDEXING_SUPPORTED_MAJOR_VERSION) {
            return null;
        }
        if (encodedVersion < INDEXING_SUPPORTED__MIN_MAJOR_VERSION) {
            return "Indexing not supported for versions older than 0.94.X";
        }
        if (encodedVersion < INDEX_WAL_COMPRESSION_MINIMUM_SUPPORTED_VERSION && conf.getBoolean("hbase.regionserver.wal.enablecompression", false)) {
            return "Indexing not supported with WAL Compression for versions of HBase older than 0.94.9 - found version:" + hbaseVersion;
        }
        return null;
    }

    public static void enableIndexing(HTableDescriptor desc, Class<? extends IndexBuilder> builder, Map<String, String> properties, int priority) throws IOException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(INDEX_BUILDER_CONF_KEY, builder.getName());
        desc.addCoprocessor(Indexer.class.getName(), null, priority, properties);
    }

    private static class BatchMutateContext {
        public final int clientVersion;
        public Collection<Pair<Mutation, byte[]>> indexUpdates = Collections.emptyList();
        public List<LockManager.RowLock> rowLocks = Lists.newArrayListWithExpectedSize((int)100);

        public BatchMutateContext(int clientVersion) {
            this.clientVersion = clientVersion;
        }
    }
}

