/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.schema.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTrackingServerAggregators
extends ServerAggregators {
    private static final Logger logger = LoggerFactory.getLogger(SizeTrackingServerAggregators.class);
    private final MemoryManager.MemoryChunk chunk;
    private final int sizeIncrease;
    private long memoryUsed = 0L;

    public SizeTrackingServerAggregators(SingleAggregateFunction[] functions, Aggregator[] aggregators, Expression[] expressions, int minNullableIndex, MemoryManager.MemoryChunk chunk, int sizeIncrease) {
        super(functions, aggregators, expressions, minNullableIndex);
        this.chunk = chunk;
        this.sizeIncrease = sizeIncrease;
    }

    @Override
    public void aggregate(Aggregator[] aggregators, Tuple result) {
        long dsize = this.memoryUsed;
        for (int i = 0; i < this.expressions.length; ++i) {
            if (this.expressions[i].evaluate(result, this.ptr) && this.ptr.getLength() != 0) {
                dsize -= (long)aggregators[i].getSize();
                aggregators[i].aggregate(result, this.ptr);
                dsize += (long)aggregators[i].getSize();
            }
            this.expressions[i].reset();
        }
        while (dsize > this.chunk.getSize()) {
            logger.info("Request: {}, resizing {} by 1024*1024", (Object)dsize, (Object)this.chunk.getSize());
            this.chunk.resize(this.chunk.getSize() + (long)this.sizeIncrease);
        }
        this.memoryUsed = dsize;
    }
}

