/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.NonSizeTrackingServerAggregators;
import org.apache.phoenix.expression.aggregator.SizeTrackingServerAggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class ServerAggregators
extends Aggregators {
    protected final Expression[] expressions;

    protected ServerAggregators(SingleAggregateFunction[] functions, Aggregator[] aggregators, Expression[] expressions, int minNullableIndex) {
        super(functions, aggregators, minNullableIndex);
        if (aggregators.length != expressions.length) {
            throw new IllegalArgumentException("Number of aggregators (" + aggregators.length + ") must match the number of expressions (" + Arrays.toString(expressions) + ")");
        }
        this.expressions = expressions;
    }

    @Override
    public abstract void aggregate(Aggregator[] var1, Tuple var2);

    public static byte[] serialize(List<SingleAggregateFunction> aggFuncs, int minNullableIndex) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)minNullableIndex);
            WritableUtils.writeVInt((DataOutput)output, (int)aggFuncs.size());
            for (int i = 0; i < aggFuncs.size(); ++i) {
                SingleAggregateFunction aggFunc = aggFuncs.get(i);
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(aggFunc).ordinal());
                aggFunc.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Aggregator[] newAggregators() {
        return this.newAggregators(null);
    }

    public Aggregator[] newAggregators(Configuration conf) {
        Aggregator[] aggregators = new Aggregator[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            aggregators[i] = this.functions[i].newServerAggregator(conf);
        }
        return aggregators;
    }

    public static ServerAggregators deserialize(byte[] b, Configuration conf, MemoryManager.MemoryChunk chunk) {
        if (b == null) {
            return NonSizeTrackingServerAggregators.EMPTY_AGGREGATORS;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int minNullableIndex = WritableUtils.readVInt((DataInput)input);
            int len = WritableUtils.readVInt((DataInput)input);
            Aggregator[] aggregators = new Aggregator[len];
            Expression[] expressions = new Expression[len];
            SingleAggregateFunction[] functions = new SingleAggregateFunction[len];
            for (int i = 0; i < aggregators.length; ++i) {
                SingleAggregateFunction aggFunc = (SingleAggregateFunction)ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                aggFunc.readFields(input, conf);
                functions[i] = aggFunc;
                aggregators[i] = aggFunc.getAggregator();
                expressions[i] = aggFunc.getAggregatorExpression();
            }
            boolean trackSize = false;
            if (chunk != null) {
                for (Aggregator aggregator : aggregators) {
                    if (!aggregator.trackSize()) continue;
                    trackSize = true;
                    break;
                }
            }
            ServerAggregators serverAggregators = trackSize ? new SizeTrackingServerAggregators(functions, aggregators, expressions, minNullableIndex, chunk, conf.getInt("phoenix.aggregate.chunk_size_increase", 0x100000)) : new NonSizeTrackingServerAggregators(functions, aggregators, expressions, minNullableIndex);
            return serverAggregators;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

