/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.FirstLastNthValueDataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstLastValueServerAggregator
extends BaseAggregator {
    private static final Logger logger = LoggerFactory.getLogger(FirstLastValueServerAggregator.class);
    protected List<Expression> children;
    protected BinaryComparator topOrder = new BinaryComparator(ByteUtil.EMPTY_BYTE_ARRAY);
    protected byte[] topValue;
    protected boolean useOffset = false;
    protected int offset = -1;
    protected TreeMap<byte[], LinkedList<byte[]>> topValues = new TreeMap(new Bytes.ByteArrayComparator());
    protected boolean isAscending;
    protected boolean hasValueDescSortOrder;
    protected Expression orderByColumn;
    protected Expression dataColumn;
    protected int topValuesCount = 0;

    public FirstLastValueServerAggregator() {
        super(SortOrder.getDefault());
    }

    @Override
    public void reset() {
        this.topOrder = new BinaryComparator(ByteUtil.EMPTY_BYTE_ARRAY);
        this.topValue = null;
        this.topValues.clear();
        this.topValuesCount = 0;
    }

    @Override
    public int getSize() {
        return super.getSize() + 48;
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        this.orderByColumn.evaluate(tuple, ptr);
        byte[] currentOrder = ptr.copyBytes();
        if (!this.dataColumn.evaluate(tuple, ptr)) {
            return;
        }
        if (this.useOffset) {
            boolean addFlag = false;
            if (this.topValuesCount < this.offset) {
                try {
                    addFlag = true;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            } else if (this.isAscending) {
                if (this.removeLastElement(currentOrder, this.topValues.lastKey(), -1)) {
                    addFlag = true;
                    --this.topValuesCount;
                }
            } else if (this.removeLastElement(currentOrder, this.topValues.firstKey(), 1)) {
                addFlag = true;
                --this.topValuesCount;
            }
            if (addFlag) {
                ++this.topValuesCount;
                if (!this.topValues.containsKey(currentOrder)) {
                    this.topValues.put(currentOrder, new LinkedList());
                }
                if (this.hasValueDescSortOrder) {
                    this.topValues.get(currentOrder).push(SortOrder.invert(ptr.get(), ptr.getOffset(), ptr.getLength()));
                } else {
                    this.topValues.get(currentOrder).push(ptr.copyBytes());
                }
            }
        } else {
            boolean isHigher;
            if (this.isAscending) {
                isHigher = this.topOrder.compareTo(currentOrder) > 0;
            } else {
                boolean bl = isHigher = this.topOrder.compareTo(currentOrder) < 0;
            }
            if (this.topOrder.getValue().length < 1 || isHigher) {
                this.topValue = this.hasValueDescSortOrder ? SortOrder.invert(ptr.get(), ptr.getOffset(), ptr.getLength()) : ptr.copyBytes();
                this.topOrder = new BinaryComparator(currentOrder);
            }
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder("FirstLastValueServerAggregator is ascending: " + this.isAscending + " value=");
        if (this.useOffset) {
            for (byte[] key : this.topValues.keySet()) {
                out.append(this.topValues.get(key));
            }
            out.append(" offset = ").append(this.offset);
        } else {
            out.append(this.topValue);
        }
        return out.toString();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        FirstLastNthValueDataContainer payload = new FirstLastNthValueDataContainer();
        payload.setIsAscending(this.isAscending);
        payload.setFixedWidthOrderValues(this.orderByColumn.getDataType().isFixedWidth());
        payload.setFixedWidthDataValues(this.dataColumn.getDataType().isFixedWidth());
        if (this.useOffset) {
            payload.setOffset(this.offset);
            if (this.topValuesCount == 0) {
                return false;
            }
        } else {
            if (this.topValue == null) {
                return false;
            }
            LinkedList<byte[]> topValueList = new LinkedList<byte[]>();
            topValueList.push(this.topValue);
            this.topValues.put(this.topOrder.getValue(), topValueList);
        }
        payload.setData(this.topValues);
        try {
            ptr.set(payload.getPayload());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    public void init(List<Expression> children, boolean isAscending, int offset) {
        this.children = children;
        this.offset = offset;
        if (offset > 0) {
            this.useOffset = true;
        }
        this.orderByColumn = children.get(0);
        this.dataColumn = children.get(2);
        boolean bl = this.hasValueDescSortOrder = this.dataColumn.getSortOrder() == SortOrder.DESC;
        this.isAscending = this.orderByColumn.getSortOrder() == SortOrder.DESC ? !isAscending : isAscending;
    }

    private boolean removeLastElement(byte[] currentOrder, byte[] lowestKey, int sortOrderInt) {
        if (Bytes.compareTo((byte[])currentOrder, (byte[])lowestKey) * sortOrderInt >= 0) {
            if (this.topValues.get(lowestKey).size() == 1) {
                this.topValues.remove(lowestKey);
            } else {
                this.topValues.get(lowestKey).pollFirst();
            }
            return true;
        }
        return false;
    }
}

