/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ExpressionUtil;

public class IsNullExpression
extends BaseSingleExpression {
    private boolean isNegate;

    public static Expression create(Expression child, boolean negate, ImmutableBytesWritable ptr) throws SQLException {
        if (!child.isNullable()) {
            return LiteralExpression.newConstant((Object)negate, (PDataType)PBoolean.INSTANCE, child.getDeterminism());
        }
        if (ExpressionUtil.isConstant(child)) {
            boolean evaluated = child.evaluate(null, ptr);
            return LiteralExpression.newConstant((Object)(negate ^ (!evaluated || ptr.getLength() == 0)), (PDataType)PBoolean.INSTANCE, child.getDeterminism());
        }
        return new IsNullExpression(child, negate);
    }

    public IsNullExpression() {
    }

    private IsNullExpression(Expression expression, boolean negate) {
        super(expression);
        this.isNegate = negate;
    }

    public IsNullExpression(List<Expression> children, boolean negate) {
        super(children);
        this.isNegate = negate;
    }

    public IsNullExpression clone(List<Expression> children) {
        return new IsNullExpression(children, this.isNegate());
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean evaluated = this.getChild().evaluate(tuple, ptr);
        if (evaluated) {
            ptr.set(this.isNegate ^ ptr.getLength() == 0 ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
            return true;
        }
        if (tuple.isImmutable()) {
            ptr.set(this.isNegate ? PDataType.FALSE_BYTES : PDataType.TRUE_BYTES);
            return true;
        }
        return false;
    }

    public boolean isNegate() {
        return this.isNegate;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.isNegate = input.readBoolean();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(this.isNegate);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(((Expression)this.children.get(0)).toString());
        if (this.isNegate) {
            buf.append(" IS NOT NULL");
        } else {
            buf.append(" IS NULL");
        }
        return buf.toString();
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return super.requiresFinalEvaluation() || !this.isNegate();
    }
}

