/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class TupleProjectionPlan
extends DelegateQueryPlan {
    private final TupleProjector tupleProjector;
    private final Expression postFilter;

    public TupleProjectionPlan(QueryPlan plan, TupleProjector tupleProjector, Expression postFilter) {
        super(plan);
        if (tupleProjector == null) {
            throw new IllegalArgumentException("tupleProjector is null");
        }
        this.tupleProjector = tupleProjector;
        this.postFilter = postFilter;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        if (this.postFilter != null) {
            planSteps.add("CLIENT FILTER BY " + this.postFilter.toString());
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator iterator = new DelegateResultIterator(this.delegate.iterator(scanGrouper, scan)){

            @Override
            public Tuple next() throws SQLException {
                Tuple tuple = super.next();
                if (tuple == null) {
                    return null;
                }
                return TupleProjectionPlan.this.tupleProjector.projectResults(tuple);
            }

            public String toString() {
                return "TupleProjectionResultIterator [projector=" + TupleProjectionPlan.this.tupleProjector + "]";
            }
        };
        if (this.postFilter != null) {
            iterator = new FilterResultIterator(iterator, this.postFilter);
        }
        return iterator;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

