/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.iterate.ChunkedResultIterator;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.MergeSortTopNResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.SerialIterators;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.CostUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanPlan
extends BaseQueryPlan {
    private static final Logger logger = LoggerFactory.getLogger(ScanPlan.class);
    private List<KeyRange> splits;
    private List<List<Scan>> scans;
    private boolean allowPageFilter;
    private boolean isSerial;
    private boolean isDataToScanWithinThreshold;
    private Long serialRowsEstimate;
    private Long serialBytesEstimate;
    private Long serialEstimateInfoTs;

    public ScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory, boolean allowPageFilter, QueryPlan dataPlan) throws SQLException {
        this(context, statement, table, projector, limit, offset, orderBy, parallelIteratorFactory, allowPageFilter, null, dataPlan);
    }

    private ScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory, boolean allowPageFilter, Expression dynamicFilter, QueryPlan dataPlan) throws SQLException {
        super(context, statement, table, projector, context.getBindManager().getParameterMetaData(), limit, offset, orderBy, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, parallelIteratorFactory != null ? parallelIteratorFactory : ScanPlan.buildResultIteratorFactory(context, statement, table, orderBy, limit, offset, allowPageFilter), dynamicFilter, dataPlan);
        boolean isOrdered;
        this.allowPageFilter = allowPageFilter;
        boolean bl = isOrdered = !orderBy.getOrderByExpressions().isEmpty();
        if (isOrdered) {
            int thresholdBytes = context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            ScanRegionObserver.serializeIntoScan(context.getScan(), thresholdBytes, limit == null ? -1 : QueryUtil.getOffsetLimit(limit, offset), orderBy.getOrderByExpressions(), projector.getEstimatedRowByteSize());
        }
        Integer perScanLimit = !allowPageFilter || isOrdered ? null : limit;
        perScanLimit = QueryUtil.getOffsetLimit(perScanLimit, offset);
        Pair<Long, Long> estimate = ScanPlan.getEstimateOfDataSizeToScanIfWithinThreshold(context, table.getTable(), perScanLimit);
        this.isDataToScanWithinThreshold = estimate != null;
        this.isSerial = ScanPlan.isSerial(context, statement, this.tableRef, orderBy, this.isDataToScanWithinThreshold);
        if (this.isSerial) {
            this.serialBytesEstimate = (Long)estimate.getFirst();
            this.serialRowsEstimate = (Long)estimate.getSecond();
            this.serialEstimateInfoTs = 0L;
        }
    }

    private static boolean isSerial(StatementContext context, FilterableStatement statement, TableRef tableRef, OrderByCompiler.OrderBy orderBy, boolean isDataWithinThreshold) throws SQLException {
        if (isDataWithinThreshold) {
            PTable table = tableRef.getTable();
            boolean hasSerialHint = statement.getHint().hasHint(HintNode.Hint.SERIAL);
            boolean canBeExecutedSerially = ScanUtil.canQueryBeExecutedSerially(table, orderBy, context);
            if (!canBeExecutedSerially) {
                if (hasSerialHint) {
                    logger.warn("This query cannot be executed serially. Ignoring the hint");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static Pair<Long, Long> getEstimateOfDataSizeToScanIfWithinThreshold(StatementContext context, PTable table, Integer perScanLimit) throws SQLException {
        Scan scan = context.getScan();
        ConnectionQueryServices services = context.getConnection().getQueryServices();
        long estRowSize = SchemaUtil.estimateRowSize(table);
        long regionSize = services.getProps().getLong("hbase.hregion.max.filesize", 0x280000000L);
        if (perScanLimit == null || scan.getFilter() != null) {
            return null;
        }
        float factor = services.getProps().getFloat("phoenix.limited.query.serial.threshold", 0.2f);
        long threshold = (long)(factor * (float)regionSize);
        long estimatedBytes = (long)perScanLimit.intValue() * estRowSize;
        long estimatedRows = perScanLimit.intValue();
        return (long)perScanLimit.intValue() * estRowSize < threshold ? new Pair((Object)estimatedBytes, (Object)estimatedRows) : null;
    }

    private static ParallelIteratorFactory buildResultIteratorFactory(StatementContext context, FilterableStatement statement, TableRef tableRef, OrderByCompiler.OrderBy orderBy, Integer limit, Integer offset, boolean allowPageFilter) throws SQLException {
        if (ScanPlan.isSerial(context, statement, tableRef, orderBy, ScanPlan.getEstimateOfDataSizeToScanIfWithinThreshold(context, tableRef.getTable(), QueryUtil.getOffsetLimit(limit, offset)) != null) || ScanUtil.isRoundRobinPossible(orderBy, context) || ScanUtil.isPacingScannersPossible(context)) {
            return ParallelIteratorFactory.NOOP_FACTORY;
        }
        SpoolingResultIterator.SpoolingResultIteratorFactory spoolingResultIteratorFactory = new SpoolingResultIterator.SpoolingResultIteratorFactory(context.getConnection().getQueryServices());
        if (!orderBy.getOrderByExpressions().isEmpty()) {
            return spoolingResultIteratorFactory;
        }
        return new ChunkedResultIterator.ChunkedResultIteratorFactory(spoolingResultIteratorFactory, context.getConnection().getMutationState(), tableRef);
    }

    @Override
    public Cost getCost() {
        Long byteCount = null;
        try {
            byteCount = this.getEstimatedBytesToScan();
        }
        catch (SQLException e) {
            // empty catch block
        }
        Double outputBytes = this.accept(new ByteCountVisitor());
        if (byteCount == null || outputBytes == null) {
            return Cost.UNKNOWN;
        }
        int parallelLevel = CostUtil.estimateParallelLevel(true, this.context.getConnection().getQueryServices());
        Cost cost = new Cost(0.0, 0.0, byteCount.longValue());
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            Cost orderByCost = CostUtil.estimateOrderByCost(byteCount.longValue(), outputBytes, parallelLevel);
            cost = cost.plus(orderByCost);
        }
        return cost;
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private static boolean isOffsetPossibleOnServer(StatementContext context, OrderByCompiler.OrderBy orderBy, Integer offset, boolean isSalted, PTable.IndexType indexType) {
        return offset != null && orderBy.getOrderByExpressions().isEmpty() && (!isSalted && indexType != PTable.IndexType.LOCAL || !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context));
    }

    @Override
    protected ResultIterator newIterator(ParallelScanGrouper scanGrouper, Scan scan, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches) throws SQLException {
        ResultIterator scanner;
        boolean initFirstScanOnly;
        scan.setAttribute("_NonAggregateQuery", QueryConstants.TRUE);
        TableRef tableRef = this.getTableRef();
        PTable table = tableRef.getTable();
        boolean isSalted = table.getBucketNum() != null;
        boolean isOrdered = !this.orderBy.getOrderByExpressions().isEmpty();
        Integer perScanLimit = !this.allowPageFilter || isOrdered ? null : QueryUtil.getOffsetLimit(this.limit, this.offset);
        boolean isOffsetOnServer = ScanPlan.isOffsetPossibleOnServer(this.context, this.orderBy, this.offset, isSalted, table.getIndexType());
        boolean bl = initFirstScanOnly = (this.orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) && this.isDataToScanWithinThreshold;
        BaseResultIterators iterators = isOffsetOnServer ? new SerialIterators(this, perScanLimit, this.offset, this.parallelIteratorFactory, scanGrouper, scan, caches, this.dataPlan) : (this.isSerial ? new SerialIterators(this, perScanLimit, null, this.parallelIteratorFactory, scanGrouper, scan, caches, this.dataPlan) : new ParallelIterators(this, perScanLimit, this.parallelIteratorFactory, scanGrouper, scan, initFirstScanOnly, caches, this.dataPlan));
        this.estimatedRows = iterators.getEstimatedRowCount();
        this.estimatedSize = iterators.getEstimatedByteCount();
        this.estimateInfoTimestamp = iterators.getEstimateInfoTimestamp();
        this.splits = iterators.getSplits();
        this.scans = iterators.getScans();
        if (isOffsetOnServer) {
            scanner = new ConcatResultIterator(iterators);
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        } else if (isOrdered) {
            scanner = new MergeSortTopNResultIterator(iterators, this.limit, this.offset, this.orderBy.getOrderByExpressions());
        } else {
            scanner = (isSalted || table.getIndexType() == PTable.IndexType.LOCAL) && ScanUtil.shouldRowsBeInRowKeyOrder(this.orderBy, this.context) ? new MergeSortRowKeyResultIterator(iterators, isSalted ? 1 : 0, this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) : (this.useRoundRobinIterator() ? new RoundRobinResultIterator(iterators, (QueryPlan)this) : new ConcatResultIterator(iterators));
            if (this.offset != null) {
                scanner = new OffsetResultIterator(scanner, this.offset);
            }
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            scanner = new SequenceResultIterator(scanner, this.context.getSequenceManager());
        }
        return scanner;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return ScanUtil.isRoundRobinPossible(this.orderBy, this.context);
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (this.isSerial) {
            return this.serialRowsEstimate;
        }
        return super.getEstimatedRowsToScan();
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (this.isSerial) {
            return this.serialBytesEstimate;
        }
        return super.getEstimatedBytesToScan();
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        if (this.isSerial) {
            return this.serialEstimateInfoTs;
        }
        return super.getEstimateInfoTimestamp();
    }
}

