/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.cache.IndexMetaDataCache;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.execute.DelegateHTable;
import org.apache.phoenix.execute.PhoenixTxIndexMutationGenerator;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MutationMetricQueue;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationState
implements SQLCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MutationState.class);
    private static final int[] EMPTY_STATEMENT_INDEX_ARRAY = new int[0];
    private static final int MAX_COMMIT_RETRIES = 3;
    private final PhoenixConnection connection;
    private final long maxSize;
    private final long maxSizeBytes;
    private final long batchSize;
    private final long batchSizeBytes;
    private long batchCount = 0L;
    private final Map<TableRef, MultiRowMutationState> mutations;
    private final Set<String> uncommittedPhysicalNames = Sets.newHashSetWithExpectedSize((int)10);
    private long sizeOffset;
    private int numRows = 0;
    private long estimatedSize = 0L;
    private int[] uncommittedStatementIndexes = EMPTY_STATEMENT_INDEX_ARRAY;
    private boolean isExternalTxContext = false;
    private Map<TableRef, MultiRowMutationState> txMutations = Collections.emptyMap();
    private PhoenixTransactionContext phoenixTransactionContext = PhoenixTransactionContext.NULL_CONTEXT;
    private final MutationMetricQueue mutationMetricQueue;
    private ReadMetricQueue readMetricQueue;

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection) {
        this(maxSize, maxSizeBytes, connection, false, null);
    }

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, PhoenixTransactionContext txContext) {
        this(maxSize, maxSizeBytes, connection, false, txContext);
    }

    public MutationState(MutationState mutationState) {
        this(mutationState.maxSize, mutationState.maxSizeBytes, mutationState.connection, true, mutationState.getPhoenixTransactionContext());
    }

    public MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, long sizeOffset) {
        this(maxSize, maxSizeBytes, connection, false, null, sizeOffset);
    }

    private MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, boolean subTask, PhoenixTransactionContext txContext) {
        this(maxSize, maxSizeBytes, connection, subTask, txContext, 0L);
    }

    private MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, boolean subTask, PhoenixTransactionContext txContext, long sizeOffset) {
        this(maxSize, maxSizeBytes, connection, Maps.newHashMapWithExpectedSize((int)5), subTask, txContext);
        this.sizeOffset = sizeOffset;
    }

    MutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection, Map<TableRef, MultiRowMutationState> mutations, boolean subTask, PhoenixTransactionContext txContext) {
        this.maxSize = maxSize;
        this.maxSizeBytes = maxSizeBytes;
        this.connection = connection;
        this.batchSize = connection.getMutateBatchSize();
        this.batchSizeBytes = connection.getMutateBatchSizeBytes();
        this.mutations = mutations;
        boolean isMetricsEnabled = connection.isRequestLevelMetricsEnabled();
        MutationMetricQueue mutationMetricQueue = this.mutationMetricQueue = isMetricsEnabled ? new MutationMetricQueue() : MutationMetricQueue.NoOpMutationMetricsQueue.NO_OP_MUTATION_METRICS_QUEUE;
        if (subTask) {
            this.phoenixTransactionContext = txContext.newTransactionContext(txContext, subTask);
        } else if (txContext != null) {
            this.isExternalTxContext = true;
            this.phoenixTransactionContext = txContext.newTransactionContext(txContext, subTask);
        }
    }

    public MutationState(TableRef table, MultiRowMutationState mutations, long sizeOffset, long maxSize, long maxSizeBytes, PhoenixConnection connection) throws SQLException {
        this(maxSize, maxSizeBytes, connection, false, null, sizeOffset);
        if (!mutations.isEmpty()) {
            this.mutations.put(table, mutations);
        }
        this.numRows = mutations.size();
        this.estimatedSize = KeyValueUtil.getEstimatedRowMutationSize(this.mutations);
        this.throwIfTooBig();
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public PhoenixTransactionContext getPhoenixTransactionContext() {
        return this.phoenixTransactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitDDLFence(PTable dataTable) throws SQLException {
        if (dataTable.isTransactional()) {
            try {
                this.phoenixTransactionContext.commitDDLFence(dataTable);
            }
            finally {
                this.phoenixTransactionContext.begin();
            }
        }
    }

    public boolean checkpointIfNeccessary(MutationPlan plan) throws SQLException {
        if (!this.phoenixTransactionContext.isTransactionRunning() || plan.getTargetRef() == null || plan.getTargetRef().getTable() == null || !plan.getTargetRef().getTable().isTransactional()) {
            return false;
        }
        Set<TableRef> sources = plan.getSourceRefs();
        if (sources.isEmpty()) {
            return false;
        }
        TableRef ignoreForExcludeCurrent = plan.getOperation() == PhoenixStatement.Operation.DELETE && sources.size() == 1 ? plan.getTargetRef() : null;
        boolean excludeCurrent = false;
        String targetPhysicalName = plan.getTargetRef().getTable().getPhysicalName().getString();
        for (TableRef source : sources) {
            String sourcePhysicalName;
            if (!source.getTable().isTransactional() || source.equals(ignoreForExcludeCurrent) || !targetPhysicalName.equals(sourcePhysicalName = source.getTable().getPhysicalName().getString())) continue;
            excludeCurrent = true;
            break;
        }
        if (excludeCurrent) {
            boolean hasUncommittedData = false;
            for (TableRef source : sources) {
                String sourcePhysicalName = source.getTable().getPhysicalName().getString();
                if (!source.getTable().isTransactional() || !this.isExternalTxContext && !this.uncommittedPhysicalNames.contains(sourcePhysicalName)) continue;
                hasUncommittedData = true;
                break;
            }
            this.phoenixTransactionContext.checkpoint(hasUncommittedData);
            if (hasUncommittedData) {
                this.uncommittedPhysicalNames.clear();
            }
            return true;
        }
        return false;
    }

    public HTableInterface getHTable(PTable table) throws SQLException {
        HTableInterface htable = this.getConnection().getQueryServices().getTable(table.getPhysicalName().getBytes());
        if (table.isTransactional() && this.phoenixTransactionContext.isTransactionRunning()) {
            htable = this.phoenixTransactionContext.getTransactionalTable(htable, table.isImmutableRows());
        }
        return htable;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public boolean isTransactionStarted() {
        return this.phoenixTransactionContext.isTransactionRunning();
    }

    public long getInitialWritePointer() {
        return this.phoenixTransactionContext.getTransactionId();
    }

    public long getWritePointer() {
        return this.phoenixTransactionContext.getWritePointer();
    }

    public PhoenixTransactionContext.PhoenixVisibilityLevel getVisibilityLevel() {
        return this.phoenixTransactionContext.getVisibilityLevel();
    }

    public boolean startTransaction(TransactionFactory.Provider provider) throws SQLException {
        if (provider == null) {
            return false;
        }
        if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_START_TXN_IF_TXN_DISABLED).build().buildException();
        }
        if (this.connection.getSCN() != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_START_TRANSACTION_WITH_SCN_SET).build().buildException();
        }
        if (this.phoenixTransactionContext == PhoenixTransactionContext.NULL_CONTEXT) {
            this.phoenixTransactionContext = provider.getTransactionProvider().getTransactionContext(this.connection);
        } else if (provider != this.phoenixTransactionContext.getProvider()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MIX_TXN_PROVIDERS).setMessage(this.phoenixTransactionContext.getProvider().name() + " and " + provider.name()).build().buildException();
        }
        if (!this.isTransactionStarted()) {
            this.resetTransactionalState();
            this.phoenixTransactionContext.begin();
            return true;
        }
        return false;
    }

    public static MutationState emptyMutationState(long maxSize, long maxSizeBytes, PhoenixConnection connection) {
        MutationState state2 = new MutationState(maxSize, maxSizeBytes, connection, Collections.emptyMap(), false, null);
        state2.sizeOffset = 0L;
        return state2;
    }

    private void throwIfTooBig() throws SQLException {
        if ((long)this.numRows > this.maxSize) {
            this.resetState();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_MUTATION_SIZE_EXCEEDED).build().buildException();
        }
        if (this.estimatedSize > this.maxSizeBytes) {
            this.resetState();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MAX_MUTATION_SIZE_BYTES_EXCEEDED).build().buildException();
        }
    }

    public long getUpdateCount() {
        return this.sizeOffset + (long)this.numRows;
    }

    private void joinMutationState(TableRef tableRef, MultiRowMutationState srcRows, Map<TableRef, MultiRowMutationState> dstMutations) {
        PTable table = tableRef.getTable();
        boolean isIndex = table.getType() == PTableType.INDEX;
        boolean incrementRowCount = dstMutations == this.mutations;
        MultiRowMutationState existingRows = dstMutations.put(tableRef, srcRows);
        if (existingRows != null) {
            for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : srcRows.entrySet()) {
                RowMutationState existingRowMutationState = existingRows.put(rowEntry.getKey(), rowEntry.getValue());
                if (existingRowMutationState != null) {
                    Map<PColumn, byte[]> newRow;
                    Map<PColumn, byte[]> existingValues = existingRowMutationState.getColumnValues();
                    if (existingValues == PRow.DELETE_MARKER || (newRow = rowEntry.getValue().getColumnValues()) == PRow.DELETE_MARKER) continue;
                    this.estimatedSize -= existingRowMutationState.calculateEstimatedSize();
                    existingRowMutationState.join(rowEntry.getValue());
                    this.estimatedSize += existingRowMutationState.calculateEstimatedSize();
                    existingRows.put(rowEntry.getKey(), existingRowMutationState);
                    continue;
                }
                if (!incrementRowCount || isIndex) continue;
                ++this.numRows;
                this.estimatedSize += rowEntry.getValue().calculateEstimatedSize();
            }
            dstMutations.put(tableRef, existingRows);
        } else {
            MultiRowMutationState newRows = new MultiRowMutationState(this.connection.getMutateBatchSize());
            newRows.putAll(srcRows);
            dstMutations.put(tableRef, newRows);
            if (incrementRowCount && !isIndex) {
                this.numRows += srcRows.size();
                this.estimatedSize += srcRows.estimatedSize;
            }
        }
    }

    private void joinMutationState(Map<TableRef, MultiRowMutationState> srcMutations, Map<TableRef, MultiRowMutationState> dstMutations) {
        for (Map.Entry<TableRef, MultiRowMutationState> entry : srcMutations.entrySet()) {
            TableRef tableRef = entry.getKey();
            MultiRowMutationState srcRows = entry.getValue();
            this.joinMutationState(tableRef, srcRows, dstMutations);
        }
    }

    public void join(MutationState newMutationState) throws SQLException {
        if (this == newMutationState) {
            return;
        }
        this.phoenixTransactionContext.join(newMutationState.getPhoenixTransactionContext());
        this.sizeOffset += newMutationState.sizeOffset;
        this.joinMutationState(newMutationState.mutations, this.mutations);
        if (!newMutationState.txMutations.isEmpty()) {
            if (this.txMutations.isEmpty()) {
                this.txMutations = Maps.newHashMapWithExpectedSize((int)this.mutations.size());
            }
            this.joinMutationState(newMutationState.txMutations, this.txMutations);
        }
        this.mutationMetricQueue.combineMetricQueues(newMutationState.mutationMetricQueue);
        if (this.readMetricQueue == null) {
            this.readMetricQueue = newMutationState.readMetricQueue;
        } else if (this.readMetricQueue != null && newMutationState.readMetricQueue != null) {
            this.readMetricQueue.combineReadMetrics(newMutationState.readMetricQueue);
        }
        this.throwIfTooBig();
    }

    private static ImmutableBytesPtr getNewRowKeyWithRowTimestamp(ImmutableBytesPtr ptr, long rowTimestamp, PTable table) {
        RowKeySchema schema = table.getRowKeySchema();
        int rowTimestampColPos = table.getRowTimestampColPos();
        ValueSchema.Field rowTimestampField = schema.getField(rowTimestampColPos);
        byte[] rowTimestampBytes = PLong.INSTANCE.toBytes(rowTimestamp, rowTimestampField.getSortOrder());
        int oldOffset = ptr.getOffset();
        int oldLength = ptr.getLength();
        schema.position(ptr, 0, rowTimestampColPos);
        byte[] b = ptr.get();
        int newOffset = ptr.getOffset();
        int length = ptr.getLength();
        for (int i = newOffset; i < newOffset + length; ++i) {
            b[i] = rowTimestampBytes[i - newOffset];
        }
        ptr.set(ptr.get(), oldOffset, oldLength);
        return ptr;
    }

    private static List<PTable> getClientMaintainedIndexes(PTable table) {
        Iterator<Object> indexIterator = table.isImmutableRows() || table.isTransactional() ? IndexMaintainer.maintainedGlobalIndexes(table.getIndexes().iterator()) : Collections.emptyIterator();
        return Lists.newArrayList(indexIterator);
    }

    private Iterator<Pair<PName, List<Mutation>>> addRowMutations(final TableRef tableRef, final MultiRowMutationState values, final long mutationTimestamp, final long serverTimestamp, boolean includeAllIndexes, final boolean sendAll) {
        final PTable table = tableRef.getTable();
        final ArrayList indexList = includeAllIndexes ? Lists.newArrayList(IndexMaintainer.maintainedIndexes(table.getIndexes().iterator())) : MutationState.getClientMaintainedIndexes(table);
        final Iterator indexes = indexList.iterator();
        final ArrayList mutationList = Lists.newArrayListWithExpectedSize((int)values.size());
        final ArrayList mutationsPertainingToIndex = indexes.hasNext() ? Lists.newArrayListWithExpectedSize((int)values.size()) : null;
        this.generateMutations(tableRef, mutationTimestamp, serverTimestamp, values, mutationList, mutationsPertainingToIndex);
        return new Iterator<Pair<PName, List<Mutation>>>(){
            boolean isFirst = true;
            Map<byte[], List<Mutation>> indexMutationsMap = null;

            @Override
            public boolean hasNext() {
                return this.isFirst || indexes.hasNext();
            }

            @Override
            public Pair<PName, List<Mutation>> next() {
                if (this.isFirst) {
                    this.isFirst = false;
                    return new Pair((Object)table.getPhysicalName(), (Object)mutationList);
                }
                PTable index = (PTable)indexes.next();
                ArrayList indexMutations = null;
                try {
                    if (!mutationsPertainingToIndex.isEmpty()) {
                        if (table.isTransactional()) {
                            if (this.indexMutationsMap == null) {
                                PhoenixTxIndexMutationGenerator generator = MutationState.this.newTxIndexMutationGenerator(table, indexList, ((Mutation)mutationsPertainingToIndex.get(0)).getAttributesMap());
                                try (HTableInterface htable = MutationState.this.connection.getQueryServices().getTable(table.getPhysicalName().getBytes());){
                                    Collection<Pair<Mutation, byte[]>> allMutations = generator.getIndexUpdates(htable, mutationsPertainingToIndex.iterator());
                                    this.indexMutationsMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
                                    for (Pair<Mutation, byte[]> mutation : allMutations) {
                                        ArrayList mutations = this.indexMutationsMap.get(mutation.getSecond());
                                        if (mutations == null) {
                                            mutations = Lists.newArrayList();
                                            this.indexMutationsMap.put((byte[])mutation.getSecond(), mutations);
                                        }
                                        mutations.add(mutation.getFirst());
                                    }
                                }
                            }
                            indexMutations = this.indexMutationsMap.get(index.getPhysicalName().getBytes());
                        } else {
                            indexMutations = IndexUtil.generateIndexData(table, index, values, mutationsPertainingToIndex, MutationState.this.connection.getKeyValueBuilder(), MutationState.this.connection);
                        }
                    }
                    if (!sendAll) {
                        TableRef key = new TableRef(index);
                        MultiRowMutationState multiRowMutationState = (MultiRowMutationState)MutationState.this.mutations.remove(key);
                        if (multiRowMutationState != null) {
                            ArrayList deleteMutations = Lists.newArrayList();
                            MutationState.this.generateMutations(tableRef, mutationTimestamp, serverTimestamp, multiRowMutationState, deleteMutations, null);
                            if (indexMutations == null) {
                                indexMutations = deleteMutations;
                            } else {
                                indexMutations.addAll(deleteMutations);
                            }
                        }
                    }
                }
                catch (IOException | SQLException e) {
                    throw new IllegalDataException(e);
                }
                return new Pair((Object)index.getPhysicalName(), indexMutations == null ? Collections.emptyList() : indexMutations);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PhoenixTxIndexMutationGenerator newTxIndexMutationGenerator(PTable table, List<PTable> indexes, Map<String, byte[]> attributes) {
        final ArrayList indexMaintainers = Lists.newArrayListWithExpectedSize((int)indexes.size());
        for (PTable index : indexes) {
            IndexMaintainer maintainer = index.getIndexMaintainer(table, this.connection);
            indexMaintainers.add(maintainer);
        }
        IndexMetaDataCache indexMetaDataCache = new IndexMetaDataCache(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public List<IndexMaintainer> getIndexMaintainers() {
                return indexMaintainers;
            }

            @Override
            public PhoenixTransactionContext getTransactionContext() {
                return MutationState.this.phoenixTransactionContext.newTransactionContext(MutationState.this.phoenixTransactionContext, true);
            }

            @Override
            public int getClientVersion() {
                return MetaDataProtocol.PHOENIX_VERSION;
            }
        };
        try {
            PhoenixIndexMetaData indexMetaData = new PhoenixIndexMetaData(indexMetaDataCache, attributes);
            return new PhoenixTxIndexMutationGenerator(this.connection.getQueryServices().getConfiguration(), indexMetaData, table.getPhysicalName().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateMutations(TableRef tableRef, long mutationTimestamp, long serverTimestamp, MultiRowMutationState values, List<Mutation> mutationList, List<Mutation> mutationsPertainingToIndex) {
        PTable table = tableRef.getTable();
        boolean tableWithRowTimestampCol = table.getRowTimestampColPos() != -1;
        Iterator<Map.Entry<ImmutableBytesPtr, RowMutationState>> iterator = values.entrySet().iterator();
        long timestampToUse = mutationTimestamp;
        MultiRowMutationState modifiedValues = new MultiRowMutationState(16);
        while (iterator.hasNext()) {
            List<Object> rowMutationsPertainingToIndex;
            List<Mutation> rowMutations;
            Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry = iterator.next();
            byte[] onDupKeyBytes = rowEntry.getValue().getOnDupKeyBytes();
            boolean hasOnDupKey = onDupKeyBytes != null;
            ImmutableBytesPtr key = rowEntry.getKey();
            RowMutationState state2 = rowEntry.getValue();
            if (tableWithRowTimestampCol) {
                RowTimestampColInfo rowTsColInfo = state2.getRowTimestampColInfo();
                if (rowTsColInfo.useServerTimestamp()) {
                    key = MutationState.getNewRowKeyWithRowTimestamp(key, serverTimestamp, table);
                    modifiedValues.put(key, state2);
                    iterator.remove();
                    timestampToUse = serverTimestamp;
                } else if (rowTsColInfo.getTimestamp() != null) {
                    timestampToUse = rowTsColInfo.getTimestamp();
                }
            }
            PRow row = table.newRow(this.connection.getKeyValueBuilder(), timestampToUse, key, hasOnDupKey, (byte[][])new byte[0][]);
            if (rowEntry.getValue().getColumnValues() == PRow.DELETE_MARKER) {
                row.delete();
                rowMutations = row.toRowMutations();
                rowMutationsPertainingToIndex = Collections.emptyList();
            } else {
                for (Map.Entry<PColumn, byte[]> valueEntry : rowEntry.getValue().getColumnValues().entrySet()) {
                    row.setValue(valueEntry.getKey(), valueEntry.getValue());
                }
                rowMutations = row.toRowMutations();
                for (Mutation mutation : rowMutations) {
                    if (onDupKeyBytes == null) continue;
                    mutation.setAttribute("_ATOMIC_OP_ATTRIB", onDupKeyBytes);
                }
                rowMutationsPertainingToIndex = rowMutations;
            }
            mutationList.addAll(rowMutations);
            if (mutationsPertainingToIndex == null) continue;
            mutationsPertainingToIndex.addAll(rowMutationsPertainingToIndex);
        }
        values.putAll(modifiedValues);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(Long timestamp) {
        return this.toMutations(false, timestamp);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations() {
        return this.toMutations(false, null);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(boolean includeMutableIndexes) {
        return this.toMutations(includeMutableIndexes, null);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(final boolean includeMutableIndexes, Long tableTimestamp) {
        final Iterator<Map.Entry<TableRef, MultiRowMutationState>> iterator = this.mutations.entrySet().iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyIterator();
        }
        Long scn = this.connection.getSCN();
        final long serverTimestamp = MutationState.getTableTimestamp(tableTimestamp, scn);
        final long mutationTimestamp = MutationState.getMutationTimestamp(scn);
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            private Map.Entry<TableRef, MultiRowMutationState> current;
            private Iterator<Pair<byte[], List<Mutation>>> innerIterator;
            {
                this.current = (Map.Entry)iterator.next();
                this.innerIterator = this.init();
            }

            private Iterator<Pair<byte[], List<Mutation>>> init() {
                final Iterator mutationIterator = MutationState.this.addRowMutations(this.current.getKey(), this.current.getValue(), mutationTimestamp, serverTimestamp, includeMutableIndexes, true);
                return new Iterator<Pair<byte[], List<Mutation>>>(){

                    @Override
                    public boolean hasNext() {
                        return mutationIterator.hasNext();
                    }

                    @Override
                    public Pair<byte[], List<Mutation>> next() {
                        Pair pair = (Pair)mutationIterator.next();
                        return new Pair((Object)((PName)pair.getFirst()).getBytes(), pair.getSecond());
                    }

                    @Override
                    public void remove() {
                        mutationIterator.remove();
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext() || iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                if (!this.innerIterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                    this.innerIterator = this.init();
                }
                return this.innerIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static long getTableTimestamp(Long tableTimestamp, Long scn) {
        return tableTimestamp != null && tableTimestamp != -1L ? tableTimestamp : (scn == null ? Long.MAX_VALUE : scn);
    }

    public static long getMutationTimestamp(Long scn) {
        return scn == null ? Long.MAX_VALUE : scn;
    }

    private long[] validateAll() throws SQLException {
        int i = 0;
        long[] timeStamps = new long[this.mutations.size()];
        for (Map.Entry<TableRef, MultiRowMutationState> entry : this.mutations.entrySet()) {
            TableRef tableRef = entry.getKey();
            timeStamps[i++] = this.validateAndGetServerTimestamp(tableRef, entry.getValue());
        }
        return timeStamps;
    }

    private long validateAndGetServerTimestamp(TableRef tableRef, MultiRowMutationState rowKeyToColumnMap) throws SQLException {
        Long scn = this.connection.getSCN();
        MetaDataClient client = new MetaDataClient(this.connection);
        long serverTimeStamp = tableRef.getTimeStamp();
        PTable table = tableRef.getTable();
        MetaDataProtocol.MetaDataMutationResult result = client.updateCache(table.getSchemaName().getString(), table.getTableName().getString());
        PTable resolvedTable = result.getTable();
        if (resolvedTable == null) {
            throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
        }
        tableRef.setTable(resolvedTable);
        List<PTable> indexes = resolvedTable.getIndexes();
        for (PTable idxTtable : indexes) {
            if (idxTtable.getIndexState() != PIndexState.ACTIVE && idxTtable.getIndexState() != PIndexState.PENDING_ACTIVE || idxTtable.getIndexDisableTimestamp() <= 0L) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_FAILURE_BLOCK_WRITE).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
        }
        long timestamp = result.getMutationTime();
        if (timestamp != -1L) {
            serverTimeStamp = timestamp;
            if (result.wasUpdated()) {
                ArrayList columns = Lists.newArrayListWithExpectedSize((int)table.getColumns().size());
                for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : rowKeyToColumnMap.entrySet()) {
                    Map<PColumn, byte[]> colValues;
                    RowMutationState valueEntry = rowEntry.getValue();
                    if (valueEntry == null || (colValues = valueEntry.getColumnValues()) == PRow.DELETE_MARKER) continue;
                    for (PColumn column : colValues.keySet()) {
                        if (column.isDynamic()) continue;
                        columns.add(column);
                    }
                }
                for (PColumn column : columns) {
                    if (column == null) continue;
                    resolvedTable.getColumnFamily(column.getFamilyName().getString()).getPColumnForColumnName(column.getName().getString());
                }
            }
        }
        return serverTimeStamp == -1L ? Long.MAX_VALUE : serverTimeStamp;
    }

    private static long calculateMutationSize(List<Mutation> mutations) {
        long byteSize = 0L;
        if (GlobalClientMetrics.isMetricsEnabled()) {
            for (Mutation mutation : mutations) {
                byteSize += KeyValueUtil.calculateMutationDiskSize(mutation);
            }
        }
        GlobalClientMetrics.GLOBAL_MUTATION_BYTES.update(byteSize);
        return byteSize;
    }

    public long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Iterator<TableRef> tableRefIterator) throws SQLException {
        int i = 0;
        long[] serverTimeStamps = null;
        boolean sendAll = false;
        if (tableRefIterator == null) {
            serverTimeStamps = this.validateAll();
            tableRefIterator = this.mutations.keySet().iterator();
            sendAll = true;
        }
        LinkedHashMap physicalTableMutationMap = Maps.newLinkedHashMap();
        try (TraceScope trace = Tracing.startNewSpan(this.connection, "Committing mutations to tables");){
            Span span = trace.getSpan();
            ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable();
            while (tableRefIterator.hasNext()) {
                TableRef tableRef = tableRefIterator.next();
                MultiRowMutationState multiRowMutationState = this.mutations.get(tableRef);
                if (multiRowMutationState == null || multiRowMutationState.isEmpty()) continue;
                long serverTimestamp = serverTimeStamps == null ? this.validateAndGetServerTimestamp(tableRef, multiRowMutationState) : serverTimeStamps[i++];
                Long scn = this.connection.getSCN();
                long mutationTimestamp = scn == null ? Long.MAX_VALUE : scn;
                PTable table = tableRef.getTable();
                Iterator<Pair<PName, List<Mutation>>> mutationsIterator = this.addRowMutations(tableRef, multiRowMutationState, mutationTimestamp, serverTimestamp, false, sendAll);
                boolean isDataTable = true;
                while (mutationsIterator.hasNext()) {
                    List mutationList;
                    Pair<PName, List<Mutation>> pair = mutationsIterator.next();
                    PName hTableName = (PName)pair.getFirst();
                    TableInfo tableInfo = new TableInfo(isDataTable, hTableName, tableRef);
                    List oldMutationList = physicalTableMutationMap.put(tableInfo, mutationList = (List)pair.getSecond());
                    if (oldMutationList != null) {
                        mutationList.addAll(0, oldMutationList);
                    }
                    isDataTable = false;
                }
                if (!table.isTransactional()) continue;
                this.addUncommittedStatementIndexes(multiRowMutationState.values());
                if (this.txMutations.isEmpty()) {
                    this.txMutations = Maps.newHashMapWithExpectedSize((int)this.mutations.size());
                }
                this.joinMutationState(new TableRef(tableRef), multiRowMutationState, this.txMutations);
            }
            long serverTimestamp = Long.MAX_VALUE;
            for (Map.Entry pair : physicalTableMutationMap.entrySet()) {
                TableInfo tableInfo = (TableInfo)pair.getKey();
                byte[] htableName = tableInfo.getHTableName().getBytes();
                List mutationList = (List)pair.getValue();
                Span child = Tracing.child(span, "Writing mutation batch for table: " + Bytes.toString((byte[])htableName));
                int retryCount = 0;
                boolean shouldRetry = false;
                long numMutations = 0L;
                long mutationSizeBytes = 0L;
                long mutationCommitTime = 0L;
                long numFailedMutations = 0L;
                long startTime = 0L;
                boolean shouldRetryIndexedMutation = false;
                IndexWriteException iwe = null;
                do {
                    TableRef origTableRef = tableInfo.getOrigTableRef();
                    PTable table = origTableRef.getTable();
                    table.getIndexMaintainers(indexMetaDataPtr, this.connection);
                    ServerCacheClient.ServerCache cache = tableInfo.isDataTable() ? this.setMetaDataOnMutations(origTableRef, mutationList, indexMetaDataPtr) : null;
                    shouldRetry = cache != null;
                    SQLException sqlE = null;
                    HTableInterface hTable = this.connection.getQueryServices().getTable(htableName);
                    try {
                        if (table.isTransactional()) {
                            this.uncommittedPhysicalNames.add(table.getPhysicalName().getString());
                            this.phoenixTransactionContext.markDMLFence(table);
                            if (!table.getIndexes().isEmpty()) {
                                hTable = new MetaDataAwareHTable(hTable, origTableRef);
                            }
                            hTable = this.phoenixTransactionContext.getTransactionalTableWriter(hTable, table);
                        }
                        numMutations = mutationList.size();
                        GlobalClientMetrics.GLOBAL_MUTATION_BATCH_SIZE.update(numMutations);
                        mutationSizeBytes = MutationState.calculateMutationSize(mutationList);
                        startTime = System.currentTimeMillis();
                        child.addTimelineAnnotation("Attempt " + retryCount);
                        List<List<Mutation>> mutationBatchList = MutationState.getMutationBatchList(this.batchSize, this.batchSizeBytes, mutationList);
                        for (final List<Mutation> mutationBatch : mutationBatchList) {
                            if (shouldRetryIndexedMutation) {
                                final HTableInterface finalHTable = hTable;
                                PhoenixIndexFailurePolicy.doBatchWithRetries(new PhoenixIndexFailurePolicy.MutateCommand(){

                                    @Override
                                    public void doMutation() throws IOException {
                                        try {
                                            finalHTable.batch(mutationBatch);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                            throw new IOException(e);
                                        }
                                    }
                                }, iwe, this.connection, this.connection.getQueryServices().getProps());
                            } else {
                                hTable.batch(mutationBatch);
                            }
                            ++this.batchCount;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Sent batch of " + mutationBatch.size() + " for " + Bytes.toString((byte[])htableName));
                        }
                        child.stop();
                        child.stop();
                        shouldRetry = false;
                        mutationCommitTime = System.currentTimeMillis() - startTime;
                        GlobalClientMetrics.GLOBAL_MUTATION_COMMIT_TIME.update(mutationCommitTime);
                        numFailedMutations = 0L;
                        this.mutations.remove(origTableRef);
                        if (!tableInfo.isDataTable()) continue;
                        this.numRows = (int)((long)this.numRows - numMutations);
                        this.estimatedSize = KeyValueUtil.getEstimatedRowMutationSize(this.mutations);
                    }
                    catch (Exception e2) {
                        SQLException e2;
                        mutationCommitTime = System.currentTimeMillis() - startTime;
                        serverTimestamp = ServerUtil.parseServerTimestamp(e2);
                        SQLException inferredE = ServerUtil.parseServerExceptionOrNull(e2);
                        if (inferredE != null) {
                            if (shouldRetry && retryCount == 0 && inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) {
                                String msg = "Swallowing exception and retrying after clearing meta cache on connection. " + inferredE;
                                logger.warn(LogUtil.addCustomAnnotations(msg, this.connection));
                                this.connection.getQueryServices().clearTableRegionCache(htableName);
                                child.addTimelineAnnotation(msg);
                                child.stop();
                                child = Tracing.child(span, "Failed batch, attempting retry");
                            }
                            if (inferredE.getErrorCode() == SQLExceptionCode.INDEX_WRITE_FAILURE.getErrorCode() && (iwe = PhoenixIndexFailurePolicy.getIndexWriteException(inferredE)) != null && !shouldRetryIndexedMutation) {
                                for (Mutation m : mutationList) {
                                    m.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_ONLY_INDEX_WRITES);
                                    KeyValueUtil.setTimestamp(m, serverTimestamp);
                                }
                                shouldRetry = true;
                                shouldRetryIndexedMutation = true;
                            }
                            e2 = inferredE;
                        }
                        int[] uncommittedStatementIndexes = this.getUncommittedStatementIndexes();
                        sqlE = new CommitException(e2, uncommittedStatementIndexes, serverTimestamp);
                        numFailedMutations = uncommittedStatementIndexes.length;
                        GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.update(numFailedMutations);
                    }
                    finally {
                        MutationMetricQueue.MutationMetric mutationsMetric = new MutationMetricQueue.MutationMetric(numMutations, mutationSizeBytes, mutationCommitTime, numFailedMutations);
                        this.mutationMetricQueue.addMetricsForTable(Bytes.toString((byte[])htableName), mutationsMetric);
                        try {
                            if (cache != null) {
                                cache.close();
                            }
                        }
                        finally {
                            try {
                                hTable.close();
                            }
                            catch (IOException e) {
                                if (sqlE != null) {
                                    sqlE.setNextException(ServerUtil.parseServerException(e));
                                }
                                sqlE = ServerUtil.parseServerException(e);
                            }
                            if (sqlE == null) continue;
                            throw sqlE;
                        }
                    }
                } while (shouldRetry && retryCount++ < 1);
            }
        }
    }

    public static List<List<Mutation>> getMutationBatchList(long batchSize, long batchSizeBytes, List<Mutation> allMutationList) {
        ArrayList mutationBatchList = Lists.newArrayList();
        ArrayList currentList = Lists.newArrayList();
        long currentBatchSizeBytes = 0L;
        for (Mutation mutation : allMutationList) {
            long mutationSizeBytes = KeyValueUtil.calculateMutationDiskSize(mutation);
            if (((long)currentList.size() == batchSize || currentBatchSizeBytes + mutationSizeBytes > batchSizeBytes) && currentList.size() > 0) {
                mutationBatchList.add(currentList);
                currentList = Lists.newArrayList();
                currentBatchSizeBytes = 0L;
            }
            currentList.add(mutation);
            currentBatchSizeBytes += mutationSizeBytes;
        }
        if (currentList.size() > 0) {
            mutationBatchList.add(currentList);
        }
        return mutationBatchList;
    }

    public byte[] encodeTransaction() throws SQLException {
        return this.phoenixTransactionContext.encodeTransaction();
    }

    private ServerCacheClient.ServerCache setMetaDataOnMutations(TableRef tableRef, List<? extends Mutation> mutations, ImmutableBytesWritable indexMetaDataPtr) throws SQLException {
        boolean hasIndexMetaData;
        PTable table = tableRef.getTable();
        byte[] tenantIdBytes = table.isMultiTenant() ? (this.connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, this.connection.getTenantId(), table.getViewIndexId() != null)) : (this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes());
        ServerCacheClient.ServerCache cache = null;
        byte[] attribValue = null;
        byte[] uuidValue = null;
        byte[] txState = ByteUtil.EMPTY_BYTE_ARRAY;
        if (table.isTransactional()) {
            txState = this.encodeTransaction();
        }
        boolean bl = hasIndexMetaData = indexMetaDataPtr.getLength() > 0;
        if (hasIndexMetaData) {
            if (IndexMetaDataCacheClient.useIndexMetadataCache(this.connection, mutations, indexMetaDataPtr.getLength() + txState.length)) {
                IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(this.connection, tableRef);
                cache = client.addIndexMetadataCache(mutations, indexMetaDataPtr, txState);
                uuidValue = cache.getId();
            } else {
                attribValue = ByteUtil.copyKeyBytesIfNecessary(indexMetaDataPtr);
                uuidValue = ServerCacheClient.generateId();
            }
        } else if (txState.length == 0) {
            return null;
        }
        for (Mutation mutation : mutations) {
            if (this.connection.getTenantId() != null) {
                mutation.setAttribute("TenantId", tenantIdBytes);
            }
            mutation.setAttribute("IdxUUID", uuidValue);
            if (attribValue != null) {
                mutation.setAttribute("IdxProtoMD", attribValue);
                mutation.setAttribute("_ClientVersion", Bytes.toBytes((int)MetaDataProtocol.PHOENIX_VERSION));
                if (txState.length <= 0) continue;
                mutation.setAttribute("_TxState", txState);
                continue;
            }
            if (hasIndexMetaData || txState.length <= 0) continue;
            mutation.setAttribute("_TxState", txState);
        }
        return cache;
    }

    private void addUncommittedStatementIndexes(Collection<RowMutationState> rowMutations) {
        for (RowMutationState rowMutationState : rowMutations) {
            this.uncommittedStatementIndexes = MutationState.joinSortedIntArrays(this.uncommittedStatementIndexes, rowMutationState.getStatementIndexes());
        }
    }

    private int[] getUncommittedStatementIndexes() {
        for (MultiRowMutationState rowMutationMap : this.mutations.values()) {
            this.addUncommittedStatementIndexes(rowMutationMap.values());
        }
        return this.uncommittedStatementIndexes;
    }

    @Override
    public void close() throws SQLException {
    }

    private void resetState() {
        this.numRows = 0;
        this.estimatedSize = 0L;
        this.mutations.clear();
        this.phoenixTransactionContext = PhoenixTransactionContext.NULL_CONTEXT;
    }

    private void resetTransactionalState() {
        this.phoenixTransactionContext.reset();
        this.txMutations = Collections.emptyMap();
        this.uncommittedPhysicalNames.clear();
        this.uncommittedStatementIndexes = EMPTY_STATEMENT_INDEX_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        try {
            this.phoenixTransactionContext.abort();
        }
        finally {
            this.resetState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void commit() throws SQLException {
        txMutations = Collections.emptyMap();
        retryCount = 0;
        while (true) {
            sendSuccessful = false;
            retryCommit = false;
            sqlE = null;
            this.send();
            txMutations = this.txMutations;
            sendSuccessful = true;
            try {
                finishSuccessful = false;
                try {
                    if (!sendSuccessful) ** GOTO lbl232
                    this.phoenixTransactionContext.commit();
                    finishSuccessful = true;
                }
                catch (SQLException e) {
                    if (MutationState.logger.isInfoEnabled()) {
                        MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                    }
                    v0 = retryCommit = e.getErrorCode() == SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode() && retryCount < 3;
                    if (sqlE == null) {
                        sqlE = e;
                    }
                    sqlE.setNextException(e);
                }
                finally {
                    if (!finishSuccessful) {
                        try {
                            this.phoenixTransactionContext.abort();
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort successful");
                            }
                        }
                        catch (SQLException e) {
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort failed with " + e);
                            }
                            if (sqlE == null) {
                                sqlE = e;
                            }
                            sqlE.setNextException(e);
                        }
                    }
                }
            }
            finally {
                provider = this.phoenixTransactionContext.getProvider();
                try {
                    this.resetState();
                }
                finally {
                    if (retryCommit) {
                        this.startTransaction(provider);
                        txTableRefs = txMutations.keySet();
                        for (TableRef tableRef : txTableRefs) {
                            dataTable = tableRef.getTable();
                            this.phoenixTransactionContext.markDMLFence(dataTable);
                        }
                        try {
                            retryCommit = this.shouldResubmitTransaction(txTableRefs);
                        }
                        catch (SQLException e) {
                            retryCommit = false;
                            if (sqlE == null) {
                                sqlE = e;
                            }
                            sqlE.setNextException(e);
                        }
                    }
                    if (sqlE != null && !retryCommit) {
                        throw sqlE;
                    }
                }
            }
            catch (SQLException e) {
                sqlE = e;
                try {
                    block126: {
                        finishSuccessful = false;
                        if (sendSuccessful) {
                            this.phoenixTransactionContext.commit();
                            finishSuccessful = true;
                        }
                        if (finishSuccessful) break block126;
                        try {
                            this.phoenixTransactionContext.abort();
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort successful");
                            }
                            ** break block134
                        }
                        catch (SQLException e) {
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info("Abort failed with " + e);
                            }
                            if (sqlE == null) {
                                sqlE = e;
                            }
                            sqlE.setNextException(e);
                        }
                        catch (SQLException e) {
                            try {
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                                }
                                v1 = retryCommit = e.getErrorCode() == SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode() && retryCount < 3;
                                if (sqlE == null) {
                                    sqlE = e;
                                } else {
                                    sqlE.setNextException(e);
                                }
                                if (finishSuccessful) ** break block127
                            }
                            catch (Throwable var27_43) {
                                block128: {
                                    if (!finishSuccessful) {
                                        try {
                                            this.phoenixTransactionContext.abort();
                                            if (MutationState.logger.isInfoEnabled()) {
                                                MutationState.logger.info("Abort successful");
                                            }
                                        }
                                        catch (SQLException e) {
                                            if (MutationState.logger.isInfoEnabled()) {
                                                MutationState.logger.info("Abort failed with " + e);
                                            }
                                            if (sqlE == null) {
                                                sqlE = e;
                                                break block128;
                                            }
                                            sqlE.setNextException(e);
                                        }
                                    }
                                }
                                throw var27_43;
                            }
                            try {
                                this.phoenixTransactionContext.abort();
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort successful");
                                }
                                ** break block135
                            }
                            catch (SQLException e) {
                                if (MutationState.logger.isInfoEnabled()) {
                                    MutationState.logger.info("Abort failed with " + e);
                                }
                                if (sqlE == null) {
                                    sqlE = e;
                                }
                                sqlE.setNextException(e);
                            }
                        }
                    }
                    {
lbl-1000:
                        // 1 sources

                        {
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                }
                finally {
                    provider = this.phoenixTransactionContext.getProvider();
                    try {
                        this.resetState();
                    }
                    finally {
                        block129: {
                            if (retryCommit) {
                                this.startTransaction(provider);
                                txTableRefs = txMutations.keySet();
                                for (TableRef tableRef : txTableRefs) {
                                    dataTable = tableRef.getTable();
                                    this.phoenixTransactionContext.markDMLFence(dataTable);
                                }
                                try {
                                    retryCommit = this.shouldResubmitTransaction(txTableRefs);
                                }
                                catch (SQLException e) {
                                    retryCommit = false;
                                    if (sqlE == null) {
                                        sqlE = e;
                                        break block129;
                                    }
                                    sqlE.setNextException(e);
                                }
                            }
                        }
                        if (sqlE != null && !retryCommit) {
                            throw sqlE;
                        }
                    }
                }
                catch (Throwable var45_64) {
                    try {
                        finishSuccessful = false;
                        try {
                            if (sendSuccessful) {
                                this.phoenixTransactionContext.commit();
                                finishSuccessful = true;
                            }
                        }
                        catch (SQLException e) {
                            if (MutationState.logger.isInfoEnabled()) {
                                MutationState.logger.info(e.getClass().getName() + " at timestamp " + this.getInitialWritePointer() + " with retry count of " + retryCount);
                            }
                            v2 = retryCommit = e.getErrorCode() == SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION.getErrorCode() && retryCount < 3;
                            if (sqlE == null) {
                                sqlE = e;
                            } else {
                                sqlE.setNextException(e);
                            }
                        }
                        finally {
                            block131: {
                                if (!finishSuccessful) {
                                    try {
                                        this.phoenixTransactionContext.abort();
                                        if (MutationState.logger.isInfoEnabled()) {
                                            MutationState.logger.info("Abort successful");
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (MutationState.logger.isInfoEnabled()) {
                                            MutationState.logger.info("Abort failed with " + e);
                                        }
                                        if (sqlE == null) {
                                            sqlE = e;
                                            break block131;
                                        }
                                        sqlE.setNextException(e);
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        provider = this.phoenixTransactionContext.getProvider();
                        try {
                            this.resetState();
                        }
                        finally {
                            block133: {
                                if (retryCommit) {
                                    this.startTransaction(provider);
                                    txTableRefs = txMutations.keySet();
                                    for (TableRef tableRef : txTableRefs) {
                                        dataTable = tableRef.getTable();
                                        this.phoenixTransactionContext.markDMLFence(dataTable);
                                    }
                                    try {
                                        retryCommit = this.shouldResubmitTransaction(txTableRefs);
                                    }
                                    catch (SQLException e) {
                                        retryCommit = false;
                                        if (sqlE == null) {
                                            sqlE = e;
                                            break block133;
                                        }
                                        sqlE.setNextException(e);
                                    }
                                }
                            }
                            if (sqlE != null && !retryCommit) {
                                throw sqlE;
                            }
                        }
                    }
                    throw var45_64;
                }
            }
lbl232:
            // 5 sources

            if (!retryCommit) break;
            ++retryCount;
            this.mutations.putAll(txMutations);
        }
    }

    private boolean shouldResubmitTransaction(Set<TableRef> txTableRefs) throws SQLException {
        if (logger.isInfoEnabled()) {
            logger.info("Checking for index updates as of " + this.getInitialWritePointer());
        }
        MetaDataClient client = new MetaDataClient(this.connection);
        PMetaData cache = this.connection.getMetaDataCache();
        boolean addedAnyIndexes = false;
        boolean allImmutableTables = !txTableRefs.isEmpty();
        for (TableRef tableRef : txTableRefs) {
            PTable dataTable = tableRef.getTable();
            PTableRef ptableRef = cache.getTableRef(dataTable.getKey());
            List<PTable> oldIndexes = ptableRef.getTable().getIndexes();
            MetaDataProtocol.MetaDataMutationResult result = client.updateCache(dataTable.getTenantId(), dataTable.getSchemaName().getString(), dataTable.getTableName().getString(), true);
            long timestamp = TransactionUtil.getResolvedTime(this.connection, result);
            tableRef.setTimeStamp(timestamp);
            PTable updatedDataTable = result.getTable();
            if (updatedDataTable == null) {
                throw new TableNotFoundException(dataTable.getSchemaName().getString(), dataTable.getTableName().getString());
            }
            allImmutableTables &= updatedDataTable.isImmutableRows();
            tableRef.setTable(updatedDataTable);
            if (addedAnyIndexes) continue;
            boolean bl = addedAnyIndexes = !oldIndexes.equals(updatedDataTable.getIndexes());
            if (!logger.isInfoEnabled()) continue;
            logger.info((addedAnyIndexes ? "Updates " : "No updates ") + "as of " + timestamp + " to " + updatedDataTable.getName().getString() + " with indexes " + updatedDataTable.getIndexes());
        }
        if (logger.isInfoEnabled()) {
            logger.info((addedAnyIndexes ? "Updates " : "No updates ") + "to indexes as of " + this.getInitialWritePointer() + " over " + (allImmutableTables ? " all immutable tables" : " some mutable tables"));
        }
        return allImmutableTables || addedAnyIndexes;
    }

    public boolean sendUncommitted() throws SQLException {
        return this.sendUncommitted(this.mutations.keySet().iterator());
    }

    public boolean sendUncommitted(Iterator<TableRef> tableRefs) throws SQLException {
        UnmodifiableIterator filteredTableRefs;
        if (this.phoenixTransactionContext.isTransactionRunning()) {
            this.phoenixTransactionContext.setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT);
        }
        if ((filteredTableRefs = Iterators.filter(tableRefs, (Predicate)new Predicate<TableRef>(){

            public boolean apply(TableRef tableRef) {
                return tableRef.getTable().isTransactional();
            }
        })).hasNext()) {
            ArrayList strippedAliases = Lists.newArrayListWithExpectedSize((int)this.mutations.keySet().size());
            while (filteredTableRefs.hasNext()) {
                TableRef tableRef = (TableRef)filteredTableRefs.next();
                if (tableRef.getTable().isTransactional()) {
                    this.startTransaction(tableRef.getTable().getTransactionProvider());
                }
                strippedAliases.add(new TableRef(null, tableRef.getTable(), tableRef.getTimeStamp(), tableRef.getLowerBoundTimeStamp(), tableRef.hasDynamicCols()));
            }
            this.send(strippedAliases.iterator());
            return true;
        }
        return false;
    }

    public void send() throws SQLException {
        this.send(null);
    }

    public static int[] joinSortedIntArrays(int[] a, int[] b) {
        int current;
        int[] result = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            int n = current = a[i] < b[j] ? a[i++] : b[j++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        while (i < a.length) {
            current = a[i++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            result[k++] = current;
        }
        while (j < b.length) {
            current = b[j++];
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        return Arrays.copyOf(result, k);
    }

    public ReadMetricQueue getReadMetricQueue() {
        return this.readMetricQueue;
    }

    public void setReadMetricQueue(ReadMetricQueue readMetricQueue) {
        this.readMetricQueue = readMetricQueue;
    }

    public MutationMetricQueue getMutationMetricQueue() {
        return this.mutationMetricQueue;
    }

    public static class RowMutationState {
        @Nonnull
        private Map<PColumn, byte[]> columnValues;
        private int[] statementIndexes;
        @Nonnull
        private final RowTimestampColInfo rowTsColInfo;
        private byte[] onDupKeyBytes;
        private long colValuesSize;

        public RowMutationState(@Nonnull Map<PColumn, byte[]> columnValues, long colValuesSize, int statementIndex, @Nonnull RowTimestampColInfo rowTsColInfo, byte[] onDupKeyBytes) {
            Preconditions.checkNotNull(columnValues);
            Preconditions.checkNotNull((Object)rowTsColInfo);
            this.columnValues = columnValues;
            this.statementIndexes = new int[]{statementIndex};
            this.rowTsColInfo = rowTsColInfo;
            this.onDupKeyBytes = onDupKeyBytes;
            this.colValuesSize = colValuesSize;
        }

        public long calculateEstimatedSize() {
            return this.colValuesSize + (long)(this.statementIndexes.length * 4) + 8L + (long)(this.onDupKeyBytes != null ? this.onDupKeyBytes.length : 0);
        }

        byte[] getOnDupKeyBytes() {
            return this.onDupKeyBytes;
        }

        public Map<PColumn, byte[]> getColumnValues() {
            return this.columnValues;
        }

        int[] getStatementIndexes() {
            return this.statementIndexes;
        }

        void join(RowMutationState newRow) {
            if (newRow.onDupKeyBytes == null) {
                this.colValuesSize += newRow.colValuesSize;
                for (Map.Entry<PColumn, byte[]> entry : newRow.columnValues.entrySet()) {
                    PColumn col = entry.getKey();
                    byte[] oldValue = this.columnValues.put(col, entry.getValue());
                    if (oldValue == null) continue;
                    this.colValuesSize -= (long)(col.getEstimatedSize() + oldValue.length);
                }
            }
            this.onDupKeyBytes = PhoenixIndexBuilder.combineOnDupKey(this.onDupKeyBytes, newRow.onDupKeyBytes);
            this.statementIndexes = MutationState.joinSortedIntArrays(this.statementIndexes, newRow.getStatementIndexes());
        }

        @Nonnull
        RowTimestampColInfo getRowTimestampColInfo() {
            return this.rowTsColInfo;
        }
    }

    public static class MultiRowMutationState {
        private Map<ImmutableBytesPtr, RowMutationState> rowKeyToRowMutationState;
        private long estimatedSize;

        public MultiRowMutationState(int size) {
            this.rowKeyToRowMutationState = Maps.newHashMapWithExpectedSize((int)size);
            this.estimatedSize = 0L;
        }

        public RowMutationState put(ImmutableBytesPtr ptr, RowMutationState rowMutationState) {
            this.estimatedSize += rowMutationState.calculateEstimatedSize();
            return this.rowKeyToRowMutationState.put(ptr, rowMutationState);
        }

        public void putAll(MultiRowMutationState other) {
            this.estimatedSize += other.estimatedSize;
            this.rowKeyToRowMutationState.putAll(other.rowKeyToRowMutationState);
        }

        public boolean isEmpty() {
            return this.rowKeyToRowMutationState.isEmpty();
        }

        public int size() {
            return this.rowKeyToRowMutationState.size();
        }

        public Set<Map.Entry<ImmutableBytesPtr, RowMutationState>> entrySet() {
            return this.rowKeyToRowMutationState.entrySet();
        }

        public void clear() {
            this.rowKeyToRowMutationState.clear();
            this.estimatedSize = 0L;
        }

        public Collection<RowMutationState> values() {
            return this.rowKeyToRowMutationState.values();
        }
    }

    @Immutable
    public static class RowTimestampColInfo {
        private final boolean useServerTimestamp;
        private final Long rowTimestamp;
        public static final RowTimestampColInfo NULL_ROWTIMESTAMP_INFO = new RowTimestampColInfo(false, null);

        public RowTimestampColInfo(boolean autoGenerate, Long value) {
            this.useServerTimestamp = autoGenerate;
            this.rowTimestamp = value;
        }

        public boolean useServerTimestamp() {
            return this.useServerTimestamp;
        }

        public Long getTimestamp() {
            return this.rowTimestamp;
        }
    }

    private static class TableInfo {
        private final boolean isDataTable;
        @Nonnull
        private final PName hTableName;
        @Nonnull
        private final TableRef origTableRef;

        public TableInfo(boolean isDataTable, PName hTableName, TableRef origTableRef) {
            Preconditions.checkNotNull((Object)hTableName);
            Preconditions.checkNotNull((Object)origTableRef);
            this.isDataTable = isDataTable;
            this.hTableName = hTableName;
            this.origTableRef = origTableRef;
        }

        public boolean isDataTable() {
            return this.isDataTable;
        }

        public PName getHTableName() {
            return this.hTableName;
        }

        public TableRef getOrigTableRef() {
            return this.origTableRef;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hTableName.hashCode();
            result = 31 * result + (this.isDataTable ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableInfo other = (TableInfo)obj;
            if (!this.hTableName.equals(other.hTableName)) {
                return false;
            }
            return this.isDataTable == other.isDataTable;
        }
    }

    private class MetaDataAwareHTable
    extends DelegateHTable {
        private final TableRef tableRef;

        private MetaDataAwareHTable(HTableInterface delegate, TableRef tableRef) {
            super(delegate);
            this.tableRef = tableRef;
        }

        @Override
        public void delete(List<Delete> deletes) throws IOException {
            ServerCacheClient.ServerCache cache = null;
            try {
                List indexes;
                ImmutableBytesWritable indexMetaDataPtr;
                if (deletes.isEmpty()) {
                    return;
                }
                PTable table = this.tableRef.getTable();
                if (table.getIndexMaintainers(indexMetaDataPtr = new ImmutableBytesWritable(), MutationState.this.connection)) {
                    cache = MutationState.this.setMetaDataOnMutations(this.tableRef, deletes, indexMetaDataPtr);
                }
                if (!(indexes = MutationState.getClientMaintainedIndexes(table)).isEmpty()) {
                    PhoenixTxIndexMutationGenerator generator = MutationState.this.newTxIndexMutationGenerator(table, indexes, deletes.get(0).getAttributesMap());
                    Collection<Pair<Mutation, byte[]>> indexUpdates = generator.getIndexUpdates(this.delegate, deletes.iterator());
                    for (PTable index : indexes) {
                        byte[] physicalName = index.getPhysicalName().getBytes();
                        try {
                            HTableInterface hindex = MutationState.this.connection.getQueryServices().getTable(physicalName);
                            Throwable throwable = null;
                            try {
                                ArrayList indexDeletes = Lists.newArrayListWithExpectedSize((int)deletes.size());
                                for (Pair<Mutation, byte[]> mutationPair : indexUpdates) {
                                    if (Bytes.equals((byte[])((byte[])mutationPair.getSecond()), (byte[])physicalName)) {
                                        indexDeletes.add(mutationPair.getFirst());
                                    }
                                    hindex.batch((List)indexDeletes);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (hindex == null) continue;
                                if (throwable != null) {
                                    try {
                                        hindex.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                hindex.close();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException(e);
                        }
                    }
                }
                this.delegate.delete(deletes);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            finally {
                if (cache != null) {
                    SQLCloseables.closeAllQuietly(Collections.singletonList(cache));
                }
            }
        }
    }
}

