/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SQLCloseables;

public class LiteralResultIterationPlan
extends BaseQueryPlan {
    protected final Iterable<Tuple> tuples;

    public LiteralResultIterationPlan(StatementContext context, FilterableStatement statement, TableRef tableRef, RowProjector projection, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        this(Collections.singletonList(new SingleKeyValueTuple((Cell)KeyValue.LOWESTKEY)), context, statement, tableRef, projection, limit, offset, orderBy, parallelIteratorFactory);
    }

    public LiteralResultIterationPlan(Iterable<Tuple> tuples, StatementContext context, FilterableStatement statement, TableRef tableRef, RowProjector projection, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        super(context, statement, tableRef, projection, context.getBindManager().getParameterMetaData(), limit, offset, orderBy, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, parallelIteratorFactory, null, null);
        this.tuples = tuples;
    }

    @Override
    public Cost getCost() {
        return Cost.ZERO;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.emptyList();
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.emptyList();
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected ResultIterator newIterator(ParallelScanGrouper scanGrouper, Scan scan, final Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches) throws SQLException {
        ResultIterator scanner = new ResultIterator(){
            private final Iterator<Tuple> tupleIterator;
            private boolean closed;
            private int count;
            private int offsetCount;
            {
                this.tupleIterator = LiteralResultIterationPlan.this.tuples.iterator();
                this.closed = false;
                this.count = 0;
                this.offsetCount = 0;
            }

            @Override
            public void close() throws SQLException {
                SQLCloseables.closeAll(caches.values());
                this.closed = true;
            }

            @Override
            public Tuple next() throws SQLException {
                while (!this.closed && LiteralResultIterationPlan.this.offset != null && this.offsetCount < LiteralResultIterationPlan.this.offset && this.tupleIterator.hasNext()) {
                    ++this.offsetCount;
                    this.tupleIterator.next();
                }
                if (!this.closed && (LiteralResultIterationPlan.this.limit == null || this.count++ < LiteralResultIterationPlan.this.limit) && this.tupleIterator.hasNext()) {
                    return this.tupleIterator.next();
                }
                return null;
            }

            @Override
            public void explain(List<String> planSteps) {
            }
        };
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            scanner = new SequenceResultIterator(scanner, this.context.getSequenceManager());
        }
        return scanner;
    }

    @Override
    public Long getEstimatedRowsToScan() {
        return 0L;
    }

    @Override
    public Long getEstimatedBytesToScan() {
        return 0L;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        return 0L;
    }
}

