/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.RuntimeContext;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.execute.visitor.RowCountVisitor;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SchemaUtil;

public class CorrelatePlan
extends DelegateQueryPlan {
    private final QueryPlan rhs;
    private final String variableId;
    private final JoinTableNode.JoinType joinType;
    private final boolean isSingleValueOnly;
    private final RuntimeContext runtimeContext;
    private final KeyValueSchema joinedSchema;
    private final KeyValueSchema lhsSchema;
    private final KeyValueSchema rhsSchema;
    private final int rhsFieldPosition;

    public CorrelatePlan(QueryPlan lhs, QueryPlan rhs, String variableId, JoinTableNode.JoinType joinType, boolean isSingleValueOnly, RuntimeContext runtimeContext, PTable joinedTable, PTable lhsTable, PTable rhsTable, int rhsFieldPosition) {
        super(lhs);
        if (joinType != JoinTableNode.JoinType.Inner && joinType != JoinTableNode.JoinType.Left && joinType != JoinTableNode.JoinType.Semi && joinType != JoinTableNode.JoinType.Anti) {
            throw new IllegalArgumentException("Unsupported join type '" + (Object)((Object)joinType) + "' by CorrelatePlan");
        }
        this.rhs = rhs;
        this.variableId = variableId;
        this.joinType = joinType;
        this.isSingleValueOnly = isSingleValueOnly;
        this.runtimeContext = runtimeContext;
        this.joinedSchema = CorrelatePlan.buildSchema(joinedTable);
        this.lhsSchema = CorrelatePlan.buildSchema(lhsTable);
        this.rhsSchema = CorrelatePlan.buildSchema(rhsTable);
        this.rhsFieldPosition = rhsFieldPosition;
    }

    private static KeyValueSchema buildSchema(PTable table) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        if (table != null) {
            for (PColumn column : table.getColumns()) {
                if (SchemaUtil.isPKColumn(column)) continue;
                builder.addField(column);
            }
        }
        return builder.build();
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList steps = Lists.newArrayList();
        steps.add("NESTED-LOOP-JOIN (" + this.joinType.toString().toUpperCase() + ") TABLES");
        for (String step : this.delegate.getExplainPlan().getPlanSteps()) {
            steps.add("    " + step);
        }
        steps.add("AND" + (this.rhsSchema.getFieldCount() == 0 ? " (SKIP MERGE)" : ""));
        for (String step : this.rhs.getExplainPlan().getPlanSteps()) {
            steps.add("    " + step);
        }
        return new ExplainPlan(steps);
    }

    @Override
    public ResultIterator iterator(final ParallelScanGrouper scanGrouper, final Scan scan) throws SQLException {
        return new ResultIterator(){
            private final ValueBitSet destBitSet;
            private final ValueBitSet lhsBitSet;
            private final ValueBitSet rhsBitSet;
            private final ResultIterator iter;
            private ResultIterator rhsIter;
            private Tuple current;
            private boolean closed;
            {
                this.destBitSet = ValueBitSet.newInstance(CorrelatePlan.this.joinedSchema);
                this.lhsBitSet = ValueBitSet.newInstance(CorrelatePlan.this.lhsSchema);
                this.rhsBitSet = CorrelatePlan.this.joinType == JoinTableNode.JoinType.Semi || CorrelatePlan.this.joinType == JoinTableNode.JoinType.Anti ? ValueBitSet.EMPTY_VALUE_BITSET : ValueBitSet.newInstance(CorrelatePlan.this.rhsSchema);
                this.iter = CorrelatePlan.this.delegate.iterator(scanGrouper, scan);
                this.rhsIter = null;
                this.current = null;
                this.closed = false;
            }

            @Override
            public void close() throws SQLException {
                if (!this.closed) {
                    this.closed = true;
                    this.iter.close();
                    if (this.rhsIter != null) {
                        this.rhsIter.close();
                    }
                }
            }

            @Override
            public Tuple next() throws SQLException {
                Tuple joined;
                if (this.closed) {
                    return null;
                }
                Tuple rhsCurrent = null;
                if (this.rhsIter != null) {
                    rhsCurrent = this.rhsIter.next();
                    if (rhsCurrent == null) {
                        this.rhsIter.close();
                        this.rhsIter = null;
                    } else if (CorrelatePlan.this.isSingleValueOnly) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                    }
                }
                while (this.rhsIter == null) {
                    this.current = this.iter.next();
                    if (this.current == null) {
                        this.close();
                        return null;
                    }
                    CorrelatePlan.this.runtimeContext.setCorrelateVariableValue(CorrelatePlan.this.variableId, this.current);
                    this.rhsIter = CorrelatePlan.this.rhs.iterator();
                    rhsCurrent = this.rhsIter.next();
                    if ((rhsCurrent != null || CorrelatePlan.this.joinType != JoinTableNode.JoinType.Inner && CorrelatePlan.this.joinType != JoinTableNode.JoinType.Semi) && (rhsCurrent == null || CorrelatePlan.this.joinType != JoinTableNode.JoinType.Anti)) continue;
                    this.rhsIter.close();
                    this.rhsIter = null;
                }
                try {
                    joined = this.rhsBitSet == ValueBitSet.EMPTY_VALUE_BITSET ? this.current : TupleProjector.mergeProjectedValue(this.convertLhs(this.current), CorrelatePlan.this.joinedSchema, this.destBitSet, rhsCurrent, CorrelatePlan.this.rhsSchema, this.rhsBitSet, CorrelatePlan.this.rhsFieldPosition, true);
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                if ((CorrelatePlan.this.joinType == JoinTableNode.JoinType.Semi || rhsCurrent == null) && this.rhsIter != null) {
                    this.rhsIter.close();
                    this.rhsIter = null;
                }
                return joined;
            }

            @Override
            public void explain(List<String> planSteps) {
            }

            private TupleProjector.ProjectedValueTuple convertLhs(Tuple lhs) throws IOException {
                TupleProjector.ProjectedValueTuple t;
                if (lhs instanceof TupleProjector.ProjectedValueTuple) {
                    t = (TupleProjector.ProjectedValueTuple)lhs;
                } else {
                    ImmutableBytesWritable ptr = CorrelatePlan.this.getContext().getTempPtr();
                    TupleProjector.decodeProjectedValue(lhs, ptr);
                    this.lhsBitSet.clear();
                    this.lhsBitSet.or(ptr);
                    int bitSetLen = this.lhsBitSet.getEstimatedLength();
                    t = new TupleProjector.ProjectedValueTuple(lhs, lhs.getValue(0).getTimestamp(), ptr.get(), ptr.getOffset(), ptr.getLength(), bitSetLen);
                }
                return t;
            }
        };
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public QueryPlan getRhsPlan() {
        return this.rhs;
    }

    @Override
    public Cost getCost() {
        Double lhsByteCount = this.delegate.accept(new ByteCountVisitor());
        Double rhsRowCount = this.rhs.accept(new RowCountVisitor());
        if (lhsByteCount == null || rhsRowCount == null) {
            return Cost.UNKNOWN;
        }
        Cost cost = new Cost(0.0, 0.0, lhsByteCount * rhsRowCount);
        Cost lhsCost = this.delegate.getCost();
        return cost.plus(lhsCost).plus(this.rhs.getCost());
    }
}

