/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.ClientProcessingPlan;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.CostUtil;

public class ClientScanPlan
extends ClientProcessingPlan {
    public ClientScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, Expression where, OrderByCompiler.OrderBy orderBy, QueryPlan delegate) {
        super(context, statement, table, projector, limit, offset, where, orderBy, delegate);
    }

    @Override
    public Cost getCost() {
        Double inputBytes = this.getDelegate().accept(new ByteCountVisitor());
        Double outputBytes = this.accept(new ByteCountVisitor());
        if (inputBytes == null || outputBytes == null) {
            return Cost.UNKNOWN;
        }
        int parallelLevel = CostUtil.estimateParallelLevel(false, this.context.getConnection().getQueryServices());
        Cost cost = new Cost(0.0, 0.0, 0.0);
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            Cost orderByCost = CostUtil.estimateOrderByCost(inputBytes, outputBytes, parallelLevel);
            cost = cost.plus(orderByCost);
        }
        return super.getCost().plus(cost);
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator iterator = this.delegate.iterator(scanGrouper, scan);
        if (this.where != null) {
            iterator = new FilterResultIterator(iterator, this.where);
        }
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            int thresholdBytes = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            iterator = new OrderedResultIterator(iterator, this.orderBy.getOrderByExpressions(), thresholdBytes, this.limit, this.offset, this.projector.getEstimatedRowByteSize());
        } else {
            if (this.offset != null) {
                iterator = new OffsetResultIterator(iterator, this.offset);
            }
            if (this.limit != null) {
                iterator = new LimitingResultIterator(iterator, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            iterator = new SequenceResultIterator(iterator, this.context.getSequenceManager());
        }
        return iterator;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        if (this.where != null) {
            planSteps.add("CLIENT FILTER BY " + this.where.toString());
        }
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.offset != null) {
                planSteps.add("CLIENT OFFSET " + this.offset);
            }
            planSteps.add("CLIENT" + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString());
        } else {
            if (this.offset != null) {
                planSteps.add("CLIENT OFFSET " + this.offset);
            }
            if (this.limit != null) {
                planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            int nSequences = this.context.getSequenceManager().getSequenceCount();
            planSteps.add("CLIENT RESERVE VALUES FROM " + nSequences + " SEQUENCE" + (nSequences == 1 ? "" : "S"));
        }
        return new ExplainPlan(planSteps);
    }
}

