/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.InterRegionServerIndexRpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollectorFactory;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionObserver
extends BaseScannerRegionObserver {
    public static final String UNGROUPED_AGG = "UngroupedAgg";
    public static final String DELETE_AGG = "DeleteAgg";
    public static final String DELETE_CQ = "DeleteCQ";
    public static final String DELETE_CF = "DeleteCF";
    public static final String EMPTY_CF = "EmptyCF";
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int scansReferenceCount = 0;
    @GuardedBy(value="lock")
    private boolean isRegionClosingOrSplitting = false;
    private static final Logger logger = LoggerFactory.getLogger(UngroupedAggregateRegionObserver.class);
    private KeyValueBuilder kvBuilder;
    private Configuration upsertSelectConfig;
    private Configuration compactionConfig;
    private Configuration indexWriteConfig;
    private ReadOnlyProps indexWriteProps;

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
        this.kvBuilder = GenericKeyValueBuilder.INSTANCE;
        this.upsertSelectConfig = PropertiesUtil.cloneConfig(e.getConfiguration());
        this.upsertSelectConfig.setClass("hbase.rpc.controllerfactory.class", InterRegionServerIndexRpcControllerFactory.class, RpcControllerFactory.class);
        this.compactionConfig = ServerUtil.getCompactionConfig(e.getConfiguration());
        this.indexWriteConfig = PropertiesUtil.cloneConfig(e.getConfiguration());
        this.indexWriteConfig.setInt("hbase.client.retries.number", e.getConfiguration().getInt("phoenix.index.rebuild.rpc.retries.counter", 5));
        this.indexWriteProps = new ReadOnlyProps(this.indexWriteConfig.iterator());
    }

    private void commitBatchWithRetries(final Region region, final List<Mutation> localRegionMutations, final long blockingMemstoreSize) throws IOException {
        try {
            this.commitBatch(region, localRegionMutations, blockingMemstoreSize);
        }
        catch (IOException e) {
            this.handleIndexWriteException(localRegionMutations, e, new PhoenixIndexFailurePolicy.MutateCommand(){

                @Override
                public void doMutation() throws IOException {
                    UngroupedAggregateRegionObserver.this.commitBatch(region, localRegionMutations, blockingMemstoreSize);
                }
            });
        }
    }

    private void commitBatch(Region region, List<Mutation> mutations, long blockingMemstoreSize) throws IOException {
        if (mutations.isEmpty()) {
            return;
        }
        Mutation[] mutationArray = new Mutation[mutations.size()];
        for (int i = 0; blockingMemstoreSize > 0L && region.getMemstoreSize() > blockingMemstoreSize && i < 30; ++i) {
            try {
                this.checkForRegionClosing();
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        logger.debug("Committing batch of " + mutations.size() + " mutations for " + region.getRegionInfo().getTable().getNameAsString());
        region.batchMutate(mutations.toArray(mutationArray), 0L, 0L);
    }

    private void setIndexAndTransactionProperties(List<Mutation> mutations, byte[] indexUUID, byte[] indexMaintainersPtr, byte[] txState, byte[] clientVersionBytes, boolean useIndexProto) {
        for (Mutation m : mutations) {
            if (indexMaintainersPtr != null) {
                m.setAttribute(useIndexProto ? "IdxProtoMD" : "IdxMD", indexMaintainersPtr);
            }
            if (indexUUID != null) {
                m.setAttribute("IdxUUID", indexUUID);
            }
            if (txState != null) {
                m.setAttribute("_TxState", txState);
            }
            if (clientVersionBytes == null) continue;
            m.setAttribute("_ClientVersion", clientVersionBytes);
        }
    }

    private void commitBatchWithHTable(HTable table, List<Mutation> mutations) throws IOException {
        if (mutations.isEmpty()) {
            return;
        }
        logger.debug("Committing batch of " + mutations.size() + " mutations for " + table);
        try {
            table.batch(mutations);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForRegionClosing() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRegionClosingOrSplitting) {
                this.lock.notifyAll();
                throw new IOException("Region is getting closed. Not allowing to write to avoid possible deadlock.");
            }
        }
    }

    public static void serializeIntoScan(Scan scan) {
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        s = super.preScannerOpen(e, scan, s);
        if (ScanUtil.isAnalyzeTable(scan)) {
            scan.setStartRow(HConstants.EMPTY_START_ROW);
            scan.setStopRow(HConstants.EMPTY_END_ROW);
            scan.setFilter(null);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Scan scan, RegionScanner s) throws IOException, SQLException {
        Object em;
        boolean buildLocalIndex;
        boolean isDescRowKeyOrderUpgrade;
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
        Region region = env.getRegion();
        long ts = scan.getTimeRange().getMax();
        boolean localIndexScan = ScanUtil.isLocalIndex(scan);
        if (ScanUtil.isAnalyzeTable(scan)) {
            byte[] gp_width_bytes = scan.getAttribute("_GUIDEPOST_WIDTH_BYTES");
            byte[] gp_per_region_bytes = scan.getAttribute("_GUIDEPOST_PER_REGION");
            StatisticsCollector statsCollector = StatisticsCollectorFactory.createStatisticsCollector(env, region.getRegionInfo().getTable().getNameAsString(), ts, gp_width_bytes, gp_per_region_bytes);
            return this.collectStats(s, statsCollector, region, scan, env.getConfiguration());
        }
        if (ScanUtil.isIndexRebuild(scan)) {
            return this.rebuildIndices(s, region, scan, env.getConfiguration());
        }
        PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme(scan);
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier(scan);
        int offsetToBe = 0;
        if (localIndexScan) {
            offsetToBe = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset(scan, offsetToBe);
        }
        int offset = offsetToBe;
        PTable projectedTable = null;
        PTableImpl writeToTable = null;
        Object values = null;
        byte[] descRowKeyTableBytes = scan.getAttribute("_UPGRADE_DESC_ROW_KEY");
        boolean bl = isDescRowKeyOrderUpgrade = descRowKeyTableBytes != null;
        if (isDescRowKeyOrderUpgrade) {
            logger.debug("Upgrading row key for " + region.getRegionInfo().getTable().getNameAsString());
            projectedTable = UngroupedAggregateRegionObserver.deserializeTable(descRowKeyTableBytes);
            try {
                writeToTable = PTableImpl.makePTable(projectedTable, true);
            }
            catch (SQLException e) {
                ServerUtil.throwIOException("Upgrade failed", e);
            }
            values = new byte[projectedTable.getPKColumns().size()][];
        }
        boolean useProto = false;
        byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        boolean bl2 = useProto = localIndexBytes != null;
        if (localIndexBytes == null) {
            localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        }
        List<IndexMaintainer> indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize(localIndexBytes, useProto);
        MutationList indexMutations = localIndexBytes == null ? new MutationList() : new MutationList(1024);
        RegionScanner theScanner = s;
        byte[] replayMutations = scan.getAttribute("_IGNORE_NEWER_MUTATIONS");
        byte[] indexUUID = scan.getAttribute("IdxUUID");
        byte[] txState = scan.getAttribute("_TxState");
        List<Expression> selectExpressions = null;
        byte[] upsertSelectTable = scan.getAttribute("_UpsertSelectTable");
        boolean isUpsert = false;
        boolean isDelete = false;
        byte[] deleteCQ = null;
        byte[] deleteCF = null;
        byte[] emptyCF = null;
        HTable targetHTable = null;
        boolean isPKChanging = false;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (upsertSelectTable != null) {
            isUpsert = true;
            projectedTable = UngroupedAggregateRegionObserver.deserializeTable(upsertSelectTable);
            targetHTable = new HTable(this.upsertSelectConfig, projectedTable.getPhysicalName().getBytes());
            selectExpressions = UngroupedAggregateRegionObserver.deserializeExpressions(scan.getAttribute("_UpsertSelectExprs"));
            values = new byte[projectedTable.getPKColumns().size()][];
            isPKChanging = ExpressionUtil.isPkPositionChanging(new TableRef(projectedTable), selectExpressions);
        } else {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            boolean bl3 = isDelete = isDeleteAgg != null && Bytes.compareTo((byte[])PDataType.TRUE_BYTES, (byte[])isDeleteAgg) == 0;
            if (!isDelete) {
                deleteCF = scan.getAttribute("_DeleteCF");
                deleteCQ = scan.getAttribute("_DeleteCQ");
            }
            emptyCF = scan.getAttribute("_EmptyCF");
        }
        TupleProjector tupleProjector = null;
        byte[][] viewConstants = null;
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
        TupleProjector p = TupleProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        boolean useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan));
        if (localIndexScan && !isDelete && !isDescRowKeyOrderUpgrade || j == null && p != null) {
            if (dataColumns != null) {
                tupleProjector = IndexUtil.getTupleProjector(scan, dataColumns);
                viewConstants = IndexUtil.deserializeViewConstantsFromScan(scan);
            }
            ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
            theScanner = this.getWrappedScanner(c, theScanner, offset, scan, dataColumns, tupleProjector, region, indexMaintainers == null ? null : indexMaintainers.get(0), viewConstants, p, tempPtr, useQualifierAsIndex);
        }
        if (j != null) {
            theScanner = new HashJoinRegionScanner(theScanner, p, j, ScanUtil.getTenantId(scan), env, useQualifierAsIndex, useNewValueColumnQualifier);
        }
        int maxBatchSize = 0;
        long maxBatchSizeBytes = 0L;
        MutationList mutations = new MutationList();
        boolean needToWrite = false;
        Configuration conf = env.getConfiguration();
        long flushSize = region.getTableDesc().getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        long blockingMemStoreSize = flushSize * (conf.getLong("hbase.hregion.memstore.block.multiplier", 4L) - 1L);
        boolean bl4 = buildLocalIndex = indexMaintainers != null && dataColumns == null && !localIndexScan;
        if (buildLocalIndex) {
            this.checkForLocalIndexColumnFamilies(region, indexMaintainers);
        }
        if (isDescRowKeyOrderUpgrade || isDelete || isUpsert || deleteCQ != null && deleteCF != null || emptyCF != null || buildLocalIndex) {
            needToWrite = true;
            maxBatchSize = conf.getInt("phoenix.mutate.batchSize", 100);
            mutations = new MutationList(Ints.saturatedCast((long)(maxBatchSize + maxBatchSize / 10)));
            maxBatchSizeBytes = conf.getLong("phoenix.mutate.batchSizeBytes", 0x200000L);
        }
        int rowCount = 0;
        boolean hasAny = false;
        boolean acquiredLock = false;
        boolean incrScanRefCount = false;
        ServerAggregators aggregators = null;
        Aggregator[] rowAggregators = null;
        RegionScanner innerScanner = theScanner;
        TenantCache tenantCache = GlobalCache.getTenantCache(env, ScanUtil.getTenantId(scan));
        try {
            em = tenantCache.getMemoryManager().allocate(0L);
            Throwable throwable = null;
            try {
                Object object;
                BaseTuple result;
                aggregators = ServerAggregators.deserialize(scan.getAttribute("_Aggs"), conf, (MemoryManager.MemoryChunk)em);
                rowAggregators = aggregators.getAggregators();
                Pair<Integer, Integer> minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan);
                BaseTuple baseTuple = result = useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
                if (logger.isDebugEnabled()) {
                    logger.debug(LogUtil.addCustomAnnotations("Starting ungrouped coprocessor scan " + scan + " " + region.getRegionInfo(), ScanUtil.getCustomAnnotations(scan)));
                }
                boolean useIndexProto = true;
                byte[] indexMaintainersPtr = scan.getAttribute("IdxProtoMD");
                if (indexMaintainersPtr == null) {
                    indexMaintainersPtr = scan.getAttribute("IdxMD");
                    useIndexProto = false;
                }
                byte[] clientVersionBytes = scan.getAttribute("_ClientVersion");
                if (needToWrite) {
                    object = this.lock;
                    synchronized (object) {
                        if (this.isRegionClosingOrSplitting) {
                            throw new IOException("Temporarily unable to write from scan because region is closing or splitting");
                        }
                        ++this.scansReferenceCount;
                        incrScanRefCount = true;
                        this.lock.notifyAll();
                    }
                }
                region.startRegionOperation();
                acquiredLock = true;
                object = innerScanner;
                synchronized (object) {
                    boolean hasMore;
                    do {
                        Cell firstKV;
                        List<Cell> results = useQualifierAsIndex ? new EncodedColumnQualiferCellsList((Integer)minMaxQualifiers.getFirst(), (Integer)minMaxQualifiers.getSecond(), encodingScheme) : new ArrayList();
                        hasMore = innerScanner.nextRaw((List)results);
                        if (results.isEmpty()) continue;
                        ++rowCount;
                        result.setKeyValues(results);
                        if (isDescRowKeyOrderUpgrade) {
                            Boolean hasValue;
                            Arrays.fill((Object[])values, null);
                            firstKV = results.get(0);
                            RowKeySchema schema = projectedTable.getRowKeySchema();
                            int maxOffset = schema.iterator(firstKV.getRowArray(), firstKV.getRowOffset() + offset, firstKV.getRowLength(), ptr);
                            for (int i = 0; i < schema.getFieldCount() && (hasValue = schema.next(ptr, i, maxOffset)) != null; ++i) {
                                int len;
                                ValueSchema.Field field = schema.getField(i);
                                if (field.getSortOrder() == SortOrder.DESC) {
                                    if (field.getDataType().isArrayType()) {
                                        field.getDataType().coerceBytes(ptr, null, field.getDataType(), field.getMaxLength(), field.getScale(), field.getSortOrder(), field.getMaxLength(), field.getScale(), field.getSortOrder(), true);
                                    } else if (field.getDataType() == PChar.INSTANCE || field.getDataType() == PBinary.INSTANCE) {
                                        for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                                        }
                                        ptr.set(ptr.get(), ptr.getOffset(), len);
                                    } else if (field.getDataType() == PFloat.INSTANCE || field.getDataType() == PDouble.INSTANCE) {
                                        byte[] invertedBytes = SortOrder.invert(ptr.get(), ptr.getOffset(), ptr.getLength());
                                        ptr.set(invertedBytes);
                                    }
                                } else if (field.getDataType() == PBinary.INSTANCE) {
                                    for (len = ptr.getLength(); len > 0 && ptr.get()[ptr.getOffset() + len - 1] == 32; --len) {
                                    }
                                    ptr.set(ptr.get(), ptr.getOffset(), len);
                                }
                                values[i] = ptr.copyBytes();
                            }
                            writeToTable.newKey(ptr, (byte[][])values);
                            if (Bytes.compareTo((byte[])firstKV.getRowArray(), (int)(firstKV.getRowOffset() + offset), (int)firstKV.getRowLength(), (byte[])ptr.get(), (int)(ptr.getOffset() + offset), (int)ptr.getLength()) == 0) continue;
                            byte[] newRow = ByteUtil.copyKeyBytesIfNecessary(ptr);
                            if (offset > 0) {
                                byte[] newRowWithOffset = new byte[offset + newRow.length];
                                System.arraycopy(firstKV.getRowArray(), firstKV.getRowOffset(), newRowWithOffset, 0, offset);
                                System.arraycopy(newRow, 0, newRowWithOffset, offset, newRow.length);
                                newRow = newRowWithOffset;
                            }
                            byte[] oldRow = Bytes.copy((byte[])firstKV.getRowArray(), (int)firstKV.getRowOffset(), (int)firstKV.getRowLength());
                            for (Cell cell : results) {
                                KeyValue newCell = new KeyValue(newRow, 0, newRow.length, cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                                switch (KeyValue.Type.codeToType((byte)cell.getTypeByte())) {
                                    case Put: {
                                        Delete del = new Delete(oldRow);
                                        del.addDeleteMarker((Cell)new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.Delete, ByteUtil.EMPTY_BYTE_ARRAY, 0, 0));
                                        mutations.add((Mutation)del);
                                        Put put = new Put(newRow);
                                        put.add((Cell)newCell);
                                        mutations.add((Mutation)put);
                                        break;
                                    }
                                    case Delete: 
                                    case DeleteColumn: 
                                    case DeleteFamily: 
                                    case DeleteFamilyVersion: {
                                        Delete delete = new Delete(newRow);
                                        delete.addDeleteMarker((Cell)newCell);
                                        mutations.add((Mutation)delete);
                                    }
                                }
                            }
                        } else if (buildLocalIndex) {
                            for (IndexMaintainer maintainer : indexMaintainers) {
                                if (results.isEmpty()) continue;
                                result.getKey(ptr);
                                ValueGetter valueGetter = maintainer.createGetterFromKeyValues(ImmutableBytesPtr.copyBytesIfNecessary(ptr), results);
                                Put put = maintainer.buildUpdateMutation(this.kvBuilder, valueGetter, ptr, results.get(0).getTimestamp(), env.getRegion().getRegionInfo().getStartKey(), env.getRegion().getRegionInfo().getEndKey());
                                indexMutations.add((Mutation)put);
                            }
                            result.setKeyValues(results);
                        } else if (isDelete) {
                            firstKV = results.get(0);
                            Delete delete = new Delete(firstKV.getRowArray(), firstKV.getRowOffset(), (int)firstKV.getRowLength(), ts);
                            if (replayMutations != null) {
                                delete.setAttribute("_IGNORE_NEWER_MUTATIONS", replayMutations);
                            }
                            mutations.add((Mutation)delete);
                            delete.setAttribute("tephra.tx.rollback", new byte[0]);
                        } else if (isUpsert) {
                            int i;
                            Arrays.fill((Object[])values, null);
                            int bucketNumOffset = 0;
                            if (projectedTable.getBucketNum() != null) {
                                values[0] = new byte[]{0};
                                bucketNumOffset = 1;
                            }
                            List<PColumn> projectedColumns = projectedTable.getColumns();
                            for (i = bucketNumOffset; i < projectedTable.getPKColumns().size(); ++i) {
                                Expression expression = selectExpressions.get(i - bucketNumOffset);
                                if (expression.evaluate(result, ptr)) {
                                    values[i] = ptr.copyBytes();
                                    if (expression.getSortOrder() == projectedColumns.get(i).getSortOrder()) continue;
                                    SortOrder.invert(values[i], 0, values[i], 0, values[i].length);
                                    continue;
                                }
                                values[i] = ByteUtil.EMPTY_BYTE_ARRAY;
                            }
                            projectedTable.newKey(ptr, (byte[][])values);
                            PRow row = projectedTable.newRow(this.kvBuilder, ts, ptr, false, (byte[][])new byte[0][]);
                            while (i < projectedColumns.size()) {
                                Expression expression = selectExpressions.get(i - bucketNumOffset);
                                if (expression.evaluate(result, ptr)) {
                                    PColumn column = projectedColumns.get(i);
                                    if (!column.getDataType().isSizeCompatible(ptr, null, expression.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                                        throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale(), column.getName().getString(), ptr);
                                    }
                                    column.getDataType().coerceBytes(ptr, null, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), projectedTable.rowKeyOrderOptimizable());
                                    byte[] bytes = ByteUtil.copyKeyBytesIfNecessary(ptr);
                                    row.setValue(column, bytes);
                                }
                                ++i;
                            }
                            for (Mutation mutation : row.toRowMutations()) {
                                if (replayMutations != null) {
                                    mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", replayMutations);
                                }
                                mutations.add(mutation);
                            }
                            for (i = 0; i < selectExpressions.size(); ++i) {
                                selectExpressions.get(i).reset();
                            }
                        } else if (deleteCF != null && deleteCQ != null && (emptyCF == null || result.getValue(deleteCF, deleteCQ) != null)) {
                            Delete delete = new Delete(results.get(0).getRowArray(), results.get(0).getRowOffset(), (int)results.get(0).getRowLength());
                            delete.deleteColumns(deleteCF, deleteCQ, ts);
                            delete.setAttribute("tephra.tx.rollback", new byte[0]);
                            mutations.add((Mutation)delete);
                        }
                        if (emptyCF != null) {
                            HashSet timeStamps = Sets.newHashSetWithExpectedSize((int)results.size());
                            for (Cell kv : results) {
                                long kvts = kv.getTimestamp();
                                if (timeStamps.contains(kvts)) continue;
                                Put put = new Put(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength());
                                put.addColumn(emptyCF, QueryConstants.EMPTY_COLUMN_BYTES, kvts, ByteUtil.EMPTY_BYTE_ARRAY);
                                mutations.add((Mutation)put);
                            }
                        }
                        if (ServerUtil.readyToCommit(mutations.size(), mutations.byteSize(), maxBatchSize, maxBatchSizeBytes)) {
                            this.commit(region, mutations, indexUUID, blockingMemStoreSize, indexMaintainersPtr, txState, targetHTable, useIndexProto, isPKChanging, clientVersionBytes);
                            mutations.clear();
                        }
                        if (ServerUtil.readyToCommit(indexMutations.size(), indexMutations.byteSize(), maxBatchSize, maxBatchSizeBytes)) {
                            this.setIndexAndTransactionProperties(indexMutations, indexUUID, indexMaintainersPtr, txState, clientVersionBytes, useIndexProto);
                            this.commitBatch(region, indexMutations, blockingMemStoreSize);
                            indexMutations.clear();
                        }
                        ((Aggregators)aggregators).aggregate(rowAggregators, result);
                        hasAny = true;
                    } while (hasMore);
                    if (!mutations.isEmpty()) {
                        this.commit(region, mutations, indexUUID, blockingMemStoreSize, indexMaintainersPtr, txState, targetHTable, useIndexProto, isPKChanging, clientVersionBytes);
                        mutations.clear();
                    }
                    if (!indexMutations.isEmpty()) {
                        this.commitBatch(region, indexMutations, blockingMemStoreSize);
                        indexMutations.clear();
                    }
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (em != null) {
                    if (throwable != null) {
                        try {
                            em.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        em.close();
                    }
                }
            }
        }
        finally {
            if (needToWrite && incrScanRefCount) {
                em = this.lock;
                synchronized (em) {
                    --this.scansReferenceCount;
                    if (this.scansReferenceCount < 0) {
                        logger.warn("Scan reference count went below zero. Something isn't correct. Resetting it back to zero");
                        this.scansReferenceCount = 0;
                    }
                    this.lock.notifyAll();
                }
            }
            try {
                if (targetHTable != null) {
                    targetHTable.close();
                }
            }
            finally {
                try {
                    innerScanner.close();
                }
                finally {
                    if (acquiredLock) {
                        region.closeRegionOperation();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Finished scanning " + rowCount + " rows for ungrouped coprocessor scan " + scan, ScanUtil.getCustomAnnotations(scan)));
        }
        final boolean hadAny = hasAny;
        KeyValue keyValue = null;
        if (hadAny) {
            byte[] value = aggregators.toBytes(rowAggregators);
            keyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
        }
        final KeyValue aggKeyValue = keyValue;
        BaseRegionScanner scanner = new BaseRegionScanner(innerScanner){
            private boolean done;
            {
                super(x0);
                this.done = !hadAny;
            }

            @Override
            public boolean isFilterDone() {
                return this.done;
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                if (this.done) {
                    return false;
                }
                this.done = true;
                results.add((Cell)aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }
        };
        return scanner;
    }

    private void checkForLocalIndexColumnFamilies(Region region, List<IndexMaintainer> indexMaintainers) throws IOException {
        HTableDescriptor tableDesc = region.getTableDesc();
        String schemaName = tableDesc.getTableName().getNamespaceAsString().equals(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR) ? SchemaUtil.getSchemaNameFromFullName(tableDesc.getTableName().getNameAsString()) : tableDesc.getTableName().getNamespaceAsString();
        String tableName = SchemaUtil.getTableNameFromFullName(tableDesc.getTableName().getNameAsString());
        for (IndexMaintainer indexMaintainer : indexMaintainers) {
            byte[] localIndexCf;
            Set<ColumnReference> coveredColumns = indexMaintainer.getCoveredColumns();
            if (coveredColumns.isEmpty() && tableDesc.getFamily(localIndexCf = indexMaintainer.getEmptyKeyValueFamily().get()) == null) {
                ServerUtil.throwIOException("Column Family Not Found", new ColumnFamilyNotFoundException(schemaName, tableName, Bytes.toString((byte[])localIndexCf)));
            }
            for (ColumnReference reference : coveredColumns) {
                byte[] cf = IndexUtil.getLocalIndexColumnFamily(reference.getFamily());
                HColumnDescriptor family = region.getTableDesc().getFamily(cf);
                if (family != null) continue;
                ServerUtil.throwIOException("Column Family Not Found", new ColumnFamilyNotFoundException(schemaName, tableName, Bytes.toString((byte[])cf)));
            }
        }
    }

    private void commit(Region region, List<Mutation> mutations, byte[] indexUUID, long blockingMemStoreSize, byte[] indexMaintainersPtr, byte[] txState, final HTable targetHTable, boolean useIndexProto, boolean isPKChanging, byte[] clientVersionBytes) throws IOException {
        ArrayList localRegionMutations = Lists.newArrayList();
        final ArrayList remoteRegionMutations = Lists.newArrayList();
        this.setIndexAndTransactionProperties(mutations, indexUUID, indexMaintainersPtr, txState, clientVersionBytes, useIndexProto);
        this.separateLocalAndRemoteMutations(targetHTable, region, mutations, localRegionMutations, remoteRegionMutations, isPKChanging);
        this.commitBatchWithRetries(region, localRegionMutations, blockingMemStoreSize);
        try {
            this.commitBatchWithHTable(targetHTable, remoteRegionMutations);
        }
        catch (IOException e) {
            this.handleIndexWriteException(remoteRegionMutations, e, new PhoenixIndexFailurePolicy.MutateCommand(){

                @Override
                public void doMutation() throws IOException {
                    UngroupedAggregateRegionObserver.this.commitBatchWithHTable(targetHTable, remoteRegionMutations);
                }
            });
        }
        localRegionMutations.clear();
        remoteRegionMutations.clear();
    }

    private void handleIndexWriteException(List<Mutation> localRegionMutations, IOException origIOE, PhoenixIndexFailurePolicy.MutateCommand mutateCommand) throws IOException {
        block16: {
            long serverTimestamp = ServerUtil.parseTimestampFromRemoteException(origIOE);
            SQLException inferredE = ServerUtil.parseLocalOrRemoteServerException(origIOE);
            if (inferredE != null && inferredE.getErrorCode() == SQLExceptionCode.INDEX_WRITE_FAILURE.getErrorCode()) {
                for (Mutation mutation : localRegionMutations) {
                    mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", REPLAY_ONLY_INDEX_WRITES);
                    KeyValueUtil.setTimestamp(mutation, serverTimestamp);
                }
                IndexWriteException iwe = PhoenixIndexFailurePolicy.getIndexWriteException(inferredE);
                try (PhoenixConnection conn = QueryUtil.getConnectionOnServer(this.indexWriteConfig).unwrap(PhoenixConnection.class);){
                    PhoenixIndexFailurePolicy.doBatchWithRetries(mutateCommand, iwe, conn, this.indexWriteProps);
                    break block16;
                }
                catch (Exception e) {
                    throw new DoNotRetryIOException((Throwable)e);
                }
            }
            throw origIOE;
        }
    }

    private void separateLocalAndRemoteMutations(HTable targetHTable, Region region, List<Mutation> mutations, List<Mutation> localRegionMutations, List<Mutation> remoteRegionMutations, boolean isPKChanging) {
        boolean areMutationsInSameTable = this.areMutationsInSameTable(targetHTable, region);
        if (areMutationsInSameTable && isPKChanging) {
            HRegionInfo regionInfo = region.getRegionInfo();
            for (Mutation mutation : mutations) {
                if (regionInfo.containsRow(mutation.getRow())) {
                    localRegionMutations.add(mutation);
                    continue;
                }
                remoteRegionMutations.add(mutation);
            }
        } else if (areMutationsInSameTable && !isPKChanging) {
            localRegionMutations.addAll(mutations);
        } else {
            remoteRegionMutations.addAll(mutations);
        }
    }

    private boolean areMutationsInSameTable(HTable targetHTable, Region region) {
        return targetHTable == null || Bytes.compareTo((byte[])targetHTable.getTableName(), (byte[])region.getTableDesc().getTableName().getName()) == 0;
    }

    public InternalScanner preCompact(final ObserverContext<RegionCoprocessorEnvironment> c, final Store store, final InternalScanner scanner, ScanType scanType) throws IOException {
        if (scanType.equals((Object)ScanType.COMPACT_DROP_DELETES)) {
            final TableName table = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable();
            return (InternalScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                @Override
                public InternalScanner run() throws Exception {
                    InternalScanner internalScanner;
                    block2: {
                        internalScanner = scanner;
                        try {
                            long clientTimeStamp = EnvironmentEdgeManager.currentTimeMillis();
                            DelegateRegionCoprocessorEnvironment compactionConfEnv = new DelegateRegionCoprocessorEnvironment((RegionCoprocessorEnvironment)c.getEnvironment(), ServerUtil.ConnectionType.COMPACTION_CONNECTION);
                            StatisticsCollector stats = StatisticsCollectorFactory.createStatisticsCollector(compactionConfEnv, table.getNameAsString(), clientTimeStamp, store.getFamily().getName());
                            internalScanner = stats.createCompactionScanner(compactionConfEnv, store, scanner);
                        }
                        catch (Exception e) {
                            if (!logger.isWarnEnabled()) break block2;
                            logger.warn("Unable to collect stats for " + table, (Throwable)e);
                        }
                    }
                    return internalScanner;
                }
            });
        }
        return scanner;
    }

    private static PTable deserializeTable(byte[] b) {
        try {
            PTableProtos.PTable ptableProto = PTableProtos.PTable.parseFrom(b);
            return PTableImpl.createFromProto(ptableProto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner rebuildIndices(final RegionScanner innerScanner, final Region region, final Scan scan, Configuration config) throws IOException {
        byte[] indexMetaData = scan.getAttribute("IdxProtoMD");
        boolean useProto = true;
        if (indexMetaData == null) {
            useProto = false;
            indexMetaData = scan.getAttribute("IdxMD");
        }
        byte[] clientVersionBytes = scan.getAttribute("_ClientVersion");
        int rowCount = 0;
        try {
            int maxBatchSize = config.getInt("phoenix.mutate.batchSize", 100);
            long maxBatchSizeBytes = config.getLong("phoenix.mutate.batchSizeBytes", 0x200000L);
            MutationList mutations = new MutationList(maxBatchSize);
            region.startRegionOperation();
            byte[] uuidValue = ServerCacheClient.generateId();
            RegionScanner regionScanner = innerScanner;
            synchronized (regionScanner) {
                boolean hasMore;
                do {
                    ArrayList results = new ArrayList();
                    hasMore = innerScanner.nextRaw(results);
                    if (results.isEmpty()) continue;
                    Put put = null;
                    Delete del = null;
                    for (Cell cell : results) {
                        if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                            if (put == null) {
                                put = new Put(CellUtil.cloneRow((Cell)cell));
                                put.setAttribute(useProto ? "IdxProtoMD" : "IdxMD", indexMetaData);
                                put.setAttribute("IdxUUID", uuidValue);
                                put.setAttribute("_IGNORE_NEWER_MUTATIONS", REPLAY_ONLY_INDEX_WRITES);
                                put.setAttribute("_ClientVersion", clientVersionBytes);
                                mutations.add((Mutation)put);
                                put.setDurability(Durability.SKIP_WAL);
                            }
                            put.add(cell);
                            continue;
                        }
                        if (del == null) {
                            del = new Delete(CellUtil.cloneRow((Cell)cell));
                            del.setAttribute(useProto ? "IdxProtoMD" : "IdxMD", indexMetaData);
                            del.setAttribute("IdxUUID", uuidValue);
                            del.setAttribute("_IGNORE_NEWER_MUTATIONS", REPLAY_ONLY_INDEX_WRITES);
                            del.setAttribute("_ClientVersion", clientVersionBytes);
                            mutations.add((Mutation)del);
                            del.setDurability(Durability.SKIP_WAL);
                        }
                        del.addDeleteMarker(cell);
                    }
                    if (ServerUtil.readyToCommit(mutations.size(), mutations.byteSize(), maxBatchSize, maxBatchSizeBytes)) {
                        this.commitBatchWithRetries(region, mutations, -1L);
                        uuidValue = ServerCacheClient.generateId();
                        mutations.clear();
                    }
                    ++rowCount;
                } while (hasMore);
                if (!mutations.isEmpty()) {
                    this.commitBatchWithRetries(region, mutations, -1L);
                }
            }
        }
        catch (IOException e) {
            logger.error("IOException during rebuilding: " + Throwables.getStackTraceAsString((Throwable)e));
            throw e;
        }
        finally {
            region.closeRegionOperation();
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(rowCount);
        final KeyValue aggKeyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        BaseRegionScanner scanner = new BaseRegionScanner(innerScanner){

            @Override
            public HRegionInfo getRegionInfo() {
                return region.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() {
                return true;
            }

            @Override
            public void close() throws IOException {
                innerScanner.close();
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                results.add((Cell)aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }
        };
        return scanner;
    }

    private RegionScanner collectStats(RegionScanner innerScanner, StatisticsCollector stats, final Region region, final Scan scan, Configuration config) throws IOException {
        StatsCollectionCallable callable = new StatsCollectionCallable(stats, region, innerScanner, config, scan);
        byte[] asyncBytes = scan.getAttribute("_RunUpdateStatsAsync");
        boolean async = false;
        if (asyncBytes != null) {
            async = Bytes.toBoolean((byte[])asyncBytes);
        }
        long rowCount = 0L;
        StatisticsCollectionRunTracker statsRunTracker = StatisticsCollectionRunTracker.getInstance(config);
        boolean runUpdateStats = statsRunTracker.addUpdateStatsCommandRegion(region.getRegionInfo());
        if (runUpdateStats) {
            if (!async) {
                rowCount = callable.call();
            } else {
                statsRunTracker.runTask(callable);
            }
        } else {
            rowCount = -100L;
            logger.info("UPDATE STATISTICS didn't run because another UPDATE STATISTICS command was already running on the region " + region.getRegionInfo().getRegionNameAsString());
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(rowCount);
        final KeyValue aggKeyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        BaseRegionScanner scanner = new BaseRegionScanner(innerScanner){

            @Override
            public HRegionInfo getRegionInfo() {
                return region.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                results.add((Cell)aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }
        };
        return scanner;
    }

    private static List<Expression> deserializeExpressions(byte[] b) {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int size = WritableUtils.readVInt((DataInput)input);
            ArrayList selectExpressions = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                ExpressionType type = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)];
                Expression selectExpression = type.newInstance();
                selectExpression.readFields(input);
                selectExpressions.add(selectExpression);
            }
            ArrayList arrayList = selectExpressions;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serialize(PTable projectedTable) {
        PTableProtos.PTable ptableProto = PTableImpl.toProto(projectedTable);
        return ptableProto.toByteArray();
    }

    public static byte[] serialize(List<Expression> selectExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)selectExpressions.size());
            for (int i = 0; i < selectExpressions.size(); ++i) {
                Expression expression = selectExpressions.get(i);
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c, byte[] splitRow) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isRegionClosingOrSplitting = true;
            if (this.scansReferenceCount > 0) {
                throw new IOException("Operations like local index building/delete/upsert select might be going on so not allowing to split.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> c, List<Pair<byte[], String>> familyPaths) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.scansReferenceCount > 0) {
                throw new DoNotRetryIOException("Operations like local index building/delete/upsert select might be going on so not allowing to bulkload.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isRegionClosingOrSplitting = true;
            while (this.scansReferenceCount > 0) {
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_UngroupedAgg") != null;
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Store store, final List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, final InternalScanner s, CompactionRequest request) throws IOException {
        final String fullTableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString();
        if (request.isMajor() && !PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME.equals(fullTableName)) {
            return (InternalScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public InternalScanner run() throws Exception {
                    try (PhoenixConnection conn = QueryUtil.getConnectionOnServer(UngroupedAggregateRegionObserver.this.compactionConfig).unwrap(PhoenixConnection.class);){
                        PTable index;
                        PTable table = PhoenixRuntime.getTableNoCache(conn, fullTableName);
                        ArrayList indexes = PTableType.INDEX.equals((Object)table.getType()) ? Lists.newArrayList((Object[])new PTable[]{table}) : table.getIndexes();
                        Iterator<PTable> i$ = indexes.iterator();
                        do {
                            if (!i$.hasNext()) return s;
                        } while ((index = i$.next()).getIndexDisableTimestamp() == 0L);
                        logger.info("Modifying major compaction scanner to retain deleted cells for a table with disabled index: " + fullTableName);
                        Scan scan = new Scan();
                        scan.setMaxVersions();
                        StoreScanner storeScanner = new StoreScanner(store, store.getScanInfo(), scan, scanners, ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
                        return storeScanner;
                    }
                    catch (Exception e) {
                        if (e instanceof TableNotFoundException) {
                            logger.debug("Ignoring HBase table that is not a Phoenix table: " + fullTableName);
                            return s;
                        }
                        logger.error("Unable to modify compaction scanner to retain deleted cells for a table with disabled Index; " + fullTableName, (Throwable)e);
                    }
                    return s;
                }
            });
        }
        return s;
    }

    static class StatsCollectionCallable
    implements Callable<Long> {
        private final StatisticsCollector statsCollector;
        private final Region region;
        private final RegionScanner innerScanner;
        private final Configuration config;
        private final Scan scan;

        StatsCollectionCallable(StatisticsCollector s, Region r, RegionScanner rs, Configuration config, Scan scan) {
            this.statsCollector = s;
            this.region = r;
            this.innerScanner = rs;
            this.config = config;
            this.scan = scan;
        }

        @Override
        public Long call() throws IOException {
            return this.collectStatsInternal();
        }

        private boolean areStatsBeingCollectedViaCompaction() {
            return StatisticsCollectionRunTracker.getInstance(this.config).areStatsBeingCollectedOnCompaction(this.region.getRegionInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long collectStatsInternal() throws IOException {
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            this.region.startRegionOperation();
            boolean hasMore = false;
            boolean noErrors = false;
            boolean compactionRunning = this.areStatsBeingCollectedViaCompaction();
            long rowCount = 0L;
            try {
                if (!compactionRunning) {
                    this.statsCollector.init();
                    RegionScanner regionScanner = this.innerScanner;
                    synchronized (regionScanner) {
                        do {
                            ArrayList<Cell> results = new ArrayList<Cell>();
                            hasMore = this.innerScanner.nextRaw(results);
                            this.statsCollector.collectStatistics(results);
                            ++rowCount;
                            compactionRunning = this.areStatsBeingCollectedViaCompaction();
                        } while (hasMore && !compactionRunning);
                        noErrors = true;
                    }
                }
                long l = compactionRunning ? -200L : rowCount;
                return l;
            }
            catch (IOException e) {
                logger.error("IOException in update stats: " + Throwables.getStackTraceAsString((Throwable)e));
                throw e;
            }
            finally {
                try {
                    if (noErrors && !compactionRunning) {
                        this.statsCollector.updateStatistic(this.region, this.scan);
                        logger.info("UPDATE STATISTICS finished successfully for scanner: " + this.innerScanner + ". Number of rows scanned: " + rowCount + ". Time: " + (System.currentTimeMillis() - startTime));
                    }
                    if (compactionRunning) {
                        logger.info("UPDATE STATISTICS stopped in between because major compaction was running for region " + this.region.getRegionInfo().getRegionNameAsString());
                    }
                }
                finally {
                    try {
                        StatisticsCollectionRunTracker.getInstance(this.config).removeUpdateStatsCommandRegion(this.region.getRegionInfo());
                        this.statsCollector.close();
                    }
                    finally {
                        try {
                            this.innerScanner.close();
                        }
                        finally {
                            this.region.closeRegionOperation();
                        }
                    }
                }
            }
        }
    }

    public static class MutationList
    extends ArrayList<Mutation> {
        private long byteSize = 0L;

        public MutationList() {
        }

        public MutationList(int size) {
            super(size);
        }

        @Override
        public boolean add(Mutation e) {
            boolean r = super.add(e);
            if (r) {
                this.byteSize += KeyValueUtil.calculateMutationDiskSize(e);
            }
            return r;
        }

        public long byteSize() {
            return this.byteSize;
        }

        @Override
        public void clear() {
            this.byteSize = 0L;
            super.clear();
        }
    }
}

