/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.BaseMasterAndRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.BaseMetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.MetaDataUtil;

public class PhoenixAccessController
extends BaseMetaDataEndpointObserver {
    private PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment env;
    private ArrayList<BaseMasterAndRegionObserver> accessControllers;
    private boolean accessCheckEnabled;
    private UserProvider userProvider;
    public static final Log LOG = LogFactory.getLog(PhoenixAccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + PhoenixAccessController.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BaseMasterAndRegionObserver> getAccessControllers() throws IOException {
        if (this.accessControllers == null) {
            PhoenixAccessController phoenixAccessController = this;
            synchronized (phoenixAccessController) {
                if (this.accessControllers == null) {
                    this.accessControllers = new ArrayList();
                    RegionCoprocessorHost cpHost = this.env.getCoprocessorHost();
                    List coprocessors = cpHost.findCoprocessors(BaseMasterAndRegionObserver.class);
                    for (BaseMasterAndRegionObserver cp : coprocessors) {
                        if (!(cp instanceof AccessControlProtos.AccessControlService.Interface)) continue;
                        this.accessControllers.add(cp);
                    }
                }
            }
        }
        return this.accessControllers;
    }

    @Override
    public void preGetTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        this.requireAccess("GetTable" + tenantId, physicalTableName, Permission.Action.READ, Permission.Action.EXEC);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        Configuration conf = env.getConfiguration();
        this.accessCheckEnabled = conf.getBoolean("phoenix.acls.enabled", false);
        if (!this.accessCheckEnabled) {
            LOG.warn((Object)"PhoenixAccessController has been loaded with authorization checks disabled.");
        }
        if (!(env instanceof PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment)) {
            throw new IllegalArgumentException("Not a valid environment, should be loaded by PhoenixMetaDataControllerEnvironment");
        }
        this.env = (PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment)env;
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        Superusers.initialize(env.getConfiguration());
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void preCreateTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, Set<byte[]> familySet, Set<TableName> indexes) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        if (tableType != PTableType.VIEW) {
            HTableDescriptor htd = new HTableDescriptor(physicalTableName);
            for (byte[] familyName : familySet) {
                htd.addFamily(new HColumnDescriptor(familyName));
            }
            for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
                observer.preCreateTable(new ObserverContext(), htd, null);
            }
        }
        HashSet<TableName> physicalTablesChecked = new HashSet<TableName>();
        if (tableType == PTableType.VIEW || tableType == PTableType.INDEX) {
            physicalTablesChecked.add(parentPhysicalTableName);
            this.requireAccess("Create" + (Object)((Object)tableType), parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
        }
        if (tableType == PTableType.VIEW) {
            Permission.Action[] requiredActions = new Permission.Action[]{Permission.Action.READ, Permission.Action.EXEC};
            for (TableName index : indexes) {
                if (!physicalTablesChecked.add(index)) continue;
                User user = this.getActiveUser();
                List<UserPermission> permissionForUser = this.getPermissionForUser(this.getUserPermissions(index), Bytes.toBytes((String)user.getShortName()));
                HashSet<Permission.Action> requireAccess = new HashSet<Permission.Action>();
                HashSet<Permission.Action> accessExists = new HashSet<Permission.Action>();
                if (permissionForUser != null) {
                    for (UserPermission userPermission : permissionForUser) {
                        for (Permission.Action action : Arrays.asList(requiredActions)) {
                            if (userPermission.implies(action)) continue;
                            requireAccess.add(action);
                        }
                    }
                    if (!requireAccess.isEmpty()) {
                        for (UserPermission userPermission : permissionForUser) {
                            accessExists.addAll(Arrays.asList(userPermission.getActions()));
                        }
                    }
                } else {
                    requireAccess.addAll(Arrays.asList(requiredActions));
                }
                if (requireAccess.isEmpty()) continue;
                byte[] indexPhysicalTable = index.getName();
                this.handleRequireAccessOnDependentTable("Create" + (Object)((Object)tableType), user.getName(), TableName.valueOf((byte[])indexPhysicalTable), tableName, requireAccess, accessExists);
            }
        }
        if (tableType == PTableType.INDEX && physicalTableName != null && !parentPhysicalTableName.equals((Object)physicalTableName) && !MetaDataUtil.isViewIndex(physicalTableName.getNameAsString())) {
            this.authorizeOrGrantAccessToUsers("Create" + (Object)((Object)tableType), parentPhysicalTableName, Arrays.asList(Permission.Action.READ, Permission.Action.WRITE, Permission.Action.CREATE, Permission.Action.EXEC, Permission.Action.ADMIN), physicalTableName);
        }
    }

    public void handleRequireAccessOnDependentTable(String request, String userName, TableName dependentTable, String requestTable, Set<Permission.Action> requireAccess, Set<Permission.Action> accessExists) throws IOException {
        HashSet<Permission.Action> unionSet = new HashSet<Permission.Action>();
        unionSet.addAll(requireAccess);
        unionSet.addAll(accessExists);
        AUDITLOG.info((Object)(request + ": Automatically granting access to index table during creation of view:" + requestTable + this.authString(userName, dependentTable, requireAccess)));
        this.grantPermissions(userName, dependentTable.getName(), unionSet.toArray(new Permission.Action[0]));
    }

    private void grantPermissions(final String toUser, final byte[] table, final Permission.Action ... actions) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)PhoenixAccessController.this.env.getConfiguration());){
                    AccessControlClient.grant((Connection)conn, (TableName)TableName.valueOf((byte[])table), (String)toUser, null, null, (Permission.Action[])actions);
                }
                catch (Throwable e) {
                    new DoNotRetryIOException(e);
                }
                return null;
            }
        });
    }

    private void authorizeOrGrantAccessToUsers(final String request, final TableName fromTable, final List<Permission.Action> requiredActionsOnTable, final TableName toTable) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)PhoenixAccessController.this.env.getConfiguration());){
                    List userPermissions = PhoenixAccessController.this.getUserPermissions(fromTable);
                    List permissionsOnTheTable = PhoenixAccessController.this.getUserPermissions(toTable);
                    if (userPermissions != null) {
                        for (UserPermission userPermission : userPermissions) {
                            HashSet<Permission.Action> requireAccess = new HashSet<Permission.Action>();
                            HashSet<Permission.Action> accessExists = new HashSet<Permission.Action>();
                            List permsToTable = PhoenixAccessController.this.getPermissionForUser(permissionsOnTheTable, userPermission.getUser());
                            for (Permission.Action action : requiredActionsOnTable) {
                                boolean haveAccess = false;
                                if (!userPermission.implies(action)) continue;
                                if (permsToTable == null) {
                                    requireAccess.add(action);
                                    continue;
                                }
                                for (UserPermission permToTable : permsToTable) {
                                    if (!permToTable.implies(action)) continue;
                                    haveAccess = true;
                                }
                                if (haveAccess) continue;
                                requireAccess.add(action);
                            }
                            if (permsToTable != null) {
                                for (UserPermission permToTable : permsToTable) {
                                    accessExists.addAll(Arrays.asList(permToTable.getActions()));
                                }
                            }
                            if (requireAccess.isEmpty()) continue;
                            if (AuthUtil.isGroupPrincipal((String)Bytes.toString((byte[])userPermission.getUser()))) {
                                AUDITLOG.warn((Object)("Users of GROUP:" + Bytes.toString((byte[])userPermission.getUser()) + " will not have following access " + requireAccess + " to the newly created index " + toTable + ", Automatic grant is not yet allowed on Groups"));
                                continue;
                            }
                            PhoenixAccessController.this.handleRequireAccessOnDependentTable(request, Bytes.toString((byte[])userPermission.getUser()), toTable, toTable.getNameAsString(), requireAccess, accessExists);
                        }
                    }
                }
                return null;
            }
        });
    }

    private List<UserPermission> getPermissionForUser(List<UserPermission> perms, byte[] user) {
        if (perms != null) {
            ArrayList<UserPermission> permissions = new ArrayList<UserPermission>();
            for (UserPermission p : perms) {
                if (!Bytes.equals((byte[])p.getUser(), (byte[])user)) continue;
                permissions.add(p);
            }
            if (!permissions.isEmpty()) {
                return permissions;
            }
        }
        return null;
    }

    @Override
    public void preDropTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, List<PTable> indexes) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            if (tableType != PTableType.VIEW) {
                observer.preDeleteTable(new ObserverContext(), physicalTableName);
            }
            if (indexes == null) continue;
            for (PTable index : indexes) {
                observer.preDeleteTable(new ObserverContext(), TableName.valueOf((byte[])index.getPhysicalName().getBytes()));
            }
        }
        if (tableType == PTableType.VIEW || tableType == PTableType.INDEX) {
            this.requireAccess("Drop " + (Object)((Object)tableType), parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
        }
    }

    @Override
    public void preAlterTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            if (tableType == PTableType.VIEW) continue;
            observer.preModifyTable(new ObserverContext(), physicalTableName, new HTableDescriptor(physicalTableName));
        }
        if (tableType == PTableType.VIEW) {
            this.requireAccess("Alter " + (Object)((Object)tableType), parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
        }
    }

    @Override
    public void preGetSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            observer.preListNamespaceDescriptors(new ObserverContext(), Arrays.asList(NamespaceDescriptor.create((String)schemaName).build()));
        }
    }

    @Override
    public void preCreateSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            observer.preCreateNamespace(new ObserverContext(), NamespaceDescriptor.create((String)schemaName).build());
        }
    }

    @Override
    public void preDropSchema(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String schemaName) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            observer.preDeleteNamespace(new ObserverContext(), schemaName);
        }
    }

    @Override
    public void preIndexUpdate(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String indexName, TableName physicalTableName, TableName parentPhysicalTableName, PIndexState newState) throws IOException {
        if (!this.accessCheckEnabled) {
            return;
        }
        for (BaseMasterAndRegionObserver observer : this.getAccessControllers()) {
            observer.preModifyTable(new ObserverContext(), physicalTableName, new HTableDescriptor(physicalTableName));
        }
        if (newState == PIndexState.BUILDING) {
            this.requireAccess("Rebuild:", parentPhysicalTableName, Permission.Action.READ, Permission.Action.EXEC);
        }
    }

    private List<UserPermission> getUserPermissions(final TableName tableName) throws IOException {
        return (List)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<UserPermission>>(){

            @Override
            public List<UserPermission> run() throws Exception {
                ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
                try (Connection connection = ConnectionFactory.createConnection((Configuration)PhoenixAccessController.this.env.getConfiguration());){
                    for (BaseMasterAndRegionObserver service : PhoenixAccessController.this.accessControllers) {
                        if (service.getClass().getName().equals(AccessController.class.getName())) {
                            userPermissions.addAll(AccessControlClient.getUserPermissions((Connection)connection, (String)tableName.getNameAsString()));
                            userPermissions.addAll(AccessControlClient.getUserPermissions((Connection)connection, (String)AuthUtil.toGroupEntry((String)tableName.getNamespaceAsString())));
                            continue;
                        }
                        this.getUserPermsFromUserDefinedAccessController(userPermissions, connection, (AccessControlProtos.AccessControlService.Interface)service);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new Exception(e);
                }
                return userPermissions;
            }

            private void getUserPermsFromUserDefinedAccessController(List<UserPermission> userPermissions, Connection connection, AccessControlProtos.AccessControlService.Interface service) {
                HBaseRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
                AccessControlProtos.GetUserPermissionsRequest.Builder builderTablePerms = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
                builderTablePerms.setTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
                builderTablePerms.setType(AccessControlProtos.Permission.Type.Table);
                AccessControlProtos.GetUserPermissionsRequest requestTablePerms = builderTablePerms.build();
                this.callGetUserPermissionsRequest(userPermissions, service, requestTablePerms, controller);
                AccessControlProtos.GetUserPermissionsRequest.Builder builderNamespacePerms = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
                builderNamespacePerms.setNamespaceName(ByteString.copyFrom((byte[])tableName.getNamespace()));
                builderNamespacePerms.setType(AccessControlProtos.Permission.Type.Namespace);
                AccessControlProtos.GetUserPermissionsRequest requestNamespacePerms = builderNamespacePerms.build();
                this.callGetUserPermissionsRequest(userPermissions, service, requestNamespacePerms, controller);
            }

            private void callGetUserPermissionsRequest(final List<UserPermission> userPermissions, AccessControlProtos.AccessControlService.Interface service, AccessControlProtos.GetUserPermissionsRequest request, HBaseRpcController controller) {
                service.getUserPermissions((RpcController)controller, request, (RpcCallback)new RpcCallback<AccessControlProtos.GetUserPermissionsResponse>(){

                    public void run(AccessControlProtos.GetUserPermissionsResponse message) {
                        if (message != null) {
                            for (AccessControlProtos.UserPermission perm : message.getUserPermissionList()) {
                                userPermissions.add(ProtobufUtil.toUserPermission((AccessControlProtos.UserPermission)perm));
                            }
                        }
                    }
                });
            }
        });
    }

    private void requireAccess(String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        ArrayList<Permission.Action> requiredAccess = new ArrayList<Permission.Action>();
        for (Permission.Action permission : permissions) {
            if (this.hasAccess(this.getUserPermissions(tableName), tableName, permission, user)) {
                result = AuthResult.allow((String)request, (String)"Table permission granted", (User)user, (Permission.Action)permission, (TableName)tableName, null, null);
            } else {
                result = AuthResult.deny((String)request, (String)"Insufficient permissions", (User)user, (Permission.Action)permission, (TableName)tableName, null, null);
                requiredAccess.add(permission);
            }
            this.logResult(result);
        }
        if (!requiredAccess.isEmpty()) {
            result = AuthResult.deny((String)request, (String)"Insufficient permissions", (User)user, (Permission.Action)((Permission.Action)requiredAccess.get(0)), (TableName)tableName, null, null);
        }
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + this.authString(user.getName(), tableName, new HashSet<Permission.Action>(Arrays.asList(permissions))));
        }
    }

    private boolean hasAccess(List<UserPermission> perms, TableName table, Permission.Action action, User user) {
        if (Superusers.isSuperUser(user)) {
            return true;
        }
        if (perms != null) {
            String[] groupNames;
            List<UserPermission> permissionsForUser = this.getPermissionForUser(perms, user.getShortName().getBytes());
            if (permissionsForUser != null) {
                for (UserPermission permissionForUser : permissionsForUser) {
                    if (!permissionForUser.implies(action)) continue;
                    return true;
                }
            }
            if ((groupNames = user.getGroupNames()) != null) {
                for (String group : groupNames) {
                    List<UserPermission> groupPerms = this.getPermissionForUser(perms, AuthUtil.toGroupEntry((String)group).getBytes());
                    if (groupPerms == null) continue;
                    for (UserPermission permissionForUser : groupPerms) {
                        if (!permissionForUser.implies(action)) continue;
                        return true;
                    }
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions found for table=" + table + " or namespace=" + table.getNamespaceAsString()));
        }
        return false;
    }

    private User getActiveUser() throws IOException {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            InetAddress remoteAddr = RpcServer.getRemoteAddress();
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString()));
        }
    }

    public String authString(String user, TableName table, Set<Permission.Action> actions) {
        StringBuilder sb = new StringBuilder();
        sb.append(" (user=").append(user != null ? user : "UNKNOWN").append(", ");
        sb.append("scope=").append(table == null ? "GLOBAL" : table.getNameWithNamespaceInclAsString()).append(", ");
        sb.append(actions.size() > 1 ? "actions=" : "action=").append(actions != null ? actions.toString() : "").append(")");
        return sb.toString();
    }

    private static final class Superusers {
        private static final Log LOG = LogFactory.getLog(Superusers.class);
        public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
        private static List<String> superUsers;
        private static List<String> superGroups;
        private static User systemUser;

        private Superusers() {
        }

        public static void initialize(Configuration conf) throws IOException {
            String[] superUserList;
            superUsers = new ArrayList<String>();
            superGroups = new ArrayList<String>();
            systemUser = User.getCurrent();
            if (systemUser == null) {
                throw new IllegalStateException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Current user name is " + systemUser.getShortName()));
            }
            String currentUser = systemUser.getShortName();
            for (String name : superUserList = conf.getStrings(SUPERUSER_CONF_KEY, new String[0])) {
                if (AuthUtil.isGroupPrincipal((String)name)) {
                    superGroups.add(AuthUtil.getGroupName((String)name));
                    continue;
                }
                superUsers.add(name);
            }
            superUsers.add(currentUser);
        }

        public static boolean isSuperUser(User user) {
            if (superUsers == null) {
                throw new IllegalStateException("Super users/super groups lists haven't been initialized properly.");
            }
            if (superUsers.contains(user.getShortName())) {
                return true;
            }
            for (String group : user.getGroupNames()) {
                if (!superGroups.contains(group)) continue;
                return true;
            }
            return false;
        }

        public static List<String> getSuperUsers() {
            return superUsers;
        }

        public static User getSystemUser() {
            return systemUser;
        }
    }
}

