/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PFunctionProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.util.ByteUtil;

public abstract class MetaDataProtocol
extends MetaDataProtos.MetaDataService {
    public static final int PHOENIX_MAJOR_VERSION = 4;
    public static final int PHOENIX_MINOR_VERSION = 14;
    public static final int PHOENIX_PATCH_NUMBER = 0;
    public static final int PHOENIX_VERSION = VersionUtil.encodeVersion(4, 14, 0);
    public static final long MIN_TABLE_TIMESTAMP = 0L;
    public static final long MIN_SYSTEM_TABLE_MIGRATION_TIMESTAMP = 0L;
    public static final String MIGRATION_IN_PROGRESS = "MigrationInProgress";
    public static final int DEFAULT_LOG_TTL = 604800;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_1_0 = 3L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_2_0 = 4L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_2_1 = 5L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_3_0 = 7L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_5_0 = 8L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_6_0 = 9L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_7_0 = 15L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_8_0 = 18L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_8_1 = 18L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_9_0 = 20L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_10_0 = 25L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_11_0 = 27L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_12_0 = 27L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_13_0 = 27L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP_4_14_0 = 28L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP = 28L;
    public static final int MUTABLE_SI_VERSION_THRESHOLD = VersionUtil.encodeVersion("0", "94", "10");
    public static final int MAX_LOCAL_SI_VERSION_DISALLOW = VersionUtil.encodeVersion("0", "98", "8");
    public static final int MIN_LOCAL_SI_VERSION_DISALLOW = VersionUtil.encodeVersion("0", "98", "6");
    public static final int MIN_RENEW_LEASE_VERSION = VersionUtil.encodeVersion("1", "1", "3");
    public static final int MIN_NAMESPACE_MAPPED_PHOENIX_VERSION = VersionUtil.encodeVersion("4", "8", "0");
    public static final int MIN_PENDING_ACTIVE_INDEX = VersionUtil.encodeVersion("4", "12", "0");
    public static final int MIN_CLIENT_RETRY_INDEX_WRITES = VersionUtil.encodeVersion("4", "14", "0");
    public static final int MIN_TX_CLIENT_SIDE_MAINTENANCE = VersionUtil.encodeVersion("4", "14", "0");
    public static final int MIN_PENDING_DISABLE_INDEX = VersionUtil.encodeVersion("4", "14", "0");
    public static final int ESSENTIAL_FAMILY_VERSION_THRESHOLD = VersionUtil.encodeVersion("0", "94", "7");
    public static final int CLIENT_KEY_VALUE_BUILDER_THRESHOLD = VersionUtil.encodeVersion("0", "94", "14");
    private static final NavigableMap<Long, String> TIMESTAMP_VERSION_MAP = new TreeMap<Long, String>();
    public static final String CURRENT_CLIENT_VERSION = "4.14.0";

    public static long getPriorVersion() {
        Iterator<Long> iterator = TIMESTAMP_VERSION_MAP.descendingKeySet().iterator();
        if (!iterator.hasNext()) {
            return -1L;
        }
        return iterator.next();
    }

    public static long getPriorUpgradeVersion() {
        return TIMESTAMP_VERSION_MAP.lowerKey((Long)TIMESTAMP_VERSION_MAP.lastKey());
    }

    public static String getVersion(long serverTimestamp) {
        String version = (String)TIMESTAMP_VERSION_MAP.get(TIMESTAMP_VERSION_MAP.floorKey(serverTimestamp));
        return version;
    }

    static {
        TIMESTAMP_VERSION_MAP.put(0L, MIGRATION_IN_PROGRESS);
        TIMESTAMP_VERSION_MAP.put(3L, "4.1.x");
        TIMESTAMP_VERSION_MAP.put(4L, "4.2.0");
        TIMESTAMP_VERSION_MAP.put(5L, "4.2.1");
        TIMESTAMP_VERSION_MAP.put(7L, "4.3.x");
        TIMESTAMP_VERSION_MAP.put(8L, "4.5.x");
        TIMESTAMP_VERSION_MAP.put(9L, "4.6.x");
        TIMESTAMP_VERSION_MAP.put(15L, "4.7.x");
        TIMESTAMP_VERSION_MAP.put(18L, "4.8.x");
        TIMESTAMP_VERSION_MAP.put(20L, "4.9.x");
        TIMESTAMP_VERSION_MAP.put(25L, "4.10.x");
        TIMESTAMP_VERSION_MAP.put(27L, "4.11.x");
        TIMESTAMP_VERSION_MAP.put(27L, "4.12.x");
        TIMESTAMP_VERSION_MAP.put(27L, "4.13.x");
        TIMESTAMP_VERSION_MAP.put(28L, "4.14.x");
    }

    public static class MetaDataMutationResult {
        private MutationCode returnCode;
        private long mutationTime;
        private PTable table;
        private List<byte[]> tableNamesToDelete;
        private List<SharedTableState> sharedTablesToDelete;
        private byte[] columnName;
        private byte[] familyName;
        private boolean wasUpdated;
        private PSchema schema;
        private Short viewIndexId;
        private List<PFunction> functions = new ArrayList<PFunction>(1);
        private long autoPartitionNum;

        public MetaDataMutationResult() {
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, PColumn column) {
            this(returnCode, currentTime, table);
            if (column != null) {
                this.columnName = column.getName().getBytes();
                this.familyName = column.getFamilyName().getBytes();
            }
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table) {
            this(returnCode, currentTime, table, Collections.emptyList());
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, List<PFunction> functions, boolean wasUpdated) {
            this.returnCode = returnCode;
            this.mutationTime = currentTime;
            this.functions = functions;
            this.wasUpdated = wasUpdated;
        }

        public MetaDataMutationResult(MutationCode returnCode, PSchema schema, long currentTime) {
            this.returnCode = returnCode;
            this.mutationTime = currentTime;
            this.schema = schema;
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, boolean wasUpdated) {
            this(returnCode, currentTime, table, Collections.emptyList());
            this.wasUpdated = wasUpdated;
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, List<byte[]> tableNamesToDelete) {
            this.returnCode = returnCode;
            this.mutationTime = currentTime;
            this.table = table;
            this.tableNamesToDelete = tableNamesToDelete;
        }

        public MetaDataMutationResult(MutationCode returnCode, int currentTime, PTable table, int viewIndexId) {
            this(returnCode, (long)currentTime, table, Collections.emptyList());
            this.viewIndexId = (short)viewIndexId;
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, List<byte[]> tableNamesToDelete, List<SharedTableState> sharedTablesToDelete) {
            this(returnCode, currentTime, table, tableNamesToDelete);
            this.sharedTablesToDelete = sharedTablesToDelete;
        }

        public MutationCode getMutationCode() {
            return this.returnCode;
        }

        public long getMutationTime() {
            return this.mutationTime;
        }

        public boolean wasUpdated() {
            return this.wasUpdated;
        }

        public PTable getTable() {
            return this.table;
        }

        public void setTable(PTable table) {
            this.table = table;
        }

        public void setFunction(PFunction function) {
            this.functions.add(function);
        }

        public List<byte[]> getTableNamesToDelete() {
            return this.tableNamesToDelete;
        }

        public byte[] getColumnName() {
            return this.columnName;
        }

        public byte[] getFamilyName() {
            return this.familyName;
        }

        public List<PFunction> getFunctions() {
            return this.functions;
        }

        public List<SharedTableState> getSharedTablesToDelete() {
            return this.sharedTablesToDelete;
        }

        public long getAutoPartitionNum() {
            return this.autoPartitionNum;
        }

        public Short getViewIndexId() {
            return this.viewIndexId;
        }

        public static MetaDataMutationResult constructFromProto(MetaDataProtos.MetaDataResponse proto) {
            MetaDataMutationResult result = new MetaDataMutationResult();
            result.returnCode = MutationCode.values()[proto.getReturnCode().ordinal()];
            result.mutationTime = proto.getMutationTime();
            if (proto.hasTable()) {
                result.wasUpdated = true;
                result.table = PTableImpl.createFromProto(proto.getTable());
            }
            if (proto.getFunctionCount() > 0) {
                result.wasUpdated = true;
                for (PFunctionProtos.PFunction function : proto.getFunctionList()) {
                    result.functions.add(PFunction.createFromProto(function));
                }
            }
            if (proto.getTablesToDeleteCount() > 0) {
                result.tableNamesToDelete = Lists.newArrayListWithExpectedSize((int)proto.getTablesToDeleteCount());
                for (ByteString tableName : proto.getTablesToDeleteList()) {
                    result.tableNamesToDelete.add(tableName.toByteArray());
                }
            }
            result.columnName = ByteUtil.EMPTY_BYTE_ARRAY;
            if (proto.hasColumnName()) {
                result.columnName = proto.getColumnName().toByteArray();
            }
            if (proto.hasFamilyName()) {
                result.familyName = proto.getFamilyName().toByteArray();
            }
            if (proto.getSharedTablesToDeleteCount() > 0) {
                result.sharedTablesToDelete = Lists.newArrayListWithExpectedSize((int)proto.getSharedTablesToDeleteCount());
                for (MetaDataProtos.SharedTableState sharedTable : proto.getSharedTablesToDeleteList()) {
                    result.sharedTablesToDelete.add(new SharedTableState(sharedTable));
                }
            }
            if (proto.hasSchema()) {
                result.schema = PSchema.createFromProto(proto.getSchema());
            }
            if (proto.hasAutoPartitionNum()) {
                result.autoPartitionNum = proto.getAutoPartitionNum();
            }
            if (proto.hasViewIndexId()) {
                result.viewIndexId = (short)proto.getViewIndexId();
            }
            return result;
        }

        public static MetaDataProtos.MetaDataResponse toProto(MetaDataMutationResult result) {
            MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
            if (result != null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.values()[result.getMutationCode().ordinal()]);
                builder.setMutationTime(result.getMutationTime());
                if (result.table != null) {
                    builder.setTable(PTableImpl.toProto(result.table));
                }
                if (result.getTableNamesToDelete() != null) {
                    for (byte[] tableName : result.tableNamesToDelete) {
                        builder.addTablesToDelete(ByteStringer.wrap((byte[])tableName));
                    }
                }
                if (result.getColumnName() != null) {
                    builder.setColumnName(ByteStringer.wrap((byte[])result.getColumnName()));
                }
                if (result.getFamilyName() != null) {
                    builder.setFamilyName(ByteStringer.wrap((byte[])result.getFamilyName()));
                }
                if (result.getSharedTablesToDelete() != null) {
                    for (SharedTableState sharedTableState : result.sharedTablesToDelete) {
                        MetaDataProtos.SharedTableState.Builder sharedTableStateBuilder = MetaDataProtos.SharedTableState.newBuilder();
                        for (PColumn col : sharedTableState.getColumns()) {
                            sharedTableStateBuilder.addColumns(PColumnImpl.toProto(col));
                        }
                        for (PName physicalName : sharedTableState.getPhysicalNames()) {
                            sharedTableStateBuilder.addPhysicalNames(ByteStringer.wrap((byte[])physicalName.getBytes()));
                        }
                        if (sharedTableState.getTenantId() != null) {
                            sharedTableStateBuilder.setTenantId(ByteStringer.wrap((byte[])sharedTableState.getTenantId().getBytes()));
                        }
                        sharedTableStateBuilder.setSchemaName(ByteStringer.wrap((byte[])sharedTableState.getSchemaName().getBytes()));
                        sharedTableStateBuilder.setTableName(ByteStringer.wrap((byte[])sharedTableState.getTableName().getBytes()));
                        sharedTableStateBuilder.setViewIndexId(sharedTableState.getViewIndexId().shortValue());
                        builder.addSharedTablesToDelete(sharedTableStateBuilder.build());
                    }
                }
                if (result.getSchema() != null) {
                    builder.setSchema(PSchema.toProto(result.schema));
                }
                builder.setAutoPartitionNum(result.getAutoPartitionNum());
                if (result.getViewIndexId() != null) {
                    builder.setViewIndexId(result.getViewIndexId().shortValue());
                }
            }
            return builder.build();
        }

        public PSchema getSchema() {
            return this.schema;
        }
    }

    public static class SharedTableState {
        private PName tenantId;
        private PName schemaName;
        private PName tableName;
        private List<PColumn> columns;
        private List<PName> physicalNames;
        private Short viewIndexId;

        public SharedTableState(PTable table) {
            this.tenantId = table.getTenantId();
            this.schemaName = table.getSchemaName();
            this.tableName = table.getTableName();
            this.columns = table.getColumns();
            this.physicalNames = table.getPhysicalNames();
            this.viewIndexId = table.getViewIndexId();
        }

        public SharedTableState(MetaDataProtos.SharedTableState sharedTable) {
            this.tenantId = sharedTable.hasTenantId() ? PNameFactory.newName(sharedTable.getTenantId().toByteArray()) : null;
            this.schemaName = PNameFactory.newName(sharedTable.getSchemaName().toByteArray());
            this.tableName = PNameFactory.newName(sharedTable.getTableName().toByteArray());
            this.columns = Lists.transform(sharedTable.getColumnsList(), (Function)new Function<PTableProtos.PColumn, PColumn>(){

                public PColumn apply(PTableProtos.PColumn column) {
                    return PColumnImpl.createFromProto(column);
                }
            });
            this.physicalNames = Lists.transform(sharedTable.getPhysicalNamesList(), (Function)new Function<ByteString, PName>(){

                public PName apply(ByteString physicalName) {
                    return PNameFactory.newName(physicalName.toByteArray());
                }
            });
            this.viewIndexId = (short)sharedTable.getViewIndexId();
        }

        public PName getTenantId() {
            return this.tenantId;
        }

        public PName getSchemaName() {
            return this.schemaName;
        }

        public PName getTableName() {
            return this.tableName;
        }

        public List<PColumn> getColumns() {
            return this.columns;
        }

        public List<PName> getPhysicalNames() {
            return this.physicalNames;
        }

        public Short getViewIndexId() {
            return this.viewIndexId;
        }
    }

    public static enum MutationCode {
        TABLE_ALREADY_EXISTS,
        TABLE_NOT_FOUND,
        COLUMN_NOT_FOUND,
        COLUMN_ALREADY_EXISTS,
        CONCURRENT_TABLE_MUTATION,
        TABLE_NOT_IN_REGION,
        NEWER_TABLE_FOUND,
        UNALLOWED_TABLE_MUTATION,
        NO_PK_COLUMNS,
        PARENT_TABLE_NOT_FOUND,
        FUNCTION_ALREADY_EXISTS,
        FUNCTION_NOT_FOUND,
        NEWER_FUNCTION_FOUND,
        FUNCTION_NOT_IN_REGION,
        SCHEMA_ALREADY_EXISTS,
        NEWER_SCHEMA_FOUND,
        SCHEMA_NOT_FOUND,
        SCHEMA_NOT_IN_REGION,
        TABLES_EXIST_ON_SCHEMA,
        UNALLOWED_SCHEMA_MUTATION,
        AUTO_PARTITION_SEQUENCE_NOT_FOUND,
        CANNOT_COERCE_AUTO_PARTITION_ID,
        TOO_MANY_INDEXES,
        NO_OP;

    }
}

