/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class WhereOptimizer {
    private static final List<KeyRange> EVERYTHING_RANGES = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    private static final List<KeyRange> SALT_PLACEHOLDER = Collections.singletonList(PChar.INSTANCE.getKeyRange(QueryConstants.SEPARATOR_BYTE_ARRAY));

    private WhereOptimizer() {
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, FilterableStatement statement, Expression whereClause) throws SQLException {
        return WhereOptimizer.pushKeyExpressionsToScan(context, statement, whereClause, null);
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, FilterableStatement statement, Expression whereClause, Set<Expression> extractNodes) throws SQLException {
        boolean hasViewIndex;
        boolean isSharedIndex;
        PName tenantId = context.getConnection().getTenantId();
        byte[] tenantIdBytes = null;
        PTable table = context.getCurrentTable().getTable();
        Integer nBuckets = table.getBucketNum();
        boolean isSalted = nBuckets != null;
        RowKeySchema schema = table.getRowKeySchema();
        boolean isMultiTenant = tenantId != null && table.isMultiTenant();
        boolean bl = isSharedIndex = table.getViewIndexId() != null;
        if (isMultiTenant) {
            tenantIdBytes = ScanUtil.getTenantIdBytes(schema, isSalted, tenantId, isSharedIndex);
        }
        if (!(whereClause != null || tenantId != null && table.isMultiTenant() || table.getViewIndexId() != null)) {
            context.setScanRanges(ScanRanges.EVERYTHING);
            return whereClause;
        }
        if (LiteralExpression.isBooleanFalseOrNull(whereClause)) {
            context.setScanRanges(ScanRanges.NOTHING);
            return null;
        }
        KeyExpressionVisitor visitor = new KeyExpressionVisitor(context, table);
        KeyExpressionVisitor.KeySlots keySlots = null;
        if (whereClause != null) {
            keySlots = whereClause.accept(visitor);
            if (!(keySlots != null || tenantId != null && table.isMultiTenant() || table.getViewIndexId() != null)) {
                context.setScanRanges(ScanRanges.EVERYTHING);
                return whereClause;
            }
            if (keySlots == KeyExpressionVisitor.EMPTY_KEY_SLOTS) {
                context.setScanRanges(ScanRanges.NOTHING);
                return null;
            }
        }
        if (keySlots == null) {
            keySlots = KeyExpressionVisitor.EMPTY_KEY_SLOTS;
        }
        if (extractNodes == null) {
            extractNodes = new HashSet<Expression>(table.getPKColumns().size());
        }
        int pkPos = 0;
        int nPKColumns = table.getPKColumns().size();
        int[] slotSpan = new int[nPKColumns];
        ArrayList cnf = Lists.newArrayListWithExpectedSize((int)schema.getMaxFields());
        KeyRange minMaxRange = keySlots.getMinMaxRange();
        if (minMaxRange == null) {
            minMaxRange = KeyRange.EVERYTHING_RANGE;
        }
        boolean hasMinMaxRange = minMaxRange != KeyRange.EVERYTHING_RANGE;
        int minMaxRangeOffset = 0;
        byte[] minMaxRangePrefix = null;
        boolean bl2 = hasViewIndex = table.getViewIndexId() != null;
        if (hasMinMaxRange) {
            int minMaxRangeSize = (isSalted ? 1 : 0) + (isMultiTenant ? tenantIdBytes.length + 1 : 0) + (hasViewIndex ? MetaDataUtil.getViewIndexIdDataType().getByteSize() : 0);
            minMaxRangePrefix = new byte[minMaxRangeSize];
        }
        Iterator<KeyExpressionVisitor.KeySlot> iterator = keySlots.iterator();
        if (isSalted) {
            cnf.add(SALT_PLACEHOLDER);
            if (hasMinMaxRange) {
                System.arraycopy(SALT_PLACEHOLDER.get(0).getLowerRange(), 0, minMaxRangePrefix, minMaxRangeOffset, 1);
                ++minMaxRangeOffset;
            }
            ++pkPos;
        }
        if (hasViewIndex) {
            byte[] viewIndexBytes = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
            KeyRange indexIdKeyRange = KeyRange.getKeyRange(viewIndexBytes);
            cnf.add(Collections.singletonList(indexIdKeyRange));
            if (hasMinMaxRange) {
                System.arraycopy(viewIndexBytes, 0, minMaxRangePrefix, minMaxRangeOffset, viewIndexBytes.length);
                minMaxRangeOffset += viewIndexBytes.length;
            }
            ++pkPos;
        }
        if (isMultiTenant) {
            KeyRange tenantIdKeyRange = KeyRange.getKeyRange(tenantIdBytes);
            cnf.add(Collections.singletonList(tenantIdKeyRange));
            if (hasMinMaxRange) {
                System.arraycopy(tenantIdBytes, 0, minMaxRangePrefix, minMaxRangeOffset, tenantIdBytes.length);
                minMaxRangeOffset += tenantIdBytes.length;
                ValueSchema.Field f = schema.getField(pkPos);
                if (!f.getDataType().isFixedWidth()) {
                    minMaxRangePrefix[minMaxRangeOffset] = SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), tenantIdBytes.length == 0, f);
                    ++minMaxRangeOffset;
                }
            }
            ++pkPos;
        }
        if (hasMinMaxRange) {
            minMaxRange = minMaxRange.prependRange(minMaxRangePrefix, 0, minMaxRangeOffset);
        }
        boolean forcedSkipScan = statement.getHint().hasHint(HintNode.Hint.SKIP_SCAN);
        boolean forcedRangeScan = statement.getHint().hasHint(HintNode.Hint.RANGE_SCAN);
        boolean hasUnboundedRange = false;
        boolean hasMultiRanges = false;
        boolean hasRangeKey = false;
        boolean stopExtracting = false;
        boolean useSkipScan = false;
        while (iterator.hasNext()) {
            KeyExpressionVisitor.KeySlot slot = iterator.next();
            if (slot == null || slot.getKeyRanges().isEmpty()) continue;
            if (slot.getPKPosition() != pkPos) {
                if (!forcedSkipScan) {
                    stopExtracting = true;
                } else {
                    useSkipScan |= !stopExtracting && !forcedRangeScan && forcedSkipScan;
                }
                for (int i = pkPos; i < slot.getPKPosition(); ++i) {
                    cnf.add(Collections.singletonList(KeyRange.EVERYTHING_RANGE));
                }
            }
            KeyPart keyPart = slot.getKeyPart();
            slotSpan[cnf.size()] = slot.getPKSpan() - 1;
            pkPos = slot.getPKPosition() + slot.getPKSpan();
            for (int i = 1; i < slot.getPKSpan() && iterator.hasNext(); ++i) {
                iterator.next();
            }
            List<KeyRange> keyRanges = slot.getKeyRanges();
            cnf.add(keyRanges);
            useSkipScan |= !(stopExtracting |= hasUnboundedRange && !forcedSkipScan || hasRangeKey && forcedRangeScan) && !forcedRangeScan && (keyRanges.size() > 1 || hasRangeKey);
            for (int i = 0; !(hasUnboundedRange && hasRangeKey || i >= keyRanges.size()); ++i) {
                KeyRange range = keyRanges.get(i);
                if (range.isUnbound()) {
                    hasRangeKey = true;
                    hasUnboundedRange = true;
                    continue;
                }
                if (range.isSingleKey()) continue;
                hasRangeKey = true;
            }
            if (stopExtracting |= forcedRangeScan && (hasMultiRanges |= keyRanges.size() > 1)) continue;
            List<Expression> nodesToExtract = keyPart.getExtractNodes();
            extractNodes.addAll(nodesToExtract);
        }
        slotSpan = Arrays.copyOf(slotSpan, cnf.size());
        ScanRanges scanRanges = ScanRanges.create(schema, cnf, slotSpan, minMaxRange, nBuckets, useSkipScan, table.getRowTimestampColPos());
        context.setScanRanges(scanRanges);
        if (whereClause == null) {
            return null;
        }
        return whereClause.accept(new RemoveExtractedNodesVisitor(extractNodes));
    }

    public static boolean getKeyExpressionCombination(List<Expression> result, StatementContext context, FilterableStatement statement, List<Expression> expressions) throws SQLException {
        int count;
        ArrayList candidateIndexes = Lists.newArrayList();
        final ArrayList pkPositions = Lists.newArrayList();
        PTable table = context.getCurrentTable().getTable();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = expressions.get(i);
            KeyExpressionVisitor visitor = new KeyExpressionVisitor(context, table);
            KeyExpressionVisitor.KeySlots keySlots = expression.accept(visitor);
            int minPkPos = Integer.MAX_VALUE;
            if (keySlots == null) continue;
            for (KeyExpressionVisitor.KeySlot slot : keySlots) {
                if (slot.getPKPosition() >= minPkPos) continue;
                minPkPos = slot.getPKPosition();
            }
            if (minPkPos == Integer.MAX_VALUE) continue;
            candidateIndexes.add(i);
            pkPositions.add(minPkPos);
        }
        if (candidateIndexes.isEmpty()) {
            return false;
        }
        Collections.sort(candidateIndexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer left, Integer right) {
                return (Integer)pkPositions.get(left) - (Integer)pkPositions.get(right);
            }
        });
        ArrayList candidates = Lists.newArrayList();
        ArrayList sampleValues = Lists.newArrayList();
        for (Integer index : candidateIndexes) {
            candidates.add(expressions.get(index));
        }
        for (int i = 0; i < 2; ++i) {
            ArrayList group = Lists.newArrayList();
            for (Expression expression : candidates) {
                PDataType type = expression.getDataType();
                group.add(LiteralExpression.newConstant(type.getSampleValue(), type));
            }
            sampleValues.add(group);
        }
        int offset = table.getBucketNum() == null ? 0 : 1;
        int maxPkSpan = 0;
        Object remaining = null;
        for (count = 0; count < candidates.size(); ++count) {
            Expression lhs = count == 0 ? (Expression)candidates.get(0) : new RowValueConstructorExpression(candidates.subList(0, count + 1), false);
            Expression firstRhs = count == 0 ? (Expression)((List)sampleValues.get(0)).get(0) : new RowValueConstructorExpression(((List)sampleValues.get(0)).subList(0, count + 1), true);
            Expression secondRhs = count == 0 ? (Expression)((List)sampleValues.get(1)).get(0) : new RowValueConstructorExpression(((List)sampleValues.get(1)).subList(0, count + 1), true);
            Expression testExpression = InListExpression.create(Lists.newArrayList((Object[])new Expression[]{lhs, firstRhs, secondRhs}), false, context.getTempPtr(), context.getCurrentTable().getTable().rowKeyOrderOptimizable());
            remaining = WhereOptimizer.pushKeyExpressionsToScan(context, statement, testExpression);
            if (context.getScanRanges().isPointLookup()) {
                ++count;
                break;
            }
            int pkSpan = context.getScanRanges().getBoundPkColumnCount() - offset;
            if (pkSpan <= maxPkSpan) break;
            maxPkSpan = pkSpan;
        }
        result.addAll(candidates.subList(0, count));
        return !(count != candidates.size() || !context.getScanRanges().isPointLookup() && !context.getScanRanges().useSkipScanFilter() || remaining != null && !remaining.equals(LiteralExpression.newConstant((Object)true, Determinism.ALWAYS)));
    }

    public static class KeyExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<KeySlots> {
        private static final KeySlots EMPTY_KEY_SLOTS = new KeySlots(){

            @Override
            public Iterator<KeySlot> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public KeyRange getMinMaxRange() {
                return null;
            }

            @Override
            public boolean isPartialExtraction() {
                return false;
            }
        };
        private final PTable table;
        private final StatementContext context;

        private static boolean isDegenerate(List<KeyRange> keyRanges) {
            return keyRanges == null || keyRanges.isEmpty() || keyRanges.size() == 1 && keyRanges.get(0) == KeyRange.EMPTY_RANGE;
        }

        private KeySlots newKeyParts(KeySlot slot, Expression extractNode, KeyRange keyRange) {
            if (keyRange == null) {
                return EMPTY_KEY_SLOTS;
            }
            List<KeyRange> keyRanges = slot.getPKSpan() == 1 ? Collections.singletonList(keyRange) : EVERYTHING_RANGES;
            KeyRange minMaxRange = null;
            if (slot.getPKSpan() > 1) {
                int initPosition = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
                if (initPosition == slot.getPKPosition()) {
                    minMaxRange = keyRange;
                } else {
                    extractNode = null;
                }
            }
            return this.newKeyParts(slot, extractNode, keyRanges, minMaxRange);
        }

        private KeySlots newKeyParts(KeySlot slot, Expression extractNode, List<KeyRange> keyRanges, KeyRange minMaxRange) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return EMPTY_KEY_SLOTS;
            }
            List extractNodes = extractNode == null || slot.getKeyPart().getExtractNodes().isEmpty() ? Collections.emptyList() : Collections.singletonList(extractNode);
            return new SingleKeySlot(new BaseKeyPart(this.table, slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, minMaxRange, slot.getOrderPreserving());
        }

        private KeySlots newKeyParts(KeySlot slot, List<Expression> extractNodes, List<KeyRange> keyRanges, KeyRange minMaxRange) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return EMPTY_KEY_SLOTS;
            }
            return new SingleKeySlot(new BaseKeyPart(this.table, slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, minMaxRange, slot.getOrderPreserving());
        }

        private KeySlots newRowValueConstructorKeyParts(RowValueConstructorExpression rvc, List<KeySlots> childSlots) {
            int pkPosition;
            KeySlots slots;
            KeySlot keySlot;
            List<Expression> childExtractNodes;
            if (childSlots.isEmpty() || rvc.isStateless()) {
                return null;
            }
            int position = -1;
            int initialPosition = -1;
            for (int i = 0; i < childSlots.size() && (childExtractNodes = (keySlot = (slots = childSlots.get(i)).iterator().next()).getKeyPart().getExtractNodes()).size() == 1 && childExtractNodes.get(0).equals(rvc.getChildren().get(i)) && (pkPosition = keySlot.getPKPosition()) >= 0; ++i) {
                if (position == -1) {
                    position = initialPosition = pkPosition;
                } else if (pkPosition != position) break;
                ++position;
                assert (keySlot.getOrderPreserving() != FunctionExpression.OrderPreserving.NO);
                if (keySlot.getOrderPreserving() == FunctionExpression.OrderPreserving.YES_IF_LAST) break;
            }
            if (position > 0) {
                int span = position - initialPosition;
                return new SingleKeySlot((KeyPart)new RowValueConstructorKeyPart(this.table.getPKColumns().get(initialPosition), rvc, span, childSlots), initialPosition, span, EVERYTHING_RANGES);
            }
            return null;
        }

        private KeySlots newScalarFunctionKeyPart(KeySlot slot, ScalarFunction node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return EMPTY_KEY_SLOTS;
            }
            KeyPart part = node.newKeyPart(slot.getKeyPart());
            if (part == null) {
                return null;
            }
            return new SingleKeySlot(part, slot.getPKPosition(), slot.getKeyRanges(), node.preservesOrder());
        }

        private KeySlots newCoerceKeyPart(KeySlot slot, final CoerceExpression node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return EMPTY_KEY_SLOTS;
            }
            final List<CoerceExpression> extractNodes = Collections.singletonList(node);
            final KeyPart childPart = slot.getKeyPart();
            final ImmutableBytesWritable ptr = this.context.getTempPtr();
            return new SingleKeySlot(new KeyPart(){

                @Override
                public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                    KeyRange range = childPart.getKeyRange(op, rhs);
                    byte[] lower = range.getLowerRange();
                    if (!range.lowerUnbound()) {
                        ptr.set(lower);
                        node.getChild().getDataType().coerceBytes(ptr, node.getDataType(), rhs.getSortOrder(), node.getChild().getSortOrder());
                        lower = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    }
                    byte[] upper = range.getUpperRange();
                    if (!range.upperUnbound()) {
                        ptr.set(upper);
                        node.getChild().getDataType().coerceBytes(ptr, node.getDataType(), rhs.getSortOrder(), node.getChild().getSortOrder());
                        upper = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    }
                    return KeyRange.getKeyRange(lower, range.isLowerInclusive(), upper, range.isUpperInclusive());
                }

                @Override
                public List<Expression> getExtractNodes() {
                    return extractNodes;
                }

                @Override
                public PColumn getColumn() {
                    return childPart.getColumn();
                }

                @Override
                public PTable getTable() {
                    return childPart.getTable();
                }
            }, slot.getPKPosition(), (List)slot.getKeyRanges());
        }

        private static boolean intersectSlots(KeySlot[] slotArray, KeySlot childSlot) {
            int childPosition = childSlot.getPKPosition();
            int childSpan = childSlot.getPKSpan();
            boolean filled = false;
            for (KeySlot slot : slotArray) {
                if (slot == null) continue;
                int position = slot.getPKPosition();
                int span = slot.getPKSpan();
                if (childPosition + childSpan <= position || childPosition >= position + span) continue;
                if (childPosition < position || childPosition == position && childSpan > span) {
                    slotArray[childPosition] = childSlot = childSlot.intersect(slot);
                    if (childSlot == null) {
                        return false;
                    }
                    filled = true;
                    continue;
                }
                slotArray[position] = slot = slot.intersect(childSlot);
                if (slot == null) {
                    return false;
                }
                filled = true;
            }
            if (!filled) {
                slotArray[childPosition] = childSlot;
            }
            return true;
        }

        private KeySlots andKeySlots(AndExpression andExpression, List<KeySlots> childSlots) {
            if (childSlots.isEmpty()) {
                return null;
            }
            int nColumns = this.table.getPKColumns().size();
            KeySlot[] keySlot = new KeySlot[nColumns];
            KeyRange minMaxRange = KeyRange.EVERYTHING_RANGE;
            ArrayList minMaxExtractNodes = Lists.newArrayList();
            int initPosition = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            boolean partialExtraction = andExpression.getChildren().size() != childSlots.size();
            for (KeySlots childSlot : childSlots) {
                if (childSlot == EMPTY_KEY_SLOTS) {
                    return EMPTY_KEY_SLOTS;
                }
                partialExtraction |= childSlot.isPartialExtraction();
                if (childSlot.getMinMaxRange() != null) {
                    minMaxRange = minMaxRange.intersect(childSlot.getMinMaxRange());
                    for (KeySlot slot : childSlot) {
                        if (slot == null) continue;
                        if (slot.getPKPosition() == initPosition) {
                            minMaxExtractNodes.addAll(slot.getKeyPart().getExtractNodes());
                            continue;
                        }
                        if (KeyExpressionVisitor.intersectSlots(keySlot, slot)) continue;
                        return EMPTY_KEY_SLOTS;
                    }
                    continue;
                }
                for (KeySlot slot : childSlot) {
                    if (slot == null || KeyExpressionVisitor.intersectSlots(keySlot, slot)) continue;
                    return EMPTY_KEY_SLOTS;
                }
            }
            if (!minMaxExtractNodes.isEmpty()) {
                keySlot[initPosition] = keySlot[initPosition] == null ? new KeySlot(new BaseKeyPart(this.table, this.table.getPKColumns().get(initPosition), minMaxExtractNodes), initPosition, 1, EVERYTHING_RANGES, null) : keySlot[initPosition].concatExtractNodes(minMaxExtractNodes);
            }
            List<KeySlot> keySlots = Arrays.asList(keySlot);
            keySlots = keySlots.subList(initPosition, keySlots.size());
            return new MultiKeySlot(keySlots, minMaxRange == KeyRange.EVERYTHING_RANGE ? null : minMaxRange, partialExtraction);
        }

        private KeySlots orKeySlots(OrExpression orExpression, List<KeySlots> childSlots) {
            if (orExpression.getChildren().size() != childSlots.size()) {
                return null;
            }
            int initialPos = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            KeySlot theSlot = null;
            List<Object> slotExtractNodes = Lists.newArrayList();
            int thePosition = -1;
            boolean partialExtraction = false;
            List<Object> slotRanges = Lists.newArrayList();
            KeyRange minMaxRange = KeyRange.EMPTY_RANGE;
            for (KeySlots childSlot : childSlots) {
                if (childSlot == EMPTY_KEY_SLOTS) continue;
                partialExtraction |= childSlot.isPartialExtraction();
                if (childSlot.getMinMaxRange() != null) {
                    if (!slotRanges.isEmpty() && thePosition != initialPos) {
                        return null;
                    }
                    minMaxRange = minMaxRange.union(childSlot.getMinMaxRange());
                    thePosition = initialPos;
                    for (KeySlot slot : childSlot) {
                        if (slot == null) continue;
                        slotExtractNodes.addAll(slot.getKeyPart().getExtractNodes());
                    }
                    continue;
                }
                for (KeySlot slot : childSlot) {
                    if (slot == null) continue;
                    if (thePosition == -1) {
                        theSlot = slot;
                        thePosition = slot.getPKPosition();
                    } else if (thePosition != slot.getPKPosition()) {
                        return null;
                    }
                    slotExtractNodes.addAll(slot.getKeyPart().getExtractNodes());
                    slotRanges.addAll(slot.getKeyRanges());
                }
            }
            if (thePosition == -1) {
                return null;
            }
            if (!slotRanges.isEmpty() && minMaxRange != KeyRange.EMPTY_RANGE) {
                boolean clearExtracts = false;
                for (KeyRange keyRange : slotRanges) {
                    KeyRange intersection;
                    if (!(clearExtracts || (intersection = minMaxRange.intersect(keyRange)) != KeyRange.EMPTY_RANGE && keyRange.equals(intersection.union(keyRange)) && minMaxRange.equals(intersection.union(minMaxRange)))) {
                        clearExtracts = true;
                    }
                    minMaxRange = minMaxRange.union(keyRange);
                }
                if (clearExtracts) {
                    partialExtraction = true;
                    slotExtractNodes = Collections.emptyList();
                }
                slotRanges = Collections.emptyList();
            }
            if (theSlot == null) {
                theSlot = new KeySlot(new BaseKeyPart(this.table, this.table.getPKColumns().get(initialPos), slotExtractNodes), initialPos, 1, EVERYTHING_RANGES, null);
            } else if (minMaxRange != KeyRange.EMPTY_RANGE && !slotExtractNodes.isEmpty()) {
                theSlot = theSlot.concatExtractNodes((List<Expression>)slotExtractNodes);
            }
            return this.newKeyParts(theSlot, (List<Expression>)(partialExtraction ? slotExtractNodes : Collections.singletonList(orExpression)), slotRanges.isEmpty() ? EVERYTHING_RANGES : KeyRange.coalesce((List<KeyRange>)slotRanges), minMaxRange == KeyRange.EMPTY_RANGE ? null : minMaxRange);
        }

        public KeyExpressionVisitor(StatementContext context, PTable table) {
            this.context = context;
            this.table = table;
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(CoerceExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return this.newCoerceKeyPart(childParts.get(0).iterator().next(), node);
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(AndExpression node, List<KeySlots> l) {
            KeySlots keyExpr = this.andKeySlots(node, l);
            return keyExpr;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(OrExpression node, List<KeySlots> l) {
            KeySlots keySlots = this.orKeySlots(node, l);
            if (keySlots == null) {
                return null;
            }
            return keySlots;
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(RowValueConstructorExpression node, List<KeySlots> childSlots) {
            return this.newRowValueConstructorKeyParts(node, childSlots);
        }

        @Override
        public KeySlots visit(RowKeyColumnExpression node) {
            PColumn column = this.table.getPKColumns().get(node.getPosition());
            return new SingleKeySlot((KeyPart)new BaseKeyPart(this.table, column, Collections.singletonList(node)), node.getPosition(), 1, EVERYTHING_RANGES);
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression node) {
            Expression rhs = node.getChildren().get(1);
            if (!rhs.isStateless() || node.getFilterOp() == CompareFilter.CompareOp.NOT_EQUAL) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(ComparisonExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            Expression rhs = node.getChildren().get(1);
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            KeyPart childPart = childSlot.getKeyPart();
            SortOrder sortOrder = childPart.getColumn().getSortOrder();
            CompareFilter.CompareOp op = sortOrder.transform(node.getFilterOp());
            KeyRange keyRange = childPart.getKeyRange(op, rhs);
            return this.newKeyParts(childSlot, node, keyRange);
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            int index = node.getKeyFormationTraversalIndex();
            if (index < 0) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(index));
        }

        @Override
        public KeySlots visitLeave(ScalarFunction node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return this.newScalarFunctionKeyPart(childParts.get(0).iterator().next(), node);
        }

        @Override
        public Iterator<Expression> visitEnter(LikeExpression node) {
            if (node.getLikeType() == LikeParseNode.LikeType.CASE_INSENSITIVE || !(node.getChildren().get(1) instanceof LiteralExpression) || node.startsWithWildcard()) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(LikeExpression node, List<KeySlots> childParts) {
            Integer childNodeFixedLength;
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            String startsWith = node.getLiteralPrefix();
            SortOrder sortOrder = node.getChildren().get(0).getSortOrder();
            byte[] key = PVarchar.INSTANCE.toBytes(startsWith, sortOrder);
            Expression firstChild = node.getChildren().get(0);
            Integer n = childNodeFixedLength = firstChild.getDataType().isFixedWidth() ? firstChild.getMaxLength() : null;
            if (childNodeFixedLength != null && key.length > childNodeFixedLength) {
                return EMPTY_KEY_SLOTS;
            }
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            byte[] lowerRange = key;
            byte[] upperRange = ByteUtil.nextKey(key);
            Integer columnFixedLength = column.getMaxLength();
            if (type.isFixedWidth()) {
                if (columnFixedLength != null) {
                    lowerRange = type.pad(lowerRange, columnFixedLength, SortOrder.ASC);
                    upperRange = type.pad(upperRange, columnFixedLength, SortOrder.ASC);
                }
            } else if (column.getSortOrder() == SortOrder.DESC && this.table.rowKeyOrderOptimizable()) {
                lowerRange = Arrays.copyOf(lowerRange, lowerRange.length + 1);
                lowerRange[lowerRange.length - 1] = 0;
            }
            KeyRange keyRange = type.getKeyRange(lowerRange, true, upperRange, false);
            return this.newKeyParts(childSlot, node.endsWithOnlyWildcard() ? node : null, keyRange);
        }

        @Override
        public Iterator<Expression> visitEnter(InListExpression node) {
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(InListExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            List<Expression> keyExpressions = node.getKeyExpressions();
            HashSet ranges = Sets.newHashSetWithExpectedSize((int)keyExpressions.size());
            KeySlot childSlot = childParts.get(0).iterator().next();
            KeyPart childPart = childSlot.getKeyPart();
            for (Expression key : keyExpressions) {
                KeyRange range = childPart.getKeyRange(CompareFilter.CompareOp.EQUAL, key);
                if (range == null) {
                    return null;
                }
                if (range == KeyRange.EMPTY_RANGE) continue;
                ranges.add(range);
            }
            return this.newKeyParts(childSlot, node, new ArrayList<KeyRange>(ranges), null);
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression node) {
            return Iterators.singletonIterator((Object)node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(IsNullExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            boolean isFixedWidth = type.isFixedWidth();
            if (isFixedWidth) {
                return node.isNegate() ? null : this.newKeyParts(childSlot, node, type.getKeyRange(new byte[SchemaUtil.getFixedByteSize(column)], true, KeyRange.UNBOUND, true));
            }
            KeyRange keyRange = node.isNegate() ? KeyRange.IS_NOT_NULL_RANGE : KeyRange.IS_NULL_RANGE;
            return this.newKeyParts(childSlot, node, keyRange);
        }

        private class RowValueConstructorKeyPart
        implements KeyPart {
            private final RowValueConstructorExpression rvc;
            private final PColumn column;
            private final List<Expression> nodes;
            private final List<KeySlots> childSlots;

            private RowValueConstructorKeyPart(PColumn column, RowValueConstructorExpression rvc, int span, List<KeySlots> childSlots) {
                this.column = column;
                if (span == rvc.getChildren().size()) {
                    this.rvc = rvc;
                    this.nodes = Collections.singletonList(rvc);
                    this.childSlots = childSlots;
                } else {
                    this.rvc = new RowValueConstructorExpression(rvc.getChildren().subList(0, span), rvc.isStateless());
                    this.nodes = Collections.emptyList();
                    this.childSlots = childSlots.subList(0, span);
                }
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }

            @Override
            public PTable getTable() {
                return KeyExpressionVisitor.this.table;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                CompareFilter.CompareOp rvcElementOp;
                boolean usedAllOfLHS;
                boolean bl = usedAllOfLHS = !this.nodes.isEmpty();
                CompareFilter.CompareOp compareOp = op == CompareFilter.CompareOp.LESS_OR_EQUAL ? CompareFilter.CompareOp.LESS : (rvcElementOp = op == CompareFilter.CompareOp.GREATER ? CompareFilter.CompareOp.GREATER_OR_EQUAL : op);
                if (op != CompareFilter.CompareOp.EQUAL) {
                    if (usedAllOfLHS) {
                        if (this.rvc.getChildren().size() < rhs.getChildren().size()) {
                            if (op == CompareFilter.CompareOp.LESS) {
                                op = CompareFilter.CompareOp.LESS_OR_EQUAL;
                            } else if (op == CompareFilter.CompareOp.GREATER_OR_EQUAL) {
                                op = CompareFilter.CompareOp.GREATER;
                            }
                        }
                    } else if (this.rvc.getChildren().size() < rhs.getChildren().size()) {
                        if (op == CompareFilter.CompareOp.LESS) {
                            op = CompareFilter.CompareOp.LESS_OR_EQUAL;
                        } else if (op == CompareFilter.CompareOp.GREATER) {
                            op = CompareFilter.CompareOp.GREATER_OR_EQUAL;
                        }
                    }
                }
                if (!usedAllOfLHS || this.rvc.getChildren().size() != rhs.getChildren().size()) {
                    rhs = new RowValueConstructorExpression(rhs.getChildren().subList(0, Math.min(this.rvc.getChildren().size(), rhs.getChildren().size())), rhs.isStateless());
                }
                final Iterator<KeySlots> keySlotsIterator = this.childSlots.iterator();
                try {
                    rhs = BaseExpression.coerce((Expression)this.rvc, rhs, new BaseExpression.ExpressionComparabilityWrapper(){

                        @Override
                        public Expression wrap(final Expression lhs, final Expression rhs, boolean rowKeyOrderOptimizable) throws SQLException {
                            final KeyPart childPart = ((KeySlots)keySlotsIterator.next()).iterator().next().getKeyPart();
                            return new BaseTerminalExpression(){

                                @Override
                                public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
                                    byte[] key;
                                    if (childPart == null) {
                                        return rhs.evaluate(tuple, ptr);
                                    }
                                    if (!rhs.evaluate(tuple, ptr)) {
                                        return false;
                                    }
                                    if (ptr.getLength() == 0) {
                                        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                                        return true;
                                    }
                                    KeyRange range = childPart.getKeyRange(rvcElementOp, rhs);
                                    if (range == KeyRange.EMPTY_RANGE) {
                                        return false;
                                    }
                                    byte[] byArray = key = range.isLowerInclusive() ? range.getLowerRange() : range.getUpperRange();
                                    if (lhs.getDataType().isFixedWidth() && lhs.getMaxLength() != null && key.length > lhs.getMaxLength()) {
                                        key = Arrays.copyOf(key, (int)lhs.getMaxLength());
                                    }
                                    ptr.set(key);
                                    return true;
                                }

                                @Override
                                public PDataType getDataType() {
                                    return childPart.getColumn().getDataType();
                                }

                                @Override
                                public boolean isNullable() {
                                    return childPart.getColumn().isNullable();
                                }

                                @Override
                                public Integer getMaxLength() {
                                    return lhs.getMaxLength();
                                }

                                @Override
                                public Integer getScale() {
                                    return childPart.getColumn().getScale();
                                }

                                @Override
                                public SortOrder getSortOrder() {
                                    return childPart.getColumn().getSortOrder();
                                }

                                @Override
                                public <T> T accept(ExpressionVisitor<T> visitor) {
                                    return null;
                                }
                            };
                        }
                    }, KeyExpressionVisitor.this.table.rowKeyOrderOptimizable());
                }
                catch (SQLException e) {
                    return null;
                }
                ImmutableBytesWritable ptr = KeyExpressionVisitor.this.context.getTempPtr();
                if (!rhs.evaluate(null, ptr)) {
                    return null;
                }
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                return ByteUtil.getKeyRange(key, op, PVarbinary.INSTANCE);
            }
        }

        private static class BaseKeyPart
        implements KeyPart {
            private final PTable table;
            private final PColumn column;
            private final List<Expression> nodes;

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                Integer length;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                rhs.evaluate(null, ptr);
                PDataType type = this.getColumn().getDataType();
                if (type.isFixedWidth() && (length = this.getColumn().getMaxLength()) != null) {
                    type.pad(ptr, length, this.getColumn().getSortOrder());
                }
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                return ByteUtil.getKeyRange(key, op, type);
            }

            private BaseKeyPart(PTable table, PColumn column, List<Expression> nodes) {
                this.table = table;
                this.column = column;
                this.nodes = nodes;
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }

            @Override
            public PTable getTable() {
                return this.table;
            }
        }

        private class SingleKeySlot
        implements KeySlots {
            private final KeySlot slot;
            private final KeyRange minMaxRange;

            private SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges) {
                this(part, pkPosition, 1, ranges);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this(part, pkPosition, 1, ranges, orderPreserving);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges) {
                this(part, pkPosition, pkSpan, ranges, null, null);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this(part, pkPosition, pkSpan, ranges, null, orderPreserving);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges, KeyRange minMaxRange, FunctionExpression.OrderPreserving orderPreserving) {
                this.slot = new KeySlot(part, pkPosition, pkSpan, ranges, orderPreserving);
                this.minMaxRange = minMaxRange;
            }

            @Override
            public Iterator<KeySlot> iterator() {
                return Iterators.singletonIterator((Object)this.slot);
            }

            @Override
            public KeyRange getMinMaxRange() {
                return this.minMaxRange;
            }

            @Override
            public boolean isPartialExtraction() {
                return this.slot.getKeyPart().getExtractNodes().isEmpty();
            }
        }

        private static class MultiKeySlot
        implements KeySlots {
            private final List<KeySlot> childSlots;
            private final KeyRange minMaxRange;
            private final boolean partialExtraction;

            private MultiKeySlot(List<KeySlot> childSlots, KeyRange minMaxRange, boolean partialExtraction) {
                this.childSlots = childSlots;
                this.minMaxRange = minMaxRange;
                this.partialExtraction = partialExtraction;
            }

            @Override
            public Iterator<KeySlot> iterator() {
                return this.childSlots.iterator();
            }

            @Override
            public KeyRange getMinMaxRange() {
                return this.minMaxRange;
            }

            @Override
            public boolean isPartialExtraction() {
                return this.partialExtraction;
            }
        }

        private final class KeySlot {
            private final int pkPosition;
            private final int pkSpan;
            private final KeyPart keyPart;
            private final List<KeyRange> keyRanges;
            private final FunctionExpression.OrderPreserving orderPreserving;

            private KeySlot(KeyPart keyPart, int pkPosition, int pkSpan, List<KeyRange> keyRanges) {
                this(keyPart, pkPosition, pkSpan, keyRanges, FunctionExpression.OrderPreserving.YES);
            }

            private KeySlot(KeyPart keyPart, int pkPosition, int pkSpan, List<KeyRange> keyRanges, FunctionExpression.OrderPreserving orderPreserving) {
                this.pkPosition = pkPosition;
                this.pkSpan = pkSpan;
                this.keyPart = keyPart;
                this.keyRanges = keyRanges;
                this.orderPreserving = orderPreserving;
            }

            public KeyPart getKeyPart() {
                return this.keyPart;
            }

            public int getPKPosition() {
                return this.pkPosition;
            }

            public int getPKSpan() {
                return this.pkSpan;
            }

            public List<KeyRange> getKeyRanges() {
                return this.keyRanges;
            }

            public final KeySlot concatExtractNodes(List<Expression> extractNodes) {
                return new KeySlot(new BaseKeyPart(this.getKeyPart().getTable(), this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), extractNodes)), this.getPKPosition(), this.getPKSpan(), this.getKeyRanges(), this.getOrderPreserving());
            }

            public final KeySlot intersect(KeySlot that) {
                if (this.getPKSpan() == 1 && that.getPKSpan() == 1) {
                    if (this.getPKPosition() != that.getPKPosition()) {
                        throw new IllegalArgumentException("Position must be equal for intersect");
                    }
                    List<KeyRange> keyRanges = KeyRange.intersect(this.getKeyRanges(), that.getKeyRanges());
                    if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                        return null;
                    }
                    return new KeySlot(new BaseKeyPart(this.getKeyPart().getTable(), this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), that.getKeyPart().getExtractNodes())), this.getPKPosition(), this.getPKSpan(), keyRanges, this.getOrderPreserving());
                }
                assert (this.getPKSpan() > 1);
                assert (this.getPKPosition() <= that.getPKPosition());
                ImmutableBytesWritable ptr = KeyExpressionVisitor.this.context.getTempPtr();
                RowKeySchema schema = KeyExpressionVisitor.this.table.getRowKeySchema();
                if (this.getPKSpan() > 1 && that.getPKSpan() > 1) {
                    return this;
                }
                assert (this.getPKSpan() > 1);
                assert (this.getPKPosition() <= that.getPKPosition());
                ArrayList newKeyRanges = Lists.newArrayListWithExpectedSize((int)this.getKeyRanges().size());
                for (KeyRange keyRange : this.getKeyRanges()) {
                    List<KeyRange> slotKeyRanges;
                    if (keyRange == KeyRange.EVERYTHING_RANGE) {
                        return this;
                    }
                    assert (keyRange.isSingleKey());
                    byte[] key = keyRange.getLowerRange();
                    int position = this.getPKPosition();
                    int thatPosition = that.getPKPosition();
                    ptr.set(key);
                    if (!schema.position(ptr, position, thatPosition) || KeyExpressionVisitor.isDegenerate(KeyRange.intersect(slotKeyRanges = Collections.singletonList(KeyRange.getKeyRange(ByteUtil.copyKeyBytesIfNecessary(ptr))), that.getKeyRanges()))) continue;
                    newKeyRanges.add(keyRange);
                }
                if (KeyExpressionVisitor.isDegenerate(newKeyRanges)) {
                    return null;
                }
                return new KeySlot(new BaseKeyPart(this.getKeyPart().getTable(), this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), that.getKeyPart().getExtractNodes())), this.getPKPosition(), this.getPKSpan(), newKeyRanges, this.getOrderPreserving());
            }

            public FunctionExpression.OrderPreserving getOrderPreserving() {
                return this.orderPreserving;
            }
        }

        private static interface KeySlots
        extends Iterable<KeySlot> {
            @Override
            public Iterator<KeySlot> iterator();

            public KeyRange getMinMaxRange();

            public boolean isPartialExtraction();
        }
    }

    private static class RemoveExtractedNodesVisitor
    extends StatelessTraverseNoExpressionVisitor<Expression> {
        private final Set<Expression> nodesToRemove;

        private RemoveExtractedNodesVisitor(Set<Expression> nodesToRemove) {
            this.nodesToRemove = nodesToRemove;
        }

        @Override
        public Expression defaultReturn(Expression node, List<Expression> e) {
            return this.nodesToRemove.contains(node) ? null : node;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Expression visit(LiteralExpression node) {
            return this.nodesToRemove.contains(node) ? null : node;
        }

        @Override
        public Expression visitLeave(AndExpression node, List<Expression> l) {
            if (!l.equals(node.getChildren())) {
                if (l.isEmpty()) {
                    return LiteralExpression.newConstant((Object)true, Determinism.ALWAYS);
                }
                if (l.size() == 1) {
                    return l.get(0);
                }
                try {
                    return AndExpression.create(l);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return node;
        }
    }
}

