/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.KeyValueUtil;

public abstract class MutatingParallelIteratorFactory
implements ParallelIteratorFactory {
    protected final PhoenixConnection connection;

    protected MutatingParallelIteratorFactory(PhoenixConnection connection) {
        this.connection = connection;
    }

    protected abstract MutationState mutate(StatementContext var1, ResultIterator var2, PhoenixConnection var3) throws SQLException;

    @Override
    public PeekingResultIterator newIterator(StatementContext parentContext, ResultIterator iterator, Scan scan, String tableName, QueryPlan plan) throws SQLException {
        final PhoenixConnection clonedConnection = new PhoenixConnection(this.connection);
        MutationState state2 = this.mutate(parentContext, iterator, clonedConnection);
        long totalRowCount = state2.getUpdateCount();
        if (clonedConnection.getAutoCommit()) {
            clonedConnection.getMutationState().join(state2);
            state2 = clonedConnection.getMutationState();
        }
        final MutationState finalState = state2;
        byte[] value = PLong.INSTANCE.toBytes(totalRowCount);
        KeyValue keyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
        final SingleKeyValueTuple tuple = new SingleKeyValueTuple((Cell)keyValue);
        return new PeekingResultIterator(){
            private boolean done = false;

            @Override
            public Tuple next() throws SQLException {
                if (this.done) {
                    return null;
                }
                this.done = true;
                return tuple;
            }

            @Override
            public void explain(List<String> planSteps) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws SQLException {
                try {
                    MutatingParallelIteratorFactory.this.connection.getMutationState().join(finalState);
                }
                finally {
                    clonedConnection.close();
                }
            }

            @Override
            public Tuple peek() throws SQLException {
                return this.done ? null : tuple;
            }
        };
    }
}

